/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.opengl.util.av.AudioSink;
import java.nio.ByteBuffer;

public class NullAudioSink
implements AudioSink {
    private volatile float playSpeed = 1.0f;
    private volatile boolean playRequested = false;
    private volatile int playingPTS = Integer.MIN_VALUE;
    private float volume = 1.0f;
    private AudioSink.AudioFormat chosenFormat = null;
    private boolean initialized = true;

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    @Override
    public final boolean setPlaySpeed(float f2) {
        if (Math.abs(1.0f - f2) < 0.01f) {
            f2 = 1.0f;
        }
        this.playSpeed = f2;
        return true;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    @Override
    public final boolean setVolume(float f2) {
        this.volume = f2;
        return true;
    }

    @Override
    public AudioSink.AudioFormat getPreferredFormat() {
        return DefaultFormat;
    }

    @Override
    public final int getMaxSupportedChannels() {
        return 8;
    }

    @Override
    public final boolean isSupported(AudioSink.AudioFormat audioFormat) {
        return true;
    }

    @Override
    public boolean init(AudioSink.AudioFormat audioFormat, float f2, int n2, int n3, int n4) {
        this.chosenFormat = audioFormat;
        return true;
    }

    @Override
    public final AudioSink.AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    @Override
    public boolean isPlaying() {
        return this.playRequested;
    }

    @Override
    public void play() {
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.playRequested = false;
    }

    @Override
    public void flush() {
    }

    @Override
    public void destroy() {
        this.initialized = false;
        this.chosenFormat = null;
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return 0;
    }

    @Override
    public int getFrameCount() {
        return 0;
    }

    @Override
    public int getQueuedFrameCount() {
        return 0;
    }

    @Override
    public int getQueuedByteCount() {
        return 0;
    }

    @Override
    public int getQueuedTime() {
        return 0;
    }

    @Override
    public final int getPTS() {
        return this.playingPTS;
    }

    @Override
    public int getFreeFrameCount() {
        return 1;
    }

    @Override
    public AudioSink.AudioFrame enqueueData(int n2, ByteBuffer byteBuffer, int n3) {
        if (!this.initialized || null == this.chosenFormat) {
            return null;
        }
        this.playingPTS = n2;
        return null;
    }
}

