/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;

public class PngChunkZTXT
extends PngChunkTextVar {
    public static final String ID = "zTXt";

    public PngChunkZTXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key.isEmpty()) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.key.getBytes(PngHelperInternal.charsetLatin1));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byte[] byArray = ChunkHelper.compressBytes(this.val.getBytes(PngHelperInternal.charsetLatin1), true);
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray2.length, false);
            chunkRaw.data = byArray2;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < chunkRaw.data.length; ++n2) {
            if (chunkRaw.data[n2] != 0) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0 || n3 > chunkRaw.data.length - 2) {
            throw new PngjException("bad zTXt chunk: no separator found");
        }
        this.key = new String(chunkRaw.data, 0, n3, PngHelperInternal.charsetLatin1);
        n2 = chunkRaw.data[n3 + 1];
        if (n2 != 0) {
            throw new PngjException("bad zTXt chunk: unknown compression method");
        }
        byte[] byArray = ChunkHelper.compressBytes(chunkRaw.data, n3 + 2, chunkRaw.data.length - n3 - 2, false);
        this.val = new String(byArray, PngHelperInternal.charsetLatin1);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkZTXT pngChunkZTXT = (PngChunkZTXT)pngChunk;
        this.key = pngChunkZTXT.key;
        this.val = pngChunkZTXT.val;
    }
}

