/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;

public class WGLGLCapabilities
extends GLCapabilities {
    private final PIXELFORMATDESCRIPTOR pfd;
    private final int pfdID;
    private int arb_pixelformat;

    public WGLGLCapabilities(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n2, GLProfile gLProfile) {
        super(gLProfile);
        this.pfd = pIXELFORMATDESCRIPTOR;
        this.pfdID = n2;
        this.arb_pixelformat = 0;
    }

    public boolean setValuesByGDI() {
        this.arb_pixelformat = -1;
        this.setRedBits(this.pfd.getCRedBits());
        this.setGreenBits(this.pfd.getCGreenBits());
        this.setBlueBits(this.pfd.getCBlueBits());
        this.setAlphaBits(this.pfd.getCAlphaBits());
        this.setAccumRedBits(this.pfd.getCAccumRedBits());
        this.setAccumGreenBits(this.pfd.getCAccumGreenBits());
        this.setAccumBlueBits(this.pfd.getCAccumBlueBits());
        this.setAccumAlphaBits(this.pfd.getCAccumAlphaBits());
        this.setDepthBits(this.pfd.getCDepthBits());
        this.setStencilBits(this.pfd.getCStencilBits());
        int n2 = this.pfd.getDwFlags();
        this.setDoubleBuffered((n2 & 1) != 0);
        this.setStereo((n2 & 2) != 0);
        this.setHardwareAccelerated((n2 & 0x40) == 0 || (n2 & 0x1000) != 0);
        return true;
    }

    public static final String PFD2String(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n2) {
        int n3 = pIXELFORMATDESCRIPTOR.getDwFlags();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (0 != (4 & n3)) {
            bl = true;
            stringBuilder.append("window");
        }
        if (0 != (8 & n3)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("bitmap");
        }
        if (0 != (0x20 & n3)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("opengl");
        }
        if (0 != (1 & n3)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("dblbuf");
        }
        if (0 != (2 & n3)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("stereo");
        }
        if (0 == (0x40 & n3) || 0 == (0x1000 & n3)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("hw-accel");
        }
        return "PFD[id = " + n2 + " (0x" + Integer.toHexString(n2) + "), colorBits " + pIXELFORMATDESCRIPTOR.getCColorBits() + ", rgba " + pIXELFORMATDESCRIPTOR.getCRedBits() + "/" + pIXELFORMATDESCRIPTOR.getCGreenBits() + "/" + pIXELFORMATDESCRIPTOR.getCBlueBits() + "/" + pIXELFORMATDESCRIPTOR.getCAlphaBits() + ", accum-rgba " + pIXELFORMATDESCRIPTOR.getCAccumRedBits() + "/" + pIXELFORMATDESCRIPTOR.getCAccumGreenBits() + "/" + pIXELFORMATDESCRIPTOR.getCAccumBlueBits() + "/" + pIXELFORMATDESCRIPTOR.getCAccumAlphaBits() + ", dp/st/ms: " + pIXELFORMATDESCRIPTOR.getCDepthBits() + "/" + pIXELFORMATDESCRIPTOR.getCStencilBits() + "/" + "0" + ", flags: " + stringBuilder.toString();
    }

    public boolean setValuesByARB(IntBuffer intBuffer, int n2, IntBuffer intBuffer2) {
        this.arb_pixelformat = 1;
        int n3 = 0;
        block20: for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = intBuffer.get(i2);
            int n5 = intBuffer2.get(i2);
            switch (n4) {
                case 8193: 
                case 8194: 
                case 8237: {
                    continue block20;
                }
                case 8195: {
                    this.setHardwareAccelerated(n5 == 8231);
                    continue block20;
                }
                case 8208: {
                    if (n5 == 1) continue block20;
                    return false;
                }
                case 8226: {
                    this.setDepthBits(n5);
                    continue block20;
                }
                case 8227: {
                    this.setStencilBits(n5);
                    continue block20;
                }
                case 8209: {
                    this.setDoubleBuffered(n5 == 1);
                    continue block20;
                }
                case 8210: {
                    this.setStereo(n5 == 1);
                    continue block20;
                }
                case 8211: {
                    if (n5 == 8236) {
                        return false;
                    }
                    if (n5 != 8608) continue block20;
                    return false;
                }
                case 8213: {
                    this.setRedBits(n5);
                    continue block20;
                }
                case 8215: {
                    this.setGreenBits(n5);
                    continue block20;
                }
                case 8217: {
                    this.setBlueBits(n5);
                    continue block20;
                }
                case 8219: {
                    n3 = n5;
                    continue block20;
                }
                case 8222: {
                    this.setAccumRedBits(n5);
                    continue block20;
                }
                case 8223: {
                    this.setAccumGreenBits(n5);
                    continue block20;
                }
                case 8224: {
                    this.setAccumBlueBits(n5);
                    continue block20;
                }
                case 8225: {
                    this.setAccumAlphaBits(n5);
                    continue block20;
                }
                case 8257: {
                    this.setSampleBuffers(n5 != 0);
                    continue block20;
                }
                case 8258: {
                    this.setNumSamples(n5);
                    continue block20;
                }
                default: {
                    throw new GLException("Unknown pixel format attribute " + n4);
                }
            }
        }
        this.setAlphaBits(n3);
        return true;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    public final PIXELFORMATDESCRIPTOR getPFD() {
        return this.pfd;
    }

    public final int getPFDID() {
        return this.pfdID;
    }

    public final boolean isSetByARB() {
        return 0 < this.arb_pixelformat;
    }

    public final boolean isSetByGDI() {
        return 0 > this.arb_pixelformat;
    }

    public final boolean isSet() {
        return 0 != this.arb_pixelformat;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: 
            case WIN32_PFD: {
                return this.getPFDID();
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("wgl vid ").append(this.pfdID).append(" ");
        switch (this.arb_pixelformat) {
            case -1: {
                stringBuilder.append("gdi");
                break;
            }
            case 0: {
                stringBuilder.append("nop");
                break;
            }
            case 1: {
                stringBuilder.append("arb");
                break;
            }
            default: {
                throw new InternalError("invalid arb_pixelformat: " + this.arb_pixelformat);
            }
        }
        stringBuilder.append(": ");
        return super.toString(stringBuilder);
    }
}

