/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import jogamp.nativewindow.windows.DWM_BLURBEHIND;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.windows.MARGINS;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsWGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    private final GLCapabilitiesChooser chooser;
    private boolean isDetermined = false;
    private boolean isExternal = false;

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2);
        this.chooser = gLCapabilitiesChooser;
        this.isDetermined = false;
    }

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, WGLGLCapabilities wGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        super(abstractGraphicsScreen, wGLGLCapabilities, gLCapabilitiesImmutable);
        this.setCapsPFD(wGLGLCapabilities);
        this.chooser = null;
    }

    static WindowsWGLGraphicsConfiguration createFromExternal(GLDrawableFactory gLDrawableFactory, long l2, int n2, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen, boolean bl) {
        AbstractGraphicsDevice abstractGraphicsDevice;
        WindowsWGLDrawableFactory windowsWGLDrawableFactory;
        WindowsWGLDrawableFactory.SharedResource sharedResource;
        if (gLDrawableFactory == null) {
            throw new GLException("Null factory");
        }
        if (l2 == 0L) {
            throw new GLException("Null HDC");
        }
        if (n2 <= 0) {
            throw new GLException("Invalid pixelformat id " + n2);
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(abstractGraphicsScreen.getDevice());
        }
        boolean bl2 = null != (sharedResource = (windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory).getOrCreateSharedResourceImpl(abstractGraphicsDevice = abstractGraphicsScreen.getDevice())) && sharedResource.hasARBPixelFormat();
        WGLGLCapabilities wGLGLCapabilities = null;
        wGLGLCapabilities = bl2 ? WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLProfile, l2, n2, 15) : WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(abstractGraphicsDevice, gLProfile, l2, n2, 15);
        if (null == wGLGLCapabilities) {
            throw new GLException("Couldn't choose Capabilities by: HDC 0x" + Long.toHexString(l2) + ", pfdID " + n2 + ", onscreen " + bl + ", hasARB " + bl2);
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, wGLGLCapabilities, wGLGLCapabilities);
        windowsWGLGraphicsConfiguration.markExternal();
        return windowsWGLGraphicsConfiguration;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public final void updateGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(this.chooser, gLDrawableFactory, nativeSurface, nArray);
    }

    public final void preselectGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, int[] nArray) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getScreen().getDevice();
        WindowsWGLGraphicsConfigurationFactory.preselectGraphicsConfiguration(this.chooser, gLDrawableFactory, abstractGraphicsDevice, this, nArray);
    }

    final void setPixelFormat(long l2, WGLGLCapabilities wGLGLCapabilities) {
        if (0L == l2) {
            throw new GLException("Error: HDC is null");
        }
        if (!WGLUtil.SetPixelFormat(l2, wGLGLCapabilities.getPFDID(), wGLGLCapabilities.getPFD())) {
            throw new GLException("Unable to set pixel format " + wGLGLCapabilities.getPFDID() + " of " + wGLGLCapabilities + " for device context " + WindowsWGLGraphicsConfiguration.toHexString(l2) + ": error code " + GDI.GetLastError());
        }
        if (!wGLGLCapabilities.isBackgroundOpaque()) {
            long l3 = GDI.WindowFromDC(l2);
            DWM_BLURBEHIND dWM_BLURBEHIND = DWM_BLURBEHIND.create();
            dWM_BLURBEHIND.setDwFlags(5);
            dWM_BLURBEHIND.setFEnable(1);
            boolean bl = GDI.DwmEnableBlurBehindWindow(l3, dWM_BLURBEHIND);
            if (bl) {
                MARGINS mARGINS = MARGINS.create();
                mARGINS.setCxLeftWidth(-1);
                mARGINS.setCxRightWidth(-1);
                mARGINS.setCyBottomHeight(-1);
                mARGINS.setCyTopHeight(-1);
                bl = GDI.DwmExtendFrameIntoClientArea(l3, mARGINS);
            }
            if (DEBUG) {
                boolean bl2 = GDIUtil.IsUndecorated(l3);
                boolean bl3 = GDIUtil.IsChild(l3);
                System.err.println("translucency enabled on wnd: 0x" + Long.toHexString(l3) + " - isUndecorated " + bl2 + ", isChild " + bl3 + ", ok: " + bl);
            }
        }
        if (DEBUG) {
            System.err.println("setPixelFormat: hdc " + WindowsWGLGraphicsConfiguration.toHexString(l2) + ", " + wGLGLCapabilities);
        }
        this.setCapsPFD(wGLGLCapabilities);
    }

    final void setCapsPFD(WGLGLCapabilities wGLGLCapabilities) {
        this.setChosenCapabilities(wGLGLCapabilities);
        this.isDetermined = true;
        if (DEBUG) {
            System.err.println("*** setCapsPFD: " + wGLGLCapabilities);
        }
    }

    public final boolean isExternal() {
        return this.isExternal;
    }

    final void markExternal() {
        this.isExternal = true;
    }

    public final boolean isDetermined() {
        return this.isDetermined;
    }

    public final PIXELFORMATDESCRIPTOR getPixelFormat() {
        return this.isDetermined ? ((WGLGLCapabilities)this.capabilitiesChosen).getPFD() : null;
    }

    public final int getPixelFormatID() {
        return this.isDetermined ? ((WGLGLCapabilities)this.capabilitiesChosen).getPFDID() : 0;
    }

    public final boolean isChoosenByARB() {
        return this.isDetermined ? ((WGLGLCapabilities)this.capabilitiesChosen).isSetByARB() : false;
    }

    static int fillAttribsForGeneralWGLARBQuery(WindowsWGLDrawableFactory.SharedResource sharedResource, IntBuffer intBuffer) {
        int n2 = 0;
        intBuffer.put(n2++, 8193);
        if (sharedResource.hasARBPBuffer()) {
            intBuffer.put(n2++, 8237);
        }
        intBuffer.put(n2++, 8194);
        intBuffer.put(n2++, 8195);
        intBuffer.put(n2++, 8208);
        intBuffer.put(n2++, 8226);
        intBuffer.put(n2++, 8227);
        intBuffer.put(n2++, 8209);
        intBuffer.put(n2++, 8210);
        intBuffer.put(n2++, 8211);
        intBuffer.put(n2++, 8213);
        intBuffer.put(n2++, 8215);
        intBuffer.put(n2++, 8217);
        intBuffer.put(n2++, 8219);
        intBuffer.put(n2++, 8222);
        intBuffer.put(n2++, 8223);
        intBuffer.put(n2++, 8224);
        intBuffer.put(n2++, 8225);
        if (sharedResource.hasARBMultisample()) {
            intBuffer.put(n2++, 8257);
            intBuffer.put(n2++, 8258);
        }
        return n2;
    }

    static boolean wglARBPFIDValid(WindowsWGLContext windowsWGLContext, long l2, int n2) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(1);
        intBuffer2.put(0, 8212);
        if (!windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l2, n2, 0, 1, intBuffer2, intBuffer)) {
            return GDI.GetLastError() == 0;
        }
        return true;
    }

    static int wglARBPFDIDCount(WindowsWGLContext windowsWGLContext, long l2) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(1);
        intBuffer2.put(0, 8192);
        WGLExt wGLExt = windowsWGLContext.getWGLExt();
        if (!wGLExt.wglGetPixelFormatAttribivARB(l2, 1, 0, 1, intBuffer2, intBuffer)) {
            if (DEBUG) {
                System.err.println("GetPixelFormatAttribivARB: Failed - HDC 0x" + Long.toHexString(l2) + ", value " + intBuffer.get(0) + ", LastError: " + GDI.GetLastError());
                ExceptionUtils.dumpStack(System.err);
            }
            return 0;
        }
        int n2 = intBuffer.get(0);
        if (0 == n2 && DEBUG) {
            System.err.println("GetPixelFormatAttribivARB: No formats - HDC 0x" + Long.toHexString(l2) + ", LastError: " + GDI.GetLastError());
            ExceptionUtils.dumpStack(System.err);
        }
        return n2;
    }

    static int[] wglAllARBPFDIDs(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 1 + i2;
        }
        return nArray;
    }

    static WGLGLCapabilities wglARBPFID2GLCapabilities(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int n2, int n3) {
        if (!sharedResource.hasARBPixelFormat()) {
            return null;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(512);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(512);
        int n4 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(sharedResource, intBuffer);
        if (!((WindowsWGLContext)sharedResource.getContext()).getWGLExt().wglGetPixelFormatAttribivARB(l2, n2, 0, n4, intBuffer, intBuffer2)) {
            throw new GLException("wglARBPFID2GLCapabilities: Error getting pixel format attributes for pixel format " + n2 + " of device context " + WindowsWGLGraphicsConfiguration.toHexString(l2) + ", werr " + GDI.GetLastError());
        }
        return WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(abstractGraphicsDevice, gLProfile, l2, n2, intBuffer, n4, intBuffer2, n3);
    }

    static WGLGLCapabilities wglARBPFID2GLCapabilitiesNoCheck(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int n2, int n3) {
        if (!sharedResource.hasARBPixelFormat()) {
            return null;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(512);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(512);
        int n4 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(sharedResource, intBuffer);
        if (!((WindowsWGLContext)sharedResource.getContext()).getWGLExt().wglGetPixelFormatAttribivARB(l2, n2, 0, n4, intBuffer, intBuffer2)) {
            throw new GLException("wglARBPFID2GLCapabilities: Error getting pixel format attributes for pixel format " + n2 + " of device context " + WindowsWGLGraphicsConfiguration.toHexString(l2) + ", werr " + GDI.GetLastError());
        }
        return WindowsWGLGraphicsConfiguration.AttribList2GLCapabilitiesNoCheck(abstractGraphicsDevice, gLProfile, l2, n2, intBuffer, n4, intBuffer2, n3);
    }

    static int[] wglChoosePixelFormatARB(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, long l2, IntBuffer intBuffer, int n2, FloatBuffer floatBuffer) {
        int[] nArray;
        IntBuffer intBuffer2;
        IntBuffer intBuffer3;
        if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(sharedResource, gLCapabilitiesImmutable, intBuffer, n2, null)) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB: GLCapabilities2AttribList failed: " + GDI.GetLastError());
                ExceptionUtils.dumpStack(System.err);
            }
            return null;
        }
        WGLExt wGLExt = ((WindowsWGLContext)sharedResource.getContext()).getWGLExt();
        if (!wGLExt.wglChoosePixelFormatARB(l2, intBuffer, floatBuffer, 256, intBuffer3 = Buffers.newDirectIntBuffer(256), intBuffer2 = Buffers.newDirectIntBuffer(1))) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB: wglChoosePixelFormatARB failed: " + GDI.GetLastError());
                ExceptionUtils.dumpStack(System.err);
            }
            return null;
        }
        int n3 = Math.min(intBuffer2.get(0), 256);
        if (0 < n3) {
            nArray = new int[n3];
            intBuffer3.get(nArray, 0, n3);
        } else {
            nArray = null;
        }
        if (DEBUG) {
            System.err.println("wglChoosePixelFormatARB: NumFormats (wglChoosePixelFormatARB) accelMode 0x" + Integer.toHexString(n2) + ": " + n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), l2, nArray[i2], 15);
                System.err.println("pixel format " + nArray[i2] + " (index " + i2 + "): " + wGLGLCapabilities);
            }
        }
        return nArray;
    }

    static List<GLCapabilitiesImmutable> wglARBPFIDs2GLCapabilities(WindowsWGLDrawableFactory.SharedResource sharedResource, AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int[] nArray, int n2, boolean bl) {
        if (!sharedResource.hasARBPixelFormat()) {
            return null;
        }
        int n3 = nArray.length;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(512);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(512);
        int n4 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(sharedResource, intBuffer);
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] >= 1 && ((WindowsWGLContext)sharedResource.getContext()).getWGLExt().wglGetPixelFormatAttribivARB(l2, nArray[i2], 0, n4, intBuffer, intBuffer2)) {
                WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(abstractGraphicsDevice, gLProfile, l2, nArray[i2], intBuffer, n4, intBuffer2, n2);
                if (null != wGLGLCapabilities) {
                    arrayList.add(wGLGLCapabilities);
                    if (DEBUG) {
                        int n5 = arrayList.size() - 1;
                        System.err.println("wglARBPFIDs2GLCapabilities: bucket[" + i2 + " -> " + n5 + "]: " + wGLGLCapabilities);
                    }
                    if (!bl) continue;
                    break;
                }
                if (!DEBUG) continue;
                WGLGLCapabilities wGLGLCapabilities2 = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilitiesNoCheck(abstractGraphicsDevice, gLProfile, l2, nArray[i2], intBuffer, n4, intBuffer2, 15);
                System.err.println("wglARBPFIDs2GLCapabilities: bucket[" + i2 + " -> skip]: pfdID " + nArray[i2] + ", " + wGLGLCapabilities2 + ", winattr " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n2).toString());
                continue;
            }
            if (!DEBUG) continue;
            if (1 > nArray[i2]) {
                System.err.println("wglARBPFIDs2GLCapabilities: Invalid pfdID " + i2 + "/" + n3 + ": " + nArray[i2]);
                continue;
            }
            System.err.println("wglARBPFIDs2GLCapabilities: Cannot get pixel format attributes for pixel format " + i2 + "/" + n3 + ": " + nArray[i2] + ", hdc " + WindowsWGLGraphicsConfiguration.toHexString(l2));
        }
        return arrayList;
    }

    static boolean GLCapabilities2AttribList(WindowsWGLDrawableFactory.SharedResource sharedResource, GLCapabilitiesImmutable gLCapabilitiesImmutable, IntBuffer intBuffer, int n2, int[] nArray) throws GLException {
        int n3;
        boolean bl;
        if (!sharedResource.hasARBPixelFormat()) {
            return false;
        }
        int n4 = 0;
        intBuffer.put(n4++, 8208);
        intBuffer.put(n4++, 1);
        if (n2 > 0) {
            intBuffer.put(n4++, 8195);
            intBuffer.put(n4++, n2);
        }
        boolean bl2 = bl = gLCapabilitiesImmutable.isPBuffer() && sharedResource.hasARBPBuffer();
        if (gLCapabilitiesImmutable.isOnscreen()) {
            n3 = 8193;
        } else if (gLCapabilitiesImmutable.isFBO()) {
            n3 = 8193;
        } else if (bl) {
            n3 = 8237;
        } else if (gLCapabilitiesImmutable.isBitmap()) {
            n3 = 8194;
        } else {
            throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
        }
        intBuffer.put(n4++, n3);
        intBuffer.put(n4++, 1);
        intBuffer.put(n4++, 8209);
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            intBuffer.put(n4++, 1);
        } else {
            intBuffer.put(n4++, 0);
        }
        intBuffer.put(n4++, 8210);
        if (gLCapabilitiesImmutable.getStereo()) {
            intBuffer.put(n4++, 1);
        } else {
            intBuffer.put(n4++, 0);
        }
        intBuffer.put(n4++, 8213);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getRedBits());
        intBuffer.put(n4++, 8215);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getGreenBits());
        intBuffer.put(n4++, 8217);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getBlueBits());
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            intBuffer.put(n4++, 8219);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getAlphaBits());
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            intBuffer.put(n4++, 8227);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getStencilBits());
        }
        intBuffer.put(n4++, 8226);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getDepthBits());
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            GLRendererQuirks gLRendererQuirks = sharedResource.getRendererQuirks(null);
            if (!bl || null == gLRendererQuirks || !gLRendererQuirks.exist(19)) {
                intBuffer.put(n4++, 8221);
                intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits());
                intBuffer.put(n4++, 8222);
                intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumRedBits());
                intBuffer.put(n4++, 8223);
                intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumGreenBits());
                intBuffer.put(n4++, 8224);
                intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumBlueBits());
                intBuffer.put(n4++, 8225);
                intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumAlphaBits());
            }
        }
        if (gLCapabilitiesImmutable.getSampleBuffers() && sharedResource.hasARBMultisample()) {
            intBuffer.put(n4++, 8257);
            intBuffer.put(n4++, 1);
            intBuffer.put(n4++, 8258);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getNumSamples());
        }
        intBuffer.put(n4++, 8211);
        intBuffer.put(n4++, 8235);
        intBuffer.put(n4++, 0);
        return true;
    }

    static int AttribList2DrawableTypeBits(IntBuffer intBuffer, int n2, IntBuffer intBuffer2) {
        int n3 = 0;
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = intBuffer.get(i2);
            switch (n4) {
                case 8193: {
                    if (intBuffer2.get(i2) != 1) continue block5;
                    n3 |= 9;
                    continue block5;
                }
                case 8194: {
                    if (intBuffer2.get(i2) != 1) continue block5;
                    n3 |= 2;
                    continue block5;
                }
                case 8237: {
                    if (intBuffer2.get(i2) != 1) continue block5;
                    n3 |= 4;
                }
            }
        }
        return n3;
    }

    static WGLGLCapabilities AttribList2GLCapabilities(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int n2, IntBuffer intBuffer, int n3, IntBuffer intBuffer2, int n4) {
        int n5 = WindowsWGLGraphicsConfiguration.AttribList2DrawableTypeBits(intBuffer, n3, intBuffer2);
        int n6 = n4 & n5;
        if (0 == n6) {
            return null;
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (WGLUtil.DescribePixelFormat(l2, n2, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0 && 0 == (n6 &= 0xFFFFFFF4)) {
            return null;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n2, gLProfile);
        wGLGLCapabilities.setValuesByARB(intBuffer, n3, intBuffer2);
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, n6, wGLGLCapabilities);
    }

    static WGLGLCapabilities AttribList2GLCapabilitiesNoCheck(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int n2, IntBuffer intBuffer, int n3, IntBuffer intBuffer2, int n4) {
        int n5 = WindowsWGLGraphicsConfiguration.AttribList2DrawableTypeBits(intBuffer, n3, intBuffer2);
        int n6 = n4 & n5;
        if (0 == n6) {
            return null;
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        WGLUtil.DescribePixelFormat(l2, n2, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR);
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n2, gLProfile);
        wGLGLCapabilities.setValuesByARB(intBuffer, n3, intBuffer2);
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, n6, wGLGLCapabilities);
    }

    static int[] wglAllGDIPFIDs(long l2) {
        int n2 = WGLUtil.DescribePixelFormat(l2, 1, 0, null);
        if (n2 == 0) {
            throw new GLException("DescribePixelFormat: No formats - HDC 0x" + Long.toHexString(l2) + ", LastError: " + GDI.GetLastError());
        }
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 1 + i2;
        }
        return nArray;
    }

    static int PFD2DrawableTypeBits(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n2 = 0;
        int n3 = pIXELFORMATDESCRIPTOR.getDwFlags();
        if (0 != (4 & n3)) {
            n2 |= 9;
        }
        if (0 != (8 & n3)) {
            n2 |= 2;
        }
        return n2;
    }

    static WGLGLCapabilities PFD2GLCapabilities(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int n2, int n3) {
        byte by;
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(l2, n2);
        if (null == pIXELFORMATDESCRIPTOR) {
            return null;
        }
        if ((pIXELFORMATDESCRIPTOR.getDwFlags() & 0x20) == 0) {
            return null;
        }
        int n4 = WindowsWGLGraphicsConfiguration.PFD2DrawableTypeBits(pIXELFORMATDESCRIPTOR);
        int n5 = n3 & n4;
        if (0 == n5) {
            if (DEBUG) {
                System.err.println("Drop [drawableType mismatch]: " + WGLGLCapabilities.PFD2String(pIXELFORMATDESCRIPTOR, n2));
            }
            return null;
        }
        if (2 == n5 && ((by = pIXELFORMATDESCRIPTOR.getCColorBits()) != 24 || 0 < pIXELFORMATDESCRIPTOR.getCAlphaBits())) {
            if (DEBUG) {
                System.err.println("Drop [color bits excl BITMAP]: " + WGLGLCapabilities.PFD2String(pIXELFORMATDESCRIPTOR, n2));
            }
            return null;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n2, gLProfile);
        wGLGLCapabilities.setValuesByGDI();
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, n5, wGLGLCapabilities);
    }

    static WGLGLCapabilities PFD2GLCapabilitiesNoCheck(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, long l2, int n2) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(l2, n2);
        return WindowsWGLGraphicsConfiguration.PFD2GLCapabilitiesNoCheck(abstractGraphicsDevice, gLProfile, pIXELFORMATDESCRIPTOR, n2);
    }

    static WGLGLCapabilities PFD2GLCapabilitiesNoCheck(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n2) {
        if (null == pIXELFORMATDESCRIPTOR) {
            return null;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n2, gLProfile);
        wGLGLCapabilities.setValuesByGDI();
        return (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(abstractGraphicsDevice, WindowsWGLGraphicsConfiguration.PFD2DrawableTypeBits(pIXELFORMATDESCRIPTOR), wGLGLCapabilities);
    }

    static PIXELFORMATDESCRIPTOR GLCapabilities2PFD(GLCapabilitiesImmutable gLCapabilitiesImmutable, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n2 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n2 < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int n3 = 4128;
        if (gLCapabilitiesImmutable.isOnscreen()) {
            n3 |= 4;
        } else if (gLCapabilitiesImmutable.isFBO()) {
            n3 |= 4;
        } else if (gLCapabilitiesImmutable.isPBuffer()) {
            n3 |= 8;
        } else if (gLCapabilitiesImmutable.isBitmap()) {
            n3 |= 8;
        } else {
            throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            n3 = gLCapabilitiesImmutable.isBitmap() || gLCapabilitiesImmutable.isPBuffer() ? (n3 |= 0x40000000) : (n3 |= 1);
        }
        if (gLCapabilitiesImmutable.getStereo()) {
            n3 |= 2;
        }
        pIXELFORMATDESCRIPTOR.setDwFlags(n3);
        pIXELFORMATDESCRIPTOR.setIPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.setCColorBits((byte)n2);
        pIXELFORMATDESCRIPTOR.setCRedBits((byte)gLCapabilitiesImmutable.getRedBits());
        pIXELFORMATDESCRIPTOR.setCGreenBits((byte)gLCapabilitiesImmutable.getGreenBits());
        pIXELFORMATDESCRIPTOR.setCBlueBits((byte)gLCapabilitiesImmutable.getBlueBits());
        pIXELFORMATDESCRIPTOR.setCAlphaBits((byte)gLCapabilitiesImmutable.getAlphaBits());
        int n4 = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.setCAccumBits((byte)n4);
        pIXELFORMATDESCRIPTOR.setCAccumRedBits((byte)gLCapabilitiesImmutable.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.setCAccumGreenBits((byte)gLCapabilitiesImmutable.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.setCAccumBlueBits((byte)gLCapabilitiesImmutable.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.setCAccumAlphaBits((byte)gLCapabilitiesImmutable.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.setCDepthBits((byte)gLCapabilitiesImmutable.getDepthBits());
        pIXELFORMATDESCRIPTOR.setCStencilBits((byte)gLCapabilitiesImmutable.getStencilBits());
        pIXELFORMATDESCRIPTOR.setILayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor(long l2, int n2) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.setNSize((short)PIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.setNVersion((short)1);
        if (0L != l2 && 1 <= n2 && WGLUtil.DescribePixelFormat(l2, n2, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
            if (DEBUG) {
                System.err.println("Info: Non displayable pixel format " + n2 + " of device context: error code " + GDI.GetLastError());
            }
            return null;
        }
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor() {
        return WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(0L, 0);
    }

    @Override
    public String toString() {
        return "WindowsWGLGraphicsConfiguration[" + this.getScreen() + ", pfdID " + this.getPixelFormatID() + ", ARB-Choosen " + this.isChoosenByARB() + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

