/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXContext;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11ExternalGLXDrawable
extends X11GLXDrawable {
    private X11ExternalGLXDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
    }

    protected static X11ExternalGLXDrawable create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        long l2 = GLX.glXGetCurrentContext();
        if (l2 == 0L) {
            throw new GLException("Error: current context null");
        }
        long l3 = GLX.glXGetCurrentDisplay();
        if (l3 == 0L) {
            throw new GLException("Error: current display null");
        }
        long l4 = GLX.glXGetCurrentDrawable();
        if (l4 == 0L) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable current");
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        GLX.glXQueryContext(l3, l2, 32780, intBuffer);
        X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)X11GraphicsScreen.createScreenDevice(l3, intBuffer.get(0), false);
        GLX.glXQueryContext(l3, l2, 32787, intBuffer);
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = X11GLXGraphicsConfiguration.create(gLProfile, x11GraphicsScreen, intBuffer.get(0));
        GLX.glXQueryDrawable(l3, l4, 32797, intBuffer);
        int n2 = intBuffer.get(0);
        GLX.glXQueryDrawable(l3, l4, 32798, intBuffer);
        int n3 = intBuffer.get(0);
        GLX.glXQueryContext(l3, l2, 32785, intBuffer);
        if ((intBuffer.get(0) & 0x8014) == 0 && DEBUG) {
            System.err.println("X11ExternalGLXDrawable: WARNING: forcing GLX_RGBA_TYPE for newly created contexts (current 0x" + Integer.toHexString(intBuffer.get(0)) + ")");
        }
        return new X11ExternalGLXDrawable(gLDrawableFactory, new WrappedSurface(x11GLXGraphicsConfiguration, l4, n2, n3, true));
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new Context(this, gLContext);
    }

    public void setSize(int n2, int n3) {
        throw new GLException("Should not call this");
    }

    static class Context
    extends X11GLXContext {
        Context(X11GLXDrawable x11GLXDrawable, GLContext gLContext) {
            super(x11GLXDrawable, gLContext);
        }
    }
}

