/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXExt;
import jogamp.opengl.x11.glx.GLXExtImpl;
import jogamp.opengl.x11.glx.GLXExtProcAddressTable;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11GLXContext
extends GLContextImpl {
    private static final Map<String, String> extensionNameMap = new HashMap<String, String>();
    private GLXExt _glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    private int hasSwapInterval = 0;
    private int hasSwapGroupNV = 0;
    protected boolean isDirect;
    protected volatile VersionNumber glXServerVersion;
    protected volatile boolean isGLXVersionGreaterEqualOneThree;
    private static final int ctx_arb_attribs_idx_major = 0;
    private static final int ctx_arb_attribs_idx_minor = 2;
    private static final int ctx_arb_attribs_idx_flags = 6;
    private static final int ctx_arb_attribs_idx_profile = 8;
    private static final int[] ctx_arb_attribs_rom;

    X11GLXContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates(boolean bl) {
        this.glXExtProcAddressTable = null;
        this.hasSwapInterval = 0;
        this.hasSwapGroupNV = 0;
        this.isDirect = false;
        this.glXServerVersion = null;
        this.isGLXVersionGreaterEqualOneThree = false;
        super.resetStates(bl);
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getGLXExtProcAddressTable();
    }

    public final GLXExtProcAddressTable getGLXExtProcAddressTable() {
        return this.glXExtProcAddressTable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this._glXExt == null) {
            this._glXExt = new GLXExtImpl(this);
        }
        return this._glXExt;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return extensionNameMap;
    }

    protected final boolean isGLXVersionGreaterEqualOneThree() {
        if (null != this.glXServerVersion) {
            return this.isGLXVersionGreaterEqualOneThree;
        }
        this.glXServerVersion = ((X11GLXDrawableFactory)this.drawable.getFactoryImpl()).getGLXVersionNumber(this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice());
        this.isGLXVersionGreaterEqualOneThree = null != this.glXServerVersion ? this.glXServerVersion.compareTo(X11GLXDrawableFactory.versionOneThree) >= 0 : false;
        return this.isGLXVersionGreaterEqualOneThree;
    }

    protected final void forceGLXVersionOneOne() {
        this.glXServerVersion = X11GLXDrawableFactory.versionOneOne;
        this.isGLXVersionGreaterEqualOneThree = false;
        if (DEBUG) {
            System.err.println("X11GLXContext.forceGLXVersionNumber: " + this.glXServerVersion);
        }
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return this.isGLXVersionGreaterEqualOneThree();
    }

    private final boolean glXMakeContextCurrent(long l2, long l3, long l4, long l5) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (this.isGLXVersionGreaterEqualOneThree()) {
                    bl = GLX.glXMakeContextCurrent(l2, l3, l4, l5);
                    break block4;
                }
                if (l3 == l4) {
                    bl = GLX.glXMakeCurrent(l2, l3, l5);
                    break block4;
                }
                throw new InternalError("Given readDrawable but no driver support");
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG_TRACE_SWITCH) break block4;
                System.err.println(X11GLXContext.getThreadName() + ": Warning: X11GLXContext.glXMakeContextCurrent failed: " + runtimeException + ", with " + "dpy " + X11GLXContext.toHexString(l2) + ", write " + X11GLXContext.toHexString(l3) + ", read " + X11GLXContext.toHexString(l4) + ", ctx " + X11GLXContext.toHexString(l5));
                runtimeException.printStackTrace();
            }
        }
        return bl;
    }

    private final boolean glXReleaseContext(long l2) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.isGLXVersionGreaterEqualOneThree() ? GLX.glXMakeContextCurrent(l2, 0L, 0L, 0L) : GLX.glXMakeCurrent(l2, 0L, 0L);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG_TRACE_SWITCH) break block2;
                System.err.println(X11GLXContext.getThreadName() + ": Warning: X11GLXContext.glXReleaseContext failed: " + runtimeException + ", with " + "dpy " + X11GLXContext.toHexString(l2));
                runtimeException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    protected void destroyContextARBImpl(long l2) {
        long l3 = this.drawable.getNativeSurface().getDisplayHandle();
        this.glXReleaseContext(l3);
        GLX.glXDestroyContext(l3, l2);
    }

    @Override
    protected long createContextARBImpl(long l2, boolean bl, int n2, int n3, int n4) {
        long l3;
        long l4;
        block16: {
            this.updateGLXProcAddressTable();
            GLXExt gLXExt = this.getGLXExt();
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl: " + X11GLXContext.getGLVersion(n3, n4, n2, "@creation") + ", handle " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", share " + X11GLXContext.toHexString(l2) + ", direct " + bl + ", glXCreateContextAttribsARB: " + X11GLXContext.toHexString(this.glXExtProcAddressTable._addressof_glXCreateContextAttribsARB));
            }
            boolean bl2 = 0 != (2 & n2);
            boolean bl3 = 0 != (0x10 & n2);
            boolean bl4 = 0 != (0x20 & n2);
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(ctx_arb_attribs_rom);
            intBuffer.put(1, n3);
            intBuffer.put(3, n4);
            if (n3 > 3 || n3 == 3 && n4 >= 2) {
                intBuffer.put(8, 37158);
                if (bl2) {
                    intBuffer.put(9, 2);
                } else {
                    intBuffer.put(9, 1);
                }
            }
            if (n3 >= 3) {
                int n5 = intBuffer.get(7);
                if (!bl2 && bl3) {
                    n5 |= 2;
                }
                if (bl4) {
                    n5 |= 1;
                }
                intBuffer.put(7, n5);
            }
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
            l4 = abstractGraphicsDevice.getHandle();
            l3 = 0L;
            try {
                X11Util.setX11ErrorHandler(true, !DEBUG);
                X11Lib.XSync(l4, false);
                l3 = gLXExt.glXCreateContextAttribsARB(l4, x11GLXGraphicsConfiguration.getFBConfig(), l2, bl, intBuffer);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block16;
                System.err.println(X11GLXContext.getThreadName() + ": Info: X11GLXContext.createContextARBImpl glXCreateContextAttribsARB failed with " + X11GLXContext.getGLVersion(n3, n4, n2, "@creation"));
                ExceptionUtils.dumpThrowable("", runtimeException);
            }
        }
        if (0L != l3) {
            if (!this.glXMakeContextCurrent(l4, this.drawable.getHandle(), this.drawableRead.getHandle(), l3)) {
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl couldn't make current " + X11GLXContext.getGLVersion(n3, n4, n2, "@creation"));
                }
                this.glXReleaseContext(l4);
                GLX.glXDestroyContext(l4, l3);
                l3 = 0L;
            } else if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: OK " + X11GLXContext.getGLVersion(n3, n4, n2, "@creation") + ", share " + l2 + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: NO " + X11GLXContext.getGLVersion(n3, n4, n2, "@creation"));
        }
        return l3;
    }

    @Override
    protected boolean createImpl(long l2) throws GLException {
        long l3;
        boolean bl;
        boolean bl2 = true;
        this.isDirect = false;
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)this.drawable.getFactoryImpl();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
        X11GLXContext x11GLXContext = (X11GLXContext)x11GLXDrawableFactory.getOrCreateSharedContext(abstractGraphicsDevice);
        long l4 = abstractGraphicsDevice.getHandle();
        if (0L != l2) {
            bl2 = GLX.glXIsDirect(l4, l2);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl3 = this.isCreateContextARBAvail(abstractGraphicsDevice) && x11GLXGraphicsConfiguration.hasFBConfig();
        boolean bl4 = bl = null != x11GLXContext && x11GLXContext.isCreatedWithARBMethod();
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createImpl: START " + gLCapabilitiesImmutable + ", share " + X11GLXContext.toHexString(l2));
            System.err.println(X11GLXContext.getThreadName() + ": Use ARB[avail[" + this.getCreateContextARBAvailStr(abstractGraphicsDevice) + "], fbCfg " + x11GLXGraphicsConfiguration.hasFBConfig() + " -> " + bl3 + "], shared " + bl + "]");
        }
        if (!x11GLXGraphicsConfiguration.hasFBConfig()) {
            this.forceGLXVersionOneOne();
            if (gLProfile.isGL3()) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create OpenGL >= 3.1 context w/o FBConfig");
            }
            this.contextHandle = GLX.glXCreateContext(l4, x11GLXGraphicsConfiguration.getXVisualInfo(), l2, bl2);
            if (0L == this.contextHandle) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create context(0)");
            }
            if (!this.glXMakeContextCurrent(l4, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                throw new GLException(X11GLXContext.getThreadName() + ": Error making temp context(0) current: display " + X11GLXContext.toHexString(l4) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            if (!this.setGLFunctionAvailability(true, 0, 0, 2, false, null == x11GLXContext)) {
                this.glXReleaseContext(l4);
                GLX.glXDestroyContext(l4, this.contextHandle);
                this.contextHandle = 0L;
                throw new GLException("setGLFunctionAvailability !strictMatch failed.1");
            }
            this.isDirect = GLX.glXIsDirect(l4, this.contextHandle);
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (old-1) share " + X11GLXContext.toHexString(l2) + ", direct " + this.isDirect + "/" + bl2);
            }
            return true;
        }
        boolean bl5 = false;
        if (bl3 && bl) {
            this.contextHandle = this.createContextARB(l2, bl2);
            bl5 = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (ARB, using sharedContext) share " + X11GLXContext.toHexString(l2));
            }
        }
        if (0L == this.contextHandle) {
            l3 = GLX.glXCreateNewContext(l4, x11GLXGraphicsConfiguration.getFBConfig(), 32788, l2, bl2);
            if (0L == l3) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create temp OpenGL context(1)");
            }
            if (!this.glXMakeContextCurrent(l4, this.drawable.getHandle(), this.drawableRead.getHandle(), l3)) {
                throw new GLException(X11GLXContext.getThreadName() + ": Error making temp context(1) current: display " + X11GLXContext.toHexString(l4) + ", context " + X11GLXContext.toHexString(l3) + ", drawable " + this.drawable);
            }
            if (!this.setGLFunctionAvailability(true, 0, 0, 2, false, null == x11GLXContext)) {
                this.glXReleaseContext(l4);
                GLX.glXDestroyContext(l4, l3);
                throw new GLException("setGLFunctionAvailability !strictMatch failed.2");
            }
            this.glXReleaseContext(l4);
            if (bl3 && !bl5) {
                boolean bl6 = this.isFunctionAvailable("glXCreateContextAttribsARB");
                boolean bl7 = this.isExtensionAvailable("GLX_ARB_create_context");
                if (bl6 && bl7) {
                    this.contextHandle = this.createContextARB(l2, bl2);
                    bl5 = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (ARB, initial) share " + X11GLXContext.toHexString(l2));
                        } else {
                            System.err.println(X11GLXContext.getThreadName() + ": createImpl: NOT OK (ARB, initial) - creation failed - share " + X11GLXContext.toHexString(l2));
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": createImpl: NOT OK (ARB, initial) - extension not available - share " + X11GLXContext.toHexString(l2) + ", isProcCreateContextAttribsARBAvailable " + bl6 + ", isExtGLXARBCreateContextAvailable " + bl7);
                }
            }
        } else {
            l3 = 0L;
        }
        if (0L != this.contextHandle) {
            if (0L != l3) {
                this.glXReleaseContext(l4);
                GLX.glXDestroyContext(l4, l3);
                if (!this.glXMakeContextCurrent(l4, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException(X11GLXContext.getThreadName() + ": Cannot make previous verified context current");
                }
            }
        } else {
            if (gLProfile.isGL3() && bl5) {
                this.glXReleaseContext(l4);
                GLX.glXDestroyContext(l4, l3);
                throw new GLException(X11GLXContext.getThreadName() + ": createImpl ARB n/a but required, profile > GL2 requested (OpenGL >= 3.1). Requested: " + gLProfile + ", current: " + this.getGLVersion());
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl ARB not used[avail " + bl3 + ", tried " + bl5 + "], fall back to !ARB context " + this.getGLVersion());
            }
            this.contextHandle = l3;
            if (!this.glXMakeContextCurrent(l4, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                this.glXReleaseContext(l4);
                GLX.glXDestroyContext(l4, l3);
                throw new GLException(X11GLXContext.getThreadName() + ": Error making context(1) current: display " + X11GLXContext.toHexString(l4) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (old-2) share " + X11GLXContext.toHexString(l2));
            }
        }
        this.isDirect = GLX.glXIsDirect(l4, this.contextHandle);
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK direct " + this.isDirect + "/" + bl2);
        }
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        long l2 = this.drawable.getNativeSurface().getDisplayHandle();
        if (!this.glXMakeContextCurrent(l2, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + X11GLXContext.toHexString(this.contextHandle) + " current on Thread " + X11GLXContext.getThreadName() + " with display " + X11GLXContext.toHexString(l2) + ", drawableWrite " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + X11GLXContext.toHexString(this.drawableRead.getHandle()) + " - " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        long l2 = this.drawable.getNativeSurface().getDisplayHandle();
        if (!this.glXReleaseContext(l2)) {
            throw new GLException(X11GLXContext.getThreadName() + ": Error freeing OpenGL context");
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        this.destroyContextARBImpl(this.contextHandle);
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n2) throws GLException {
        long l2 = this.getHandle();
        long l3 = gLContext.getHandle();
        long l4 = this.drawable.getNativeSurface().getDisplayHandle();
        if (0L == l4) {
            throw new GLException(X11GLXContext.getThreadName() + ": Connection to X display not yet set up");
        }
        GLX.glXCopyContext(l4, l3, l2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "GLX-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": Initializing GLX extension address table: " + string);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.glXExtProcAddressTable = (GLXExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": GLContext GLX ProcAddressTable reusing key(" + string + ") -> " + X11GLXContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.glXExtProcAddressTable = new GLXExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getGLXExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getGLXExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": GLContext GLX ProcAddressTable mapping key(" + string + ") -> " + X11GLXContext.toHexString(this.getGLXExtProcAddressTable().hashCode()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        NativeSurface nativeSurface = this.drawable.getNativeSurface();
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        StringBuilder stringBuilder = new StringBuilder();
        x11GraphicsDevice.lock();
        try {
            if (DEBUG) {
                System.err.println("GLX Version client " + GLXUtil.getClientVersionNumber() + ", server: " + GLXUtil.getGLXServerVersionNumber(x11GraphicsDevice));
            }
            if (((X11GLXDrawableFactory)this.drawable.getFactoryImpl()).isGLXVersionGreaterEqualOneOne(x11GraphicsDevice)) {
                String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 3);
                if (DEBUG) {
                    System.err.println("GLX extensions (glXGetClientString): " + string);
                }
                stringBuilder.append(string).append(" ");
                string = GLX.glXQueryExtensionsString(x11GraphicsDevice.getHandle(), nativeSurface.getScreenIndex());
                if (DEBUG) {
                    System.err.println("GLX extensions (glXQueryExtensionsString): " + string);
                }
                stringBuilder.append(string).append(" ");
                string = GLX.glXQueryServerString(x11GraphicsDevice.getHandle(), nativeSurface.getScreenIndex(), 3);
                if (DEBUG) {
                    System.err.println("GLX extensions (glXQueryServerString): " + string);
                }
                stringBuilder.append(string).append(" ");
            }
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        return stringBuilder;
    }

    @Override
    protected boolean setSwapIntervalImpl(int n2) {
        if (!this.drawable.getChosenGLCapabilities().isOnscreen()) {
            return false;
        }
        GLXExt gLXExt = this.getGLXExt();
        if (0 == this.hasSwapInterval) {
            try {
                if (gLXExt.isExtensionAvailable("GLX_SGI_swap_control")) {
                    if (DEBUG) {
                        System.err.println("X11GLXContext.setSwapInterval using: GLX_SGI_swap_control");
                    }
                    this.hasSwapInterval = 2;
                } else {
                    this.hasSwapInterval = -1;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapInterval = -1;
            }
        }
        if (2 == this.hasSwapInterval) {
            try {
                return 0 == gLXExt.glXSwapIntervalSGI(n2);
            }
            catch (Throwable throwable) {
                this.hasSwapInterval = -1;
            }
        }
        return false;
    }

    private final int initSwapGroupImpl(GLXExt gLXExt) {
        if (0 == this.hasSwapGroupNV) {
            try {
                this.hasSwapGroupNV = gLXExt.isExtensionAvailable("GLX_NV_swap_group") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = 1;
            }
            if (DEBUG) {
                System.err.println("initSwapGroupImpl: GLX_NV_swap_group: " + this.hasSwapGroupNV);
            }
        }
        return this.hasSwapGroupNV;
    }

    @Override
    protected final boolean queryMaxSwapGroupsImpl(int[] nArray, int n2, int[] nArray2, int n3) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            NativeSurface nativeSurface = this.drawable.getNativeSurface();
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer(nArray.length - n2);
                IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(nArray2.length - n3);
                if (gLXExt.glXQueryMaxSwapGroupsNV(nativeSurface.getDisplayHandle(), nativeSurface.getScreenIndex(), intBuffer, intBuffer2)) {
                    intBuffer.get(nArray, n2, intBuffer.remaining());
                    intBuffer2.get(nArray, n2, intBuffer2.remaining());
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean joinSwapGroupImpl(int n2) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            try {
                if (gLXExt.glXJoinSwapGroupNV(this.drawable.getNativeSurface().getDisplayHandle(), this.drawable.getHandle(), n2)) {
                    this.currentSwapGroup = n2;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean bindSwapBarrierImpl(int n2, int n3) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            try {
                if (gLXExt.glXBindSwapBarrierNV(this.drawable.getNativeSurface().getDisplayHandle(), n2, n3)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append(", direct ");
        stringBuilder.append(this.isDirect);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static {
        extensionNameMap.put("GL_ARB_pbuffer", "GLX_SGIX_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "GLX_SGIX_pbuffer");
        ctx_arb_attribs_rom = new int[]{8337, 0, 8338, 0, 32785, 32788, 8340, 0, 0, 0, 0};
    }
}

