/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.glxn.qrgen.exception.QRGenerationException;
import net.glxn.qrgen.image.ImageType;

public class QRCode {
    Writer qrWriter;
    private int width = 125;
    private int height = 125;
    private final String text;
    private ImageType imageType = ImageType.PNG;
    private final HashMap<EncodeHintType, Object> hints = new HashMap();

    private QRCode(String text) {
        this.text = text;
        this.qrWriter = new QRCodeWriter();
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public QRCode to(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public QRCode withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public QRCode withCharset(String charset) {
        this.hints.put(EncodeHintType.CHARACTER_SET, charset);
        return this;
    }

    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToFile(this.createMatrix(), this.imageType.toString(), file);
        }
        catch (Exception e2) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e2);
        }
        return file;
    }

    public File file(String name) {
        File file;
        try {
            file = this.createTempFile(name);
            MatrixToImageWriter.writeToFile(this.createMatrix(), this.imageType.toString(), file);
        }
        catch (Exception e2) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e2);
        }
        return file;
    }

    public ByteArrayOutputStream stream() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.writeToStream(stream);
        }
        catch (Exception e2) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e2);
        }
        return stream;
    }

    public void writeTo(OutputStream stream) {
        try {
            this.writeToStream(stream);
        }
        catch (Exception e2) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e2);
        }
    }

    private void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream(this.createMatrix(), this.imageType.toString(), stream);
    }

    private BitMatrix createMatrix() throws WriterException {
        return this.qrWriter.encode(this.text, BarcodeFormat.QR_CODE, this.width, this.height, this.hints);
    }

    private File createTempFile() throws IOException {
        File file = File.createTempFile("QRCode", "." + this.imageType.toString().toLowerCase());
        file.deleteOnExit();
        return file;
    }

    private File createTempFile(String name) throws IOException {
        File file = File.createTempFile(name, "." + this.imageType.toString().toLowerCase());
        file.deleteOnExit();
        return file;
    }
}

