/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;

public class GroupLayout
implements LayoutManager2 {
    private static final int MIN_SIZE = 0;
    private static final int PREF_SIZE = 1;
    private static final int MAX_SIZE = 2;
    private static final int SPECIFIC_SIZE = 3;
    private static final int UNSET = Integer.MIN_VALUE;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final int NO_ALIGNMENT = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int CENTER = 4;
    public static final int BASELINE = 3;
    public static final int DEFAULT_SIZE = -1;
    public static final int PREFERRED_SIZE = -2;
    private boolean autocreatePadding;
    private boolean autocreateContainerPadding;
    private Group horizontalGroup;
    private Group verticalGroup;
    private Map componentInfos;
    private Container host;
    private Set tmpParallelSet;
    private boolean springsChanged;
    private boolean isValid;
    private boolean hasPreferredPaddingSprings;
    private LayoutStyle layoutStyle;
    private boolean honorsVisibility;
    static /* synthetic */ Class class$org$jdesktop$layout$GroupLayout;

    private static void checkSize(int n2, int n3, int n4, boolean bl) {
        GroupLayout.checkResizeType(n2, bl);
        if (!bl && n3 < 0) {
            throw new IllegalArgumentException("Pref must be >= 0");
        }
        if (bl) {
            GroupLayout.checkResizeType(n3, true);
        }
        GroupLayout.checkResizeType(n4, bl);
        GroupLayout.checkLessThan(n2, n3);
        GroupLayout.checkLessThan(n3, n4);
    }

    private static void checkResizeType(int n2, boolean bl) {
        if (n2 < 0 && (bl && n2 != -1 && n2 != -2 || !bl && n2 != -2)) {
            throw new IllegalArgumentException("Invalid size");
        }
    }

    private static void checkLessThan(int n2, int n3) {
        if (n2 >= 0 && n3 >= 0 && n2 > n3) {
            throw new IllegalArgumentException("Following is not met: min<=pref<=max");
        }
    }

    public GroupLayout(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Container must be non-null");
        }
        this.honorsVisibility = true;
        this.host = container;
        this.setHorizontalGroup(this.createParallelGroup(1, true));
        this.setVerticalGroup(this.createParallelGroup(1, true));
        this.componentInfos = new HashMap();
        this.tmpParallelSet = new HashSet();
    }

    public void setHonorsVisibility(boolean bl) {
        if (this.honorsVisibility != bl) {
            this.honorsVisibility = bl;
            this.springsChanged = true;
            this.isValid = false;
            this.invalidateHost();
        }
    }

    public boolean getHonorsVisibility() {
        return this.honorsVisibility;
    }

    public void setHonorsVisibility(Component component, Boolean bl) {
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        this.getComponentInfo(component).setHonorsVisibility(bl);
        this.springsChanged = true;
        this.isValid = false;
        this.invalidateHost();
    }

    public String toString() {
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HORIZONTAL\n");
        this.dump(stringBuffer, this.horizontalGroup, "  ", 1);
        stringBuffer.append("\nVERTICAL\n");
        this.dump(stringBuffer, this.verticalGroup, "  ", 2);
        return stringBuffer.toString();
    }

    private void dump(StringBuffer stringBuffer, Spring spring, String string, int n2) {
        Object object;
        String string2 = "";
        String string3 = "";
        if (spring instanceof ComponentSpring) {
            object = (ComponentSpring)spring;
            string2 = Integer.toString(((ComponentSpring)object).getOrigin()) + " ";
            String string4 = ((ComponentSpring)object).getComponent().getName();
            if (string4 != null) {
                string2 = "name=" + string4 + ", ";
            }
        }
        if (spring instanceof AutopaddingSpring) {
            object = (AutopaddingSpring)spring;
            string3 = ", userCreated=" + ((AutopaddingSpring)object).getUserCreated() + ", matches=" + ((AutopaddingSpring)object).getMatchDescription();
        }
        stringBuffer.append(string + spring.getClass().getName() + " " + Integer.toHexString(spring.hashCode()) + " " + string2 + ", size=" + spring.getSize() + ", alignment=" + spring.getAlignment() + " prefs=[" + spring.getMinimumSize(n2) + " " + spring.getPreferredSize(n2) + " " + spring.getMaximumSize(n2) + string3 + "]\n");
        if (spring instanceof Group) {
            object = ((Group)spring).springs;
            string = string + "  ";
            for (int i2 = 0; i2 < object.size(); ++i2) {
                this.dump(stringBuffer, (Spring)object.get(i2), string, n2);
            }
        }
    }

    public void setAutocreateGaps(boolean bl) {
        if (this.autocreatePadding != bl) {
            this.autocreatePadding = bl;
            this.invalidateHost();
        }
    }

    public boolean getAutocreateGaps() {
        return this.autocreatePadding;
    }

    public void setAutocreateContainerGaps(boolean bl) {
        if (bl != this.autocreateContainerPadding) {
            this.autocreateContainerPadding = bl;
            this.horizontalGroup = this.createTopLevelGroup(this.getHorizontalGroup());
            this.verticalGroup = this.createTopLevelGroup(this.getVerticalGroup());
            this.invalidateHost();
        }
    }

    public boolean getAutocreateContainerGaps() {
        return this.autocreateContainerPadding;
    }

    public void setHorizontalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.horizontalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    public Group getHorizontalGroup() {
        int n2 = 0;
        if (this.horizontalGroup.springs.size() > 1) {
            n2 = 1;
        }
        return (Group)this.horizontalGroup.springs.get(n2);
    }

    public void setVerticalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.verticalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    public Group getVerticalGroup() {
        int n2 = 0;
        if (this.verticalGroup.springs.size() > 1) {
            n2 = 1;
        }
        return (Group)this.verticalGroup.springs.get(n2);
    }

    private Group createTopLevelGroup(Group group) {
        SequentialGroup sequentialGroup = this.createSequentialGroup();
        if (this.getAutocreateContainerGaps()) {
            sequentialGroup.addSpring(new ContainerAutopaddingSpring());
            sequentialGroup.add(group);
            sequentialGroup.addSpring(new ContainerAutopaddingSpring());
        } else {
            sequentialGroup.add(group);
        }
        return sequentialGroup;
    }

    public SequentialGroup createSequentialGroup() {
        return new SequentialGroup();
    }

    public ParallelGroup createParallelGroup() {
        return this.createParallelGroup(1);
    }

    public ParallelGroup createParallelGroup(int n2) {
        return this.createParallelGroup(n2, true);
    }

    public ParallelGroup createParallelGroup(int n2, boolean bl) {
        if (n2 == 3) {
            return new BaselineGroup(bl);
        }
        return new ParallelGroup(n2, bl);
    }

    public ParallelGroup createBaselineGroup(boolean bl, boolean bl2) {
        return new BaselineGroup(bl, bl2);
    }

    public void linkSize(Component[] componentArray) {
        this.linkSize(componentArray, 3);
    }

    public void linkSize(Component[] componentArray, int n2) {
        boolean bl;
        if (componentArray == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        boolean bl2 = (n2 & 1) == 1;
        boolean bl3 = bl = (n2 & 2) == 2;
        if (!bl && !bl2) {
            throw new IllegalArgumentException("Axis must contain HORIZONTAL or VERTICAL");
        }
        for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
            Component component = componentArray[i2];
            if (componentArray[i2] == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.getComponentInfo(component);
        }
        if (bl2) {
            this.linkSize0(componentArray, 1);
        }
        if (bl) {
            this.linkSize0(componentArray, 2);
        }
        this.invalidateHost();
    }

    private void linkSize0(Component[] componentArray, int n2) {
        LinkInfo linkInfo = this.getComponentInfo(componentArray[componentArray.length - 1]).getLinkInfo(n2);
        for (int i2 = componentArray.length - 2; i2 >= 0; --i2) {
            linkInfo.add(this.getComponentInfo(componentArray[i2]));
        }
    }

    public void replace(Component component, Component component2) {
        ComponentInfo componentInfo;
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        if ((componentInfo = (ComponentInfo)this.componentInfos.remove(component)) == null) {
            throw new IllegalArgumentException("Component must already exist");
        }
        this.host.remove(component);
        if (component2.getParent() != this.host) {
            this.host.add(component2);
        }
        componentInfo.setComponent(component2);
        this.componentInfos.put(component2, componentInfo);
        this.invalidateHost();
    }

    public void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyle = layoutStyle;
        this.invalidateHost();
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    private LayoutStyle getLayoutStyle0() {
        LayoutStyle layoutStyle = this.getLayoutStyle();
        if (layoutStyle == null) {
            layoutStyle = LayoutStyle.getSharedInstance();
        }
        return layoutStyle;
    }

    private void invalidateHost() {
        if (this.host instanceof JComponent) {
            ((JComponent)this.host).revalidate();
        } else {
            this.host.invalidate();
        }
        this.host.repaint();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        ComponentInfo componentInfo = (ComponentInfo)this.componentInfos.remove(component);
        if (componentInfo != null) {
            componentInfo.dispose();
            this.springsChanged = true;
            this.isValid = false;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(1);
        return this.adjustSize(this.horizontalGroup.getPreferredSize(1), this.verticalGroup.getPreferredSize(2));
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(0);
        return this.adjustSize(this.horizontalGroup.getMinimumSize(1), this.verticalGroup.getMinimumSize(2));
    }

    public void layoutContainer(Container container) {
        this.prepare(3);
        Insets insets = container.getInsets();
        int n2 = container.getWidth() - insets.left - insets.right;
        int n3 = container.getHeight() - insets.top - insets.bottom;
        boolean bl = this.isLeftToRight();
        if (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.calculateAutopadding(this.horizontalGroup, 1, 3, 0, n2);
            this.calculateAutopadding(this.verticalGroup, 2, 3, 0, n3);
        }
        this.horizontalGroup.setSize(1, 0, n2);
        this.verticalGroup.setSize(2, 0, n3);
        Iterator iterator = this.componentInfos.values().iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = (ComponentInfo)iterator.next();
            Component component = componentInfo.getComponent();
            componentInfo.setBounds(insets, n2, bl);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public Dimension maximumLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(2);
        return this.adjustSize(this.horizontalGroup.getMaximumSize(1), this.verticalGroup.getMaximumSize(2));
    }

    public float getLayoutAlignmentX(Container container) {
        this.checkParent(container);
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        this.checkParent(container);
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout(Container container) {
        this.checkParent(container);
        Object object = container.getTreeLock();
        synchronized (object) {
            this.isValid = false;
        }
    }

    private void prepare(int n2) {
        boolean bl = false;
        if (!this.isValid) {
            this.isValid = true;
            this.horizontalGroup.setSize(1, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.verticalGroup.setSize(2, Integer.MIN_VALUE, Integer.MIN_VALUE);
            Iterator iterator = this.componentInfos.values().iterator();
            while (iterator.hasNext()) {
                ComponentInfo componentInfo = (ComponentInfo)iterator.next();
                if (componentInfo.updateVisibility()) {
                    bl = true;
                }
                componentInfo.clearCachedSize();
            }
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
        }
        if (this.springsChanged || bl) {
            this.checkComponents();
            this.horizontalGroup.removeAutopadding();
            this.verticalGroup.removeAutopadding();
            if (this.getAutocreateGaps()) {
                this.insertAutopadding(true);
            } else if (this.hasPreferredPaddingSprings || this.getAutocreateContainerGaps()) {
                this.insertAutopadding(false);
            }
            this.springsChanged = false;
        }
        if (n2 != 3 && (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings)) {
            this.calculateAutopadding(this.horizontalGroup, 1, n2, 0, 0);
            this.calculateAutopadding(this.verticalGroup, 2, n2, 0, 0);
        }
    }

    private void calculateAutopadding(Group group, int n2, int n3, int n4, int n5) {
        group.unsetAutopadding();
        switch (n3) {
            case 0: {
                n5 = group.getMinimumSize(n2);
                break;
            }
            case 1: {
                n5 = group.getPreferredSize(n2);
                break;
            }
            case 2: {
                n5 = group.getMaximumSize(n2);
            }
        }
        group.setSize(n2, n4, n5);
        group.calculateAutopadding(n2);
    }

    private void checkComponents() {
        Iterator iterator = this.componentInfos.values().iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = (ComponentInfo)iterator.next();
            if (componentInfo.horizontalSpring == null) {
                throw new IllegalStateException(componentInfo.component + " is not attached to a horizontal group");
            }
            if (componentInfo.verticalSpring != null) continue;
            throw new IllegalStateException(componentInfo.component + " is not attached to a vertical group");
        }
    }

    private void registerComponents(Group group, int n2) {
        List list = group.springs;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Spring spring = (Spring)list.get(i2);
            if (spring instanceof ComponentSpring) {
                ((ComponentSpring)spring).installIfNecessary(n2);
                continue;
            }
            if (!(spring instanceof Group)) continue;
            this.registerComponents((Group)spring, n2);
        }
    }

    private Dimension adjustSize(int n2, int n3) {
        Insets insets = this.host.getInsets();
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    private void checkParent(Container container) {
        if (container != this.host) {
            throw new IllegalArgumentException("GroupLayout can only be used with one Container at a time");
        }
    }

    private ComponentInfo getComponentInfo(Component component) {
        ComponentInfo componentInfo = (ComponentInfo)this.componentInfos.get(component);
        if (componentInfo == null) {
            componentInfo = new ComponentInfo(component);
            this.componentInfos.put(component, componentInfo);
            if (component.getParent() != this.host) {
                this.host.add(component);
            }
        }
        return componentInfo;
    }

    private void insertAutopadding(boolean bl) {
        this.horizontalGroup.insertAutopadding(1, new ArrayList(1), new ArrayList(1), new ArrayList(1), new ArrayList(1), bl);
        this.verticalGroup.insertAutopadding(2, new ArrayList(1), new ArrayList(1), new ArrayList(1), new ArrayList(1), bl);
    }

    private boolean areParallelSiblings(Component component, Component component2, int n2) {
        Spring spring;
        ComponentSpring componentSpring;
        ComponentSpring componentSpring2;
        ComponentInfo componentInfo = this.getComponentInfo(component);
        ComponentInfo componentInfo2 = this.getComponentInfo(component2);
        if (n2 == 1) {
            componentSpring2 = componentInfo.horizontalSpring;
            componentSpring = componentInfo2.horizontalSpring;
        } else {
            componentSpring2 = componentInfo.verticalSpring;
            componentSpring = componentInfo2.verticalSpring;
        }
        Set set = this.tmpParallelSet;
        set.clear();
        for (spring = componentSpring2.getParent(); spring != null; spring = spring.getParent()) {
            set.add(spring);
        }
        for (spring = componentSpring.getParent(); spring != null; spring = spring.getParent()) {
            if (!set.contains(spring)) continue;
            set.clear();
            while (spring != null) {
                if (spring instanceof ParallelGroup) {
                    return true;
                }
                spring = spring.getParent();
            }
            return false;
        }
        set.clear();
        return false;
    }

    private boolean isLeftToRight() {
        return this.host.getComponentOrientation().isLeftToRight();
    }

    private final class ComponentInfo {
        private Component component;
        ComponentSpring horizontalSpring;
        ComponentSpring verticalSpring;
        private LinkInfo horizontalMaster;
        private LinkInfo verticalMaster;
        private boolean visible;
        private Boolean honorsVisibility;
        static final /* synthetic */ boolean $assertionsDisabled;

        ComponentInfo(Component component) {
            this.component = component;
            this.updateVisibility();
        }

        public void dispose() {
            this.removeSpring(this.horizontalSpring);
            this.horizontalSpring = null;
            this.removeSpring(this.verticalSpring);
            this.verticalSpring = null;
            if (this.horizontalMaster != null) {
                this.horizontalMaster.remove(this);
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.remove(this);
            }
        }

        void setHonorsVisibility(Boolean bl) {
            this.honorsVisibility = bl;
        }

        private void removeSpring(Spring spring) {
            if (spring != null) {
                ((Group)spring.getParent()).springs.remove(spring);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        boolean updateVisibility() {
            boolean bl;
            boolean bl2 = this.honorsVisibility == null ? GroupLayout.this.getHonorsVisibility() : this.honorsVisibility.booleanValue();
            boolean bl3 = bl = bl2 ? this.component.isVisible() : true;
            if (this.visible != bl) {
                this.visible = bl;
                return true;
            }
            return false;
        }

        public void setBounds(Insets insets, int n2, boolean bl) {
            int n3 = this.horizontalSpring.getOrigin();
            int n4 = this.horizontalSpring.getSize();
            int n5 = this.verticalSpring.getOrigin();
            int n6 = this.verticalSpring.getSize();
            if (!bl) {
                n3 = n2 - n3 - n4;
            }
            this.component.setBounds(n3 + insets.left, n5 + insets.top, n4, n6);
        }

        public void setComponent(Component component) {
            this.component = component;
            if (this.horizontalSpring != null) {
                this.horizontalSpring.setComponent(component);
            }
            if (this.verticalSpring != null) {
                this.verticalSpring.setComponent(component);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isLinked(int n2) {
            if (n2 == 1) {
                return this.horizontalMaster != null;
            }
            if (!$assertionsDisabled && n2 != 2) {
                throw new AssertionError();
            }
            return this.verticalMaster != null;
        }

        private void setLinkInfo(int n2, LinkInfo linkInfo) {
            if (n2 == 1) {
                this.horizontalMaster = linkInfo;
            } else {
                if (!$assertionsDisabled && n2 != 2) {
                    throw new AssertionError();
                }
                this.verticalMaster = linkInfo;
            }
        }

        public LinkInfo getLinkInfo(int n2) {
            return this.getLinkInfo(n2, true);
        }

        private LinkInfo getLinkInfo(int n2, boolean bl) {
            if (n2 == 1) {
                if (this.horizontalMaster == null && bl) {
                    new LinkInfo(1).add(this);
                }
                return this.horizontalMaster;
            }
            if (!$assertionsDisabled && n2 != 2) {
                throw new AssertionError();
            }
            if (this.verticalMaster == null && bl) {
                new LinkInfo(2).add(this);
            }
            return this.verticalMaster;
        }

        public void clearCachedSize() {
            if (this.horizontalMaster != null) {
                this.horizontalMaster.clearCachedSize();
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.clearCachedSize();
            }
        }

        int getLinkSize(int n2, int n3) {
            if (n2 == 1) {
                return this.horizontalMaster.getSize(n2);
            }
            if (!$assertionsDisabled && n2 != 2) {
                throw new AssertionError();
            }
            return this.verticalMaster.getSize(n2);
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    private static final class LinkInfo {
        private final int axis;
        private final List linked = new ArrayList();
        private int size = Integer.MIN_VALUE;
        static final /* synthetic */ boolean $assertionsDisabled;

        LinkInfo(int n2) {
            this.axis = n2;
        }

        public void add(ComponentInfo componentInfo) {
            LinkInfo linkInfo = componentInfo.getLinkInfo(this.axis, false);
            if (linkInfo == null) {
                this.linked.add(componentInfo);
                componentInfo.setLinkInfo(this.axis, this);
            } else if (linkInfo != this) {
                this.linked.addAll(linkInfo.linked);
                for (int i2 = 0; i2 < linkInfo.linked.size(); ++i2) {
                    ComponentInfo componentInfo2 = (ComponentInfo)linkInfo.linked.get(i2);
                    componentInfo2.setLinkInfo(this.axis, this);
                }
            }
            this.clearCachedSize();
        }

        public void remove(ComponentInfo componentInfo) {
            this.linked.remove(componentInfo);
            componentInfo.setLinkInfo(this.axis, null);
            if (this.linked.size() == 1) {
                ((ComponentInfo)this.linked.get(0)).setLinkInfo(this.axis, null);
            }
            this.clearCachedSize();
        }

        public void clearCachedSize() {
            this.size = Integer.MIN_VALUE;
        }

        public int getSize(int n2) {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.calculateLinkedSize(n2);
            }
            return this.size;
        }

        private int calculateLinkedSize(int n2) {
            int n3 = 0;
            for (int i2 = 0; i2 < this.linked.size(); ++i2) {
                ComponentSpring componentSpring;
                ComponentInfo componentInfo = (ComponentInfo)this.linked.get(i2);
                if (n2 == 1) {
                    componentSpring = componentInfo.horizontalSpring;
                } else {
                    if (!$assertionsDisabled && n2 != 2) {
                        throw new AssertionError();
                    }
                    componentSpring = componentInfo.verticalSpring;
                }
                n3 = Math.max(n3, componentSpring.calculateNonlinkedPreferredSize(n2));
            }
            return n3;
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    private class ContainerAutopaddingSpring
    extends AutopaddingSpring {
        private List targets;

        ContainerAutopaddingSpring() {
            this.setUserCreated(true);
        }

        ContainerAutopaddingSpring(int n2, int n3) {
            super(n2, n3);
            this.setUserCreated(true);
        }

        public void addTarget(ComponentSpring componentSpring, int n2) {
            if (this.targets == null) {
                this.targets = new ArrayList(1);
            }
            this.targets.add(componentSpring);
        }

        public void calculatePadding(int n2) {
            LayoutStyle layoutStyle = GroupLayout.this.getLayoutStyle0();
            int n3 = 0;
            this.size = 0;
            if (this.targets != null) {
                int n4 = n2 == 1 ? (GroupLayout.this.isLeftToRight() ? 7 : 3) : 5;
                for (int i2 = this.targets.size() - 1; i2 >= 0; --i2) {
                    ComponentSpring componentSpring = (ComponentSpring)this.targets.get(i2);
                    int n5 = 10;
                    if (componentSpring.getComponent() instanceof JComponent) {
                        n5 = layoutStyle.getContainerGap((JComponent)componentSpring.getComponent(), n4, GroupLayout.this.host);
                        n3 = Math.max(n5, n3);
                        n5 -= componentSpring.getOrigin();
                    } else {
                        n3 = Math.max(n5, n3);
                    }
                    this.size = Math.max(this.size, n5);
                }
            } else {
                int n6 = n2 == 1 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                if (this.sources != null) {
                    for (int i3 = this.sources.size() - 1; i3 >= 0; --i3) {
                        ComponentSpring componentSpring = (ComponentSpring)this.sources.get(i3);
                        n3 = Math.max(n3, this.updateSize(layoutStyle, componentSpring, n6));
                    }
                } else if (this.source != null) {
                    n3 = this.updateSize(layoutStyle, this.source, n6);
                }
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(n3, this.lastSize);
            }
        }

        private int updateSize(LayoutStyle layoutStyle, ComponentSpring componentSpring, int n2) {
            int n3 = 10;
            if (componentSpring.getComponent() instanceof JComponent) {
                n3 = layoutStyle.getContainerGap((JComponent)componentSpring.getComponent(), n2, GroupLayout.this.host);
            }
            int n4 = Math.max(0, this.getParent().getSize() - componentSpring.getSize() - componentSpring.getOrigin());
            this.size = Math.max(this.size, n3 - n4);
            return n3;
        }

        String getMatchDescription() {
            if (this.targets != null) {
                return "leading: " + this.targets.toString();
            }
            if (this.sources != null) {
                return "trailing: " + this.sources.toString();
            }
            return "--";
        }
    }

    private static final class AutopaddingMatch {
        public final ComponentSpring source;
        public final ComponentSpring target;

        AutopaddingMatch(ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            this.source = componentSpring;
            this.target = componentSpring2;
        }

        private String toString(ComponentSpring componentSpring) {
            return componentSpring.getComponent().getName();
        }

        public String toString() {
            return "[" + this.toString(this.source) + "-" + this.toString(this.target) + "]";
        }
    }

    private class AutopaddingSpring
    extends Spring {
        List sources;
        ComponentSpring source;
        private List matches;
        int size;
        int lastSize;
        private final int pref;
        private final int max;
        private int type;
        private boolean userCreated;

        private AutopaddingSpring() {
            this.pref = -2;
            this.max = -2;
            this.type = 0;
        }

        AutopaddingSpring(int n2, int n3) {
            this.pref = n2;
            this.max = n3;
        }

        AutopaddingSpring(int n2, int n3, int n4) {
            this.type = n2;
            this.pref = n3;
            this.max = n4;
            this.userCreated = true;
        }

        public void setSource(ComponentSpring componentSpring) {
            this.source = componentSpring;
        }

        public void setSources(List list) {
            this.sources = new ArrayList(list);
        }

        public void setUserCreated(boolean bl) {
            this.userCreated = bl;
        }

        public boolean getUserCreated() {
            return this.userCreated;
        }

        void unset() {
            this.lastSize = this.getSize();
            super.unset();
            this.size = 0;
        }

        public void reset() {
            this.size = 0;
            this.sources = null;
            this.source = null;
            this.matches = null;
        }

        public void calculatePadding(int n2) {
            this.size = Integer.MIN_VALUE;
            int n3 = Integer.MIN_VALUE;
            if (this.matches != null) {
                LayoutStyle layoutStyle = GroupLayout.this.getLayoutStyle0();
                int n4 = n2 == 1 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                for (int i2 = this.matches.size() - 1; i2 >= 0; --i2) {
                    AutopaddingMatch autopaddingMatch = (AutopaddingMatch)this.matches.get(i2);
                    n3 = Math.max(n3, this.calculatePadding(layoutStyle, n4, autopaddingMatch.source, autopaddingMatch.target));
                }
            }
            if (this.size == Integer.MIN_VALUE) {
                this.size = 0;
            }
            if (n3 == Integer.MIN_VALUE) {
                n3 = 0;
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(n3, this.lastSize);
            }
        }

        private int calculatePadding(LayoutStyle layoutStyle, int n2, ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            int n3 = componentSpring2.getOrigin() - (componentSpring.getOrigin() + componentSpring.getSize());
            if (n3 >= 0) {
                int n4 = componentSpring.getComponent() instanceof JComponent && componentSpring2.getComponent() instanceof JComponent ? layoutStyle.getPreferredGap((JComponent)componentSpring.getComponent(), (JComponent)componentSpring2.getComponent(), this.type, n2, GroupLayout.this.host) : 10;
                if (n4 > n3) {
                    this.size = Math.max(this.size, n4 - n3);
                }
                return n4;
            }
            return 0;
        }

        public void addTarget(ComponentSpring componentSpring, int n2) {
            int n3;
            int n4 = n3 = n2 == 1 ? 2 : 1;
            if (this.source != null) {
                if (GroupLayout.this.areParallelSiblings(this.source.getComponent(), componentSpring.getComponent(), n3)) {
                    this.addValidTarget(this.source, componentSpring);
                }
            } else {
                Component component = componentSpring.getComponent();
                for (int i2 = this.sources.size() - 1; i2 >= 0; --i2) {
                    ComponentSpring componentSpring2 = (ComponentSpring)this.sources.get(i2);
                    if (!GroupLayout.this.areParallelSiblings(componentSpring2.getComponent(), component, n3)) continue;
                    this.addValidTarget(componentSpring2, componentSpring);
                }
            }
        }

        private void addValidTarget(ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            if (this.matches == null) {
                this.matches = new ArrayList(1);
            }
            this.matches.add(new AutopaddingMatch(componentSpring, componentSpring2));
        }

        int calculateMinimumSize(int n2) {
            return this.size;
        }

        int calculatePreferredSize(int n2) {
            if (this.pref == -2 || this.pref == -1) {
                return this.size;
            }
            return Math.max(this.size, this.pref);
        }

        int calculateMaximumSize(int n2) {
            if (this.max >= 0) {
                return Math.max(this.getPreferredSize(n2), this.max);
            }
            return this.size;
        }

        String getMatchDescription() {
            return this.matches == null ? "" : this.matches.toString();
        }

        public String toString() {
            return super.toString() + this.getMatchDescription();
        }

        boolean willHaveZeroSize(boolean bl) {
            return bl;
        }
    }

    private final class GapSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;

        GapSpring(int n2, int n3, int n4) {
            GroupLayout.checkSize(n2, n3, n4, false);
            this.min = n2;
            this.pref = n3;
            this.max = n4;
        }

        int calculateMinimumSize(int n2) {
            if (this.min == -2) {
                return this.getPreferredSize(n2);
            }
            return this.min;
        }

        int calculatePreferredSize(int n2) {
            return this.pref;
        }

        int calculateMaximumSize(int n2) {
            if (this.max == -2) {
                return this.getPreferredSize(n2);
            }
            return this.max;
        }

        boolean willHaveZeroSize(boolean bl) {
            return false;
        }
    }

    private final class PaddingSpring
    extends Spring {
        private final JComponent source;
        private final JComponent target;
        private final int type;
        private final boolean canGrow;

        PaddingSpring(JComponent jComponent, JComponent jComponent2, int n2, boolean bl) {
            this.source = jComponent;
            this.target = jComponent2;
            this.type = n2;
            this.canGrow = bl;
        }

        int calculateMinimumSize(int n2) {
            return this.getPadding(n2);
        }

        int calculatePreferredSize(int n2) {
            return this.getPadding(n2);
        }

        int calculateMaximumSize(int n2) {
            if (this.canGrow) {
                return Short.MAX_VALUE;
            }
            return this.getPadding(n2);
        }

        private int getPadding(int n2) {
            int n3 = n2 == 1 ? 3 : 5;
            return GroupLayout.this.getLayoutStyle0().getPreferredGap(this.source, this.target, this.type, n3, GroupLayout.this.host);
        }

        boolean willHaveZeroSize(boolean bl) {
            return false;
        }
    }

    private final class ComponentSpring
    extends Spring {
        private Component component;
        private int origin;
        private final int min;
        private final int pref;
        private final int max;
        private int baseline;
        private boolean installed;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ComponentSpring(Component component, int n2, int n3, int n4) {
            this.baseline = -1;
            this.component = component;
            if (component == null) {
                throw new IllegalArgumentException("Component must be non-null");
            }
            GroupLayout.checkSize(n2, n3, n4, true);
            this.min = n2;
            this.max = n4;
            this.pref = n3;
            GroupLayout.this.getComponentInfo(component);
        }

        int calculateMinimumSize(int n2) {
            if (this.isLinked(n2)) {
                return this.getLinkSize(n2, 0);
            }
            return this.calculateNonlinkedMinimumSize(n2);
        }

        int calculatePreferredSize(int n2) {
            if (this.isLinked(n2)) {
                return this.getLinkSize(n2, 1);
            }
            int n3 = this.getMinimumSize(n2);
            int n4 = this.calculateNonlinkedPreferredSize(n2);
            int n5 = this.getMaximumSize(n2);
            return Math.min(n5, Math.max(n3, n4));
        }

        int calculateMaximumSize(int n2) {
            if (this.isLinked(n2)) {
                return this.getLinkSize(n2, 2);
            }
            return Math.max(this.getMinimumSize(n2), this.calculateNonlinkedMaximumSize(n2));
        }

        boolean isVisible() {
            return GroupLayout.this.getComponentInfo(this.getComponent()).isVisible();
        }

        int calculateNonlinkedMinimumSize(int n2) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.min >= 0) {
                return this.min;
            }
            if (this.min == -2) {
                return this.calculateNonlinkedPreferredSize(n2);
            }
            if (!$assertionsDisabled && this.min != -1) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(n2, this.component.getMinimumSize());
        }

        int calculateNonlinkedPreferredSize(int n2) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.pref >= 0) {
                return this.pref;
            }
            if (!$assertionsDisabled && this.pref != -1 && this.pref != -2) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(n2, this.component.getPreferredSize());
        }

        int calculateNonlinkedMaximumSize(int n2) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.max >= 0) {
                return this.max;
            }
            if (this.max == -2) {
                return this.calculateNonlinkedPreferredSize(n2);
            }
            if (!$assertionsDisabled && this.max != -1) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(n2, this.component.getMaximumSize());
        }

        private int getSizeAlongAxis(int n2, Dimension dimension) {
            return n2 == 1 ? dimension.width : dimension.height;
        }

        private int getLinkSize(int n2, int n3) {
            if (!this.isVisible()) {
                return 0;
            }
            ComponentInfo componentInfo = GroupLayout.this.getComponentInfo(this.component);
            return componentInfo.getLinkSize(n2, n3);
        }

        void setSize(int n2, int n3, int n4) {
            super.setSize(n2, n3, n4);
            this.origin = n3;
            if (n4 == Integer.MIN_VALUE) {
                this.baseline = -1;
            }
        }

        int getOrigin() {
            return this.origin;
        }

        void setComponent(Component component) {
            this.component = component;
        }

        Component getComponent() {
            return this.component;
        }

        int getBaseline() {
            if (this.baseline == -1 && this.component instanceof JComponent) {
                ComponentSpring componentSpring = ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring;
                int n2 = componentSpring.getPreferredSize(1);
                int n3 = this.getPreferredSize(2);
                if (n2 > 0 && n3 > 0) {
                    this.baseline = Baseline.getBaseline((JComponent)this.component, n2, this.getPreferredSize(2));
                }
            }
            return this.baseline;
        }

        int getBaselineResizeBehavior() {
            return Baseline.getBaselineResizeBehavior(this.getComponent());
        }

        private boolean isLinked(int n2) {
            return GroupLayout.this.getComponentInfo(this.component).isLinked(n2);
        }

        void installIfNecessary(int n2) {
            if (!this.installed) {
                this.installed = true;
                if (n2 == 1) {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring = this;
                } else {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).verticalSpring = this;
                }
            }
        }

        boolean willHaveZeroSize(boolean bl) {
            return !this.isVisible();
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    private class BaselineGroup
    extends ParallelGroup {
        private boolean allSpringsHaveBaseline;
        private int prefAscent;
        private int prefDescent;
        private boolean baselineAnchorSet;
        private boolean baselineAnchoredToTop;
        private boolean calcedBaseline;

        BaselineGroup(boolean bl) {
            super(1, bl);
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        BaselineGroup(boolean bl, boolean bl2) {
            this(bl);
            this.baselineAnchoredToTop = bl2;
            this.baselineAnchorSet = true;
        }

        void unset() {
            super.unset();
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        void setValidSize(int n2, int n3, int n4) {
            this.checkAxis(n2);
            if (this.prefAscent == -1) {
                super.setValidSize(n2, n3, n4);
            } else {
                this.baselineLayout(n3, n4);
            }
        }

        int calculateSize(int n2, int n3) {
            this.checkAxis(n2);
            if (!this.calcedBaseline) {
                this.calculateBaselineAndResizeBehavior();
            }
            if (n3 == 0) {
                return this.calculateMinSize();
            }
            if (n3 == 2) {
                return this.calculateMaxSize();
            }
            if (this.allSpringsHaveBaseline) {
                return this.prefAscent + this.prefDescent;
            }
            return Math.max(this.prefAscent + this.prefDescent, super.calculateSize(n2, n3));
        }

        private void calculateBaselineAndResizeBehavior() {
            this.prefAscent = 0;
            this.prefDescent = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                int n4;
                Spring spring = this.getSpring(i2);
                if (spring.getAlignment() != 0 && spring.getAlignment() != 3 || (n4 = spring.getBaseline()) < 0) continue;
                if (spring.isResizable(2)) {
                    int n5 = spring.getBaselineResizeBehavior();
                    if (n3 == 0) {
                        n3 = n5;
                    } else if (n5 != n3) {
                        n3 = 1;
                    }
                }
                this.prefAscent = Math.max(this.prefAscent, n4);
                this.prefDescent = Math.max(this.prefDescent, spring.getPreferredSize(2) - n4);
                ++n2;
            }
            if (!this.baselineAnchorSet) {
                this.baselineAnchoredToTop = n3 != 2;
            }
            this.allSpringsHaveBaseline = n2 == this.springs.size();
            this.calcedBaseline = true;
        }

        private int calculateMaxSize() {
            int n2 = this.prefAscent;
            int n3 = this.prefDescent;
            int n4 = 0;
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                int n5;
                Spring spring = this.getSpring(i2);
                int n6 = spring.getMaximumSize(2);
                if ((spring.getAlignment() == 0 || spring.getAlignment() == 3) && (n5 = spring.getBaseline()) >= 0) {
                    int n7 = spring.getPreferredSize(2);
                    if (n7 == n6) continue;
                    switch (spring.getBaselineResizeBehavior()) {
                        case 1: {
                            if (!this.baselineAnchoredToTop) break;
                            n3 = Math.max(n3, n6 - n5);
                            break;
                        }
                        case 2: {
                            if (this.baselineAnchoredToTop) break;
                            n2 = Math.max(n2, n6 - n7 + n5);
                            break;
                        }
                    }
                    continue;
                }
                n4 = Math.max(n4, n6);
            }
            return Math.max(n4, n2 + n3);
        }

        private int calculateMinSize() {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.baselineAnchoredToTop) {
                n2 = this.prefAscent;
            } else {
                n3 = this.prefDescent;
            }
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                int n5;
                Spring spring = this.getSpring(i2);
                int n6 = spring.getMinimumSize(2);
                if ((spring.getAlignment() == 0 || spring.getAlignment() == 3) && (n5 = spring.getBaseline()) >= 0) {
                    int n7 = spring.getPreferredSize(2);
                    switch (spring.getBaselineResizeBehavior()) {
                        case 1: {
                            if (this.baselineAnchoredToTop) {
                                n3 = Math.max(n6 - n5, n3);
                                break;
                            }
                            n2 = Math.max(n5, n2);
                            break;
                        }
                        case 2: {
                            if (!this.baselineAnchoredToTop) {
                                n2 = Math.max(n5 - (n7 - n6), n2);
                                break;
                            }
                            n3 = Math.max(n7 - n5, n3);
                            break;
                        }
                        default: {
                            n2 = Math.max(n5, n2);
                            n3 = Math.max(n7 - n5, n3);
                            break;
                        }
                    }
                    continue;
                }
                n4 = Math.max(n4, n6);
            }
            return Math.max(n4, n2 + n3);
        }

        private void baselineLayout(int n2, int n3) {
            int n4;
            int n5;
            if (this.baselineAnchoredToTop) {
                n5 = this.prefAscent;
                n4 = n3 - n5;
            } else {
                n5 = n3 - this.prefDescent;
                n4 = this.prefDescent;
            }
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                Spring spring = this.getSpring(i2);
                int n6 = spring.getAlignment();
                if (n6 == 0 || n6 == 3) {
                    int n7 = spring.getBaseline();
                    if (n7 >= 0) {
                        int n8;
                        int n9;
                        int n10 = spring.getMaximumSize(2);
                        int n11 = n9 = spring.getPreferredSize(2);
                        switch (spring.getBaselineResizeBehavior()) {
                            case 1: {
                                n8 = n2 + n5 - n7;
                                n11 = Math.min(n4, n10 - n7) + n7;
                                break;
                            }
                            case 2: {
                                n11 = Math.min(n5, n10 - n9 + n7) + (n9 - n7);
                                n8 = n2 + n5 + (n9 - n7) - n11;
                                break;
                            }
                            default: {
                                n8 = n2 + n5 - n7;
                            }
                        }
                        spring.setSize(2, n8, n11);
                        continue;
                    }
                    this.setChildSize(spring, 2, n2, n3);
                    continue;
                }
                this.setChildSize(spring, 2, n2, n3);
            }
        }

        int getBaseline() {
            if (this.springs.size() > 1) {
                this.getPreferredSize(2);
                return this.prefAscent;
            }
            if (this.springs.size() == 1) {
                return this.getSpring(0).getBaseline();
            }
            return -1;
        }

        int getBaselineResizeBehavior() {
            if (this.springs.size() == 1) {
                return this.getSpring(0).getBaselineResizeBehavior();
            }
            if (this.baselineAnchoredToTop) {
                return 1;
            }
            return 2;
        }

        private void checkAxis(int n2) {
            if (n2 == 1) {
                throw new IllegalStateException("Baseline must be used along vertical axis");
            }
        }
    }

    public class ParallelGroup
    extends Group {
        private final int childAlignment;
        private final boolean resizable;

        ParallelGroup(int n2, boolean bl) {
            this.childAlignment = n2;
            this.resizable = bl;
        }

        public ParallelGroup add(Group group) {
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public ParallelGroup add(Component component, int n2, int n3, int n4) {
            return (ParallelGroup)this.addSpring(new ComponentSpring(component, n2, n3, n4));
        }

        public ParallelGroup add(int n2) {
            return this.add(n2, n2, n2);
        }

        public ParallelGroup add(int n2, int n3, int n4) {
            return (ParallelGroup)this.addSpring(new GapSpring(n2, n3, n4));
        }

        public ParallelGroup add(int n2, Group group) {
            this.checkChildAlignment(n2);
            group.setAlignment(n2);
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup add(int n2, Component component) {
            return this.add(n2, component, -1, -1, -1);
        }

        public ParallelGroup add(int n2, Component component, int n3, int n4, int n5) {
            this.checkChildAlignment(n2);
            ComponentSpring componentSpring = new ComponentSpring(component, n3, n4, n5);
            componentSpring.setAlignment(n2);
            return (ParallelGroup)this.addSpring(componentSpring);
        }

        boolean isResizable() {
            return this.resizable;
        }

        int operator(int n2, int n3) {
            return Math.max(n2, n3);
        }

        int calculateMinimumSize(int n2) {
            if (!this.isResizable()) {
                return this.getPreferredSize(n2);
            }
            return super.calculateMinimumSize(n2);
        }

        int calculateMaximumSize(int n2) {
            if (!this.isResizable()) {
                return this.getPreferredSize(n2);
            }
            return super.calculateMaximumSize(n2);
        }

        void setValidSize(int n2, int n3, int n4) {
            int n5 = this.springs.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                this.setChildSize(this.getSpring(i2), n2, n3, n4);
            }
        }

        void setChildSize(Spring spring, int n2, int n3, int n4) {
            int n5 = spring.getAlignment();
            int n6 = Math.min(Math.max(spring.getMinimumSize(n2), n4), spring.getMaximumSize(n2));
            if (n5 == 0) {
                n5 = this.childAlignment;
            }
            switch (n5) {
                case 2: {
                    spring.setSize(n2, n3 + n4 - n6, n6);
                    break;
                }
                case 4: {
                    spring.setSize(n2, n3 + (n4 - n6) / 2, n6);
                    break;
                }
                default: {
                    spring.setSize(n2, n3, n6);
                }
            }
        }

        void insertAutopadding(int n2, List list, List list2, List list3, List list4, boolean bl) {
            int n3 = this.springs.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Spring spring = this.getSpring(i2);
                if (spring instanceof ComponentSpring) {
                    if (!((ComponentSpring)spring).isVisible()) continue;
                    for (int i3 = 0; i3 < list.size(); ++i3) {
                        ((AutopaddingSpring)list.get(i3)).addTarget((ComponentSpring)spring, n2);
                    }
                    list4.add(spring);
                    continue;
                }
                if (spring instanceof Group) {
                    ((Group)spring).insertAutopadding(n2, list, list2, list3, list4, bl);
                    continue;
                }
                if (!(spring instanceof AutopaddingSpring)) continue;
                ((AutopaddingSpring)spring).setSources(list3);
                list2.add(spring);
            }
        }

        private void checkChildAlignment(int n2) {
            boolean bl = this instanceof BaselineGroup;
            if (!bl && n2 == 3) {
                throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
            }
            if (n2 != 4 && n2 != 3 && n2 != 1 && n2 != 2) {
                throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
            }
        }
    }

    private static final class SpringDelta
    implements Comparable {
        public final int index;
        public int delta;

        public SpringDelta(int n2, int n3) {
            this.index = n2;
            this.delta = n3;
        }

        public int compareTo(Object object) {
            return this.delta - ((SpringDelta)object).delta;
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", delta=" + this.delta + "]";
        }
    }

    public class SequentialGroup
    extends Group {
        private Spring baselineSpring;
        static final /* synthetic */ boolean $assertionsDisabled;

        SequentialGroup() {
        }

        public SequentialGroup add(Group group) {
            return (SequentialGroup)this.addSpring(group);
        }

        public SequentialGroup add(boolean bl, Group group) {
            this.add(group);
            if (bl) {
                this.baselineSpring = group;
            }
            return this;
        }

        public SequentialGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public SequentialGroup add(boolean bl, Component component) {
            this.add(component);
            if (bl) {
                this.baselineSpring = this.getSpring(this.springs.size() - 1);
            }
            return this;
        }

        public SequentialGroup add(Component component, int n2, int n3, int n4) {
            return (SequentialGroup)this.addSpring(new ComponentSpring(component, n2, n3, n4));
        }

        public SequentialGroup add(boolean bl, Component component, int n2, int n3, int n4) {
            this.add(component, n2, n3, n4);
            if (bl) {
                this.baselineSpring = this.getSpring(this.springs.size() - 1);
            }
            return this;
        }

        public SequentialGroup add(int n2) {
            return this.add(n2, n2, n2);
        }

        public SequentialGroup add(int n2, int n3, int n4) {
            return (SequentialGroup)this.addSpring(new GapSpring(n2, n3, n4));
        }

        public SequentialGroup addPreferredGap(JComponent jComponent, JComponent jComponent2, int n2) {
            return this.addPreferredGap(jComponent, jComponent2, n2, false);
        }

        public SequentialGroup addPreferredGap(JComponent jComponent, JComponent jComponent2, int n2, boolean bl) {
            if (n2 != 0 && n2 != 1 && n2 != 3) {
                throw new IllegalArgumentException("Invalid type argument");
            }
            if (jComponent == null || jComponent2 == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            return (SequentialGroup)this.addSpring(new PaddingSpring(jComponent, jComponent2, n2, bl));
        }

        public SequentialGroup addPreferredGap(int n2) {
            return this.addPreferredGap(n2, -1, -1);
        }

        public SequentialGroup addPreferredGap(int n2, int n3, int n4) {
            if (n2 != 0 && n2 != 1) {
                throw new IllegalArgumentException("Padding type must be one of Padding.RELATED or Padding.UNRELATED");
            }
            if (n3 < 0 && n3 != -1 && n3 != -2 || n4 < 0 && n4 != -1 && n4 != -2 || n3 >= 0 && n4 >= 0 && n3 > n4) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_SIZE, PREFERRED_SIZE, or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new AutopaddingSpring(n2, n3, n4));
        }

        public SequentialGroup addContainerGap() {
            return this.addContainerGap(-1, -1);
        }

        public SequentialGroup addContainerGap(int n2, int n3) {
            if (n2 < 0 && n2 != -1 || n3 < 0 && n3 != -1 && n3 != -2 || n2 >= 0 && n3 >= 0 && n2 > n3) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new ContainerAutopaddingSpring(n2, n3));
        }

        int operator(int n2, int n3) {
            return this.constrain(n2) + this.constrain(n3);
        }

        void setValidSize(int n2, int n3, int n4) {
            int n5 = this.getPreferredSize(n2);
            if (n4 == n5) {
                int n6 = this.springs.size();
                for (int i2 = 0; i2 < n6; ++i2) {
                    Spring spring = this.getSpring(i2);
                    int n7 = spring.getPreferredSize(n2);
                    spring.setSize(n2, n3, n7);
                    n3 += n7;
                }
            } else if (this.springs.size() == 1) {
                Spring spring = this.getSpring(0);
                spring.setSize(n2, n3, Math.min(Math.max(n4, spring.getMinimumSize(n2)), spring.getMaximumSize(n2)));
            } else if (this.springs.size() > 1) {
                this.setValidSizeNotPreferred(n2, n3, n4);
            }
        }

        private void setValidSizeNotPreferred(int n2, int n3, int n4) {
            List list;
            int n5;
            int n6 = n4 - this.getPreferredSize(n2);
            if (!$assertionsDisabled && n6 == 0) {
                throw new AssertionError();
            }
            boolean bl = n6 < 0;
            int n7 = this.springs.size();
            if (bl) {
                n6 *= -1;
            }
            if ((n5 = (list = this.buildResizableList(n2, bl)).size()) > 0) {
                Object object;
                int n8;
                int n9 = n6 / n5;
                int n10 = n6 - n9 * n5;
                int[] nArray = new int[n7];
                int n11 = bl ? -1 : 1;
                for (n8 = 0; n8 < n5; ++n8) {
                    object = (SpringDelta)list.get(n8);
                    if (n8 + 1 == n5) {
                        n9 += n10;
                    }
                    ((SpringDelta)object).delta = Math.min(n9, ((SpringDelta)object).delta);
                    n6 -= ((SpringDelta)object).delta;
                    if (((SpringDelta)object).delta != n9 && n8 + 1 < n5) {
                        n9 = n6 / (n5 - n8 - 1);
                        n10 = n6 - n9 * (n5 - n8 - 1);
                    }
                    nArray[((SpringDelta)object).index] = n11 * ((SpringDelta)object).delta;
                }
                for (n8 = 0; n8 < n7; ++n8) {
                    object = this.getSpring(n8);
                    int n12 = ((Spring)object).getPreferredSize(n2) + nArray[n8];
                    ((Spring)object).setSize(n2, n3, n12);
                    n3 += n12;
                }
            } else {
                for (int i2 = 0; i2 < n7; ++i2) {
                    Spring spring = this.getSpring(i2);
                    int n13 = bl ? spring.getMinimumSize(n2) : spring.getMaximumSize(n2);
                    spring.setSize(n2, n3, n13);
                    n3 += n13;
                }
            }
        }

        private List buildResizableList(int n2, boolean bl) {
            int n3 = this.springs.size();
            ArrayList<SpringDelta> arrayList = new ArrayList<SpringDelta>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                Spring spring = this.getSpring(i2);
                int n4 = bl ? spring.getPreferredSize(n2) - spring.getMinimumSize(n2) : spring.getMaximumSize(n2) - spring.getPreferredSize(n2);
                if (n4 <= 0) continue;
                arrayList.add(new SpringDelta(i2, n4));
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        private int indexOfNextNonZeroSpring(int n2, boolean bl) {
            while (n2 < this.springs.size()) {
                Spring spring = (Spring)this.springs.get(n2);
                if (!spring.willHaveZeroSize(bl)) {
                    return n2;
                }
                ++n2;
            }
            return n2;
        }

        void insertAutopadding(int n2, List list, List list2, List list3, List list4, boolean bl) {
            ArrayList<AutopaddingSpring> arrayList = new ArrayList<AutopaddingSpring>(list);
            ArrayList arrayList2 = new ArrayList(1);
            ArrayList<ComponentSpring> arrayList3 = new ArrayList<ComponentSpring>(list3);
            ArrayList arrayList4 = null;
            int n3 = 0;
            while (n3 < this.springs.size()) {
                int n4;
                Spring spring = this.getSpring(n3);
                if (spring instanceof AutopaddingSpring) {
                    if (arrayList.size() == 0) {
                        AutopaddingSpring autopaddingSpring = (AutopaddingSpring)spring;
                        autopaddingSpring.setSources(arrayList3);
                        arrayList3.clear();
                        n4 = this.indexOfNextNonZeroSpring(n3 + 1, true);
                        if (n4 == this.springs.size()) {
                            if (!(autopaddingSpring instanceof ContainerAutopaddingSpring)) {
                                list2.add(autopaddingSpring);
                            }
                        } else {
                            arrayList.clear();
                            arrayList.add(autopaddingSpring);
                        }
                        n3 = n4;
                        continue;
                    }
                    n3 = this.indexOfNextNonZeroSpring(n3 + 1, true);
                    continue;
                }
                if (arrayList3.size() > 0 && bl) {
                    AutopaddingSpring autopaddingSpring = new AutopaddingSpring();
                    this.springs.add(n3, autopaddingSpring);
                    continue;
                }
                if (spring instanceof ComponentSpring) {
                    ComponentSpring componentSpring = (ComponentSpring)spring;
                    if (!componentSpring.isVisible()) {
                        ++n3;
                        continue;
                    }
                    for (n4 = 0; n4 < arrayList.size(); ++n4) {
                        ((AutopaddingSpring)arrayList.get(n4)).addTarget(componentSpring, n2);
                    }
                    arrayList3.clear();
                    arrayList.clear();
                    n4 = this.indexOfNextNonZeroSpring(n3 + 1, false);
                    if (n4 == this.springs.size()) {
                        list4.add(componentSpring);
                    } else {
                        arrayList3.add(componentSpring);
                    }
                    n3 = n4;
                    continue;
                }
                if (spring instanceof Group) {
                    if (arrayList4 == null) {
                        arrayList4 = new ArrayList(1);
                    } else {
                        arrayList4.clear();
                    }
                    arrayList2.clear();
                    ((Group)spring).insertAutopadding(n2, arrayList, arrayList2, arrayList3, arrayList4, bl);
                    arrayList3.clear();
                    arrayList.clear();
                    int n5 = this.indexOfNextNonZeroSpring(n3 + 1, arrayList4.size() == 0);
                    if (n5 == this.springs.size()) {
                        list4.addAll(arrayList4);
                        list2.addAll(arrayList2);
                    } else {
                        arrayList3.addAll(arrayList4);
                        arrayList.addAll(arrayList2);
                    }
                    n3 = n5;
                    continue;
                }
                arrayList.clear();
                arrayList3.clear();
                ++n3;
            }
        }

        int getBaseline() {
            int n2;
            if (this.baselineSpring != null && (n2 = this.baselineSpring.getBaseline()) >= 0) {
                int n3 = 0;
                int n4 = this.springs.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    Spring spring = this.getSpring(i2);
                    if (spring == this.baselineSpring) {
                        return n3 + n2;
                    }
                    n3 += spring.getPreferredSize(2);
                }
            }
            return -1;
        }

        int getBaselineResizeBehavior() {
            if (this.isResizable(2)) {
                if (!this.baselineSpring.isResizable(2)) {
                    Spring spring;
                    int n2;
                    boolean bl = false;
                    int n3 = this.springs.size();
                    for (n2 = 0; n2 < n3 && (spring = this.getSpring(n2)) != this.baselineSpring; ++n2) {
                        if (!spring.isResizable(2)) continue;
                        bl = true;
                        break;
                    }
                    n2 = 0;
                    for (n3 = this.springs.size() - 1; n3 >= 0 && (spring = this.getSpring(n3)) != this.baselineSpring; --n3) {
                        if (!spring.isResizable(2)) continue;
                        n2 = 1;
                        break;
                    }
                    if (bl && n2 == 0) {
                        return 2;
                    }
                    if (!bl && n2 != 0) {
                        return 1;
                    }
                } else {
                    int n4 = this.baselineSpring.getBaselineResizeBehavior();
                    if (n4 == 1) {
                        int n5 = this.springs.size();
                        for (int i2 = 0; i2 < n5; ++i2) {
                            Spring spring = this.getSpring(i2);
                            if (spring == this.baselineSpring) {
                                return 1;
                            }
                            if (!spring.isResizable(2)) continue;
                            return 4;
                        }
                    } else if (n4 == 2) {
                        for (int i3 = this.springs.size() - 1; i3 >= 0; --i3) {
                            Spring spring = this.getSpring(i3);
                            if (spring == this.baselineSpring) {
                                return 2;
                            }
                            if (!spring.isResizable(2)) continue;
                            return 4;
                        }
                    }
                }
                return 4;
            }
            return 1;
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    public abstract class Group
    extends Spring {
        List springs;
        static final /* synthetic */ boolean $assertionsDisabled;

        Group() {
            this.springs = new ArrayList();
        }

        int indexOf(Spring spring) {
            return this.springs.indexOf(spring);
        }

        Group addSpring(Spring spring) {
            this.springs.add(spring);
            spring.setParent(this);
            if (!(spring instanceof AutopaddingSpring) || !((AutopaddingSpring)spring).getUserCreated()) {
                GroupLayout.this.springsChanged = true;
            }
            return this;
        }

        void setSize(int n2, int n3, int n4) {
            super.setSize(n2, n3, n4);
            if (n4 == Integer.MIN_VALUE) {
                for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                    this.getSpring(i2).setSize(n2, n3, n4);
                }
            } else {
                this.setValidSize(n2, n3, n4);
            }
        }

        abstract void setValidSize(int var1, int var2, int var3);

        int calculateMinimumSize(int n2) {
            return this.calculateSize(n2, 0);
        }

        int calculatePreferredSize(int n2) {
            return this.calculateSize(n2, 1);
        }

        int calculateMaximumSize(int n2) {
            return this.calculateSize(n2, 2);
        }

        abstract int operator(int var1, int var2);

        int calculateSize(int n2, int n3) {
            int n4 = this.springs.size();
            if (n4 == 0) {
                return 0;
            }
            if (n4 == 1) {
                return this.getSpringSize(this.getSpring(0), n2, n3);
            }
            int n5 = this.constrain(this.operator(this.getSpringSize(this.getSpring(0), n2, n3), this.getSpringSize(this.getSpring(1), n2, n3)));
            for (int i2 = 2; i2 < n4; ++i2) {
                n5 = this.constrain(this.operator(n5, this.getSpringSize(this.getSpring(i2), n2, n3)));
            }
            return n5;
        }

        Spring getSpring(int n2) {
            return (Spring)this.springs.get(n2);
        }

        int getSpringSize(Spring spring, int n2, int n3) {
            switch (n3) {
                case 0: {
                    return spring.getMinimumSize(n2);
                }
                case 1: {
                    return spring.getPreferredSize(n2);
                }
                case 2: {
                    return spring.getMaximumSize(n2);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        abstract void insertAutopadding(int var1, List var2, List var3, List var4, List var5, boolean var6);

        void removeAutopadding() {
            this.unset();
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.springs.get(i2);
                if (spring instanceof AutopaddingSpring) {
                    if (((AutopaddingSpring)spring).getUserCreated()) {
                        ((AutopaddingSpring)spring).reset();
                        continue;
                    }
                    this.springs.remove(i2);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).removeAutopadding();
            }
        }

        void unsetAutopadding() {
            this.unset();
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.springs.get(i2);
                if (spring instanceof AutopaddingSpring) {
                    ((AutopaddingSpring)spring).unset();
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).unsetAutopadding();
            }
        }

        void calculateAutopadding(int n2) {
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.springs.get(i2);
                if (spring instanceof AutopaddingSpring) {
                    spring.unset();
                    ((AutopaddingSpring)spring).calculatePadding(n2);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).calculateAutopadding(n2);
            }
            this.unset();
        }

        boolean willHaveZeroSize(boolean bl) {
            for (int i2 = this.springs.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.springs.get(i2);
                if (spring.willHaveZeroSize(bl)) continue;
                return false;
            }
            return true;
        }

        static {
            $assertionsDisabled = !(class$org$jdesktop$layout$GroupLayout == null ? (class$org$jdesktop$layout$GroupLayout = GroupLayout.class$("org.jdesktop.layout.GroupLayout")) : class$org$jdesktop$layout$GroupLayout).desiredAssertionStatus();
        }
    }

    abstract class Spring {
        private int size;
        private int min;
        private int max = Integer.MIN_VALUE;
        private int pref = Integer.MIN_VALUE;
        private Spring parent;
        private int alignment;

        Spring() {
            this.min = Integer.MIN_VALUE;
        }

        abstract int calculateMinimumSize(int var1);

        abstract int calculatePreferredSize(int var1);

        abstract int calculateMaximumSize(int var1);

        void setParent(Spring spring) {
            this.parent = spring;
        }

        Spring getParent() {
            return this.parent;
        }

        void setAlignment(int n2) {
            this.alignment = n2;
        }

        int getAlignment() {
            return this.alignment;
        }

        final int getMinimumSize(int n2) {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.constrain(this.calculateMinimumSize(n2));
            }
            return this.min;
        }

        final int getPreferredSize(int n2) {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.constrain(this.calculatePreferredSize(n2));
            }
            return this.pref;
        }

        final int getMaximumSize(int n2) {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.constrain(this.calculateMaximumSize(n2));
            }
            return this.max;
        }

        void unset() {
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.size = Integer.MIN_VALUE;
        }

        void setSize(int n2, int n3, int n4) {
            this.size = n4;
            if (n4 == Integer.MIN_VALUE) {
                this.unset();
            }
        }

        int getSize() {
            return this.size;
        }

        int constrain(int n2) {
            return Math.min(n2, Short.MAX_VALUE);
        }

        int getBaseline() {
            return -1;
        }

        int getBaselineResizeBehavior() {
            return 4;
        }

        final boolean isResizable(int n2) {
            int n3;
            int n4 = this.getMinimumSize(n2);
            return n4 != (n3 = this.getPreferredSize(n2)) || n3 != this.getMaximumSize(n2);
        }

        abstract boolean willHaveZeroSize(boolean var1);
    }
}

