/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult ddata;

    public DecoderResult decode(AztecDetectorResult detectorResult) throws FormatException {
        this.ddata = detectorResult;
        BitMatrix matrix = detectorResult.getBits();
        boolean[] rawbits = this.extractBits(matrix);
        boolean[] correctedBits = this.correctBits(rawbits);
        String result = Decoder.getEncodedData(correctedBits);
        return new DecoderResult(null, result, null, null);
    }

    public static String highLevelDecode(boolean[] correctedBits) {
        return Decoder.getEncodedData(correctedBits);
    }

    private static String getEncodedData(boolean[] correctedBits) {
        int endIndex = correctedBits.length;
        Table latchTable = Table.UPPER;
        Table shiftTable = Table.UPPER;
        StringBuilder result = new StringBuilder(20);
        int index = 0;
        while (index < endIndex) {
            int size;
            if (shiftTable == Table.BINARY) {
                if (endIndex - index < 5) break;
                int length = Decoder.readCode(correctedBits, index, 5);
                index += 5;
                if (length == 0) {
                    if (endIndex - index < 11) break;
                    length = Decoder.readCode(correctedBits, index, 11) + 31;
                    index += 11;
                }
                for (int charCount = 0; charCount < length; ++charCount) {
                    if (endIndex - index < 8) {
                        index = endIndex;
                        break;
                    }
                    int code = Decoder.readCode(correctedBits, index, 8);
                    result.append((char)code);
                    index += 8;
                }
                shiftTable = latchTable;
                continue;
            }
            int n2 = size = shiftTable == Table.DIGIT ? 4 : 5;
            if (endIndex - index < size) break;
            int code = Decoder.readCode(correctedBits, index, size);
            index += size;
            String str = Decoder.getCharacter(shiftTable, code);
            if (str.startsWith("CTRL_")) {
                shiftTable = Decoder.getTable(str.charAt(5));
                if (str.charAt(6) != 'L') continue;
                latchTable = shiftTable;
                continue;
            }
            result.append(str);
            shiftTable = latchTable;
        }
        return result.toString();
    }

    private static Table getTable(char t) {
        switch (t) {
            case 'L': {
                return Table.LOWER;
            }
            case 'P': {
                return Table.PUNCT;
            }
            case 'M': {
                return Table.MIXED;
            }
            case 'D': {
                return Table.DIGIT;
            }
            case 'B': {
                return Table.BINARY;
            }
        }
        return Table.UPPER;
    }

    private static String getCharacter(Table table, int code) {
        switch (table) {
            case UPPER: {
                return UPPER_TABLE[code];
            }
            case LOWER: {
                return LOWER_TABLE[code];
            }
            case MIXED: {
                return MIXED_TABLE[code];
            }
            case PUNCT: {
                return PUNCT_TABLE[code];
            }
            case DIGIT: {
                return DIGIT_TABLE[code];
            }
        }
        throw new IllegalStateException("Bad table");
    }

    private boolean[] correctBits(boolean[] rawbits) throws FormatException {
        GenericGF gf;
        int codewordSize;
        if (this.ddata.getNbLayers() <= 2) {
            codewordSize = 6;
            gf = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            codewordSize = 8;
            gf = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            codewordSize = 10;
            gf = GenericGF.AZTEC_DATA_10;
        } else {
            codewordSize = 12;
            gf = GenericGF.AZTEC_DATA_12;
        }
        int numDataCodewords = this.ddata.getNbDatablocks();
        int numCodewords = rawbits.length / codewordSize;
        if (numCodewords < numDataCodewords) {
            throw FormatException.getFormatInstance();
        }
        int offset = rawbits.length % codewordSize;
        int numECCodewords = numCodewords - numDataCodewords;
        int[] dataWords = new int[numCodewords];
        int i2 = 0;
        while (i2 < numCodewords) {
            dataWords[i2] = Decoder.readCode(rawbits, offset, codewordSize);
            ++i2;
            offset += codewordSize;
        }
        try {
            ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(gf);
            rsDecoder.decode(dataWords, numECCodewords);
        }
        catch (ReedSolomonException ex) {
            throw FormatException.getFormatInstance(ex);
        }
        int mask = (1 << codewordSize) - 1;
        int stuffedBits = 0;
        for (int i3 = 0; i3 < numDataCodewords; ++i3) {
            int dataWord = dataWords[i3];
            if (dataWord == 0 || dataWord == mask) {
                throw FormatException.getFormatInstance();
            }
            if (dataWord != 1 && dataWord != mask - 1) continue;
            ++stuffedBits;
        }
        boolean[] correctedBits = new boolean[numDataCodewords * codewordSize - stuffedBits];
        int index = 0;
        for (int i4 = 0; i4 < numDataCodewords; ++i4) {
            int dataWord = dataWords[i4];
            if (dataWord == 1 || dataWord == mask - 1) {
                Arrays.fill(correctedBits, index, index + codewordSize - 1, dataWord > 1);
                index += codewordSize - 1;
                continue;
            }
            for (int bit = codewordSize - 1; bit >= 0; --bit) {
                correctedBits[index++] = (dataWord & 1 << bit) != 0;
            }
        }
        return correctedBits;
    }

    boolean[] extractBits(BitMatrix matrix) {
        int i2;
        boolean compact = this.ddata.isCompact();
        int layers = this.ddata.getNbLayers();
        int baseMatrixSize = compact ? 11 + layers * 4 : 14 + layers * 4;
        int[] alignmentMap = new int[baseMatrixSize];
        boolean[] rawbits = new boolean[Decoder.totalBitsInLayer(layers, compact)];
        if (compact) {
            for (i2 = 0; i2 < alignmentMap.length; ++i2) {
                alignmentMap[i2] = i2;
            }
        } else {
            int matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center = matrixSize / 2;
            for (int i3 = 0; i3 < origCenter; ++i3) {
                int newOffset = i3 + i3 / 15;
                alignmentMap[origCenter - i3 - 1] = center - newOffset - 1;
                alignmentMap[origCenter + i3] = center + newOffset + 1;
            }
        }
        int rowOffset = 0;
        for (i2 = 0; i2 < layers; ++i2) {
            int rowSize = compact ? (layers - i2) * 4 + 9 : (layers - i2) * 4 + 12;
            int low = i2 * 2;
            int high = baseMatrixSize - 1 - low;
            for (int j2 = 0; j2 < rowSize; ++j2) {
                int columnOffset = j2 * 2;
                for (int k2 = 0; k2 < 2; ++k2) {
                    rawbits[rowOffset + columnOffset + k2] = matrix.get(alignmentMap[low + k2], alignmentMap[low + j2]);
                    rawbits[rowOffset + 2 * rowSize + columnOffset + k2] = matrix.get(alignmentMap[low + j2], alignmentMap[high - k2]);
                    rawbits[rowOffset + 4 * rowSize + columnOffset + k2] = matrix.get(alignmentMap[high - k2], alignmentMap[high - j2]);
                    rawbits[rowOffset + 6 * rowSize + columnOffset + k2] = matrix.get(alignmentMap[high - j2], alignmentMap[low + k2]);
                }
            }
            rowOffset += rowSize * 8;
        }
        return rawbits;
    }

    private static int readCode(boolean[] rawbits, int startIndex, int length) {
        int res = 0;
        for (int i2 = startIndex; i2 < startIndex + length; ++i2) {
            res <<= 1;
            if (!rawbits[i2]) continue;
            res |= 1;
        }
        return res;
    }

    private static int totalBitsInLayer(int layers, boolean compact) {
        return ((compact ? 88 : 112) + 16 * layers) * layers;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

