/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] moduleBitCount) {
        int decodedValue = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(moduleBitCount));
        if (decodedValue != -1) {
            return decodedValue;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(moduleBitCount);
    }

    private static int[] sampleBitCounts(int[] moduleBitCount) {
        float bitCountSum = PDF417Common.getBitCountSum(moduleBitCount);
        int[] result = new int[8];
        int bitCountIndex = 0;
        int sumPreviousBits = 0;
        for (int i2 = 0; i2 < 17; ++i2) {
            float sampleIndex = bitCountSum / 34.0f + (float)i2 * bitCountSum / 17.0f;
            if ((float)(sumPreviousBits + moduleBitCount[bitCountIndex]) <= sampleIndex) {
                sumPreviousBits += moduleBitCount[bitCountIndex];
            }
            int n2 = ++bitCountIndex;
            result[n2] = result[n2] + 1;
        }
        return result;
    }

    private static int getDecodedCodewordValue(int[] moduleBitCount) {
        int decodedValue = PDF417CodewordDecoder.getBitValue(moduleBitCount);
        return PDF417Common.getCodeword(decodedValue) == -1 ? -1 : decodedValue;
    }

    private static int getBitValue(int[] moduleBitCount) {
        long result = 0L;
        for (int i2 = 0; i2 < moduleBitCount.length; ++i2) {
            for (int bit = 0; bit < moduleBitCount[i2]; ++bit) {
                result = result << 1 | (long)(i2 % 2 == 0 ? 1 : 0);
            }
        }
        return (int)result;
    }

    private static int getClosestDecodedValue(int[] moduleBitCount) {
        int bitCountSum = PDF417Common.getBitCountSum(moduleBitCount);
        float[] bitCountRatios = new float[8];
        for (int i2 = 0; i2 < bitCountRatios.length; ++i2) {
            bitCountRatios[i2] = (float)moduleBitCount[i2] / (float)bitCountSum;
        }
        float bestMatchError = Float.MAX_VALUE;
        int bestMatch = -1;
        for (int j2 = 0; j2 < RATIOS_TABLE.length; ++j2) {
            float diff;
            float error = 0.0f;
            float[] ratioTableRow = RATIOS_TABLE[j2];
            for (int k2 = 0; k2 < 8 && !((error += (diff = ratioTableRow[k2] - bitCountRatios[k2]) * diff) >= bestMatchError); ++k2) {
            }
            if (!(error < bestMatchError)) continue;
            bestMatchError = error;
            bestMatch = PDF417Common.SYMBOL_TABLE[j2];
        }
        return bestMatch;
    }

    static {
        for (int i2 = 0; i2 < PDF417Common.SYMBOL_TABLE.length; ++i2) {
            int currentSymbol = PDF417Common.SYMBOL_TABLE[i2];
            int currentBit = currentSymbol & 1;
            for (int j2 = 0; j2 < 8; ++j2) {
                float size = 0.0f;
                while ((currentSymbol & 1) == currentBit) {
                    size += 1.0f;
                    currentSymbol >>= 1;
                }
                currentBit = currentSymbol & 1;
                PDF417CodewordDecoder.RATIOS_TABLE[i2][8 - j2 - 1] = size / 17.0f;
            }
        }
    }
}

