/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common;

import java.io.PrintStream;

public class ExceptionUtils {
    public static void dumpStack(PrintStream printStream) {
        ExceptionUtils.dumpStack(printStream, 1, -1);
    }

    public static void dumpStack(PrintStream printStream, int n2, int n3) {
        ExceptionUtils.dumpStack(printStream, new Exception(""), n2 + 1, n3);
    }

    public static void dumpStack(PrintStream printStream, Throwable throwable, int n2, int n3) {
        ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), n2, n3);
    }

    public static void dumpStack(PrintStream printStream, StackTraceElement[] stackTraceElementArray, int n2, int n3) {
        if (null == stackTraceElementArray) {
            return;
        }
        int n4 = 0 > n3 ? stackTraceElementArray.length : Math.min(n3 + n2, stackTraceElementArray.length);
        for (int i2 = n2; i2 < n4; ++i2) {
            printStream.println("    [" + i2 + "]: " + stackTraceElementArray[i2]);
        }
    }

    public static void dumpThrowable(String string, Throwable throwable) {
        System.err.println("Caught " + string + " " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + " on thread " + Thread.currentThread().getName());
        ExceptionUtils.dumpStack(System.err, throwable.getStackTrace(), 0, -1);
        int n2 = 1;
        for (Throwable throwable2 = throwable.getCause(); null != throwable2; throwable2 = throwable2.getCause()) {
            System.err.println("Caused[" + n2 + "] by " + throwable2.getClass().getSimpleName() + ": " + throwable2.getMessage() + " on thread " + Thread.currentThread().getName());
            ExceptionUtils.dumpStack(System.err, throwable2.getStackTrace(), 0, -1);
            ++n2;
        }
    }
}

