/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public class IntBitfield {
    public static final int UNIT_SIZE = 32;
    private static final long UNIT_SHIFT_L = 5L;
    private static final int UNIT_SHIFT_I = 5;
    private final int[] storage;
    private final long bitsCountL;
    private final int bitsCountI;

    public IntBitfield(long l2) {
        int n2 = (int)Math.max(1L, l2 + 7L >>> 5);
        this.storage = new int[n2];
        this.bitsCountL = (long)n2 << 5;
        this.bitsCountI = this.bitsCountL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.bitsCountL;
    }

    public IntBitfield(int n2) {
        int n3 = Math.max(1, n2 + 7 >>> 5);
        this.storage = new int[n3];
        this.bitsCountI = n3 << 5;
        this.bitsCountL = this.bitsCountI;
    }

    private final void check(long l2) {
        if (0L > l2 || l2 >= this.bitsCountL) {
            throw new ArrayIndexOutOfBoundsException("Bitnum should be within [0.." + (this.bitsCountL - 1L) + "], but is " + l2);
        }
    }

    private final void check(int n2) {
        if (0 > n2 || n2 >= this.bitsCountI) {
            throw new ArrayIndexOutOfBoundsException("Bitnum should be within [0.." + (this.bitsCountI - 1) + "], but is " + n2);
        }
    }

    public final long capacity() {
        return this.bitsCountL;
    }

    public final boolean get(long l2) {
        this.check(l2);
        int n2 = (int)(l2 >>> 5);
        int n3 = (int)(l2 - ((long)n2 << 5));
        return 0 != (this.storage[n2] & 1 << n3);
    }

    public final boolean get(int n2) {
        this.check(n2);
        int n3 = n2 >>> 5;
        int n4 = n2 - (n3 << 5);
        return 0 != (this.storage[n3] & 1 << n4);
    }

    public final boolean put(long l2, boolean bl) {
        boolean bl2;
        this.check(l2);
        int n2 = (int)(l2 >>> 5);
        int n3 = (int)(l2 - ((long)n2 << 5));
        int n4 = 1 << n3;
        boolean bl3 = bl2 = 0 != (this.storage[n2] & n4);
        if (bl2 != bl) {
            if (bl) {
                int n5 = n2;
                this.storage[n5] = this.storage[n5] | n4;
            } else {
                int n6 = n2;
                this.storage[n6] = this.storage[n6] & ~n4;
            }
        }
        return bl2;
    }

    public final boolean put(int n2, boolean bl) {
        boolean bl2;
        this.check(n2);
        int n3 = n2 >>> 5;
        int n4 = n2 - (n3 << 5);
        int n5 = 1 << n4;
        boolean bl3 = bl2 = 0 != (this.storage[n3] & n5);
        if (bl2 != bl) {
            if (bl) {
                int n6 = n3;
                this.storage[n6] = this.storage[n6] | n5;
            } else {
                int n7 = n3;
                this.storage[n7] = this.storage[n7] & ~n5;
            }
        }
        return bl2;
    }

    public static final int getBitCount(int n2) {
        int n3 = n2;
        n3 -= n2 >>> 1 & 0xDB6DB6DB;
        return ((n3 -= n2 >>> 2 & 0x49249249) + (n3 >>> 3) & 0xC71C71C7) % 63;
    }

    public long getBitCount() {
        long l2 = 0L;
        for (int i2 = this.storage.length - 1; i2 >= 0; --i2) {
            l2 += (long)IntBitfield.getBitCount(this.storage[i2]);
        }
        return l2;
    }
}

