/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class IntIntHashMap
implements Cloneable,
Iterable<Entry> {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private int keyNotFoundValue = -1;
    private static final boolean isPrimitive;
    private static final Constructor<Entry> entryConstructor;
    private static final Method equalsMethod;

    public IntIntHashMap() {
        this(16, 0.75f);
    }

    public IntIntHashMap(int n2) {
        this(n2, 0.75f);
    }

    public IntIntHashMap(int n2, float f2) {
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n2) {
            this.capacity <<= 1;
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private IntIntHashMap(float f2, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.loadFactor = f2;
        this.table = new Entry[n2];
        this.size = n3;
        this.mask = n4;
        this.capacity = n5;
        this.threshold = n6;
        this.keyNotFoundValue = n7;
    }

    public Object clone() {
        IntIntHashMap intIntHashMap = new IntIntHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (int i2 = this.table.length - 1; i2 >= 0; --i2) {
            Entry entry = this.table[i2];
            while (null != entry) {
                arrayList.add(entry);
                entry = entry.next;
            }
            int n2 = arrayList.size();
            Entry entry2 = null;
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                entry = (Entry)arrayList.remove(i3);
                if (isPrimitive) {
                    entry2 = new Entry(entry.key, entry.value, entry2);
                    continue;
                }
                Object object = ReflectionUtil.callMethod(entry.value, IntIntHashMap.getCloneMethod(entry.value), new Object[0]);
                entry2 = (Entry)ReflectionUtil.createInstance(entryConstructor, entry.key, object, entry2);
            }
            intIntHashMap.table[i2] = entry2;
        }
        return intIntHashMap;
    }

    public boolean containsValue(int n2) {
        Entry[] entryArray = this.table;
        int n3 = entryArray.length;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Boolean bl;
                if (isPrimitive ? entry.value == n2 : (bl = (Boolean)ReflectionUtil.callMethod(n2, equalsMethod, entry.value)) != false) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2 & this.mask;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2 & this.mask;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return this.keyNotFoundValue;
    }

    public int put(int n2, int n3) {
        Entry[] entryArray = this.table;
        int n4 = n2 & this.mask;
        Entry entry = entryArray[n4];
        while (entry != null) {
            if (entry.key == n2) {
                int n5 = entry.value;
                entry.value = n3;
                return n5;
            }
            entry = entry.next;
        }
        entryArray[n4] = new Entry(n2, n3, entryArray[n4]);
        if (this.size++ >= this.threshold) {
            int n6 = 2 * this.capacity;
            Entry[] entryArray2 = new Entry[n6];
            int n7 = n6 - 1;
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                Entry entry2;
                Entry entry3 = entryArray[i2];
                if (entry3 == null) continue;
                entryArray[i2] = null;
                do {
                    entry2 = entry3.next;
                    int n8 = entry3.key & n7;
                    entry3.next = entryArray2[n8];
                    entryArray2[n8] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray2;
            this.capacity = n6;
            this.threshold = (int)((float)n6 * this.loadFactor);
            this.mask = n7;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(IntIntHashMap intIntHashMap) {
        for (Entry entry : intIntHashMap) {
            this.put(entry.key, entry.value);
        }
    }

    public int remove(int n2) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n3 = n2 & this.mask;
        Entry entry2 = entry = entryArray[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == n2) {
                --this.size;
                if (entry == entry2) {
                    entryArray[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public int setKeyNotFoundValue(int n2) {
        int n3 = this.keyNotFoundValue;
        this.keyNotFoundValue = n2;
        return n3;
    }

    public int getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("{");
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private static Method getCloneMethod(Object object) {
        final Class<?> clazz = object.getClass();
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod("clone", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", noSuchMethodException);
                }
            }
        });
    }

    static {
        final Class<Integer> clazz = Integer.TYPE;
        final Class<Integer> clazz2 = Integer.TYPE;
        isPrimitive = clazz.isPrimitive();
        if (!isPrimitive) {
            EntryCM entryCM = AccessController.doPrivileged(new PrivilegedAction<EntryCM>(){

                @Override
                public EntryCM run() {
                    EntryCM entryCM = new EntryCM();
                    entryCM.c = ReflectionUtil.getConstructor(Entry.class, clazz2, clazz, Entry.class);
                    try {
                        entryCM.m1 = clazz.getDeclaredMethod("equals", Object.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new JogampRuntimeException("Class " + clazz + " doesn't support equals(Object)");
                    }
                    return entryCM;
                }
            });
            entryConstructor = entryCM.c;
            equalsMethod = entryCM.m1;
        } else {
            entryConstructor = null;
            equalsMethod = null;
        }
    }

    public static final class Entry {
        public final int key;
        public int value;
        Entry next;

        Entry(int n2, int n3, Entry entry) {
            this.key = n2;
            this.value = n3;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n2) {
            this.value = n2;
        }

        public StringBuilder toString(StringBuilder stringBuilder) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("[").append(this.key).append(":").append(this.value).append("]");
            return stringBuilder;
        }

        public String toString() {
            return this.toString(null).toString();
        }
    }

    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entryArray) {
            this.entries = entryArray;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry entry = this.next;
            if (entry != null && entry.next != null) {
                this.next = entry.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry entry2;
                    if ((entry2 = this.entries[this.index++]) == null) continue;
                    this.next = entry2;
                    return entry;
                }
                this.next = null;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class EntryCM {
        Constructor<Entry> c = null;
        Method m1 = null;

        EntryCM() {
        }
    }
}

