/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.Ringbuffer;
import java.io.PrintStream;
import java.lang.reflect.Array;

public class SyncedRingbuffer<T>
implements Ringbuffer<T> {
    private final Object syncGlobal = new Object();
    private T[] array;
    private int capacity;
    private int readPos;
    private int writePos;
    private int size;

    @Override
    public final String toString() {
        return "SyncedRingbuffer<?>[filled " + this.size + " / " + this.capacity + ", writePos " + this.writePos + ", readPos " + this.readPos + "]";
    }

    @Override
    public final void dump(PrintStream printStream, String string) {
        printStream.println(string + " " + this.toString() + " {");
        for (int i2 = 0; i2 < this.capacity; ++i2) {
            printStream.println("\t[" + i2 + "]: " + this.array[i2]);
        }
        printStream.println("}");
    }

    public SyncedRingbuffer(T[] TArray) throws IllegalArgumentException {
        this.capacity = TArray.length;
        this.array = SyncedRingbuffer.newArray(TArray.getClass(), this.capacity);
        this.resetImpl(true, TArray);
    }

    public SyncedRingbuffer(Class<? extends T[]> clazz, int n2) {
        this.capacity = n2;
        this.array = SyncedRingbuffer.newArray(clazz, n2);
        this.resetImpl(false, null);
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.syncGlobal;
        synchronized (object) {
            this.resetImpl(false, null);
            for (int i2 = 0; i2 < this.capacity; ++i2) {
                this.array[i2] = null;
            }
        }
    }

    @Override
    public final void resetFull(T[] TArray) throws IllegalArgumentException {
        this.resetImpl(true, TArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetImpl(boolean bl, T[] TArray) throws IllegalArgumentException {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (null != TArray) {
                if (TArray.length != this.capacity()) {
                    throw new IllegalArgumentException("copyFrom array length " + TArray.length + " != capacity " + this);
                }
                System.arraycopy(TArray, 0, this.array, 0, TArray.length);
            } else if (bl) {
                throw new IllegalArgumentException("copyFrom array is null");
            }
            this.readPos = 0;
            this.writePos = 0;
            this.size = bl ? this.capacity : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getFreeSlots() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.capacity - this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return 0 == this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFull() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.capacity == this.size;
        }
    }

    @Override
    public final T get() {
        try {
            return this.getImpl(false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final T getBlocking() throws InterruptedException {
        return this.getImpl(true, false);
    }

    @Override
    public final T peek() {
        try {
            return this.getImpl(false, true);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final T peekBlocking() throws InterruptedException {
        return this.getImpl(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T getImpl(boolean bl, boolean bl2) throws InterruptedException {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (0 == this.size) {
                if (bl) {
                    while (0 == this.size) {
                        this.syncGlobal.wait();
                    }
                } else {
                    return null;
                }
            }
            int n2 = this.readPos;
            T t = this.array[n2];
            if (!bl2) {
                this.array[n2] = null;
                --this.size;
                this.readPos = (n2 + 1) % this.capacity;
                this.syncGlobal.notifyAll();
            }
            return t;
        }
    }

    @Override
    public final boolean put(T t) {
        try {
            return this.putImpl(t, false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final void putBlocking(T t) throws InterruptedException {
        if (!this.putImpl(t, false, true)) {
            throw new InternalError("Blocking put failed: " + this);
        }
    }

    @Override
    public final boolean putSame(boolean bl) throws InterruptedException {
        return this.putImpl(null, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean putImpl(T t, boolean bl, boolean bl2) throws InterruptedException {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (this.capacity == this.size) {
                if (bl2) {
                    while (this.capacity == this.size) {
                        this.syncGlobal.wait();
                    }
                } else {
                    return false;
                }
            }
            int n2 = this.writePos;
            if (!bl) {
                this.array[n2] = t;
            }
            ++this.size;
            this.writePos = (n2 + 1) % this.capacity;
            this.syncGlobal.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitForFreeSlots(int n2) throws InterruptedException {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (this.capacity - this.size < n2) {
                while (this.capacity - this.size < n2) {
                    this.syncGlobal.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void growEmptyBuffer(T[] TArray) throws IllegalStateException, IllegalArgumentException {
        Object object = this.syncGlobal;
        synchronized (object) {
            int n2;
            Class<?> clazz;
            if (null == TArray) {
                throw new IllegalArgumentException("newElements is null");
            }
            Class<?> clazz2 = this.array.getClass();
            if (clazz2 != (clazz = TArray.getClass())) {
                throw new IllegalArgumentException("newElements array-type mismatch, internal " + clazz2 + ", newElements " + clazz);
            }
            if (0 != this.size) {
                throw new IllegalStateException("Buffer is not empty: " + this);
            }
            if (this.readPos != this.writePos) {
                throw new InternalError("R/W pos not equal: " + this);
            }
            int n3 = TArray.length;
            int n4 = this.capacity + n3;
            T[] TArray2 = this.array;
            T[] TArray3 = SyncedRingbuffer.newArray(clazz2, n4);
            this.writePos += n3;
            if (this.readPos > 0) {
                System.arraycopy(TArray2, 0, TArray3, 0, this.readPos);
            }
            if (n3 > 0) {
                System.arraycopy(TArray, 0, TArray3, this.readPos, n3);
            }
            if ((n2 = this.capacity - this.readPos) > 0) {
                System.arraycopy(TArray2, this.readPos, TArray3, this.writePos, n2);
            }
            this.size = n3;
            this.capacity = n4;
            this.array = TArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void growFullBuffer(int n2) throws IllegalStateException, IllegalArgumentException {
        Object object = this.syncGlobal;
        synchronized (object) {
            int n3;
            if (0 > n2) {
                throw new IllegalArgumentException("amount " + n2 + " < 0 ");
            }
            if (this.capacity != this.size) {
                throw new IllegalStateException("Buffer is not full: " + this);
            }
            if (this.readPos != this.writePos) {
                throw new InternalError("R/W pos not equal: " + this);
            }
            Class<?> clazz = this.array.getClass();
            int n4 = this.capacity + n2;
            T[] TArray = this.array;
            T[] TArray2 = SyncedRingbuffer.newArray(clazz, n4);
            this.readPos += n2;
            if (this.writePos > 0) {
                System.arraycopy(TArray, 0, TArray2, 0, this.writePos);
            }
            if ((n3 = this.capacity - this.writePos) > 0) {
                System.arraycopy(TArray, this.writePos, TArray2, this.readPos, n3);
            }
            this.capacity = n4;
            this.array = TArray2;
        }
    }

    private static <T> T[] newArray(Class<? extends T[]> clazz, int n2) {
        return clazz == Object[].class ? new Object[n2] : (Object[])Array.newInstance(clazz.getComponentType(), n2);
    }
}

