/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.DimensionImmutable;

public class Dimension
implements Cloneable,
DimensionImmutable {
    int width;
    int height;

    public Dimension() {
        this(0, 0);
    }

    public Dimension(int[] nArray) {
        this(nArray[0], nArray[1]);
    }

    public Dimension(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("width and height must be within: [0..2147483647]");
        }
        this.width = n2;
        this.height = n3;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final void set(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public final void setWidth(int n2) {
        this.width = n2;
    }

    public final void setHeight(int n2) {
        this.height = n2;
    }

    public final Dimension scale(int n2) {
        this.width *= n2;
        this.height *= n2;
        return this;
    }

    public final Dimension add(Dimension dimension) {
        this.width += dimension.width;
        this.height += dimension.height;
        return this;
    }

    public String toString() {
        return this.width + " x " + this.height;
    }

    @Override
    public int compareTo(DimensionImmutable dimensionImmutable) {
        int n2 = this.width * this.height;
        int n3 = dimensionImmutable.getWidth() * dimensionImmutable.getHeight();
        if (n2 > n3) {
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            return this.height == dimension.height && this.width == dimension.width;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 31 + this.width;
        return (n2 << 5) - n2 + this.height;
    }
}

