/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.common.util.IntBitfield;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import java.util.Arrays;

public enum PixelFormat {
    LUMINANCE(new CType[]{CType.Y}, 1, 8, 8),
    RGB565(new CType[]{CType.R, CType.G, CType.B}, new int[]{31, 63, 31}, new int[]{0, 5, 11}, 16),
    BGR565(new CType[]{CType.B, CType.G, CType.R}, new int[]{31, 63, 31}, new int[]{0, 5, 11}, 16),
    RGBA5551(new CType[]{CType.R, CType.G, CType.B, CType.A}, new int[]{31, 31, 31, 1}, new int[]{0, 5, 10, 15}, 16),
    ABGR1555(new CType[]{CType.A, CType.B, CType.G, CType.R}, new int[]{1, 31, 31, 31}, new int[]{0, 1, 6, 11}, 16),
    RGB888(new CType[]{CType.R, CType.G, CType.B}, 3, 8, 24),
    BGR888(new CType[]{CType.B, CType.G, CType.R}, 3, 8, 24),
    RGBx8888(new CType[]{CType.R, CType.G, CType.B}, 3, 8, 32),
    BGRx8888(new CType[]{CType.B, CType.G, CType.R}, 3, 8, 32),
    RGBA8888(new CType[]{CType.R, CType.G, CType.B, CType.A}, 4, 8, 32),
    ABGR8888(new CType[]{CType.A, CType.B, CType.G, CType.R}, 4, 8, 32),
    ARGB8888(new CType[]{CType.A, CType.R, CType.G, CType.B}, 4, 8, 32),
    BGRA8888(new CType[]{CType.B, CType.G, CType.R, CType.A}, 4, 8, 32);

    public final Composition comp;

    private PixelFormat(CType[] cTypeArray, int n3, int n4, int n5) {
        this.comp = new PackedComposition(cTypeArray, n3, n4, n5);
    }

    private PixelFormat(CType[] cTypeArray, int[] nArray, int[] nArray2, int n3) {
        this.comp = new PackedComposition(cTypeArray, nArray, nArray2, n3);
    }

    public static PixelFormat valueOf(Composition composition) {
        PixelFormat[] pixelFormatArray = PixelFormat.values();
        for (int i2 = pixelFormatArray.length - 1; i2 >= 0; --i2) {
            PixelFormat pixelFormat = pixelFormatArray[i2];
            if (composition.hashCode() != pixelFormat.comp.hashCode() || !composition.equals(pixelFormat.comp)) continue;
            return pixelFormat;
        }
        return null;
    }

    private static String toHexString(int[] nArray, int[] nArray2, int[] nArray3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n2 = nArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nArray[i2]).append(": ").append("0x").append(Integer.toHexString(nArray2[i2])).append(" << ").append(nArray3[i2]);
        }
        return stringBuilder.append("]").toString();
    }

    public static class PackedComposition
    implements Composition {
        private final CType[] compOrder;
        private final int[] compMask;
        private final int[] compBitCount;
        private final int[] compBitShift;
        private final int bitsPerPixel;
        private final int bitStride;
        private final boolean uniform;
        private final int hashCode;

        @Override
        public final String toString() {
            return String.format("PackedComp[order %s, stride %d, bpp %d, uni %b, comp %d: %s]", Arrays.toString((Object[])this.compOrder), this.bitStride, this.bitsPerPixel, this.uniform, this.compMask.length, PixelFormat.toHexString(this.compBitCount, this.compMask, this.compBitShift));
        }

        public PackedComposition(CType[] cTypeArray, int n2, int n3, int n4) {
            this.compOrder = cTypeArray;
            this.compMask = new int[n2];
            this.compBitShift = new int[n2];
            this.compBitCount = new int[n2];
            int n5 = (1 << n3) - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.compMask[i2] = n5;
                this.compBitShift[i2] = n3 * i2;
                this.compBitCount[i2] = n3;
            }
            this.uniform = true;
            this.bitsPerPixel = n3 * n2;
            this.bitStride = n4;
            if (this.bitStride < this.bitsPerPixel) {
                throw new IllegalArgumentException(String.format("bit-stride %d < bitsPerPixel %d", this.bitStride, this.bitsPerPixel));
            }
            this.hashCode = this.hashCodeImpl();
        }

        public PackedComposition(CType[] cTypeArray, int[] nArray, int[] nArray2, int n2) {
            this.compOrder = cTypeArray;
            this.compMask = nArray;
            this.compBitShift = nArray2;
            this.compBitCount = new int[nArray.length];
            int n3 = 0;
            boolean bl = true;
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                int n4 = nArray[i2];
                int n5 = IntBitfield.getBitCount(n4);
                n3 += n5;
                this.compBitCount[i2] = n5;
                if (i2 <= 0 || !bl) continue;
                bl = nArray[i2 - 1] == n4;
            }
            this.uniform = bl;
            this.bitsPerPixel = n3;
            this.bitStride = n2;
            if (this.bitStride < this.bitsPerPixel) {
                throw new IllegalArgumentException(String.format("bit-stride %d < bitsPerPixel %d", this.bitStride, this.bitsPerPixel));
            }
            this.hashCode = this.hashCodeImpl();
        }

        @Override
        public final boolean isUniform() {
            return this.uniform;
        }

        @Override
        public final boolean isInterleaved() {
            return true;
        }

        @Override
        public final int componentCount() {
            return this.compMask.length;
        }

        @Override
        public final int bitsPerPixel() {
            return this.bitsPerPixel;
        }

        @Override
        public final int bitStride() {
            return this.bitStride;
        }

        @Override
        public final int bytesPerPixel() {
            return (7 + this.bitStride) / 8;
        }

        @Override
        public final CType[] componentOrder() {
            return this.compOrder;
        }

        @Override
        public final int find(CType cType) {
            return PixelFormatUtil.find(cType, this.compOrder, false);
        }

        @Override
        public final int[] componentBitMask() {
            return this.compMask;
        }

        @Override
        public final int[] componentBitCount() {
            return this.compBitCount;
        }

        @Override
        public final int[] componentBitShift() {
            return this.compBitShift;
        }

        @Override
        public final int decodeSingleI32(int n2, int n3) {
            return n2 >>> this.compBitShift[n3] & this.compMask[n3];
        }

        @Override
        public final int decodeSingleI64(long l2, int n2) {
            return (int)(0xFFFFFFFFL & l2 >>> this.compBitShift[n2]) & this.compMask[n2];
        }

        @Override
        public final int encodeSingleI32(int n2, int n3) {
            return (n2 & this.compMask[n3]) << this.compBitShift[n3];
        }

        @Override
        public final long encodeSingleI64(int n2, int n3) {
            return (0xFFFFFFFFL & (long)(n2 & this.compMask[n3])) << this.compBitShift[n3];
        }

        @Override
        public final int encode3CompI32(int n2, int n3, int n4) {
            return (n2 & this.compMask[0]) << this.compBitShift[0] | (n3 & this.compMask[1]) << this.compBitShift[1] | (n4 & this.compMask[2]) << this.compBitShift[2];
        }

        @Override
        public final int encode4CompI32(int n2, int n3, int n4, int n5) {
            return (n2 & this.compMask[0]) << this.compBitShift[0] | (n3 & this.compMask[1]) << this.compBitShift[1] | (n4 & this.compMask[2]) << this.compBitShift[2] | (n5 & this.compMask[3]) << this.compBitShift[3];
        }

        @Override
        public final int encodeSingleI8(byte by, int n2) {
            return (by & this.compMask[n2]) << this.compBitShift[n2];
        }

        @Override
        public final int encode3CompI8(byte by, byte by2, byte by3) {
            return (by & this.compMask[0]) << this.compBitShift[0] | (by2 & this.compMask[1]) << this.compBitShift[1] | (by3 & this.compMask[2]) << this.compBitShift[2];
        }

        @Override
        public final int encode4CompI8(byte by, byte by2, byte by3, byte by4) {
            return (by & this.compMask[0]) << this.compBitShift[0] | (by2 & this.compMask[1]) << this.compBitShift[1] | (by3 & this.compMask[2]) << this.compBitShift[2] | (by4 & this.compMask[3]) << this.compBitShift[3];
        }

        @Override
        public final float toFloat(int n2, int n3, boolean bl) {
            if (bl) {
                return (float)(n2 >>> this.compBitShift[n3] & this.compMask[n3]) / (float)this.compMask[n3];
            }
            return (float)(n2 & this.compMask[n3]) / (float)this.compMask[n3];
        }

        @Override
        public final int fromFloat(float f2, int n2, boolean bl) {
            int n3 = (int)(f2 * (float)this.compMask[n2] + 0.5f);
            return bl ? n3 << this.compBitShift[n2] : n3;
        }

        @Override
        public final int defaultValue(int n2, boolean bl) {
            int n3 = CType.A == this.compOrder[n2] || CType.Y == this.compOrder[n2] ? this.compMask[n2] : 0;
            return bl ? n3 << this.compBitShift[n2] : n3;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        private final int hashCodeImpl() {
            int n2;
            int n3 = 31 + this.bitStride;
            n3 = (n3 << 5) - n3 + this.bitsPerPixel;
            n3 = (n3 << 5) - n3 + this.compMask.length;
            for (n2 = this.compOrder.length - 1; n2 >= 0; --n2) {
                n3 = (n3 << 5) - n3 + this.compOrder[n2].ordinal();
            }
            for (n2 = this.compMask.length - 1; n2 >= 0; --n2) {
                n3 = (n3 << 5) - n3 + this.compMask[n2];
            }
            for (n2 = this.compBitShift.length - 1; n2 >= 0; --n2) {
                n3 = (n3 << 5) - n3 + this.compBitShift[n2];
            }
            return n3;
        }

        @Override
        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PackedComposition) {
                PackedComposition packedComposition = (PackedComposition)object;
                return this.bitStride == packedComposition.bitStride && this.bitsPerPixel == packedComposition.bitsPerPixel && Arrays.equals((Object[])this.compOrder, (Object[])packedComposition.compOrder) && Arrays.equals(this.compMask, packedComposition.compMask) && Arrays.equals(this.compBitShift, packedComposition.compBitShift);
            }
            return false;
        }
    }

    public static interface Composition {
        public static final int UNDEF = -1;

        public boolean isUniform();

        public boolean isInterleaved();

        public int componentCount();

        public int bitsPerPixel();

        public int bitStride();

        public int bytesPerPixel();

        public CType[] componentOrder();

        public int find(CType var1);

        public int[] componentBitMask();

        public int[] componentBitCount();

        public int[] componentBitShift();

        public int decodeSingleI32(int var1, int var2);

        public int decodeSingleI64(long var1, int var3);

        public int encodeSingleI32(int var1, int var2);

        public long encodeSingleI64(int var1, int var2);

        public int encode3CompI32(int var1, int var2, int var3);

        public int encode4CompI32(int var1, int var2, int var3, int var4);

        public int encodeSingleI8(byte var1, int var2);

        public int encode3CompI8(byte var1, byte var2, byte var3);

        public int encode4CompI8(byte var1, byte var2, byte var3, byte var4);

        public float toFloat(int var1, int var2, boolean var3);

        public int fromFloat(float var1, int var2, boolean var3);

        public int defaultValue(int var1, boolean var2);

        public int hashCode();

        public boolean equals(Object var1);

        public String toString();
    }

    public static enum CType {
        R,
        G,
        B,
        A,
        Y,
        U,
        V;

    }
}

