/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.PointImmutable;

public class Point
implements Cloneable,
PointImmutable {
    int x;
    int y;

    public Point(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public Point() {
        this(0, 0);
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int compareTo(PointImmutable pointImmutable) {
        int n2 = this.x * this.y;
        int n3 = pointImmutable.getX() * pointImmutable.getY();
        if (n2 > n3) {
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.y == point.y && this.x == point.x;
        }
        return false;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public int hashCode() {
        int n2 = 31 + this.x;
        n2 = (n2 << 5) - n2 + this.y;
        return n2;
    }

    public String toString() {
        return this.x + " / " + this.y;
    }

    public final void set(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public final void setX(int n2) {
        this.x = n2;
    }

    public final void setY(int n2) {
        this.y = n2;
    }

    public final Point translate(Point point) {
        this.x += point.x;
        this.y += point.y;
        return this;
    }

    public final Point translate(int n2, int n3) {
        this.x += n2;
        this.y += n3;
        return this;
    }

    public final Point scale(int n2, int n3) {
        this.x *= n2;
        this.y *= n3;
        return this;
    }

    public final Point scale(float f2, float f3) {
        this.x = (int)((float)this.x * f2 + 0.5f);
        this.y = (int)((float)this.y * f3 + 0.5f);
        return this;
    }

    public final Point scaleInv(int n2, int n3) {
        this.x /= n2;
        this.y /= n3;
        return this;
    }

    public final Point scaleInv(float f2, float f3) {
        this.x = (int)((float)this.x / f2 + 0.5f);
        this.y = (int)((float)this.y / f3 + 0.5f);
        return this;
    }
}

