/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import jogamp.newt.Debug;

public class DoubleTapScrollGesture
implements GestureHandler {
    public static final int SCROLL_SLOP_PIXEL;
    public static final int DOUBLE_TAP_SLOP_PIXEL;
    public static final float SCROLL_SLOP_MM;
    public static final float DOUBLE_TAP_SLOP_MM;
    private static final int ST_NONE = 0;
    private static final int ST_1PRESS = 1;
    private static final int ST_2PRESS_T = 2;
    private static final int ST_2PRESS_C = 3;
    private static final int ST_SCROLL = 4;
    private final int scrollSlop;
    private final int scrollSlopSquare;
    private final int doubleTapSlop;
    private final int doubleTapSlopSquare;
    private final float[] scrollDistance = new float[]{0.0f, 0.0f};
    private final int[] pIds = new int[]{-1, -1};
    private int gestureState;
    private int sqStartDist;
    private int lastX;
    private int lastY;
    private int pointerDownCount;
    private MouseEvent hitGestureEvent;

    private static final int getSquareDistance(float f2, float f3, float f4, float f5) {
        int n2 = (int)f2 - (int)f4;
        int n3 = (int)f3 - (int)f5;
        return n2 * n2 + n3 * n3;
    }

    private int gesturePointers(MouseEvent mouseEvent, int n2) {
        int n3 = 0;
        for (int i2 = mouseEvent.getPointerCount() - 1; i2 >= 0; --i2) {
            short s;
            if (n2 == i2 || this.pIds[0] != (s = mouseEvent.getPointerId(i2)) && this.pIds[1] != s) continue;
            ++n3;
        }
        return n3;
    }

    public DoubleTapScrollGesture(int n2, int n3) {
        this.scrollSlop = n2;
        this.scrollSlopSquare = n2 * n2;
        this.doubleTapSlop = n3;
        this.doubleTapSlopSquare = n3 * n3;
        this.pointerDownCount = 0;
        this.clear(true);
        if (DEBUG) {
            System.err.println("DoubleTapScroll    scrollSlop (scaled) " + this.scrollSlop);
            System.err.println("DoubleTapScroll doubleTapSlop (scaled) " + this.doubleTapSlop);
        }
    }

    public String toString() {
        return "DoubleTapScroll[state " + this.gestureState + ", in " + this.isWithinGesture() + ", has " + (null != this.hitGestureEvent) + ", pc " + this.pointerDownCount + "]";
    }

    @Override
    public void clear(boolean bl) {
        this.scrollDistance[0] = 0.0f;
        this.scrollDistance[1] = 0.0f;
        this.hitGestureEvent = null;
        if (bl) {
            this.gestureState = 0;
            this.sqStartDist = 0;
            this.pIds[0] = -1;
            this.pIds[1] = -1;
            this.lastX = 0;
            this.lastY = 0;
        }
    }

    @Override
    public boolean isWithinGesture() {
        return 3 <= this.gestureState;
    }

    @Override
    public boolean hasGesture() {
        return null != this.hitGestureEvent;
    }

    @Override
    public InputEvent getGestureEvent() {
        if (null != this.hitGestureEvent) {
            MouseEvent mouseEvent = this.hitGestureEvent;
            int n2 = mouseEvent.getModifiers();
            float[] fArray = mouseEvent.getRotation();
            fArray[0] = this.scrollDistance[0] / (float)this.scrollSlop;
            fArray[1] = this.scrollDistance[1] / (float)this.scrollSlop;
            if (fArray[0] * fArray[0] > fArray[1] * fArray[1]) {
                n2 |= 1;
            }
            return new MouseEvent(207, mouseEvent.getSource(), mouseEvent.getWhen(), n2, mouseEvent.getAllPointerTypes(), mouseEvent.getAllPointerIDs(), mouseEvent.getAllX(), mouseEvent.getAllY(), mouseEvent.getAllPressures(), mouseEvent.getMaxPressure(), mouseEvent.getButton(), mouseEvent.getClickCount(), fArray, this.scrollSlop);
        }
        return null;
    }

    public final float[] getScrollDistanceXY() {
        return this.scrollDistance;
    }

    @Override
    public boolean process(InputEvent inputEvent) {
        if (null != this.hitGestureEvent || !(inputEvent instanceof MouseEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)inputEvent;
        if (mouseEvent.getPointerType(0).getPointerClass() != MouseEvent.PointerClass.Onscreen) {
            return false;
        }
        this.pointerDownCount = mouseEvent.getPointerCount();
        short s = mouseEvent.getEventType();
        int n2 = mouseEvent.getX(0);
        int n3 = mouseEvent.getY(0);
        switch (s) {
            case 203: {
                int n4 = 0;
                if (0 == this.gestureState && 1 == this.pointerDownCount) {
                    this.pIds[0] = mouseEvent.getPointerId(0);
                    this.pIds[1] = -1;
                    this.gestureState = 1;
                } else if (0 < this.gestureState && 2 == this.pointerDownCount && 1 == this.gesturePointers(mouseEvent, 0)) {
                    int n5 = mouseEvent.getX(1);
                    int n6 = mouseEvent.getY(1);
                    int n7 = (n2 + n5) / 2;
                    int n8 = (n3 + n6) / 2;
                    if (1 == this.gestureState) {
                        boolean bl;
                        int n9 = DoubleTapScrollGesture.getSquareDistance(n2, n3, n5, n6);
                        boolean bl2 = bl = n9 < this.doubleTapSlopSquare;
                        if (bl) {
                            n4 = 2;
                            this.pIds[0] = mouseEvent.getPointerId(0);
                            this.pIds[1] = mouseEvent.getPointerId(1);
                            this.lastX = n7;
                            this.lastY = n8;
                            this.sqStartDist = n9;
                            this.gestureState = 2;
                        }
                        if (DEBUG) {
                            int n10 = (int)Math.round(Math.sqrt(n9));
                            System.err.println(this + ".pressed.1: dist " + n10 + ", gPtr " + n4 + ", distWithin2DTSlop " + bl + ", last " + this.lastX + "/" + this.lastY + ", " + mouseEvent);
                        }
                    } else if (3 == this.gestureState) {
                        n4 = this.gesturePointers(mouseEvent, -1);
                        if (2 == n4) {
                            this.lastX = n7;
                            this.lastY = n8;
                        } else {
                            this.clear(true);
                        }
                    }
                }
                if (!DEBUG) break;
                System.err.println(this + ".pressed: gPtr " + n4 + ", this " + this.lastX + "/" + this.lastY + ", " + mouseEvent);
                break;
            }
            case 204: {
                --this.pointerDownCount;
                int n11 = this.gesturePointers(mouseEvent, 0);
                if (1 == n11) {
                    this.gestureState = 3;
                } else if (0 == n11) {
                    this.clear(true);
                }
                if (!DEBUG) break;
                System.err.println(this + ".released: gPtr " + n11 + ", " + mouseEvent);
                break;
            }
            case 206: {
                if (2 != this.pointerDownCount || 1 >= this.gestureState) break;
                int n12 = this.gesturePointers(mouseEvent, -1);
                if (2 == n12) {
                    boolean bl;
                    int n13 = mouseEvent.getX(1);
                    int n14 = mouseEvent.getY(1);
                    int n15 = (n2 + n13) / 2;
                    int n16 = (n3 + n14) / 2;
                    int n17 = DoubleTapScrollGesture.getSquareDistance(n2, n3, n13, n14);
                    boolean bl3 = bl = Math.abs(n17 - this.sqStartDist) <= this.doubleTapSlopSquare;
                    if (bl) {
                        switch (this.gestureState) {
                            case 2: {
                                int bl4 = DoubleTapScrollGesture.getSquareDistance(this.lastX, this.lastY, n15, n16);
                                if (bl4 <= this.scrollSlopSquare) break;
                                this.gestureState = 4;
                                break;
                            }
                            case 3: {
                                this.gestureState = 4;
                                break;
                            }
                            case 4: {
                                this.scrollDistance[0] = this.lastX - n15;
                                this.scrollDistance[1] = this.lastY - n16;
                                this.hitGestureEvent = mouseEvent;
                            }
                        }
                        if (DEBUG) {
                            boolean bl5 = n17 < this.doubleTapSlopSquare;
                            int n21 = (int)Math.round(Math.sqrt(n17));
                            int n22 = DoubleTapScrollGesture.getSquareDistance(this.lastX, this.lastY, n15, n16);
                            int n4 = (int)Math.round(Math.sqrt(n22));
                            System.err.println(this + ".dragged.1: pDist " + n21 + ", scrollLen " + n4 + ", gPtr " + n12 + " [" + this.pIds[0] + ", " + this.pIds[1] + "]" + ", diffDistWithinTapSlop " + bl + ", distWithin2DTSlop " + bl5 + ", this " + n15 + "/" + n16 + ", last " + this.lastX + "/" + this.lastY + ", d " + this.scrollDistance[0] + "/" + this.scrollDistance[1]);
                        }
                    } else {
                        if (DEBUG) {
                            boolean bl4 = n17 < this.doubleTapSlopSquare;
                            int n5 = (int)Math.round(Math.sqrt(n17));
                            int n6 = (int)Math.round(Math.sqrt(this.sqStartDist));
                            System.err.println(this + ".dragged.X1: pDist " + n5 + ", distStart " + n6 + ", gPtr " + n12 + " [" + this.pIds[0] + ", " + this.pIds[1] + "]" + ", diffDistWithinTapSlop " + bl + ", distWithin2DTSlop " + bl4 + ", this " + n15 + "/" + n16 + ", last " + this.lastX + "/" + this.lastY + ", d " + this.scrollDistance[0] + "/" + this.scrollDistance[1]);
                        }
                        this.clear(true);
                    }
                    if (2 >= this.gestureState) break;
                    this.lastX = n15;
                    this.lastY = n16;
                    break;
                }
                if (DEBUG) {
                    System.err.println(this + ".dragged.X2: gPtr " + n12 + " [" + this.pIds[0] + ", " + this.pIds[1] + "]" + ", last " + this.lastX + "/" + this.lastY + ", d " + this.scrollDistance[0] + "/" + this.scrollDistance[1]);
                }
                this.clear(true);
                break;
            }
        }
        return null != this.hitGestureEvent;
    }

    static {
        Debug.initSingleton();
        SCROLL_SLOP_PIXEL = PropertyAccess.getIntProperty("newt.event.scroll_slop_pixel", true, 16);
        DOUBLE_TAP_SLOP_PIXEL = PropertyAccess.getIntProperty("newt.event.double_tap_slop_pixel", true, 104);
        SCROLL_SLOP_MM = PropertyAccess.getIntProperty("newt.event.scroll_slop_mm", true, 3);
        DOUBLE_TAP_SLOP_MM = PropertyAccess.getIntProperty("newt.event.double_tap_slop_mm", true, 20);
    }
}

