/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.common.util.IntBitfield;
import com.jogamp.newt.event.NEWTEvent;

public abstract class InputEvent
extends NEWTEvent {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 16;
    public static final int BUTTON1_MASK = 32;
    public static final int BUTTON2_MASK = 64;
    public static final int BUTTON3_MASK = 128;
    public static final int BUTTON4_MASK = 256;
    public static final int BUTTON5_MASK = 512;
    public static final int BUTTON6_MASK = 1024;
    public static final int BUTTON7_MASK = 2048;
    public static final int BUTTON8_MASK = 4096;
    public static final int BUTTON9_MASK = 8192;
    public static final int BUTTONLAST_MASK = 0x100000;
    public static final int BUTTONALL_MASK = 2097120;
    public static final int AUTOREPEAT_MASK = 0x20000000;
    public static final int CONFINED_MASK = 0x40000000;
    public static final int INVISIBLE_MASK = Integer.MIN_VALUE;
    private final int modifiers;

    public static final int getButtonMask(int n2) {
        if (0 < n2 && n2 <= 16) {
            return 1 << 4 + n2;
        }
        return 0;
    }

    protected InputEvent(short s, Object object, long l2, int n2) {
        super(s, object, l2);
        this.modifiers = n2;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isAltGraphDown() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isAutoRepeat() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isConfined() {
        return (this.modifiers & 0x40000000) != 0;
    }

    public final boolean isInvisible() {
        return (this.modifiers & Integer.MIN_VALUE) != 0;
    }

    public final StringBuilder getModifiersString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        boolean bl = true;
        if (this.isShiftDown()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("shift");
        }
        if (this.isControlDown()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("ctrl");
        }
        if (this.isMetaDown()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("meta");
        }
        if (this.isAltDown()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("alt");
        }
        if (this.isAltGraphDown()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("altgr");
        }
        if (this.isAutoRepeat()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("repeat");
        }
        for (int i2 = 1; i2 <= 16; ++i2) {
            if (!this.isButtonDown(i2)) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("button").append(i2);
        }
        if (this.isConfined()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("confined");
        }
        if (this.isInvisible()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append("invisible");
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public final short[] getButtonsDown() {
        int n2 = this.getButtonDownCount();
        short[] sArray = new short[n2];
        int n3 = 0;
        for (int i2 = 1; i2 <= 16; ++i2) {
            if (!this.isButtonDown(i2)) continue;
            sArray[n3++] = (short)(0 + i2);
        }
        return sArray;
    }

    public final boolean isButtonDown(int n2) {
        return (this.modifiers & InputEvent.getButtonMask(n2)) != 0;
    }

    public final int getButtonDownCount() {
        return IntBitfield.getBitCount(this.modifiers & 0x1FFFE0);
    }

    public final boolean isAnyButtonDown() {
        return 0 != (this.modifiers & 0x1FFFE0);
    }

    @Override
    public String toString() {
        return this.toString(null).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("InputEvent[modifiers: ");
        this.getModifiersString(stringBuilder);
        stringBuilder.append(", ");
        super.toString(stringBuilder).append("]");
        return stringBuilder;
    }

    public static interface InputType {
    }

    public static interface InputClass {
    }
}

