/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.InputEvent;
import java.util.Arrays;

public class MouseEvent
extends InputEvent {
    public static final short BUTTON1 = 1;
    public static final short BUTTON2 = 2;
    public static final short BUTTON3 = 3;
    public static final short BUTTON4 = 4;
    public static final short BUTTON5 = 5;
    public static final short BUTTON6 = 6;
    public static final short BUTTON7 = 7;
    public static final short BUTTON8 = 8;
    public static final short BUTTON9 = 9;
    public static final short BUTTON_COUNT = 16;
    private final PointerType[] pointerType;
    private final short[] pointerID;
    private final int[] x;
    private final int[] y;
    private final float[] pressure;
    private final short clickCount;
    private final short button;
    private final float[] rotationXYZ;
    private final float rotationScale;
    private final float maxPressure;
    private static final float[] constMousePressure0 = new float[]{0.0f};
    private static final float[] constMousePressure1 = new float[]{1.0f};
    private static final PointerType[] constMousePointerTypes = new PointerType[]{PointerType.Mouse};
    public static final short EVENT_MOUSE_CLICKED = 200;
    public static final short EVENT_MOUSE_ENTERED = 201;
    public static final short EVENT_MOUSE_EXITED = 202;
    public static final short EVENT_MOUSE_PRESSED = 203;
    public static final short EVENT_MOUSE_RELEASED = 204;
    public static final short EVENT_MOUSE_MOVED = 205;
    public static final short EVENT_MOUSE_DRAGGED = 206;
    public static final short EVENT_MOUSE_WHEEL_MOVED = 207;

    public static final float[] getRotationXYZ(float f2, int n2) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        if (0 != (n2 & 1)) {
            fArray[0] = f2;
        } else {
            fArray[1] = f2;
        }
        return fArray;
    }

    public static final short getClickTimeout() {
        return 300;
    }

    public MouseEvent(short s, Object object, long l2, int n2, int n3, int n4, short s2, short s3, float[] fArray, float f2) {
        super(s, object, l2, n2);
        this.x = new int[]{n3};
        this.y = new int[]{n4};
        switch (s) {
            case 200: 
            case 203: 
            case 206: {
                this.pressure = constMousePressure1;
                break;
            }
            default: {
                this.pressure = constMousePressure0;
            }
        }
        this.maxPressure = 1.0f;
        this.pointerID = new short[]{0};
        this.clickCount = s2;
        this.button = s3;
        this.rotationXYZ = fArray;
        this.rotationScale = f2;
        this.pointerType = constMousePointerTypes;
    }

    public MouseEvent(short s, Object object, long l2, int n2, PointerType[] pointerTypeArray, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f2, short s2, short s3, float[] fArray2, float f3) {
        super(s, object, l2, n2);
        this.x = nArray;
        this.y = nArray2;
        int n3 = pointerTypeArray.length;
        if (n3 != sArray.length || n3 != nArray.length || n3 != nArray2.length || n3 != fArray.length) {
            throw new IllegalArgumentException("All multiple pointer arrays must be of same size");
        }
        if (0.0f >= f2) {
            throw new IllegalArgumentException("maxPressure must be > 0.0f");
        }
        this.pressure = fArray;
        this.maxPressure = f2;
        this.pointerID = sArray;
        this.clickCount = s3;
        this.button = s2;
        this.rotationXYZ = fArray2;
        this.rotationScale = f3;
        this.pointerType = pointerTypeArray;
    }

    public final MouseEvent createVariant(short s) {
        return new MouseEvent(s, this.source, this.getWhen(), this.getModifiers(), this.pointerType, this.pointerID, this.x, this.y, this.pressure, this.maxPressure, this.button, this.clickCount, this.rotationXYZ, this.rotationScale);
    }

    public final int getPointerCount() {
        return this.pointerType.length;
    }

    public final PointerType getPointerType(int n2) {
        if (0 > n2 || n2 >= this.pointerType.length) {
            return null;
        }
        return this.pointerType[n2];
    }

    public final PointerType[] getAllPointerTypes() {
        return this.pointerType;
    }

    public final short getPointerId(int n2) {
        if (0 > n2 || n2 >= this.pointerID.length) {
            return -1;
        }
        return this.pointerID[n2];
    }

    public final int getPointerIdx(short s) {
        if (s >= 0) {
            for (int i2 = this.pointerID.length - 1; i2 >= 0; --i2) {
                if (this.pointerID[i2] != s) continue;
                return i2;
            }
        }
        return -1;
    }

    public final short[] getAllPointerIDs() {
        return this.pointerID;
    }

    public final short getButton() {
        return this.button;
    }

    public final short getClickCount() {
        return this.clickCount;
    }

    public final int getX() {
        return this.x[0];
    }

    public final int getY() {
        return this.y[0];
    }

    public final int getX(int n2) {
        return this.x[n2];
    }

    public final int getY(int n2) {
        return this.y[n2];
    }

    public final int[] getAllX() {
        return this.x;
    }

    public final int[] getAllY() {
        return this.y;
    }

    public final float getPressure(boolean bl) {
        return bl ? this.pressure[0] / this.maxPressure : this.pressure[0];
    }

    public final float getPressure(int n2, boolean bl) {
        return bl ? this.pressure[n2] / this.maxPressure : this.pressure[n2];
    }

    public final float[] getAllPressures() {
        return this.pressure;
    }

    public final float getMaxPressure() {
        return this.maxPressure;
    }

    public final float[] getRotation() {
        return this.rotationXYZ;
    }

    public final float getRotationScale() {
        return this.rotationScale;
    }

    @Override
    public final String toString() {
        return this.toString(null).toString();
    }

    @Override
    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("MouseEvent[").append(MouseEvent.getEventTypeString(this.getEventType())).append(", ").append(Arrays.toString(this.x)).append("/").append(Arrays.toString(this.y)).append(", button ").append(this.button).append(", count ").append(this.clickCount).append(", rotation [").append(this.rotationXYZ[0]).append(", ").append(this.rotationXYZ[1]).append(", ").append(this.rotationXYZ[2]).append("] * ").append(this.rotationScale);
        if (this.pointerID.length > 0) {
            stringBuilder.append(", pointer<").append(this.pointerID.length).append(">[");
            for (int i2 = 0; i2 < this.pointerID.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.pointerID[i2]).append("/").append(this.pointerType[i2]).append(": ").append(this.x[i2]).append("/").append(this.y[i2]).append(", ").append("p[").append(this.pressure[i2]).append("/").append(this.maxPressure).append("=").append(this.pressure[i2] / this.maxPressure).append("]");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(", ");
        return super.toString(stringBuilder).append("]");
    }

    public static String getEventTypeString(short s) {
        switch (s) {
            case 200: {
                return "EVENT_MOUSE_CLICKED";
            }
            case 201: {
                return "EVENT_MOUSE_ENTERED";
            }
            case 202: {
                return "EVENT_MOUSE_EXITED";
            }
            case 203: {
                return "EVENT_MOUSE_PRESSED";
            }
            case 204: {
                return "EVENT_MOUSE_RELEASED";
            }
            case 205: {
                return "EVENT_MOUSE_MOVED";
            }
            case 206: {
                return "EVENT_MOUSE_DRAGGED";
            }
            case 207: {
                return "EVENT_MOUSE_WHEEL_MOVED";
            }
        }
        return "unknown (" + s + ")";
    }

    public static enum PointerType implements InputEvent.InputType
    {
        Mouse(PointerClass.Offscreen),
        TouchPad(PointerClass.Offscreen),
        TouchScreen(PointerClass.Onscreen),
        Pen(PointerClass.Onscreen),
        Undefined(PointerClass.Undefined);

        PointerClass pc;

        public PointerClass getPointerClass() {
            return this.pc;
        }

        public static PointerType valueOf(int n2) throws IllegalArgumentException {
            PointerType[] pointerTypeArray = PointerType.values();
            if (0 <= n2 && n2 < pointerTypeArray.length) {
                return pointerTypeArray[n2];
            }
            throw new IllegalArgumentException("Ordinal " + n2 + " out of range of PointerType.values()[0.." + (pointerTypeArray.length - 1) + "]");
        }

        public static PointerType[] valuesOf(int[] nArray) throws IllegalArgumentException {
            int n2 = nArray.length;
            PointerType[] pointerTypeArray = new PointerType[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                pointerTypeArray[i2] = PointerType.valueOf(nArray[i2]);
            }
            return pointerTypeArray;
        }

        private PointerType(PointerClass pointerClass) {
            this.pc = pointerClass;
        }
    }

    public static enum PointerClass implements InputEvent.InputClass
    {
        Offscreen,
        Onscreen,
        Undefined;

    }
}

