/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.VectorUtil;
import java.nio.FloatBuffer;
import jogamp.opengl.Debug;

public final class FloatUtil {
    public static final boolean DEBUG = Debug.debug("Math");
    private static volatile boolean machEpsilonAvail = false;
    private static float machEpsilon = 0.0f;
    private static final boolean DEBUG_EPSILON = false;
    public static final float E = (float)Math.E;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float SQUARED_PI = 9.869605f;
    public static final float EPSILON = 1.1920929E-7f;
    public static final float INV_DEVIANCE = 1.0E-5f;

    public static float[] makeIdentity(float[] fArray, int n2) {
        fArray[n2 + 0 + 0] = 1.0f;
        fArray[n2 + 1 + 0] = 0.0f;
        fArray[n2 + 2 + 0] = 0.0f;
        fArray[n2 + 3 + 0] = 0.0f;
        fArray[n2 + 0 + 4] = 0.0f;
        fArray[n2 + 1 + 4] = 1.0f;
        fArray[n2 + 2 + 4] = 0.0f;
        fArray[n2 + 3 + 4] = 0.0f;
        fArray[n2 + 0 + 8] = 0.0f;
        fArray[n2 + 1 + 8] = 0.0f;
        fArray[n2 + 2 + 8] = 1.0f;
        fArray[n2 + 3 + 8] = 0.0f;
        fArray[n2 + 0 + 12] = 0.0f;
        fArray[n2 + 1 + 12] = 0.0f;
        fArray[n2 + 2 + 12] = 0.0f;
        fArray[n2 + 3 + 12] = 1.0f;
        return fArray;
    }

    public static float[] makeIdentity(float[] fArray) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
        return fArray;
    }

    public static float[] makeTranslation(float[] fArray, int n2, boolean bl, float f2, float f3, float f4) {
        if (bl) {
            FloatUtil.makeIdentity(fArray, n2);
        } else {
            fArray[n2 + 0 + 0] = 1.0f;
            fArray[n2 + 1 + 4] = 1.0f;
            fArray[n2 + 2 + 8] = 1.0f;
            fArray[n2 + 3 + 12] = 1.0f;
        }
        fArray[n2 + 0 + 12] = f2;
        fArray[n2 + 1 + 12] = f3;
        fArray[n2 + 2 + 12] = f4;
        return fArray;
    }

    public static float[] makeTranslation(float[] fArray, boolean bl, float f2, float f3, float f4) {
        if (bl) {
            FloatUtil.makeIdentity(fArray);
        } else {
            fArray[0] = 1.0f;
            fArray[5] = 1.0f;
            fArray[10] = 1.0f;
            fArray[15] = 1.0f;
        }
        fArray[12] = f2;
        fArray[13] = f3;
        fArray[14] = f4;
        return fArray;
    }

    public static float[] makeScale(float[] fArray, int n2, boolean bl, float f2, float f3, float f4) {
        if (bl) {
            FloatUtil.makeIdentity(fArray, n2);
        } else {
            fArray[n2 + 0 + 12] = 0.0f;
            fArray[n2 + 1 + 12] = 0.0f;
            fArray[n2 + 2 + 12] = 0.0f;
            fArray[n2 + 3 + 12] = 1.0f;
        }
        fArray[n2 + 0 + 0] = f2;
        fArray[n2 + 1 + 4] = f3;
        fArray[n2 + 2 + 8] = f4;
        return fArray;
    }

    public static float[] makeScale(float[] fArray, boolean bl, float f2, float f3, float f4) {
        if (bl) {
            FloatUtil.makeIdentity(fArray);
        } else {
            fArray[12] = 0.0f;
            fArray[13] = 0.0f;
            fArray[14] = 0.0f;
            fArray[15] = 1.0f;
        }
        fArray[0] = f2;
        fArray[5] = f3;
        fArray[10] = f4;
        return fArray;
    }

    public static float[] makeRotationAxis(float[] fArray, int n2, float f2, float f3, float f4, float f5, float[] fArray2) {
        float f6 = FloatUtil.cos(f2);
        float f7 = 1.0f - f6;
        float f8 = FloatUtil.sin(f2);
        fArray2[0] = f3;
        fArray2[1] = f4;
        fArray2[2] = f5;
        VectorUtil.normalizeVec3(fArray2);
        f3 = fArray2[0];
        f4 = fArray2[1];
        f5 = fArray2[2];
        float f9 = f3 * f4;
        float f10 = f3 * f5;
        float f11 = f3 * f8;
        float f12 = f4 * f8;
        float f13 = f4 * f5;
        float f14 = f5 * f8;
        fArray[0 + n2] = f3 * f3 * f7 + f6;
        fArray[1 + n2] = f9 * f7 + f14;
        fArray[2 + n2] = f10 * f7 - f12;
        fArray[3 + n2] = 0.0f;
        fArray[4 + n2] = f9 * f7 - f14;
        fArray[5 + n2] = f4 * f4 * f7 + f6;
        fArray[6 + n2] = f13 * f7 + f11;
        fArray[7 + n2] = 0.0f;
        fArray[8 + n2] = f10 * f7 + f12;
        fArray[9 + n2] = f13 * f7 - f11;
        fArray[10 + n2] = f5 * f5 * f7 + f6;
        fArray[11 + n2] = 0.0f;
        fArray[12 + n2] = 0.0f;
        fArray[13 + n2] = 0.0f;
        fArray[14 + n2] = 0.0f;
        fArray[15 + n2] = 1.0f;
        return fArray;
    }

    public static float[] makeRotationEuler(float[] fArray, int n2, float f2, float f3, float f4) {
        float f5 = FloatUtil.cos(f3);
        float f6 = FloatUtil.sin(f3);
        float f7 = FloatUtil.cos(f4);
        float f8 = FloatUtil.sin(f4);
        float f9 = FloatUtil.cos(f2);
        float f10 = FloatUtil.sin(f2);
        fArray[0 + n2] = f5 * f7;
        fArray[1 + n2] = f8;
        fArray[2 + n2] = -f6 * f7;
        fArray[3 + n2] = 0.0f;
        fArray[4 + n2] = f6 * f10 - f5 * f8 * f9;
        fArray[5 + n2] = f7 * f9;
        fArray[6 + n2] = f6 * f8 * f9 + f5 * f10;
        fArray[7 + n2] = 0.0f;
        fArray[8 + n2] = f5 * f8 * f10 + f6 * f9;
        fArray[9 + n2] = -f7 * f10;
        fArray[10 + n2] = -f6 * f8 * f10 + f5 * f9;
        fArray[11 + n2] = 0.0f;
        fArray[12 + n2] = 0.0f;
        fArray[13 + n2] = 0.0f;
        fArray[14 + n2] = 0.0f;
        fArray[15 + n2] = 1.0f;
        return fArray;
    }

    public static float[] makeOrtho(float[] fArray, int n2, boolean bl, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (bl) {
            fArray[n2 + 1 + 0] = 0.0f;
            fArray[n2 + 2 + 0] = 0.0f;
            fArray[n2 + 3 + 0] = 0.0f;
            fArray[n2 + 0 + 4] = 0.0f;
            fArray[n2 + 2 + 4] = 0.0f;
            fArray[n2 + 3 + 4] = 0.0f;
            fArray[n2 + 0 + 8] = 0.0f;
            fArray[n2 + 1 + 8] = 0.0f;
            fArray[n2 + 3 + 8] = 0.0f;
        }
        float f8 = f3 - f2;
        float f9 = f5 - f4;
        float f10 = f7 - f6;
        float f11 = -1.0f * (f3 + f2) / f8;
        float f12 = -1.0f * (f5 + f4) / f9;
        float f13 = -1.0f * (f7 + f6) / f10;
        fArray[n2 + 0 + 0] = 2.0f / f8;
        fArray[n2 + 1 + 4] = 2.0f / f9;
        fArray[n2 + 2 + 8] = -2.0f / f10;
        fArray[n2 + 0 + 12] = f11;
        fArray[n2 + 1 + 12] = f12;
        fArray[n2 + 2 + 12] = f13;
        fArray[n2 + 3 + 12] = 1.0f;
        return fArray;
    }

    public static float[] makeFrustum(float[] fArray, int n2, boolean bl, float f2, float f3, float f4, float f5, float f6, float f7) throws GLException {
        if (f6 <= 0.0f || f7 < 0.0f) {
            throw new GLException("GL_INVALID_VALUE: zNear and zFar must be positive, and zNear>0");
        }
        if (f2 == f3 || f5 == f4 || f6 == f7) {
            throw new GLException("GL_INVALID_VALUE: top,bottom and left,right and zNear,zFar must not be equal");
        }
        if (bl) {
            fArray[n2 + 1 + 0] = 0.0f;
            fArray[n2 + 2 + 0] = 0.0f;
            fArray[n2 + 3 + 0] = 0.0f;
            fArray[n2 + 0 + 4] = 0.0f;
            fArray[n2 + 2 + 4] = 0.0f;
            fArray[n2 + 3 + 4] = 0.0f;
            fArray[n2 + 0 + 12] = 0.0f;
            fArray[n2 + 1 + 12] = 0.0f;
        }
        float f8 = 2.0f * f6;
        float f9 = f3 - f2;
        float f10 = f5 - f4;
        float f11 = f7 - f6;
        float f12 = (f3 + f2) / f9;
        float f13 = (f5 + f4) / f10;
        float f14 = -1.0f * (f7 + f6) / f11;
        float f15 = -2.0f * (f7 * f6) / f11;
        fArray[n2 + 0 + 0] = f8 / f9;
        fArray[n2 + 1 + 4] = f8 / f10;
        fArray[n2 + 0 + 8] = f12;
        fArray[n2 + 1 + 8] = f13;
        fArray[n2 + 2 + 8] = f14;
        fArray[n2 + 3 + 8] = -1.0f;
        fArray[n2 + 2 + 12] = f15;
        fArray[n2 + 3 + 12] = 0.0f;
        return fArray;
    }

    public static float[] makePerspective(float[] fArray, int n2, boolean bl, float f2, float f3, float f4, float f5) throws GLException {
        float f6 = FloatUtil.tan(f2 / 2.0f) * f4;
        float f7 = -1.0f * f6;
        float f8 = f3 * f7;
        float f9 = f3 * f6;
        return FloatUtil.makeFrustum(fArray, n2, bl, f8, f9, f7, f6, f4, f5);
    }

    public static float[] makePerspective(float[] fArray, int n2, boolean bl, FovHVHalves fovHVHalves, float f2, float f3) throws GLException {
        FovHVHalves fovHVHalves2 = fovHVHalves.toTangents();
        float f4 = fovHVHalves2.top * f2;
        float f5 = -1.0f * fovHVHalves2.bottom * f2;
        float f6 = -1.0f * fovHVHalves2.left * f2;
        float f7 = fovHVHalves2.right * f2;
        return FloatUtil.makeFrustum(fArray, n2, bl, f6, f7, f5, f4, f2, f3);
    }

    public static float[] makeLookAt(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, float[] fArray4, int n5, float[] fArray5) {
        fArray5[0] = fArray3[0 + n4] - fArray2[0 + n3];
        fArray5[1] = fArray3[1 + n4] - fArray2[1 + n3];
        fArray5[2] = fArray3[2 + n4] - fArray2[2 + n3];
        VectorUtil.normalizeVec3(fArray5);
        VectorUtil.crossVec3(fArray5, 3, fArray5, 0, fArray4, n5);
        VectorUtil.normalizeVec3(fArray5, 3);
        VectorUtil.crossVec3(fArray5, 6, fArray5, 3, fArray5, 0);
        fArray[n2 + 0 + 0] = fArray5[3];
        fArray[n2 + 0 + 1] = fArray5[6];
        fArray[n2 + 0 + 2] = -fArray5[0];
        fArray[n2 + 0 + 3] = 0.0f;
        fArray[n2 + 4 + 0] = fArray5[4];
        fArray[n2 + 4 + 1] = fArray5[7];
        fArray[n2 + 4 + 2] = -fArray5[1];
        fArray[n2 + 4 + 3] = 0.0f;
        fArray[n2 + 8 + 0] = fArray5[5];
        fArray[n2 + 8 + 1] = fArray5[8];
        fArray[n2 + 8 + 2] = -fArray5[2];
        fArray[n2 + 8 + 3] = 0.0f;
        fArray[n2 + 12 + 0] = 0.0f;
        fArray[n2 + 12 + 1] = 0.0f;
        fArray[n2 + 12 + 2] = 0.0f;
        fArray[n2 + 12 + 3] = 1.0f;
        FloatUtil.makeTranslation(fArray5, true, -fArray2[0 + n3], -fArray2[1 + n3], -fArray2[2 + n3]);
        FloatUtil.multMatrix(fArray, n2, fArray5, 0);
        return fArray;
    }

    public static float[] makePick(float[] fArray, int n2, float f2, float f3, float f4, float f5, int[] nArray, int n3, float[] fArray2) {
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return null;
        }
        FloatUtil.makeTranslation(fArray, n2, true, ((float)nArray[2 + n3] - 2.0f * (f2 - (float)nArray[0 + n3])) / f4, ((float)nArray[3 + n3] - 2.0f * (f3 - (float)nArray[1 + n3])) / f5, 0.0f);
        FloatUtil.makeScale(fArray2, true, (float)nArray[2 + n3] / f4, (float)nArray[3 + n3] / f5, 1.0f);
        FloatUtil.multMatrix(fArray, n2, fArray2, 0);
        return fArray;
    }

    public static float[] transposeMatrix(float[] fArray, int n2, float[] fArray2, int n3) {
        fArray2[n3 + 0] = fArray[n2 + 0];
        fArray2[n3 + 1] = fArray[n2 + 4];
        fArray2[n3 + 2] = fArray[n2 + 8];
        fArray2[n3 + 3] = fArray[n2 + 12];
        fArray2[n3 + 0 + 4] = fArray[n2 + 1 + 0];
        fArray2[n3 + 1 + 4] = fArray[n2 + 1 + 4];
        fArray2[n3 + 2 + 4] = fArray[n2 + 1 + 8];
        fArray2[n3 + 3 + 4] = fArray[n2 + 1 + 12];
        fArray2[n3 + 0 + 8] = fArray[n2 + 2 + 0];
        fArray2[n3 + 1 + 8] = fArray[n2 + 2 + 4];
        fArray2[n3 + 2 + 8] = fArray[n2 + 2 + 8];
        fArray2[n3 + 3 + 8] = fArray[n2 + 2 + 12];
        fArray2[n3 + 0 + 12] = fArray[n2 + 3 + 0];
        fArray2[n3 + 1 + 12] = fArray[n2 + 3 + 4];
        fArray2[n3 + 2 + 12] = fArray[n2 + 3 + 8];
        fArray2[n3 + 3 + 12] = fArray[n2 + 3 + 12];
        return fArray2;
    }

    public static float[] transposeMatrix(float[] fArray, float[] fArray2) {
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[4];
        fArray2[2] = fArray[8];
        fArray2[3] = fArray[12];
        fArray2[4] = fArray[1];
        fArray2[5] = fArray[5];
        fArray2[6] = fArray[9];
        fArray2[7] = fArray[13];
        fArray2[8] = fArray[2];
        fArray2[9] = fArray[6];
        fArray2[10] = fArray[10];
        fArray2[11] = fArray[14];
        fArray2[12] = fArray[3];
        fArray2[13] = fArray[7];
        fArray2[14] = fArray[11];
        fArray2[15] = fArray[15];
        return fArray2;
    }

    public static float matrixDeterminant(float[] fArray, int n2) {
        float f2 = fArray[5 + n2];
        float f3 = fArray[6 + n2];
        float f4 = fArray[7 + n2];
        float f5 = fArray[9 + n2];
        float f6 = fArray[10 + n2];
        float f7 = fArray[11 + n2];
        float f8 = fArray[13 + n2];
        float f9 = fArray[14 + n2];
        float f10 = fArray[15 + n2];
        float f11 = 0.0f;
        f11 += fArray[0 + n2] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
        f2 = fArray[1 + n2];
        f3 = fArray[2 + n2];
        f4 = fArray[3 + n2];
        f11 -= fArray[4 + n2] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
        f5 = fArray[5 + n2];
        f6 = fArray[6 + n2];
        f7 = fArray[7 + n2];
        f11 += fArray[8 + n2] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
        f8 = fArray[9 + n2];
        f9 = fArray[10 + n2];
        f10 = fArray[11 + n2];
        return f11 -= fArray[12 + n2] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
    }

    public static float matrixDeterminant(float[] fArray) {
        float f2 = fArray[5];
        float f3 = fArray[6];
        float f4 = fArray[7];
        float f5 = fArray[9];
        float f6 = fArray[10];
        float f7 = fArray[11];
        float f8 = fArray[13];
        float f9 = fArray[14];
        float f10 = fArray[15];
        float f11 = 0.0f;
        f11 += fArray[0] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
        f2 = fArray[1];
        f3 = fArray[2];
        f4 = fArray[3];
        f11 -= fArray[4] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
        f5 = fArray[5];
        f6 = fArray[6];
        f7 = fArray[7];
        f11 += fArray[8] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
        f8 = fArray[9];
        f9 = fArray[10];
        f10 = fArray[11];
        return f11 -= fArray[12] * (f2 * (f6 * f10 - f9 * f7) - f5 * (f3 * f10 - f9 * f4) + f8 * (f3 * f7 - f6 * f4));
    }

    public static float[] invertMatrix(float[] fArray, int n2, float[] fArray2, int n3) {
        float f2;
        float f3 = Math.abs(fArray[0]);
        for (int i2 = 1; i2 < 16; ++i2) {
            f2 = Math.abs(fArray[i2]);
            if (!(f2 > f3)) continue;
            f3 = f2;
        }
        if (0.0f == f3) {
            return null;
        }
        float f4 = 1.0f / f3;
        f3 = fArray[0 + n2] * f4;
        float f5 = fArray[1 + n2] * f4;
        f2 = fArray[2 + n2] * f4;
        float f6 = fArray[3 + n2] * f4;
        float f7 = fArray[4 + n2] * f4;
        float f8 = fArray[5 + n2] * f4;
        float f9 = fArray[6 + n2] * f4;
        float f10 = fArray[7 + n2] * f4;
        float f11 = fArray[8 + n2] * f4;
        float f12 = fArray[9 + n2] * f4;
        float f13 = fArray[10 + n2] * f4;
        float f14 = fArray[11 + n2] * f4;
        float f15 = fArray[12 + n2] * f4;
        float f16 = fArray[13 + n2] * f4;
        float f17 = fArray[14 + n2] * f4;
        float f18 = fArray[15 + n2] * f4;
        float f19 = f8 * (f13 * f18 - f17 * f14) - f12 * (f9 * f18 - f17 * f10) + f16 * (f9 * f14 - f13 * f10);
        float f20 = -(f5 * (f13 * f18 - f17 * f14) - f12 * (f2 * f18 - f17 * f6) + f16 * (f2 * f14 - f13 * f6));
        float f21 = f5 * (f9 * f18 - f17 * f10) - f8 * (f2 * f18 - f17 * f6) + f16 * (f2 * f10 - f9 * f6);
        float f22 = -(f5 * (f9 * f14 - f13 * f10) - f8 * (f2 * f14 - f13 * f6) + f12 * (f2 * f10 - f9 * f6));
        float f23 = -(f7 * (f13 * f18 - f17 * f14) - f11 * (f9 * f18 - f17 * f10) + f15 * (f9 * f14 - f13 * f10));
        float f24 = f3 * (f13 * f18 - f17 * f14) - f11 * (f2 * f18 - f17 * f6) + f15 * (f2 * f14 - f13 * f6);
        float f25 = -(f3 * (f9 * f18 - f17 * f10) - f7 * (f2 * f18 - f17 * f6) + f15 * (f2 * f10 - f9 * f6));
        float f26 = f3 * (f9 * f14 - f13 * f10) - f7 * (f2 * f14 - f13 * f6) + f11 * (f2 * f10 - f9 * f6);
        float f27 = f7 * (f12 * f18 - f16 * f14) - f11 * (f8 * f18 - f16 * f10) + f15 * (f8 * f14 - f12 * f10);
        float f28 = -(f3 * (f12 * f18 - f16 * f14) - f11 * (f5 * f18 - f16 * f6) + f15 * (f5 * f14 - f12 * f6));
        float f29 = f3 * (f8 * f18 - f16 * f10) - f7 * (f5 * f18 - f16 * f6) + f15 * (f5 * f10 - f8 * f6);
        float f30 = -(f3 * (f8 * f14 - f12 * f10) - f7 * (f5 * f14 - f12 * f6) + f11 * (f5 * f10 - f8 * f6));
        float f31 = -(f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9));
        float f32 = f3 * (f12 * f17 - f16 * f13) - f11 * (f5 * f17 - f16 * f2) + f15 * (f5 * f13 - f12 * f2);
        float f33 = -(f3 * (f8 * f17 - f16 * f9) - f7 * (f5 * f17 - f16 * f2) + f15 * (f5 * f9 - f8 * f2));
        float f34 = f3 * (f8 * f13 - f12 * f9) - f7 * (f5 * f13 - f12 * f2) + f11 * (f5 * f9 - f8 * f2);
        float f35 = (f3 * f19 + f7 * f20 + f11 * f21 + f15 * f22) / f4;
        if (0.0f == f35) {
            return null;
        }
        fArray2[0 + n3] = f19 / f35;
        fArray2[1 + n3] = f20 / f35;
        fArray2[2 + n3] = f21 / f35;
        fArray2[3 + n3] = f22 / f35;
        fArray2[4 + n3] = f23 / f35;
        fArray2[5 + n3] = f24 / f35;
        fArray2[6 + n3] = f25 / f35;
        fArray2[7 + n3] = f26 / f35;
        fArray2[8 + n3] = f27 / f35;
        fArray2[9 + n3] = f28 / f35;
        fArray2[10 + n3] = f29 / f35;
        fArray2[11 + n3] = f30 / f35;
        fArray2[12 + n3] = f31 / f35;
        fArray2[13 + n3] = f32 / f35;
        fArray2[14 + n3] = f33 / f35;
        fArray2[15 + n3] = f34 / f35;
        return fArray2;
    }

    public static float[] invertMatrix(float[] fArray, float[] fArray2) {
        float f2;
        float f3 = Math.abs(fArray[0]);
        for (int i2 = 1; i2 < 16; ++i2) {
            f2 = Math.abs(fArray[i2]);
            if (!(f2 > f3)) continue;
            f3 = f2;
        }
        if (0.0f == f3) {
            return null;
        }
        float f4 = 1.0f / f3;
        f3 = fArray[0] * f4;
        float f5 = fArray[1] * f4;
        f2 = fArray[2] * f4;
        float f6 = fArray[3] * f4;
        float f7 = fArray[4] * f4;
        float f8 = fArray[5] * f4;
        float f9 = fArray[6] * f4;
        float f10 = fArray[7] * f4;
        float f11 = fArray[8] * f4;
        float f12 = fArray[9] * f4;
        float f13 = fArray[10] * f4;
        float f14 = fArray[11] * f4;
        float f15 = fArray[12] * f4;
        float f16 = fArray[13] * f4;
        float f17 = fArray[14] * f4;
        float f18 = fArray[15] * f4;
        float f19 = f8 * (f13 * f18 - f17 * f14) - f12 * (f9 * f18 - f17 * f10) + f16 * (f9 * f14 - f13 * f10);
        float f20 = -(f5 * (f13 * f18 - f17 * f14) - f12 * (f2 * f18 - f17 * f6) + f16 * (f2 * f14 - f13 * f6));
        float f21 = f5 * (f9 * f18 - f17 * f10) - f8 * (f2 * f18 - f17 * f6) + f16 * (f2 * f10 - f9 * f6);
        float f22 = -(f5 * (f9 * f14 - f13 * f10) - f8 * (f2 * f14 - f13 * f6) + f12 * (f2 * f10 - f9 * f6));
        float f23 = -(f7 * (f13 * f18 - f17 * f14) - f11 * (f9 * f18 - f17 * f10) + f15 * (f9 * f14 - f13 * f10));
        float f24 = f3 * (f13 * f18 - f17 * f14) - f11 * (f2 * f18 - f17 * f6) + f15 * (f2 * f14 - f13 * f6);
        float f25 = -(f3 * (f9 * f18 - f17 * f10) - f7 * (f2 * f18 - f17 * f6) + f15 * (f2 * f10 - f9 * f6));
        float f26 = f3 * (f9 * f14 - f13 * f10) - f7 * (f2 * f14 - f13 * f6) + f11 * (f2 * f10 - f9 * f6);
        float f27 = f7 * (f12 * f18 - f16 * f14) - f11 * (f8 * f18 - f16 * f10) + f15 * (f8 * f14 - f12 * f10);
        float f28 = -(f3 * (f12 * f18 - f16 * f14) - f11 * (f5 * f18 - f16 * f6) + f15 * (f5 * f14 - f12 * f6));
        float f29 = f3 * (f8 * f18 - f16 * f10) - f7 * (f5 * f18 - f16 * f6) + f15 * (f5 * f10 - f8 * f6);
        float f30 = -(f3 * (f8 * f14 - f12 * f10) - f7 * (f5 * f14 - f12 * f6) + f11 * (f5 * f10 - f8 * f6));
        float f31 = -(f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9));
        float f32 = f3 * (f12 * f17 - f16 * f13) - f11 * (f5 * f17 - f16 * f2) + f15 * (f5 * f13 - f12 * f2);
        float f33 = -(f3 * (f8 * f17 - f16 * f9) - f7 * (f5 * f17 - f16 * f2) + f15 * (f5 * f9 - f8 * f2));
        float f34 = f3 * (f8 * f13 - f12 * f9) - f7 * (f5 * f13 - f12 * f2) + f11 * (f5 * f9 - f8 * f2);
        float f35 = (f3 * f19 + f7 * f20 + f11 * f21 + f15 * f22) / f4;
        if (0.0f == f35) {
            return null;
        }
        fArray2[0] = f19 / f35;
        fArray2[1] = f20 / f35;
        fArray2[2] = f21 / f35;
        fArray2[3] = f22 / f35;
        fArray2[4] = f23 / f35;
        fArray2[5] = f24 / f35;
        fArray2[6] = f25 / f35;
        fArray2[7] = f26 / f35;
        fArray2[8] = f27 / f35;
        fArray2[9] = f28 / f35;
        fArray2[10] = f29 / f35;
        fArray2[11] = f30 / f35;
        fArray2[12] = f31 / f35;
        fArray2[13] = f32 / f35;
        fArray2[14] = f33 / f35;
        fArray2[15] = f34 / f35;
        return fArray2;
    }

    public static boolean mapObjToWinCoords(float f2, float f3, float f4, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, float[] fArray3, int n5, float[] fArray4, float[] fArray5) {
        fArray4[0] = f2;
        fArray4[1] = f3;
        fArray4[2] = f4;
        fArray4[3] = 1.0f;
        FloatUtil.multMatrixVec(fArray, n2, fArray4, 0, fArray5, 0);
        FloatUtil.multMatrixVec(fArray2, n3, fArray5, 0, fArray4, 0);
        if (fArray4[3] == 0.0f) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3] * 0.5f;
        fArray4[0] = fArray4[0] * fArray4[3] + 0.5f;
        fArray4[1] = fArray4[1] * fArray4[3] + 0.5f;
        fArray4[2] = fArray4[2] * fArray4[3] + 0.5f;
        fArray3[0 + n5] = fArray4[0] * (float)nArray[2 + n4] + (float)nArray[0 + n4];
        fArray3[1 + n5] = fArray4[1] * (float)nArray[3 + n4] + (float)nArray[1 + n4];
        fArray3[2 + n5] = fArray4[2];
        return true;
    }

    public static boolean mapObjToWinCoords(float f2, float f3, float f4, float[] fArray, int[] nArray, int n2, float[] fArray2, int n3, float[] fArray3, float[] fArray4) {
        fArray4[0] = f2;
        fArray4[1] = f3;
        fArray4[2] = f4;
        fArray4[3] = 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray4, fArray3);
        if (fArray3[3] == 0.0f) {
            return false;
        }
        fArray3[3] = 1.0f / fArray3[3] * 0.5f;
        fArray3[0] = fArray3[0] * fArray3[3] + 0.5f;
        fArray3[1] = fArray3[1] * fArray3[3] + 0.5f;
        fArray3[2] = fArray3[2] * fArray3[3] + 0.5f;
        fArray2[0 + n3] = fArray3[0] * (float)nArray[2 + n2] + (float)nArray[0 + n2];
        fArray2[1 + n3] = fArray3[1] * (float)nArray[3 + n2] + (float)nArray[1 + n2];
        fArray2[2 + n3] = fArray3[2];
        return true;
    }

    public static boolean mapWinToObjCoords(float f2, float f3, float f4, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, float[] fArray3, int n5, float[] fArray4, float[] fArray5) {
        FloatUtil.multMatrix(fArray2, n3, fArray, n2, fArray4, 0);
        if (null == FloatUtil.invertMatrix(fArray4, fArray4)) {
            return false;
        }
        fArray5[0] = f2;
        fArray5[1] = f3;
        fArray5[2] = f4;
        fArray5[3] = 1.0f;
        fArray5[0] = (fArray5[0] - (float)nArray[0 + n4]) / (float)nArray[2 + n4];
        fArray5[1] = (fArray5[1] - (float)nArray[1 + n4]) / (float)nArray[3 + n4];
        fArray5[0] = fArray5[0] * 2.0f - 1.0f;
        fArray5[1] = fArray5[1] * 2.0f - 1.0f;
        fArray5[2] = fArray5[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray4, 0, fArray5, 0, fArray5, 4);
        if ((double)fArray5[7] == 0.0) {
            return false;
        }
        fArray5[7] = 1.0f / fArray5[7];
        fArray3[0 + n5] = fArray5[4] * fArray5[7];
        fArray3[1 + n5] = fArray5[5] * fArray5[7];
        fArray3[2 + n5] = fArray5[6] * fArray5[7];
        return true;
    }

    public static boolean mapWinToObjCoords(float f2, float f3, float f4, float[] fArray, int[] nArray, int n2, float[] fArray2, int n3, float[] fArray3, float[] fArray4) {
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray3[3] = 1.0f;
        fArray3[0] = (fArray3[0] - (float)nArray[0 + n2]) / (float)nArray[2 + n2];
        fArray3[1] = (fArray3[1] - (float)nArray[1 + n2]) / (float)nArray[3 + n2];
        fArray3[0] = fArray3[0] * 2.0f - 1.0f;
        fArray3[1] = fArray3[1] * 2.0f - 1.0f;
        fArray3[2] = fArray3[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray3, fArray4);
        if ((double)fArray4[3] == 0.0) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3];
        fArray2[0 + n3] = fArray4[0] * fArray4[3];
        fArray2[1 + n3] = fArray4[1] * fArray4[3];
        fArray2[2 + n3] = fArray4[2] * fArray4[3];
        return true;
    }

    public static boolean mapWinToObjCoords(float f2, float f3, float f4, float f5, float[] fArray, int[] nArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, float[] fArray4, float[] fArray5) {
        fArray4[0] = f2;
        fArray4[1] = f3;
        fArray4[3] = 1.0f;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n2]) / (float)nArray[2 + n2];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n2]) / (float)nArray[3 + n2];
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = f4;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray2[0 + n3] = fArray5[0] * fArray5[3];
        fArray2[1 + n3] = fArray5[1] * fArray5[3];
        fArray2[2 + n3] = fArray5[2] * fArray5[3];
        fArray4[2] = f5;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray3[0 + n4] = fArray5[0] * fArray5[3];
        fArray3[1 + n4] = fArray5[1] * fArray5[3];
        fArray3[2 + n4] = fArray5[2] * fArray5[3];
        return true;
    }

    public static boolean mapWinToObjCoords(float f2, float f3, float f4, float f5, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, float f6, float f7, float[] fArray3, int n5, float[] fArray4, float[] fArray5) {
        FloatUtil.multMatrix(fArray2, n3, fArray, n2, fArray4, 0);
        if (null == FloatUtil.invertMatrix(fArray4, fArray4)) {
            return false;
        }
        fArray5[0] = f2;
        fArray5[1] = f3;
        fArray5[2] = f4;
        fArray5[3] = 1.0f;
        fArray5[0] = (fArray5[0] - (float)nArray[0 + n4]) / (float)nArray[2 + n4];
        fArray5[1] = (fArray5[1] - (float)nArray[1 + n4]) / (float)nArray[3 + n4];
        fArray5[2] = (fArray5[2] - f6) / (f7 - f6);
        fArray5[0] = fArray5[0] * 2.0f - 1.0f;
        fArray5[1] = fArray5[1] * 2.0f - 1.0f;
        fArray5[2] = fArray5[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(fArray4, 0, fArray5, 0, fArray5, 4);
        if ((double)fArray5[7] == 0.0) {
            return false;
        }
        fArray5[7] = 1.0f / fArray5[7];
        fArray3[0 + n5] = fArray5[4];
        fArray3[1 + n5] = fArray5[5];
        fArray3[2 + n5] = fArray5[6];
        fArray3[3 + n5] = fArray5[7];
        return true;
    }

    public static boolean mapWinToRay(float f2, float f3, float f4, float f5, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, Ray ray, float[] fArray3, float[] fArray4, float[] fArray5) {
        FloatUtil.multMatrix(fArray2, n3, fArray, n2, fArray3, 0);
        if (null == FloatUtil.invertMatrix(fArray3, fArray3)) {
            return false;
        }
        if (FloatUtil.mapWinToObjCoords(f2, f3, f4, f5, fArray3, nArray, n4, ray.orig, 0, ray.dir, 0, fArray4, fArray5)) {
            VectorUtil.normalizeVec3(VectorUtil.subVec3(ray.dir, ray.dir, ray.orig));
            return true;
        }
        return false;
    }

    public static float[] multMatrix(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        float f2 = fArray2[n3 + 0 + 0];
        float f3 = fArray2[n3 + 1 + 0];
        float f4 = fArray2[n3 + 2 + 0];
        float f5 = fArray2[n3 + 3 + 0];
        float f6 = fArray2[n3 + 0 + 4];
        float f7 = fArray2[n3 + 1 + 4];
        float f8 = fArray2[n3 + 2 + 4];
        float f9 = fArray2[n3 + 3 + 4];
        float f10 = fArray2[n3 + 0 + 8];
        float f11 = fArray2[n3 + 1 + 8];
        float f12 = fArray2[n3 + 2 + 8];
        float f13 = fArray2[n3 + 3 + 8];
        float f14 = fArray2[n3 + 0 + 12];
        float f15 = fArray2[n3 + 1 + 12];
        float f16 = fArray2[n3 + 2 + 12];
        float f17 = fArray2[n3 + 3 + 12];
        float f18 = fArray[n2 + 0];
        float f19 = fArray[n2 + 4];
        float f20 = fArray[n2 + 8];
        float f21 = fArray[n2 + 12];
        fArray3[n4 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[n4 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[n4 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[n4 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[n2 + 1 + 0];
        f19 = fArray[n2 + 1 + 4];
        f20 = fArray[n2 + 1 + 8];
        f21 = fArray[n2 + 1 + 12];
        fArray3[n4 + 1 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[n4 + 1 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[n4 + 1 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[n4 + 1 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[n2 + 2 + 0];
        f19 = fArray[n2 + 2 + 4];
        f20 = fArray[n2 + 2 + 8];
        f21 = fArray[n2 + 2 + 12];
        fArray3[n4 + 2 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[n4 + 2 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[n4 + 2 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[n4 + 2 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[n2 + 3 + 0];
        f19 = fArray[n2 + 3 + 4];
        f20 = fArray[n2 + 3 + 8];
        f21 = fArray[n2 + 3 + 12];
        fArray3[n4 + 3 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[n4 + 3 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[n4 + 3 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[n4 + 3 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        return fArray3;
    }

    public static float[] multMatrix(float[] fArray, float[] fArray2, float[] fArray3) {
        float f2 = fArray2[0];
        float f3 = fArray2[1];
        float f4 = fArray2[2];
        float f5 = fArray2[3];
        float f6 = fArray2[4];
        float f7 = fArray2[5];
        float f8 = fArray2[6];
        float f9 = fArray2[7];
        float f10 = fArray2[8];
        float f11 = fArray2[9];
        float f12 = fArray2[10];
        float f13 = fArray2[11];
        float f14 = fArray2[12];
        float f15 = fArray2[13];
        float f16 = fArray2[14];
        float f17 = fArray2[15];
        float f18 = fArray[0];
        float f19 = fArray[4];
        float f20 = fArray[8];
        float f21 = fArray[12];
        fArray3[0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[1];
        f19 = fArray[5];
        f20 = fArray[9];
        f21 = fArray[13];
        fArray3[1] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[5] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[9] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[13] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[2];
        f19 = fArray[6];
        f20 = fArray[10];
        f21 = fArray[14];
        fArray3[2] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[6] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[10] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[14] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[3];
        f19 = fArray[7];
        f20 = fArray[11];
        f21 = fArray[15];
        fArray3[3] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray3[7] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray3[11] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray3[15] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        return fArray3;
    }

    public static float[] multMatrix(float[] fArray, int n2, float[] fArray2, int n3) {
        float f2 = fArray2[n3 + 0 + 0];
        float f3 = fArray2[n3 + 1 + 0];
        float f4 = fArray2[n3 + 2 + 0];
        float f5 = fArray2[n3 + 3 + 0];
        float f6 = fArray2[n3 + 0 + 4];
        float f7 = fArray2[n3 + 1 + 4];
        float f8 = fArray2[n3 + 2 + 4];
        float f9 = fArray2[n3 + 3 + 4];
        float f10 = fArray2[n3 + 0 + 8];
        float f11 = fArray2[n3 + 1 + 8];
        float f12 = fArray2[n3 + 2 + 8];
        float f13 = fArray2[n3 + 3 + 8];
        float f14 = fArray2[n3 + 0 + 12];
        float f15 = fArray2[n3 + 1 + 12];
        float f16 = fArray2[n3 + 2 + 12];
        float f17 = fArray2[n3 + 3 + 12];
        float f18 = fArray[n2 + 0];
        float f19 = fArray[n2 + 4];
        float f20 = fArray[n2 + 8];
        float f21 = fArray[n2 + 12];
        fArray[n2 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[n2 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[n2 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[n2 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[n2 + 1 + 0];
        f19 = fArray[n2 + 1 + 4];
        f20 = fArray[n2 + 1 + 8];
        f21 = fArray[n2 + 1 + 12];
        fArray[n2 + 1 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[n2 + 1 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[n2 + 1 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[n2 + 1 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[n2 + 2 + 0];
        f19 = fArray[n2 + 2 + 4];
        f20 = fArray[n2 + 2 + 8];
        f21 = fArray[n2 + 2 + 12];
        fArray[n2 + 2 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[n2 + 2 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[n2 + 2 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[n2 + 2 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[n2 + 3 + 0];
        f19 = fArray[n2 + 3 + 4];
        f20 = fArray[n2 + 3 + 8];
        f21 = fArray[n2 + 3 + 12];
        fArray[n2 + 3 + 0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[n2 + 3 + 4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[n2 + 3 + 8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[n2 + 3 + 12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        return fArray;
    }

    public static float[] multMatrix(float[] fArray, float[] fArray2) {
        float f2 = fArray2[0];
        float f3 = fArray2[1];
        float f4 = fArray2[2];
        float f5 = fArray2[3];
        float f6 = fArray2[4];
        float f7 = fArray2[5];
        float f8 = fArray2[6];
        float f9 = fArray2[7];
        float f10 = fArray2[8];
        float f11 = fArray2[9];
        float f12 = fArray2[10];
        float f13 = fArray2[11];
        float f14 = fArray2[12];
        float f15 = fArray2[13];
        float f16 = fArray2[14];
        float f17 = fArray2[15];
        float f18 = fArray[0];
        float f19 = fArray[4];
        float f20 = fArray[8];
        float f21 = fArray[12];
        fArray[0] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[4] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[8] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[12] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[1];
        f19 = fArray[5];
        f20 = fArray[9];
        f21 = fArray[13];
        fArray[1] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[5] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[9] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[13] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[2];
        f19 = fArray[6];
        f20 = fArray[10];
        f21 = fArray[14];
        fArray[2] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[6] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[10] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[14] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        f18 = fArray[3];
        f19 = fArray[7];
        f20 = fArray[11];
        f21 = fArray[15];
        fArray[3] = f18 * f2 + f19 * f3 + f20 * f4 + f21 * f5;
        fArray[7] = f18 * f6 + f19 * f7 + f20 * f8 + f21 * f9;
        fArray[11] = f18 * f10 + f19 * f11 + f20 * f12 + f21 * f13;
        fArray[15] = f18 * f14 + f19 * f15 + f20 * f16 + f21 * f17;
        return fArray;
    }

    public static void multMatrix(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, float[] fArray) {
        int n2 = floatBuffer.position();
        int n3 = floatBuffer2.position();
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = n2 + i2;
            float f2 = floatBuffer.get(n4 + 0);
            float f3 = floatBuffer.get(n4 + 4);
            float f4 = floatBuffer.get(n4 + 8);
            float f5 = floatBuffer.get(n4 + 12);
            fArray[i2 + 0] = f2 * floatBuffer2.get(n3 + 0 + 0) + f3 * floatBuffer2.get(n3 + 1 + 0) + f4 * floatBuffer2.get(n3 + 2 + 0) + f5 * floatBuffer2.get(n3 + 3 + 0);
            fArray[i2 + 4] = f2 * floatBuffer2.get(n3 + 0 + 4) + f3 * floatBuffer2.get(n3 + 1 + 4) + f4 * floatBuffer2.get(n3 + 2 + 4) + f5 * floatBuffer2.get(n3 + 3 + 4);
            fArray[i2 + 8] = f2 * floatBuffer2.get(n3 + 0 + 8) + f3 * floatBuffer2.get(n3 + 1 + 8) + f4 * floatBuffer2.get(n3 + 2 + 8) + f5 * floatBuffer2.get(n3 + 3 + 8);
            fArray[i2 + 12] = f2 * floatBuffer2.get(n3 + 0 + 12) + f3 * floatBuffer2.get(n3 + 1 + 12) + f4 * floatBuffer2.get(n3 + 2 + 12) + f5 * floatBuffer2.get(n3 + 3 + 12);
        }
    }

    public static void multMatrix(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n2 = floatBuffer.position();
        int n3 = floatBuffer2.position();
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = n2 + i2;
            float f2 = floatBuffer.get(n4 + 0);
            float f3 = floatBuffer.get(n4 + 4);
            float f4 = floatBuffer.get(n4 + 8);
            float f5 = floatBuffer.get(n4 + 12);
            floatBuffer.put(n4 + 0, f2 * floatBuffer2.get(n3 + 0 + 0) + f3 * floatBuffer2.get(n3 + 1 + 0) + f4 * floatBuffer2.get(n3 + 2 + 0) + f5 * floatBuffer2.get(n3 + 3 + 0));
            floatBuffer.put(n4 + 4, f2 * floatBuffer2.get(n3 + 0 + 4) + f3 * floatBuffer2.get(n3 + 1 + 4) + f4 * floatBuffer2.get(n3 + 2 + 4) + f5 * floatBuffer2.get(n3 + 3 + 4));
            floatBuffer.put(n4 + 8, f2 * floatBuffer2.get(n3 + 0 + 8) + f3 * floatBuffer2.get(n3 + 1 + 8) + f4 * floatBuffer2.get(n3 + 2 + 8) + f5 * floatBuffer2.get(n3 + 3 + 8));
            floatBuffer.put(n4 + 12, f2 * floatBuffer2.get(n3 + 0 + 12) + f3 * floatBuffer2.get(n3 + 1 + 12) + f4 * floatBuffer2.get(n3 + 2 + 12) + f5 * floatBuffer2.get(n3 + 3 + 12));
        }
    }

    public static float[] multMatrixVec(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        fArray3[0 + n4] = fArray2[0 + n3] * fArray[0 + n2] + fArray2[1 + n3] * fArray[4 + n2] + fArray2[2 + n3] * fArray[8 + n2] + fArray2[3 + n3] * fArray[12 + n2];
        int n5 = 1 + n2;
        fArray3[1 + n4] = fArray2[0 + n3] * fArray[0 + n5] + fArray2[1 + n3] * fArray[4 + n5] + fArray2[2 + n3] * fArray[8 + n5] + fArray2[3 + n3] * fArray[12 + n5];
        int n6 = 2 + n2;
        fArray3[2 + n4] = fArray2[0 + n3] * fArray[0 + n6] + fArray2[1 + n3] * fArray[4 + n6] + fArray2[2 + n3] * fArray[8 + n6] + fArray2[3 + n3] * fArray[12 + n6];
        int n7 = 3 + n2;
        fArray3[3 + n4] = fArray2[0 + n3] * fArray[0 + n7] + fArray2[1 + n3] * fArray[4 + n7] + fArray2[2 + n3] * fArray[8 + n7] + fArray2[3 + n3] * fArray[12 + n7];
        return fArray3;
    }

    public static float[] multMatrixVec(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray2[0] * fArray[0] + fArray2[1] * fArray[4] + fArray2[2] * fArray[8] + fArray2[3] * fArray[12];
        fArray3[1] = fArray2[0] * fArray[1] + fArray2[1] * fArray[5] + fArray2[2] * fArray[9] + fArray2[3] * fArray[13];
        fArray3[2] = fArray2[0] * fArray[2] + fArray2[1] * fArray[6] + fArray2[2] * fArray[10] + fArray2[3] * fArray[14];
        fArray3[3] = fArray2[0] * fArray[3] + fArray2[1] * fArray[7] + fArray2[2] * fArray[11] + fArray2[3] * fArray[15];
        return fArray3;
    }

    public static void multMatrixVec(FloatBuffer floatBuffer, float[] fArray, float[] fArray2) {
        int n2 = floatBuffer.position();
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = i2 + n2;
            fArray2[i2] = fArray[0] * floatBuffer.get(0 + n3) + fArray[1] * floatBuffer.get(4 + n3) + fArray[2] * floatBuffer.get(8 + n3) + fArray[3] * floatBuffer.get(12 + n3);
        }
    }

    public static float[] copyMatrixColumn(float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        fArray2[0 + n4] = fArray[0 + n3 * 4 + n2];
        fArray2[1 + n4] = fArray[1 + n3 * 4 + n2];
        fArray2[2 + n4] = fArray[2 + n3 * 4 + n2];
        if (fArray2.length > 3 + n4) {
            fArray2[3 + n4] = fArray[3 + n3 * 4 + n2];
        }
        return fArray2;
    }

    public static float[] copyMatrixRow(float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        fArray2[0 + n4] = fArray[n3 + 0 + n2];
        fArray2[1 + n4] = fArray[n3 + 4 + n2];
        fArray2[2 + n4] = fArray[n3 + 8 + n2];
        if (fArray2.length > 3 + n4) {
            fArray2[3 + n4] = fArray[n3 + 12 + n2];
        }
        return fArray2;
    }

    public static StringBuilder matrixRowToString(StringBuilder stringBuilder, String string, FloatBuffer floatBuffer, int n2, int n3, int n4, boolean bl, int n5) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        int n6 = n2 + floatBuffer.position();
        if (bl) {
            for (int i2 = 0; i2 < n4; ++i2) {
                stringBuilder.append(String.format(string + " ", Float.valueOf(floatBuffer.get(n6 + n5 * n4 + i2))));
            }
        } else {
            for (int i3 = 0; i3 < n4; ++i3) {
                stringBuilder.append(String.format(string + " ", Float.valueOf(floatBuffer.get(n6 + n5 + i3 * n3))));
            }
        }
        return stringBuilder;
    }

    public static StringBuilder matrixRowToString(StringBuilder stringBuilder, String string, float[] fArray, int n2, int n3, int n4, boolean bl, int n5) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (bl) {
            for (int i2 = 0; i2 < n4; ++i2) {
                stringBuilder.append(String.format(string + " ", Float.valueOf(fArray[n2 + n5 * n4 + i2])));
            }
        } else {
            for (int i3 = 0; i3 < n4; ++i3) {
                stringBuilder.append(String.format(string + " ", Float.valueOf(fArray[n2 + n5 + i3 * n3])));
            }
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, String string2, FloatBuffer floatBuffer, int n2, int n3, int n4, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string3 = null == string ? "" : string;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(string3).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string2, floatBuffer, n2, n3, n4, bl, i2);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, String string2, float[] fArray, int n2, int n3, int n4, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string3 = null == string ? "" : string;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(string3).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string2, fArray, n2, n3, n4, bl, i2);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, String string2, FloatBuffer floatBuffer, int n2, FloatBuffer floatBuffer2, int n3, int n4, int n5, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string3 = null == string ? "" : string;
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuilder.append(string3).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string2, floatBuffer, n2, n4, n5, bl, i2);
            stringBuilder.append("=?= ");
            FloatUtil.matrixRowToString(stringBuilder, string2, floatBuffer2, n3, n4, n5, bl, i2);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    public static StringBuilder matrixToString(StringBuilder stringBuilder, String string, String string2, float[] fArray, int n2, float[] fArray2, int n3, int n4, int n5, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string3 = null == string ? "" : string;
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuilder.append(string3).append("[ ");
            FloatUtil.matrixRowToString(stringBuilder, string2, fArray, n2, n4, n5, bl, i2);
            stringBuilder.append("=?= ");
            FloatUtil.matrixRowToString(stringBuilder, string2, fArray2, n3, n4, n5, bl, i2);
            stringBuilder.append("]").append(Platform.getNewline());
        }
        return stringBuilder;
    }

    private static void calculateMachineEpsilonFloat() {
        float f2 = 1.0f;
        int n2 = 0;
        do {
            ++n2;
        } while (1.0f + (f2 /= 2.0f) / 2.0f != 1.0f);
        machEpsilon = f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float getMachineEpsilon() {
        if (machEpsilonAvail) return machEpsilon;
        Class<FloatUtil> clazz = FloatUtil.class;
        synchronized (FloatUtil.class) {
            if (machEpsilonAvail) return machEpsilon;
            machEpsilonAvail = true;
            FloatUtil.calculateMachineEpsilonFloat();
            // ** MonitorExit[var0] (shouldn't be in output)
            return machEpsilon;
        }
    }

    public static boolean isEqual(float f2, float f3) {
        return Float.floatToIntBits(f2) == Float.floatToIntBits(f3);
    }

    public static boolean isEqual(float f2, float f3, float f4) {
        if (Math.abs(f2 - f3) < f4) {
            return true;
        }
        return Float.floatToIntBits(f2) == Float.floatToIntBits(f3);
    }

    public static int compare(float f2, float f3) {
        int n2;
        if (f2 < f3) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        int n3 = Float.floatToIntBits(f2);
        if (n3 == (n2 = Float.floatToIntBits(f3))) {
            return 0;
        }
        if (n3 < n2) {
            return -1;
        }
        return 1;
    }

    public static int compare(float f2, float f3, float f4) {
        if (Math.abs(f2 - f3) < f4) {
            return 0;
        }
        return FloatUtil.compare(f2, f3);
    }

    public static boolean isZero(float f2, float f3) {
        return Math.abs(f2) < f3;
    }

    public static float abs(float f2) {
        return Math.abs(f2);
    }

    public static float pow(float f2, float f3) {
        return (float)Math.pow(f2, f3);
    }

    public static float sin(float f2) {
        return (float)Math.sin(f2);
    }

    public static float asin(float f2) {
        return (float)Math.asin(f2);
    }

    public static float cos(float f2) {
        return (float)Math.cos(f2);
    }

    public static float acos(float f2) {
        return (float)Math.acos(f2);
    }

    public static float tan(float f2) {
        return (float)Math.tan(f2);
    }

    public static float atan(float f2) {
        return (float)Math.atan(f2);
    }

    public static float atan2(float f2, float f3) {
        return (float)Math.atan2(f2, f3);
    }

    public static float sqrt(float f2) {
        return (float)Math.sqrt(f2);
    }

    public static float getZBufferEpsilon(int n2, float f2, float f3) {
        return f2 * f2 / (f3 * (float)(1 << n2) - f2);
    }

    public static int getZBufferValue(int n2, float f2, float f3, float f4) {
        float f5 = f4 / (f4 - f3);
        float f6 = f4 * f3 / (f3 - f4);
        return (int)((float)(1 << n2) * (f5 + f6 / f2));
    }

    public static float getOrthoWinZ(float f2, float f3, float f4) {
        return (1.0f / f3 - 1.0f / f2) / (1.0f / f3 - 1.0f / f4);
    }
}

