/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;

public final class FovHVHalves {
    public final float left;
    public final float right;
    public final float top;
    public final float bottom;
    public final boolean inTangents;

    public FovHVHalves(float f2, float f3, float f4, float f5, boolean bl) {
        this.left = f2;
        this.right = f3;
        this.top = f4;
        this.bottom = f5;
        this.inTangents = bl;
    }

    public static FovHVHalves byRadians(float f2, float f3) {
        float f4 = FloatUtil.tan(f2 / 2.0f);
        float f5 = FloatUtil.tan(f3 / 2.0f);
        return new FovHVHalves(f4, f4, f5, f5, true);
    }

    public static FovHVHalves byFovyRadianAndAspect(float f2, float f3) {
        float f4 = FloatUtil.tan(f2 / 2.0f);
        float f5 = f3 * f4;
        return new FovHVHalves(f5, f5, f4, f4, true);
    }

    public static FovHVHalves byRadians(float f2, float f3, float f4, float f5) {
        return new FovHVHalves(FloatUtil.tan(f2 * f3), FloatUtil.tan(f2 * (1.0f - f3)), FloatUtil.tan(f4 * f5), FloatUtil.tan(f4 * (1.0f - f5)), true);
    }

    public static FovHVHalves byFovyRadianAndAspect(float f2, float f3, float f4, float f5) {
        float f6 = FloatUtil.tan(f2 / 2.0f);
        float f7 = f4 * f6;
        float f8 = FloatUtil.atan(f7) * 2.0f;
        return FovHVHalves.byRadians(f8, f5, f2, f3);
    }

    public final FovHVHalves toTangents() {
        if (this.inTangents) {
            return this;
        }
        return new FovHVHalves(FloatUtil.tan(this.left), FloatUtil.tan(this.right), FloatUtil.tan(this.top), FloatUtil.tan(this.bottom), true);
    }

    public final float horzFov() {
        return this.left + this.right;
    }

    public final float vertFov() {
        return this.top + this.bottom;
    }

    public final String toString() {
        return "FovHVH[" + (this.inTangents ? "tangents" : "radians") + ": " + this.left + " l, " + this.right + " r, " + this.top + " t, " + this.bottom + " b]";
    }

    public final String toStringInDegrees() {
        String string;
        String string2 = string = this.inTangents ? "tangents" : "radians";
        if (this.inTangents) {
            float f2 = FloatUtil.atan(this.left);
            float f3 = FloatUtil.atan(this.right);
            float f4 = FloatUtil.atan(this.top);
            float f5 = FloatUtil.atan(this.bottom);
            return "FovHVH[degrees: " + f2 * 57.295776f + " l, " + f3 * 57.295776f + " r, " + f4 * 57.295776f + " t, " + f5 * 57.295776f + " b, stored-as: " + string + "]";
        }
        return "FovHVH[degrees: " + this.left * 57.295776f + " l, " + this.right * 57.295776f + " r, " + this.top * 57.295776f + " t, " + this.bottom * 57.295776f + " b, stored-as: " + string + "]";
    }
}

