/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math.geom;

import com.jogamp.opengl.math.geom.AABBox;
import jogamp.common.os.PlatformPropsImpl;

public class Frustum {
    protected final Plane[] planes = new Plane[6];
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;
    public static final int NEAR = 4;
    public static final int FAR = 5;

    public Frustum() {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.planes[i2] = new Plane();
        }
    }

    public final Plane[] getPlanes() {
        return this.planes;
    }

    public final void updateByPlanes(Plane[] planeArray) {
        for (int i2 = 0; i2 < 6; ++i2) {
            Plane plane = this.planes[i2];
            float[] fArray = plane.n;
            Plane plane2 = planeArray[i2];
            float[] fArray2 = plane2.n;
            fArray[0] = fArray2[0];
            fArray[1] = fArray2[1];
            fArray[2] = fArray2[2];
            plane.d = plane2.d;
        }
    }

    public void updateByPMV(float[] fArray, int n2) {
        Plane plane = this.planes[0];
        Object object = plane.n;
        object[0] = fArray[n2 + 3 + 0] + fArray[n2 + 0 + 0];
        object[1] = fArray[n2 + 3 + 4] + fArray[n2 + 0 + 4];
        object[2] = fArray[n2 + 3 + 8] + fArray[n2 + 0 + 8];
        plane.d = fArray[n2 + 3 + 12] + fArray[n2 + 0 + 12];
        plane = this.planes[1];
        object = plane.n;
        object[0] = fArray[n2 + 3 + 0] - fArray[n2 + 0 + 0];
        object[1] = fArray[n2 + 3 + 4] - fArray[n2 + 0 + 4];
        object[2] = fArray[n2 + 3 + 8] - fArray[n2 + 0 + 8];
        plane.d = fArray[n2 + 3 + 12] - fArray[n2 + 0 + 12];
        plane = this.planes[2];
        object = plane.n;
        object[0] = fArray[n2 + 3 + 0] + fArray[n2 + 1 + 0];
        object[1] = fArray[n2 + 3 + 4] + fArray[n2 + 1 + 4];
        object[2] = fArray[n2 + 3 + 8] + fArray[n2 + 1 + 8];
        plane.d = fArray[n2 + 3 + 12] + fArray[n2 + 1 + 12];
        plane = this.planes[3];
        object = plane.n;
        object[0] = fArray[n2 + 3 + 0] - fArray[n2 + 1 + 0];
        object[1] = fArray[n2 + 3 + 4] - fArray[n2 + 1 + 4];
        object[2] = fArray[n2 + 3 + 8] - fArray[n2 + 1 + 8];
        plane.d = fArray[n2 + 3 + 12] - fArray[n2 + 1 + 12];
        plane = this.planes[4];
        object = plane.n;
        object[0] = fArray[n2 + 3 + 0] + fArray[n2 + 2 + 0];
        object[1] = fArray[n2 + 3 + 4] + fArray[n2 + 2 + 4];
        object[2] = fArray[n2 + 3 + 8] + fArray[n2 + 2 + 8];
        plane.d = fArray[n2 + 3 + 12] + fArray[n2 + 2 + 12];
        plane = this.planes[5];
        object = plane.n;
        object[0] = fArray[n2 + 3 + 0] - fArray[n2 + 2 + 0];
        object[1] = fArray[n2 + 3 + 4] - fArray[n2 + 2 + 4];
        object[2] = fArray[n2 + 3 + 8] - fArray[n2 + 2 + 8];
        plane.d = fArray[n2 + 3 + 12] - fArray[n2 + 2 + 12];
        for (int i2 = 0; i2 < 6; ++i2) {
            object = this.planes[i2];
            float[] fArray2 = object.n;
            double d2 = Math.sqrt(fArray2[0] * fArray2[0] + fArray2[1] * fArray2[1] + fArray2[2] * fArray2[2]);
            fArray2[0] = (float)((double)fArray2[0] / d2);
            fArray2[1] = (float)((double)fArray2[1] / d2);
            fArray2[2] = (float)((double)fArray2[2] / d2);
            object.d = (float)((double)object.d / d2);
        }
    }

    private static final boolean isOutsideImpl(Plane plane, AABBox aABBox) {
        float[] fArray = aABBox.getLow();
        float[] fArray2 = aABBox.getHigh();
        return !(plane.distanceTo(fArray[0], fArray[1], fArray[2]) > 0.0f || plane.distanceTo(fArray2[0], fArray[1], fArray[2]) > 0.0f || plane.distanceTo(fArray[0], fArray2[1], fArray[2]) > 0.0f || plane.distanceTo(fArray2[0], fArray2[1], fArray[2]) > 0.0f || plane.distanceTo(fArray[0], fArray[1], fArray2[2]) > 0.0f || plane.distanceTo(fArray2[0], fArray[1], fArray2[2]) > 0.0f || plane.distanceTo(fArray[0], fArray2[1], fArray2[2]) > 0.0f) && !(plane.distanceTo(fArray2[0], fArray2[1], fArray2[2]) > 0.0f);
    }

    public final boolean isAABBoxOutside(AABBox aABBox) {
        for (int i2 = 0; i2 < 6; ++i2) {
            if (!Frustum.isOutsideImpl(this.planes[i2], aABBox)) continue;
            return true;
        }
        return false;
    }

    public final Location classifyPoint(float[] fArray) {
        Location location = Location.INSIDE;
        for (int i2 = 0; i2 < 6; ++i2) {
            float f2 = this.planes[i2].distanceTo(fArray);
            if (f2 < 0.0f) {
                return Location.OUTSIDE;
            }
            if (f2 != 0.0f) continue;
            location = Location.INTERSECT;
        }
        return location;
    }

    public final boolean isPointOutside(float[] fArray) {
        return Location.OUTSIDE == this.classifyPoint(fArray);
    }

    public final Location classifySphere(float[] fArray, float f2) {
        Location location = Location.INSIDE;
        for (int i2 = 0; i2 < 6; ++i2) {
            float f3 = this.planes[i2].distanceTo(fArray);
            if (f3 < -f2) {
                return Location.OUTSIDE;
            }
            if (!(f3 < f2)) continue;
            location = Location.INTERSECT;
        }
        return location;
    }

    public final boolean isSphereOutside(float[] fArray, float f2) {
        return Location.OUTSIDE == this.classifySphere(fArray, f2);
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("Frustum[ Planes[ ").append(PlatformPropsImpl.NEWLINE).append(" L: ").append(this.planes[0]).append(", ").append(PlatformPropsImpl.NEWLINE).append(" R: ").append(this.planes[1]).append(", ").append(PlatformPropsImpl.NEWLINE).append(" B: ").append(this.planes[2]).append(", ").append(PlatformPropsImpl.NEWLINE).append(" T: ").append(this.planes[3]).append(", ").append(PlatformPropsImpl.NEWLINE).append(" N: ").append(this.planes[4]).append(", ").append(PlatformPropsImpl.NEWLINE).append(" F: ").append(this.planes[5]).append("], ").append(PlatformPropsImpl.NEWLINE).append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public static enum Location {
        OUTSIDE,
        INSIDE,
        INTERSECT;

    }

    public static class Plane {
        public final float[] n = new float[3];
        public float d;

        public final float distanceTo(float f2, float f3, float f4) {
            return this.n[0] * f2 + this.n[1] * f3 + this.n[2] * f4 + this.d;
        }

        public final float distanceTo(float[] fArray) {
            return this.n[0] * fArray[0] + this.n[1] * fArray[1] + this.n[2] * fArray[2] + this.d;
        }

        public String toString() {
            return "Plane[ [ " + this.n[0] + ", " + this.n[1] + ", " + this.n[2] + " ], " + this.d + "]";
        }
    }
}

