/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLArrayDataClient;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLArrayHandlerInterleaved;
import jogamp.opengl.util.GLDataArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandlerFlat;
import jogamp.opengl.util.glsl.GLSLArrayHandler;
import jogamp.opengl.util.glsl.GLSLArrayHandlerFlat;
import jogamp.opengl.util.glsl.GLSLArrayHandlerInterleaved;

public class GLArrayDataServer
extends GLArrayDataClient
implements GLArrayDataEditable {
    private int interleavedOffset = 0;
    private GLBufferStorage mappedStorage = null;

    public static GLArrayDataServer createFixed(int n2, int n3, int n4, boolean bl, int n5, Buffer buffer, int n6) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, n2, n3, n4, bl, n5, buffer, buffer.limit(), 0, false, gLFixedArrayHandler, 0, 0L, n6, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixed(int n2, int n3, int n4, boolean bl, int n5, int n6) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, n2, n3, n4, bl, 0, null, n5, 0, false, gLFixedArrayHandler, 0, 0L, n6, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSL(String string, int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n2, n3, bl, 0, null, n4, 0, true, gLSLArrayHandler, 0, 0L, n5, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLMapped(String string, int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n2, n3, bl, 0, null, 0, n4, true, gLSLArrayHandler, 0, 0L, n5, 34962, true);
        gLArrayDataServer.seal(true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSL(String string, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n2, n3, bl, n4, buffer, buffer.limit(), 0, true, gLSLArrayHandler, 0, 0L, n5, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createData(int n2, int n3, int n4, Buffer buffer, int n5, int n6) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n2, n3, false, n4, buffer, buffer.limit(), 0, false, gLDataArrayHandler, 0, 0L, n5, n6, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createData(int n2, int n3, int n4, int n5, int n6) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n2, n3, false, 0, null, n4, 0, false, gLDataArrayHandler, 0, 0L, n5, n6, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createDataMapped(int n2, int n3, int n4, int n5, int n6) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n2, n3, false, 0, null, 0, n4, false, gLDataArrayHandler, 0, 0L, n5, n6, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleaved(int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n2, n3, false, 0, null, n4, 0, false, gLArrayHandlerInterleaved, 0, 0L, n5, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleavedMapped(int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n2, n3, false, 0, null, 0, n4, false, gLArrayHandlerInterleaved, 0, 0L, n5, 34962, false);
        gLArrayDataServer.seal(true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleaved(int n2, int n3, boolean bl, int n4, Buffer buffer, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n2, n3, bl, n4, buffer, buffer.limit(), 0, false, gLArrayHandlerInterleaved, 0, 0L, n5, 34962, false);
        return gLArrayDataServer;
    }

    public GLArrayData addFixedSubArray(int n2, int n3, int n4) {
        if (this.interleavedOffset >= this.getComponentCount() * this.getComponentSizeInBytes()) {
            int n5 = this.interleavedOffset / this.getComponentSizeInBytes();
            throw new GLException("Interleaved offset > total components (" + n5 + " > " + this.getComponentCount() + ")");
        }
        if (this.usesGLSL) {
            throw new GLException("buffer uses GLSL");
        }
        int n6 = 0 == this.getStride() ? this.getComponentCount() * this.getComponentSizeInBytes() : this.getStride();
        GLArrayDataWrapper gLArrayDataWrapper = 0 < this.mappedElementCount ? GLArrayDataWrapper.createFixed(n2, n3, this.getComponentType(), this.getNormalized(), n6, this.mappedElementCount, this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n4) : GLArrayDataWrapper.createFixed(n2, n3, this.getComponentType(), this.getNormalized(), n6, this.getBuffer(), this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n4);
        gLArrayDataWrapper.setVBOEnabled(this.isVBO());
        this.interleavedOffset += n3 * this.getComponentSizeInBytes();
        if (34962 == n4) {
            this.glArrayHandler.addSubHandler(new GLFixedArrayHandlerFlat(gLArrayDataWrapper));
        }
        return gLArrayDataWrapper;
    }

    public static GLArrayDataServer createGLSLInterleaved(int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n2, n3, bl, 0, null, n4, 0, false, gLSLArrayHandlerInterleaved, 0, 0L, n5, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLInterleavedMapped(int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n2, n3, bl, 0, null, 0, n4, false, gLSLArrayHandlerInterleaved, 0, 0L, n5, 34962, true);
        gLArrayDataServer.seal(true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLInterleaved(int n2, int n3, boolean bl, int n4, Buffer buffer, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n2, n3, bl, n4, buffer, buffer.limit(), 0, false, gLSLArrayHandlerInterleaved, 0, 0L, n5, 34962, true);
        return gLArrayDataServer;
    }

    public GLArrayData addGLSLSubArray(String string, int n2, int n3) {
        if (this.interleavedOffset >= this.getComponentCount() * this.getComponentSizeInBytes()) {
            int n4 = this.interleavedOffset / this.getComponentSizeInBytes();
            throw new GLException("Interleaved offset > total components (" + n4 + " > " + this.getComponentCount() + ")");
        }
        if (!this.usesGLSL) {
            throw new GLException("buffer uses fixed function");
        }
        int n5 = 0 == this.getStride() ? this.getComponentCount() * this.getComponentSizeInBytes() : this.getStride();
        GLArrayDataWrapper gLArrayDataWrapper = 0 < this.mappedElementCount ? GLArrayDataWrapper.createGLSL(string, n2, this.getComponentType(), this.getNormalized(), n5, this.mappedElementCount, this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n3) : GLArrayDataWrapper.createGLSL(string, n2, this.getComponentType(), this.getNormalized(), n5, this.getBuffer(), this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n3);
        gLArrayDataWrapper.setVBOEnabled(this.isVBO());
        this.interleavedOffset += n2 * this.getComponentSizeInBytes();
        if (34962 == n3) {
            this.glArrayHandler.addSubHandler(new GLSLArrayHandlerFlat(gLArrayDataWrapper));
        }
        return gLArrayDataWrapper;
    }

    public final void setInterleavedOffset(int n2) {
        this.interleavedOffset = n2;
    }

    public final int getInterleavedOffset() {
        return this.interleavedOffset;
    }

    @Override
    public void destroy(GL gL) {
        int n2 = this.vboName;
        super.destroy(gL);
        if (n2 != 0) {
            int[] nArray = new int[]{n2};
            gL.glDeleteBuffers(1, nArray, 0);
            this.vboName = 0;
        }
    }

    @Override
    public void setVBOEnabled(boolean bl) {
        this.checkSeal(false);
        super.setVBOEnabled(bl);
    }

    public GLBufferStorage mapStorage(GL gL, int n2) {
        if (null != this.getBuffer()) {
            throw new IllegalStateException("user buffer not null");
        }
        if (null != this.mappedStorage) {
            throw new IllegalStateException("already mapped: " + this.mappedStorage);
        }
        this.checkSeal(true);
        this.bindBuffer(gL, true);
        gL.glBufferData(this.getVBOTarget(), this.getSizeInBytes(), null, this.getVBOUsage());
        GLBufferStorage gLBufferStorage = gL.mapBuffer(this.getVBOTarget(), n2);
        this.setMappedBuffer(gLBufferStorage);
        this.bindBuffer(gL, false);
        this.seal(false);
        this.rewind();
        return gLBufferStorage;
    }

    public GLBufferStorage mapStorage(GL gL, long l2, long l3, int n2) {
        if (null != this.getBuffer()) {
            throw new IllegalStateException("user buffer not null");
        }
        if (null != this.mappedStorage) {
            throw new IllegalStateException("already mapped: " + this.mappedStorage);
        }
        this.checkSeal(true);
        this.bindBuffer(gL, true);
        gL.glBufferData(this.getVBOTarget(), this.getSizeInBytes(), null, this.getVBOUsage());
        GLBufferStorage gLBufferStorage = gL.mapBufferRange(this.getVBOTarget(), l2, l3, n2);
        this.setMappedBuffer(gLBufferStorage);
        this.bindBuffer(gL, false);
        this.seal(false);
        this.rewind();
        return gLBufferStorage;
    }

    private final void setMappedBuffer(GLBufferStorage gLBufferStorage) {
        this.mappedStorage = gLBufferStorage;
        ByteBuffer byteBuffer = gLBufferStorage.getMappedBuffer();
        if (this.componentClazz == ByteBuffer.class) {
            this.buffer = byteBuffer;
        } else if (this.componentClazz == ShortBuffer.class) {
            this.buffer = byteBuffer.asShortBuffer();
        } else if (this.componentClazz == IntBuffer.class) {
            this.buffer = byteBuffer.asIntBuffer();
        } else if (this.componentClazz == FloatBuffer.class) {
            this.buffer = byteBuffer.asFloatBuffer();
        } else {
            throw new GLException("Given Buffer Class not supported: " + this.componentClazz + ":\n\t" + this);
        }
    }

    public void unmapStorage(GL gL) {
        if (null == this.mappedStorage) {
            throw new IllegalStateException("not mapped");
        }
        this.mappedStorage = null;
        this.buffer = null;
        this.seal(true);
        this.bindBuffer(gL, true);
        gL.glUnmapBuffer(this.getVBOTarget());
        this.bindBuffer(gL, false);
    }

    @Override
    public String toString() {
        return "GLArrayDataServer[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", usesGLSL " + this.usesGLSL + ", usesShaderState " + (null != this.shaderState) + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.componentsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c" + ", initialElementCount " + this.initialElementCount + ", mappedElementCount " + this.mappedElementCount + ", mappedStorage " + this.mappedStorage + ", vboEnabled " + this.vboEnabled + ", vboName " + this.vboName + ", vboUsage 0x" + Integer.toHexString(this.vboUsage) + ", vboTarget 0x" + Integer.toHexString(this.vboTarget) + ", vboOffset " + this.vboOffset + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + ", alive " + this.alive + "]";
    }

    @Override
    protected void init(String string, int n2, int n3, int n4, boolean bl, int n5, Buffer buffer, int n6, int n7, boolean bl2, GLArrayHandler gLArrayHandler, int n8, long l2, int n9, int n10, boolean bl3) throws GLException {
        super.init(string, n2, n3, n4, bl, n5, buffer, n6, n7, bl2, gLArrayHandler, n8, l2, n9, n10, bl3);
        this.vboEnabled = true;
    }

    @Override
    protected void init_vbo(GL gL) {
        super.init_vbo(gL);
        if (this.vboEnabled && this.vboName == 0) {
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            this.vboName = nArray[0];
            if (0 < this.interleavedOffset) {
                this.glArrayHandler.setSubArrayVBOName(this.vboName);
            }
        }
    }

    protected GLArrayDataServer() {
    }

    public GLArrayDataServer(GLArrayDataServer gLArrayDataServer) {
        super(gLArrayDataServer);
        this.interleavedOffset = gLArrayDataServer.interleavedOffset;
        this.mappedStorage = gLArrayDataServer.mappedStorage;
    }
}

