/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GLBuffers
extends Buffers {
    public static final boolean isSignedGLType(int n2) {
        switch (n2) {
            case 5121: 
            case 5123: 
            case 5125: 
            case 34552: {
                return false;
            }
        }
        return true;
    }

    public static final boolean isGLTypeFixedPoint(int n2) {
        switch (n2) {
            case 5126: 
            case 5130: 
            case 5131: 
            case 36193: {
                return false;
            }
        }
        return true;
    }

    public static final int sizeOfGLType(int n2) {
        switch (n2) {
            case 5120: 
            case 5121: 
            case 32818: 
            case 33634: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 34234: 
            case 34235: 
            case 36193: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5132: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 34552: 
            case 34554: 
            case 35899: 
            case 35902: 
            case 36342: {
                return 4;
            }
            case 36269: {
                return 8;
            }
            case 5126: {
                return 4;
            }
            case 5130: {
                return 8;
            }
        }
        return -1;
    }

    public static final Buffer newDirectGLBuffer(int n2, int n3) {
        switch (n2) {
            case 5120: 
            case 5121: 
            case 32818: 
            case 33634: {
                return GLBuffers.newDirectByteBuffer(n3);
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 34234: 
            case 34235: 
            case 36193: {
                return GLBuffers.newDirectShortBuffer(n3);
            }
            case 5124: 
            case 5125: 
            case 5132: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 34552: 
            case 34554: 
            case 35899: 
            case 35902: 
            case 36342: {
                return GLBuffers.newDirectIntBuffer(n3);
            }
            case 36269: {
                return GLBuffers.newDirectLongBuffer(n3);
            }
            case 5126: {
                return GLBuffers.newDirectFloatBuffer(n3);
            }
            case 5130: {
                return GLBuffers.newDirectDoubleBuffer(n3);
            }
        }
        return null;
    }

    public static final Buffer sliceGLBuffer(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        if (byteBuffer == null || n3 == 0) {
            return null;
        }
        int n5 = byteBuffer.position();
        int n6 = byteBuffer.limit();
        byteBuffer.position(n2);
        byteBuffer.limit(n2 + n3);
        Buffer buffer = null;
        switch (n4) {
            case 5120: 
            case 5121: 
            case 32818: 
            case 33634: {
                buffer = byteBuffer.slice().order(byteBuffer.order());
                break;
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 34234: 
            case 34235: 
            case 36193: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asShortBuffer();
                break;
            }
            case 5124: 
            case 5125: 
            case 5132: 
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 34552: 
            case 34554: 
            case 35899: 
            case 35902: 
            case 36342: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asIntBuffer();
                break;
            }
            case 36269: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asLongBuffer();
                break;
            }
            case 5126: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                break;
            }
            case 5130: {
                buffer = byteBuffer.slice().order(byteBuffer.order()).asDoubleBuffer();
            }
        }
        byteBuffer.position(n5).limit(n6);
        return buffer;
    }

    private static final int glGetInteger(GL gL, int n2, int[] nArray) {
        gL.glGetIntegerv(n2, nArray, 0);
        return nArray[0];
    }

    public static final int sizeof(GL gL, int[] nArray, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        int n10 = 0;
        int n11 = 0;
        if (bl) {
            n9 = GLBuffers.glGetInteger(gL, 3333, nArray);
            if (gL.isGL2ES3()) {
                n6 = GLBuffers.glGetInteger(gL, 3330, nArray);
                n7 = GLBuffers.glGetInteger(gL, 3331, nArray);
                n8 = GLBuffers.glGetInteger(gL, 3332, nArray);
                if (n5 > 1 && gL.isGL2GL3() && gL.getContext().getGLVersionNumber().compareTo(GLContext.Version1_2) >= 0) {
                    n10 = GLBuffers.glGetInteger(gL, 32876, nArray);
                    n11 = GLBuffers.glGetInteger(gL, 32875, nArray);
                }
            }
        } else {
            n9 = GLBuffers.glGetInteger(gL, 3317, nArray);
            if (gL.isGL2ES3()) {
                n6 = GLBuffers.glGetInteger(gL, 3314, nArray);
                n7 = GLBuffers.glGetInteger(gL, 3315, nArray);
                n8 = GLBuffers.glGetInteger(gL, 3316, nArray);
                if (n5 > 1 && (gL.isGL3ES3() || gL.isGL2GL3() && gL.getContext().getGLVersionNumber().compareTo(GLContext.Version1_2) >= 0)) {
                    n10 = GLBuffers.glGetInteger(gL, 32878, nArray);
                    n11 = GLBuffers.glGetInteger(gL, 32877, nArray);
                }
            }
        }
        n3 = Math.max(0, n3);
        n4 = Math.max(1, n4);
        n5 = Math.max(1, n5);
        n7 = Math.max(0, n7);
        n8 = Math.max(0, n8);
        n9 = Math.max(1, n9);
        n11 = Math.max(0, n11);
        n10 = n10 > 0 ? n10 : n4;
        n6 = n6 > 0 ? n6 : n3;
        int n12 = n6 * n2;
        int n13 = n8 * n2;
        switch (n9) {
            case 1: {
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                int n14 = n12 & n9 - 1;
                if (n14 > 0) {
                    n12 += n9 - n14;
                }
                if ((n14 = n13 & n9 - 1) <= 0) break;
                n13 += n9 - n14;
                break;
            }
            default: {
                throw new GLException("Invalid alignment " + n9 + ", must be 2**n (1,2,4,8). Pls notify the maintainer in case this is our bug.");
            }
        }
        return n13 + (n11 + n5 - 1) * n10 * n12 + (n7 + n4 - 1) * n12 + n3 * n2;
    }

    public static final int sizeof(GL gL, int[] nArray, int n2, int n3, int n4, int n5, int n6, boolean bl) throws GLException {
        if (n4 < 0) {
            return 0;
        }
        if (n5 < 0) {
            return 0;
        }
        if (n6 < 0) {
            return 0;
        }
        int n7 = GLBuffers.bytesPerPixel(n2, n3);
        return GLBuffers.sizeof(gL, nArray, n7, n4, n5, n6, bl);
    }

    public static final int bytesPerPixel(int n2, int n3) throws GLException {
        int n4 = 0;
        int n5 = GLBuffers.componentCount(n2);
        switch (n3) {
            case 6656: {
                if (6400 == n2 || 6401 == n2) {
                    n4 = 1;
                    break;
                }
                throw new GLException("BITMAP type only supported for format COLOR_INDEX and STENCIL_INDEX, not 0x" + Integer.toHexString(n2));
            }
            case 5120: 
            case 5121: {
                n4 = 1;
                break;
            }
            case 5122: 
            case 5123: 
            case 5131: 
            case 36193: {
                n4 = 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 5132: {
                n4 = 4;
                break;
            }
            case 5130: {
                n4 = 8;
                break;
            }
            case 32818: 
            case 33634: {
                n4 = 1;
                n5 = 1;
                break;
            }
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 34234: 
            case 34235: {
                n4 = 2;
                n5 = 1;
                break;
            }
            case 34552: 
            case 34554: {
                n4 = 2;
                n5 = 2;
                break;
            }
            case 32821: 
            case 33639: 
            case 33640: 
            case 34042: 
            case 35899: 
            case 35902: 
            case 36342: {
                n4 = 4;
                n5 = 1;
                break;
            }
            case 36269: {
                n4 = 8;
                n5 = 1;
                break;
            }
            default: {
                throw new GLException("type 0x" + Integer.toHexString(n3) + "/" + "format 0x" + Integer.toHexString(n2) + " not supported [yet], pls notify the maintainer in case this is our bug.");
            }
        }
        return n5 * n4;
    }

    public static final int componentCount(int n2) throws GLException {
        int n3;
        switch (n2) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: 
            case 34041: 
            case 36244: 
            case 36245: 
            case 36246: {
                n3 = 1;
                break;
            }
            case 6410: 
            case 33319: 
            case 33320: 
            case 34548: 
            case 34553: {
                n3 = 2;
                break;
            }
            case 6407: 
            case 32992: 
            case 36248: 
            case 36250: {
                n3 = 3;
                break;
            }
            case 34233: {
                n3 = 3;
                break;
            }
            case 6408: 
            case 32768: 
            case 32993: 
            case 36249: 
            case 36251: {
                n3 = 4;
                break;
            }
            default: {
                throw new GLException("format 0x" + Integer.toHexString(n2) + " not supported [yet], pls notify the maintainer in case this is our bug.");
            }
        }
        return n3;
    }

    public static final int getNextPowerOf2(int n2) {
        if ((n2 - 1 & n2) == 0) {
            return n2;
        }
        int n3 = 0;
        while (n2 > 0) {
            n2 >>= 1;
            ++n3;
        }
        return 1 << n3;
    }

    public static final float[] getFloatArray(double[] dArray) {
        int n2 = dArray.length;
        float[] fArray = new float[n2--];
        while (n2 >= 0) {
            fArray[n2] = (float)dArray[n2];
            --n2;
        }
        return fArray;
    }
}

