/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.ImageLineHelper;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngWriter;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;

public class PNGPixelRect
extends PixelRectangle.GenericPixelRect {
    private static final boolean DEBUG = Debug.debug("PNG");
    private final double[] dpi;

    public static PNGPixelRect read(InputStream inputStream, PixelFormat pixelFormat, boolean bl, int n2, boolean bl2) throws IOException {
        int[] nArray;
        int n3;
        boolean bl3;
        boolean bl4;
        PngReader pngReader = new PngReader(new BufferedInputStream(inputStream), null);
        ImageInfo imageInfo = pngReader.imgInfo;
        PngChunkPLTE pngChunkPLTE = pngReader.getMetadata().getPLTE();
        PngChunkTRNS pngChunkTRNS = pngReader.getMetadata().getTRNS();
        boolean bl5 = imageInfo.indexed;
        boolean bl6 = bl5 ? pngChunkTRNS != null : (bl4 = imageInfo.alpha);
        if (DEBUG) {
            System.err.println("PNGPixelRect: " + imageInfo);
        }
        int n4 = bl5 ? (bl4 ? 4 : 3) : imageInfo.channels;
        boolean bl7 = bl3 = 2 == n4 && imageInfo.greyscale && imageInfo.alpha;
        if (1 != n4 && 3 != n4 && 4 != n4 && !bl3) {
            throw new RuntimeException("PNGPixelRect can only handle Lum/RGB/RGBA [1/3/4 channels] or Lum+A (GA) images for now. Channels " + n4 + " Paletted: " + bl5);
        }
        int n5 = n3 = bl5 ? n4 : imageInfo.bytesPixel;
        if (1 != n3 && 3 != n3 && 4 != n3 && !bl3) {
            throw new RuntimeException("PNGPixelRect can only handle Lum/RGB/RGBA [1/3/4 bpp] images for now. BytesPerPixel " + n3);
        }
        if (n4 != n3) {
            throw new RuntimeException("PNGPixelRect currently only handles Channels [1/3/4] == BytePerPixel [1/3/4], channels: " + n4 + ", bytesPerPixel " + n3);
        }
        int n6 = imageInfo.cols;
        int n7 = imageInfo.rows;
        Object object = pngReader.getMetadata().getDpi();
        double d2 = object[0];
        double d3 = object[1];
        if (bl5) {
            object = bl4 ? (Object)((Object)PixelFormat.RGBA8888) : (Object)((Object)PixelFormat.RGB888);
        } else {
            switch (n4) {
                case 1: {
                    object = (Object)PixelFormat.LUMINANCE;
                    break;
                }
                case 2: {
                    object = (Object)(bl3 ? PixelFormat.LUMINANCE : null);
                    break;
                }
                case 3: {
                    object = (Object)PixelFormat.RGB888;
                    break;
                }
                case 4: {
                    object = (Object)PixelFormat.RGBA8888;
                    break;
                }
                default: {
                    object = null;
                }
            }
            if (null == object) {
                throw new InternalError("XXX: channels: " + n4 + ", bytesPerPixel " + n3);
            }
        }
        Object object2 = null == pixelFormat ? (bl3 ? PixelFormat.BGRA8888 : (Object)object) : pixelFormat;
        int n8 = Math.max(n2, object2.comp.bytesPerPixel() * n6);
        ByteBuffer byteBuffer = bl ? Buffers.newDirectByteBuffer(n8 * n7) : ByteBuffer.allocate(n8 * n7);
        int n9 = n8 * n7;
        if (byteBuffer.limit() < n9) {
            throw new IndexOutOfBoundsException("Dest buffer has insufficient bytes left, needs " + n9 + ": " + byteBuffer);
        }
        n9 = bl2 ? 1 : 0;
        int[] nArray2 = nArray = bl5 ? new int[n6 * n4] : null;
        if (DEBUG) {
            System.err.println("PNGPixelRect: indexed " + bl5 + ", alpha " + bl4 + ", grayscale " + imageInfo.greyscale + ", channels " + n4 + "/" + imageInfo.channels + ", bytesPerPixel " + n3 + "/" + imageInfo.bytesPixel + ", grayAlpha " + bl3 + ", pixels " + n6 + "x" + n7 + ", dpi " + d2 + "x" + d3 + ", format " + object);
            System.err.println("PNGPixelRect: destFormat " + (Object)object2 + " (" + (Object)((Object)pixelFormat) + ", fast-path " + (object2 == object) + "), destDirectBuffer " + bl + ", destIsGLOriented (flip) " + bl2);
            System.err.println("PNGPixelRect: destStrideInBytes " + n8 + " (destMinStrideInBytes " + n2 + ")");
        }
        for (int i2 = 0; i2 < n7; ++i2) {
            int n10;
            int n11;
            ImageLine imageLine = pngReader.readRow(i2);
            int n12 = 0;
            int n13 = n11 = n9 != 0 ? (n7 - 1 - i2) * n8 : i2 * n8;
            if (bl5) {
                for (n10 = n6 - 1; n10 >= 0; --n10) {
                    nArray = ImageLineHelper.palette2rgb(imageLine, pngChunkPLTE, pngChunkTRNS, nArray);
                    n11 = PNGPixelRect.getPixelRGBA8ToAny(object2, byteBuffer, n11, nArray, n12, bl4);
                    n12 += n3;
                }
                continue;
            }
            if (1 == n4) {
                for (n10 = n6 - 1; n10 >= 0; --n10) {
                    n11 = PNGPixelRect.getPixelLUMToAny(object2, byteBuffer, n11, (byte)imageLine.scanline[n12++], (byte)-1);
                }
                continue;
            }
            if (bl3) {
                for (n10 = n6 - 1; n10 >= 0; --n10) {
                    n11 = PNGPixelRect.getPixelLUMToAny(object2, byteBuffer, n11, (byte)imageLine.scanline[n12++], (byte)imageLine.scanline[n12++]);
                }
                continue;
            }
            if (object == object2) {
                for (n10 = n6 - 1; n10 >= 0; --n10) {
                    n11 = PNGPixelRect.getPixelRGBSame(byteBuffer, n11, imageLine.scanline, n12, n3);
                    n12 += n3;
                }
                continue;
            }
            for (n10 = n6 - 1; n10 >= 0; --n10) {
                n11 = PNGPixelRect.getPixelRGBA8ToAny(object2, byteBuffer, n11, imageLine.scanline, n12, bl4);
                n12 += n3;
            }
        }
        pngReader.end();
        return new PNGPixelRect((PixelFormat)((Object)object2), new Dimension(n6, n7), n8, bl2, byteBuffer, d2, d3);
    }

    private static final int getPixelLUMToAny(PixelFormat pixelFormat, ByteBuffer byteBuffer, int n2, byte by, byte by2) {
        switch (pixelFormat) {
            case LUMINANCE: {
                byteBuffer.put(n2++, by);
                break;
            }
            case BGR888: 
            case RGB888: {
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by);
                break;
            }
            case ABGR8888: 
            case ARGB8888: {
                byteBuffer.put(n2++, by2);
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by);
                break;
            }
            case BGRA8888: 
            case RGBA8888: {
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by);
                byteBuffer.put(n2++, by2);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
            }
        }
        return n2;
    }

    private static final int getPixelRGBA8ToAny(PixelFormat pixelFormat, ByteBuffer byteBuffer, int n2, int[] nArray, int n3, boolean bl) {
        int n4 = PixelFormatUtil.convertToInt32(pixelFormat, (byte)nArray[n3], (byte)nArray[n3 + 1], (byte)nArray[n3 + 2], bl ? (byte)nArray[n3 + 3] : (byte)-1);
        int n5 = pixelFormat.comp.bytesPerPixel();
        byteBuffer.put(n2++, (byte)n4);
        if (1 < n5) {
            byteBuffer.put(n2++, (byte)(n4 >>> 8));
            byteBuffer.put(n2++, (byte)(n4 >>> 16));
            if (4 == n5) {
                byteBuffer.put(n2++, (byte)(n4 >>> 24));
            }
        }
        return n2;
    }

    private static final int getPixelRGBSame(ByteBuffer byteBuffer, int n2, int[] nArray, int n3, int n4) {
        byteBuffer.put(n2++, (byte)nArray[n3]);
        if (1 < n4) {
            byteBuffer.put(n2++, (byte)nArray[n3 + 1]);
            byteBuffer.put(n2++, (byte)nArray[n3 + 2]);
            if (4 == n4) {
                byteBuffer.put(n2++, (byte)nArray[n3 + 3]);
            }
        }
        return n2;
    }

    private int setPixelRGBA8(ImageLine imageLine, int n2, ByteBuffer byteBuffer, int n3, int n4, boolean bl) {
        int n5;
        int n6 = n5 = bl ? 3 : 2;
        if (byteBuffer.limit() <= n3 + n5) {
            throw new IndexOutOfBoundsException("Buffer has unsufficient bytes left, needs [" + n3 + ".." + (n3 + n5) + "]: " + byteBuffer);
        }
        int n7 = PixelFormatUtil.convertToInt32(bl ? PixelFormat.RGBA8888 : PixelFormat.RGB888, this.pixelformat, byteBuffer, n3);
        imageLine.scanline[n2] = 0xFF & n7;
        imageLine.scanline[n2 + 1] = 0xFF & n7 >>> 8;
        imageLine.scanline[n2 + 2] = 0xFF & n7 >>> 16;
        if (bl) {
            imageLine.scanline[n2 + 3] = 0xFF & n7 >>> 24;
        }
        return n3 + this.pixelformat.comp.bytesPerPixel();
    }

    private static void setPixelRGBA8(PixelFormat pixelFormat, ImageLine imageLine, int n2, int n3, int n4, boolean bl) {
        int n5 = PixelFormatUtil.convertToInt32(bl ? PixelFormat.RGBA8888 : PixelFormat.RGB888, pixelFormat, n3);
        imageLine.scanline[n2] = 0xFF & n5;
        imageLine.scanline[n2 + 1] = 0xFF & n5 >>> 8;
        imageLine.scanline[n2 + 2] = 0xFF & n5 >>> 16;
        if (bl) {
            imageLine.scanline[n2 + 3] = 0xFF & n5 >>> 24;
        }
    }

    public PNGPixelRect(PixelFormat pixelFormat, DimensionImmutable dimensionImmutable, int n2, boolean bl, ByteBuffer byteBuffer, double d2, double d3) {
        super(pixelFormat, dimensionImmutable, n2, bl, byteBuffer);
        this.dpi = new double[]{d2, d3};
    }

    public PNGPixelRect(PixelRectangle pixelRectangle, double d2, double d3) {
        super(pixelRectangle);
        this.dpi = new double[]{d2, d3};
    }

    public double[] getDpi() {
        return this.dpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, boolean bl) throws IOException {
        int n2 = this.size.getWidth();
        int n3 = this.size.getHeight();
        int n4 = this.pixelformat.comp.bytesPerPixel();
        ImageInfo imageInfo = new ImageInfo(n2, n3, 8, 4 == n4, 1 == n4, false);
        try {
            PngWriter pngWriter = new PngWriter(outputStream, imageInfo);
            pngWriter.getMetadata().setDpi(this.dpi[0], this.dpi[1]);
            pngWriter.getMetadata().setTimeNow(0);
            pngWriter.getMetadata().setText("Title", "JogAmp PNGPixelRect");
            boolean bl2 = 4 == n4;
            ImageLine imageLine = new ImageLine(imageInfo);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5;
                int n6 = this.isGLOriented ? (n3 - 1 - i2) * this.strideInBytes : i2 * this.strideInBytes;
                int n7 = 0;
                if (1 == n4) {
                    for (n5 = n2 - 1; n5 >= 0; --n5) {
                        imageLine.scanline[n7++] = this.pixels.get(n6++);
                    }
                } else {
                    for (n5 = n2 - 1; n5 >= 0; --n5) {
                        n6 = this.setPixelRGBA8(imageLine, n7, this.pixels, n6, n4, bl2);
                        n7 += n4;
                    }
                }
                pngWriter.writeRow(imageLine, i2);
            }
            pngWriter.end();
        }
        finally {
            if (bl) {
                IOUtil.close(outputStream, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(PixelFormat pixelFormat, DimensionImmutable dimensionImmutable, int n2, boolean bl, IntBuffer intBuffer, double d2, double d3, OutputStream outputStream, boolean bl2) throws IOException {
        int n3 = dimensionImmutable.getWidth();
        int n4 = dimensionImmutable.getHeight();
        int n5 = pixelFormat.comp.bytesPerPixel();
        ImageInfo imageInfo = new ImageInfo(n3, n4, 8, 4 == n5, 1 == n5, false);
        if (0 != n2) {
            if (n2 < dimensionImmutable.getWidth()) {
                throw new IllegalArgumentException("Invalid stride " + n5 + ", must be greater than width " + dimensionImmutable.getWidth());
            }
        } else {
            n2 = dimensionImmutable.getWidth();
        }
        int n6 = n2 * dimensionImmutable.getHeight();
        if (intBuffer.limit() < n6) {
            throw new IndexOutOfBoundsException("Dest buffer has insufficient pixels left, needs " + n6 + ": " + intBuffer);
        }
        try {
            PngWriter pngWriter = new PngWriter(outputStream, imageInfo);
            pngWriter.getMetadata().setDpi(d2, d3);
            pngWriter.getMetadata().setTimeNow(0);
            pngWriter.getMetadata().setText("Title", "JogAmp PNGPixelRect");
            boolean bl3 = 4 == n5;
            ImageLine imageLine = new ImageLine(imageInfo);
            for (int i2 = 0; i2 < n4; ++i2) {
                int n7;
                int n8 = bl ? (n4 - 1 - i2) * n2 : i2 * n2;
                int n9 = 0;
                if (1 == n5) {
                    for (n7 = n3 - 1; n7 >= 0; --n7) {
                        imageLine.scanline[n9++] = intBuffer.get(n8++);
                    }
                } else {
                    for (n7 = n3 - 1; n7 >= 0; --n7) {
                        PNGPixelRect.setPixelRGBA8(pixelFormat, imageLine, n9, intBuffer.get(n8++), n5, bl3);
                        n9 += n5;
                    }
                }
                pngWriter.writeRow(imageLine, i2);
            }
            pngWriter.end();
        }
        finally {
            if (bl2) {
                IOUtil.close(outputStream, false);
            }
        }
    }
}

