/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.common.net.Uri;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import jogamp.opengl.Debug;

public class ShaderCode {
    public static final boolean DEBUG_CODE = Debug.isPropertyDefined("jogl.debug.GLSLCode", true);
    public static final String SUFFIX_VERTEX_SOURCE = "vp";
    public static final String SUFFIX_VERTEX_BINARY = "bvp";
    public static final String SUFFIX_GEOMETRY_SOURCE = "gp";
    public static final String SUFFIX_GEOMETRY_BINARY = "bgp";
    public static final String SUFFIX_TESS_CONTROL_SOURCE = "tcp";
    public static final String SUFFIX_TESS_CONTROL_BINARY = "btcp";
    public static final String SUFFIX_TESS_EVALUATION_SOURCE = "tep";
    public static final String SUFFIX_TESS_EVALUATION_BINARY = "btep";
    public static final String SUFFIX_FRAGMENT_SOURCE = "fp";
    public static final String SUFFIX_FRAGMENT_BINARY = "bfp";
    public static final String SUB_PATH_NVIDIA = "nvidia";
    public static final String es2_default_precision_vp = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String es2_default_precision_fp = "\nprecision mediump float;\nprecision mediump int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String es3_default_precision_vp = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String es3_default_precision_fp = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String gl3_default_precision_vp_gp = "\nprecision highp float;\nprecision highp int;\n";
    public static final String gl3_default_precision_fp = "\nprecision highp float;\nprecision mediump int;\n/*precision mediump sampler2D;*/\n";
    public static final String REQUIRE = "require";
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    public static final String WARN = "warn";
    protected CharSequence[][] shaderSource = null;
    protected Buffer shaderBinary = null;
    protected int shaderBinaryFormat = -1;
    protected IntBuffer shader = null;
    protected int shaderType = -1;
    protected int id = -1;
    protected boolean valid = false;
    protected static int nextID = 1;

    public ShaderCode(int n2, int n3, CharSequence[][] charSequenceArray) {
        if (charSequenceArray.length != n3) {
            throw new IllegalArgumentException("shader number (" + n3 + ") and sourceFiles array (" + charSequenceArray.length + ") of different lenght.");
        }
        switch (n2) {
            case 35632: 
            case 35633: 
            case 36313: 
            case 36487: 
            case 36488: {
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n2);
            }
        }
        this.shaderSource = charSequenceArray;
        this.shaderBinaryFormat = -1;
        this.shaderBinary = null;
        this.shaderType = n2;
        this.shader = Buffers.newDirectIntBuffer(n3);
        this.id = ShaderCode.getNextID();
        if (DEBUG_CODE) {
            System.out.println("Created: " + this.toString());
        }
    }

    public ShaderCode(int n2, int n3, int n4, Buffer buffer) {
        switch (n2) {
            case 35632: 
            case 35633: 
            case 36313: 
            case 36487: 
            case 36488: {
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n2);
            }
        }
        this.shaderSource = null;
        this.shaderBinaryFormat = n4;
        this.shaderBinary = buffer;
        this.shaderType = n2;
        this.shader = Buffers.newDirectIntBuffer(n3);
        this.id = ShaderCode.getNextID();
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n2, int n3, Class<?> clazz, String[] stringArray, boolean bl) {
        if (null != gL2ES2 && !ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            return null;
        }
        CharSequence[][] charSequenceArray = null;
        if (null != stringArray) {
            charSequenceArray = new CharSequence[stringArray.length][1];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    charSequenceArray[i2][0] = ShaderCode.readShaderSource(clazz, stringArray[i2], bl);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("readShaderSource(" + stringArray[i2] + ") error: ", iOException);
                }
                if (null != charSequenceArray[i2][0]) continue;
                charSequenceArray = null;
            }
        }
        if (null == charSequenceArray) {
            return null;
        }
        return new ShaderCode(n2, n3, charSequenceArray);
    }

    public static ShaderCode create(int n2, int n3, Class<?> clazz, int n4, String string) {
        ByteBuffer byteBuffer = null;
        if (null != string && 0 <= n4) {
            try {
                byteBuffer = ShaderCode.readShaderBinary(clazz, string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("readShaderBinary(" + string + ") error: ", iOException);
            }
            if (null == byteBuffer) {
                n4 = -1;
            }
        }
        if (null == byteBuffer) {
            return null;
        }
        return new ShaderCode(n2, n3, n4, byteBuffer);
    }

    public static String getFileSuffix(boolean bl, int n2) {
        switch (n2) {
            case 35633: {
                return bl ? SUFFIX_VERTEX_BINARY : SUFFIX_VERTEX_SOURCE;
            }
            case 35632: {
                return bl ? SUFFIX_FRAGMENT_BINARY : SUFFIX_FRAGMENT_SOURCE;
            }
            case 36313: {
                return bl ? SUFFIX_GEOMETRY_BINARY : SUFFIX_GEOMETRY_SOURCE;
            }
            case 36488: {
                return bl ? SUFFIX_TESS_CONTROL_BINARY : SUFFIX_TESS_CONTROL_SOURCE;
            }
            case 36487: {
                return bl ? SUFFIX_TESS_EVALUATION_BINARY : SUFFIX_TESS_EVALUATION_SOURCE;
            }
        }
        throw new GLException("illegal shader type: " + n2);
    }

    public static String getBinarySubPath(int n2) {
        switch (n2) {
            case 35083: {
                return SUB_PATH_NVIDIA;
            }
        }
        throw new GLException("unsupported binary format: " + n2);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n2, int n3, Class<?> clazz, String string, String[] stringArray, String string2, String string3, boolean bl) {
        Object object;
        Object[] objectArray;
        ShaderCode shaderCode = null;
        String string4 = null;
        String string5 = null;
        if (null != stringArray && ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            int n4;
            objectArray = new String[stringArray.length];
            object = ShaderCode.getFileSuffix(false, n2);
            if (null != string && string.length() > 0) {
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    objectArray[n4] = string + '/' + stringArray[n4] + "." + (String)object;
                }
            } else {
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    objectArray[n4] = stringArray[n4] + "." + (String)object;
                }
            }
            if (null != (shaderCode = ShaderCode.create(gL2ES2, n2, n3, clazz, (String[])objectArray, bl))) {
                return shaderCode;
            }
            string4 = Arrays.toString(objectArray);
        } else {
            objectArray = null;
        }
        if (null != string3) {
            object = ShaderUtil.getShaderBinaryFormats(gL2ES2);
            String string6 = ShaderCode.getFileSuffix(true, n2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                String string7 = ShaderCode.getBinarySubPath(n5);
                if (null == string7 || null == (shaderCode = ShaderCode.create(n2, n3, clazz, n5, string5 = string2 + '/' + string7 + '/' + string3 + "." + string6))) continue;
                return shaderCode;
            }
        }
        throw new GLException("No shader code found (source nor binary) for src: " + string4 + ", bin: " + string5);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n2, Class<?> clazz, String string, String string2, String string3, boolean bl) {
        return ShaderCode.create(gL2ES2, n2, 1, clazz, string, new String[]{string3}, string2, string3, bl);
    }

    public int id() {
        return this.id;
    }

    public int shaderType() {
        return this.shaderType;
    }

    public String shaderTypeStr() {
        return ShaderCode.shaderTypeStr(this.shaderType);
    }

    public static String shaderTypeStr(int n2) {
        switch (n2) {
            case 35633: {
                return "VERTEX_SHADER";
            }
            case 35632: {
                return "FRAGMENT_SHADER";
            }
            case 36313: {
                return "GEOMETRY_SHADER";
            }
            case 36488: {
                return "TESS_CONTROL_SHADER";
            }
            case 36487: {
                return "TESS_EVALUATION_SHADER";
            }
        }
        return "UNKNOWN_SHADER";
    }

    public int shaderBinaryFormat() {
        return this.shaderBinaryFormat;
    }

    public Buffer shaderBinary() {
        return this.shaderBinary;
    }

    public CharSequence[][] shaderSource() {
        return this.shaderSource;
    }

    public boolean isValid() {
        return this.valid;
    }

    public IntBuffer shader() {
        return this.shader;
    }

    public boolean compile(GL2ES2 gL2ES2) {
        return this.compile(gL2ES2, null);
    }

    public boolean compile(GL2ES2 gL2ES2, PrintStream printStream) {
        if (this.isValid()) {
            return true;
        }
        if (null != this.shaderSource) {
            if (DEBUG_CODE) {
                System.err.println("ShaderCode.compile:");
                this.dumpShaderSource(System.err);
            }
            this.valid = ShaderUtil.createAndCompileShader(gL2ES2, this.shader, this.shaderType, this.shaderSource, printStream);
        } else if (null != this.shaderBinary) {
            this.valid = ShaderUtil.createAndLoadShader(gL2ES2, this.shader, this.shaderType, this.shaderBinaryFormat, this.shaderBinary, printStream);
        } else {
            throw new GLException("no code (source or binary)");
        }
        return this.valid;
    }

    public void destroy(GL2ES2 gL2ES2) {
        if (this.isValid()) {
            if (null != gL2ES2) {
                ShaderUtil.deleteShader(gL2ES2, this.shader());
            }
            this.valid = false;
        }
        if (null != this.shaderBinary) {
            this.shaderBinary.clear();
            this.shaderBinary = null;
        }
        this.shaderSource = null;
        this.shaderBinaryFormat = -1;
        this.shaderType = -1;
        this.id = -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ShaderCode) {
            return this.id() == ((ShaderCode)object).id();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ShaderCode[id=" + this.id + ", type=" + this.shaderTypeStr() + ", valid=" + this.valid + ", shader: ");
        for (int i2 = 0; i2 < this.shader.remaining(); ++i2) {
            stringBuilder.append(" " + this.shader.get(i2));
        }
        if (null != this.shaderSource) {
            stringBuilder.append(", source]");
        } else if (null != this.shaderBinary) {
            stringBuilder.append(", binary " + this.shaderBinary + "]");
        }
        return stringBuilder.toString();
    }

    public void dumpShaderSource(PrintStream printStream) {
        if (null == this.shaderSource) {
            printStream.println("<no shader source>");
            return;
        }
        int n2 = this.shaderSource.length;
        int n3 = null != this.shader ? this.shader.capacity() : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            printStream.println("");
            printStream.println("Shader #" + i2 + "/" + n3 + " name " + this.shader.get(i2));
            printStream.println("--------------------------------------------------------------");
            if (i2 >= n2) {
                printStream.println("<no shader source>");
            } else {
                CharSequence[] charSequenceArray = this.shaderSource[i2];
                int n4 = 0;
                for (int i3 = 0; i3 < charSequenceArray.length; ++i3) {
                    printStream.printf("%4d: // Segment %d/%d: \n", n4, i3, charSequenceArray.length);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(charSequenceArray[i3].toString()));
                    String string = null;
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            printStream.printf("%4d: %s\n", ++n4, string);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            printStream.println("--------------------------------------------------------------");
        }
    }

    public int insertShaderSource(int n2, String string, int n3, CharSequence charSequence) {
        int n4;
        if (null == this.shaderSource) {
            throw new IllegalStateException("no shader source");
        }
        int n5 = n4 = null != this.shader ? this.shader.capacity() : 0;
        if (0 > n2 || n2 >= n4) {
            throw new IndexOutOfBoundsException("shaderIdx not within shader bounds [0.." + (n4 - 1) + "]: " + n2);
        }
        int n6 = this.shaderSource.length;
        if (n2 >= n6) {
            throw new IndexOutOfBoundsException("shaderIdx not within source bounds [0.." + (n6 - 1) + "]: " + n2);
        }
        CharSequence[] charSequenceArray = this.shaderSource[n2];
        int n7 = 0;
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            int n8;
            if (!(charSequenceArray[i2] instanceof StringBuilder)) {
                throw new IllegalStateException("shader source not a mutable StringBuilder, but CharSequence of type: " + charSequenceArray[i2].getClass().getName());
            }
            StringBuilder stringBuilder = (StringBuilder)charSequenceArray[i2];
            if (n3 >= (n7 += stringBuilder.length()) || 0 > (n8 = stringBuilder.indexOf(string, n3))) continue;
            int n9 = stringBuilder.indexOf("\n", n8 += string.length());
            if (0 > n9) {
                n9 = stringBuilder.indexOf("\r", n8);
            }
            if (0 < n9) {
                n8 = n9 + 1;
            } else {
                stringBuilder.insert(n8, "\n");
                ++n8;
            }
            stringBuilder.insert(n8, charSequence);
            return n8 + charSequence.length();
        }
        return -1;
    }

    public int replaceInShaderSource(String string, String string2) {
        if (null == this.shaderSource) {
            throw new IllegalStateException("no shader source");
        }
        if (string == string2 || string.equals(string2)) {
            return 0;
        }
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = 0;
        for (CharSequence[] charSequenceArray : this.shaderSource) {
            for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
                if (!(charSequenceArray[i2] instanceof StringBuilder)) {
                    throw new IllegalStateException("shader source not a mutable StringBuilder, but CharSequence of type: " + charSequenceArray[i2].getClass().getName());
                }
                StringBuilder stringBuilder = (StringBuilder)charSequenceArray[i2];
                int n5 = 0;
                while (n5 < stringBuilder.length() - n2 + 1) {
                    int n6 = stringBuilder.indexOf(string, n5);
                    if (0 <= n6) {
                        int n7 = n6 + n2;
                        stringBuilder.replace(n6, n7, string2);
                        n5 = n6 + n3;
                        ++n4;
                        continue;
                    }
                    n5 = stringBuilder.length();
                }
            }
        }
        return n4;
    }

    public int insertShaderSource(int n2, int n3, CharSequence charSequence) {
        int n4;
        if (null == this.shaderSource) {
            throw new IllegalStateException("no shader source");
        }
        int n5 = n4 = null != this.shader ? this.shader.capacity() : 0;
        if (0 > n2 || n2 >= n4) {
            throw new IndexOutOfBoundsException("shaderIdx not within shader bounds [0.." + (n4 - 1) + "]: " + n2);
        }
        int n6 = this.shaderSource.length;
        if (n2 >= n6) {
            throw new IndexOutOfBoundsException("shaderIdx not within source bounds [0.." + (n6 - 1) + "]: " + n2);
        }
        CharSequence[] charSequenceArray = this.shaderSource[n2];
        int n7 = 0;
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            if (!(charSequenceArray[i2] instanceof StringBuilder)) {
                throw new IllegalStateException("shader source not a mutable StringBuilder, but CharSequence of type: " + charSequenceArray[i2].getClass().getName());
            }
            StringBuilder stringBuilder = (StringBuilder)charSequenceArray[i2];
            n7 += stringBuilder.length();
            if (0 > n3 && i2 == charSequenceArray.length - 1) {
                n3 = n7;
            }
            if (0 > n3 || n3 > n7) continue;
            stringBuilder.insert(n3, charSequence);
            return n3 + charSequence.length();
        }
        return n3;
    }

    public int insertShaderSource(int n2, int n3, Class<?> clazz, String string) throws IOException {
        CharSequence charSequence = ShaderCode.readShaderSource(clazz, string, true);
        if (null != charSequence) {
            return this.insertShaderSource(n2, n3, charSequence);
        }
        return n3;
    }

    private static int readShaderSource(Class<?> clazz, URLConnection uRLConnection, StringBuilder stringBuilder, int n2) throws IOException {
        if (DEBUG_CODE) {
            if (0 == n2) {
                stringBuilder.append("// " + uRLConnection.getURL().toExternalForm() + "\n");
            } else {
                stringBuilder.append("// included @ line " + n2 + ": " + uRLConnection.getURL().toExternalForm() + "\n");
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                ++n2;
                if (string.startsWith("#include ")) {
                    String string2 = string.substring(9).trim();
                    URLConnection uRLConnection2 = null;
                    Uri uri = Uri.valueOf(uRLConnection.getURL()).getRelativeOf(new Uri.Encoded(string2, "/!_-.~"));
                    uRLConnection2 = IOUtil.openURL(uri.toURL(), "ShaderCode.relativeOf ");
                    if (uRLConnection2 == null) {
                        uRLConnection2 = IOUtil.getResource(clazz, string2);
                    }
                    if (uRLConnection2 == null) {
                        throw new FileNotFoundException("Can't find include file " + string2);
                    }
                    n2 = ShaderCode.readShaderSource(clazz, uRLConnection2, stringBuilder, n2);
                    continue;
                }
                stringBuilder.append(string + "\n");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        finally {
            IOUtil.close(bufferedReader, false);
        }
        return n2;
    }

    public static void readShaderSource(Class<?> clazz, URLConnection uRLConnection, StringBuilder stringBuilder) throws IOException {
        ShaderCode.readShaderSource(clazz, uRLConnection, stringBuilder, 0);
    }

    public static CharSequence readShaderSource(Class<?> clazz, String string, boolean bl) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(clazz, string);
        if (uRLConnection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ShaderCode.readShaderSource(clazz, uRLConnection, stringBuilder);
        return bl ? stringBuilder : stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readShaderBinary(Class<?> clazz, String string) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(clazz, string);
        if (uRLConnection == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            ByteBuffer byteBuffer = IOUtil.copyStream2ByteBuffer(bufferedInputStream);
            return byteBuffer;
        }
        finally {
            IOUtil.close(bufferedInputStream, false);
        }
    }

    public static String createExtensionDirective(String string, String string2) {
        return "#extension " + string + " : " + string2 + "\n";
    }

    public final int addGLSLVersion(GL2ES2 gL2ES2) {
        return this.insertShaderSource(0, 0, gL2ES2.getContext().getGLSLVersionString());
    }

    public final int addDefaultShaderPrecision(GL2ES2 gL2ES2, int n2) {
        String string;
        if (gL2ES2.isGLES3()) {
            switch (this.shaderType) {
                case 35633: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                case 35632: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else if (gL2ES2.isGLES2()) {
            switch (this.shaderType) {
                case 35633: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                case 35632: {
                    string = es2_default_precision_fp;
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else if (ShaderCode.requiresGL3DefaultPrecision(gL2ES2)) {
            switch (this.shaderType) {
                case 35633: 
                case 36313: 
                case 36487: 
                case 36488: {
                    string = gl3_default_precision_vp_gp;
                    break;
                }
                case 35632: {
                    string = gl3_default_precision_fp;
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else {
            string = null;
        }
        if (null != string) {
            n2 = this.insertShaderSource(0, n2, string);
        }
        return n2;
    }

    public static final boolean requiresDefaultPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGLES()) {
            return true;
        }
        return ShaderCode.requiresGL3DefaultPrecision(gL2ES2);
    }

    public static final boolean requiresGL3DefaultPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGL3()) {
            VersionNumber versionNumber = gL2ES2.getContext().getGLSLVersionNumber();
            return versionNumber.compareTo(GLContext.Version1_30) >= 0 && versionNumber.compareTo(GLContext.Version1_50) < 0;
        }
        return false;
    }

    public final int defaultShaderCustomization(GL2ES2 gL2ES2, boolean bl, boolean bl2) {
        int n2 = bl ? this.addGLSLVersion(gL2ES2) : 0;
        if (bl2) {
            n2 = this.addDefaultShaderPrecision(gL2ES2, n2);
        }
        return n2;
    }

    public final int defaultShaderCustomization(GL2ES2 gL2ES2, boolean bl, String string) {
        int n2 = bl ? this.addGLSLVersion(gL2ES2) : 0;
        n2 = gL2ES2.isGLES() && null != string ? this.insertShaderSource(0, n2, string) : this.addDefaultShaderPrecision(gL2ES2, n2);
        return n2;
    }

    private static synchronized int getNextID() {
        return nextID++;
    }
}

