/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class DDSImage {
    private FileInputStream fis;
    private FileChannel chan;
    private ByteBuffer buf;
    private Header header;
    public static final int DDSD_CAPS = 1;
    public static final int DDSD_HEIGHT = 2;
    public static final int DDSD_WIDTH = 4;
    public static final int DDSD_PITCH = 8;
    public static final int DDSD_BACKBUFFERCOUNT = 32;
    public static final int DDSD_ZBUFFERBITDEPTH = 64;
    public static final int DDSD_ALPHABITDEPTH = 128;
    public static final int DDSD_LPSURFACE = 2048;
    public static final int DDSD_PIXELFORMAT = 4096;
    public static final int DDSD_MIPMAPCOUNT = 131072;
    public static final int DDSD_LINEARSIZE = 524288;
    public static final int DDSD_DEPTH = 0x800000;
    public static final int DDPF_ALPHAPIXELS = 1;
    public static final int DDPF_ALPHA = 2;
    public static final int DDPF_FOURCC = 4;
    public static final int DDPF_PALETTEINDEXED4 = 8;
    public static final int DDPF_PALETTEINDEXEDTO8 = 16;
    public static final int DDPF_PALETTEINDEXED8 = 32;
    public static final int DDPF_RGB = 64;
    public static final int DDPF_COMPRESSED = 128;
    public static final int DDPF_RGBTOYUV = 256;
    public static final int DDPF_YUV = 512;
    public static final int DDPF_ZBUFFER = 1024;
    public static final int DDPF_PALETTEINDEXED1 = 2048;
    public static final int DDPF_PALETTEINDEXED2 = 4096;
    public static final int DDPF_ZPIXELS = 8192;
    public static final int DDSCAPS_TEXTURE = 4096;
    public static final int DDSCAPS_MIPMAP = 0x400000;
    public static final int DDSCAPS_COMPLEX = 8;
    public static final int DDSCAPS2_CUBEMAP = 512;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEX = 1024;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEX = 2048;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEY = 4096;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEY = 8192;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEZ = 16384;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEZ = 32768;
    public static final int D3DFMT_UNKNOWN = 0;
    public static final int D3DFMT_R8G8B8 = 20;
    public static final int D3DFMT_A8R8G8B8 = 21;
    public static final int D3DFMT_X8R8G8B8 = 22;
    public static final int D3DFMT_DXT1 = 827611204;
    public static final int D3DFMT_DXT2 = 844388420;
    public static final int D3DFMT_DXT3 = 861165636;
    public static final int D3DFMT_DXT4 = 877942852;
    public static final int D3DFMT_DXT5 = 894720068;
    private static final int MAGIC = 542327876;

    public static DDSImage read(String string) throws IOException {
        return DDSImage.read(new File(string));
    }

    public static DDSImage read(File file) throws IOException {
        DDSImage dDSImage = new DDSImage();
        dDSImage.readFromFile(file);
        return dDSImage;
    }

    public static DDSImage read(ByteBuffer byteBuffer) throws IOException {
        DDSImage dDSImage = new DDSImage();
        dDSImage.readFromBuffer(byteBuffer);
        return dDSImage;
    }

    public void close() {
        try {
            if (this.chan != null) {
                this.chan.close();
                this.chan = null;
            }
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
            this.buf = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static DDSImage createFromData(int n2, int n3, int n4, ByteBuffer[] byteBufferArray) throws IllegalArgumentException {
        DDSImage dDSImage = new DDSImage();
        dDSImage.initFromData(n2, n3, n4, byteBufferArray);
        return dDSImage;
    }

    public static boolean isDDSImage(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!inputStream.markSupported()) {
            throw new IOException("Can not test non-destructively whether given InputStream is a DDS image");
        }
        inputStream.mark(4);
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = inputStream.read();
            if (n3 < 0) {
                inputStream.reset();
                return false;
            }
            n2 = n2 >>> 8 | n3 << 24;
        }
        inputStream.reset();
        return n2 == 542327876;
    }

    public void write(String string) throws IOException {
        this.write(new File(string));
    }

    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = IOUtil.getFileOutputStream(file, true);
        FileChannel fileChannel = fileOutputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(Header.writtenSize());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header.write(byteBuffer);
        byteBuffer.rewind();
        fileChannel.write(byteBuffer);
        this.buf.position(Header.writtenSize());
        fileChannel.write(this.buf);
        fileChannel.force(true);
        fileChannel.close();
        fileOutputStream.close();
    }

    public boolean isSurfaceDescFlagSet(int n2) {
        return (this.header.flags & n2) != 0;
    }

    public boolean isPixelFormatFlagSet(int n2) {
        return (this.header.pfFlags & n2) != 0;
    }

    public int getPixelFormat() {
        if (this.isCompressed()) {
            return this.getCompressionFormat();
        }
        if (this.isPixelFormatFlagSet(64)) {
            if (this.isPixelFormatFlagSet(1)) {
                if (this.getDepth() == 32 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255 && this.header.pfABitMask == -16777216) {
                    return 21;
                }
            } else {
                if (this.getDepth() == 24 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255) {
                    return 20;
                }
                if (this.getDepth() == 32 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255) {
                    return 22;
                }
            }
        }
        return 0;
    }

    public boolean isCubemap() {
        return (this.header.ddsCaps1 & 8) != 0 && (this.header.ddsCaps2 & 0x200) != 0;
    }

    public boolean isCubemapSidePresent(int n2) {
        return this.isCubemap() && (this.header.ddsCaps2 & n2) != 0;
    }

    public boolean isCompressed() {
        return this.isPixelFormatFlagSet(4);
    }

    public int getCompressionFormat() {
        return this.header.pfFourCC;
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    public int getDepth() {
        return this.header.pfRGBBitCount;
    }

    public int getNumMipMaps() {
        if (!this.isSurfaceDescFlagSet(131072)) {
            return 0;
        }
        return this.header.mipMapCountOrAux;
    }

    public ImageInfo getMipMap(int n2) {
        return this.getMipMap(0, n2);
    }

    public ImageInfo getMipMap(int n2, int n3) {
        if (!this.isCubemap() && n2 != 0) {
            throw new RuntimeException("Illegal side for 2D texture: " + n2);
        }
        if (this.isCubemap() && !this.isCubemapSidePresent(n2)) {
            throw new RuntimeException("Illegal side, side not present: " + n2);
        }
        if (this.getNumMipMaps() > 0 && (n3 < 0 || n3 >= this.getNumMipMaps())) {
            throw new RuntimeException("Illegal mipmap number " + n3 + " (0.." + (this.getNumMipMaps() - 1) + ")");
        }
        int n4 = Header.writtenSize();
        if (this.isCubemap()) {
            n4 += this.sideShiftInBytes(n2);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += this.mipMapSizeInBytes(i2);
        }
        this.buf.limit(n4 + this.mipMapSizeInBytes(n3));
        this.buf.position(n4);
        ByteBuffer byteBuffer = this.buf.slice();
        this.buf.position(0);
        this.buf.limit(this.buf.capacity());
        return new ImageInfo(byteBuffer, this.mipMapWidth(n3), this.mipMapHeight(n3), this.isCompressed(), this.getCompressionFormat());
    }

    public ImageInfo[] getAllMipMaps() {
        return this.getAllMipMaps(0);
    }

    public ImageInfo[] getAllMipMaps(int n2) {
        int n3 = this.getNumMipMaps();
        if (n3 == 0) {
            n3 = 1;
        }
        ImageInfo[] imageInfoArray = new ImageInfo[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            imageInfoArray[i2] = this.getMipMap(n2, i2);
        }
        return imageInfoArray;
    }

    public static String getCompressionFormatName(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2 = (char)(n2 & 0xFF);
            stringBuilder.append(c2);
            n2 >>= 8;
        }
        return stringBuilder.toString();
    }

    public static ByteBuffer allocateBlankBuffer(int n2, int n3, int n4) {
        int n5 = n2 * n3;
        switch (n4) {
            case 33776: 
            case 33777: {
                n5 /= 2;
                break;
            }
            case 33778: 
            case 33779: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal OpenGL texture internal format " + n4);
            }
        }
        if (n5 == 0) {
            n5 = 1;
        }
        return Buffers.newDirectByteBuffer(n5);
    }

    public void debugPrint() {
        int n2;
        PrintStream printStream = System.err;
        printStream.println("Compressed texture: " + this.isCompressed());
        if (this.isCompressed()) {
            n2 = this.getCompressionFormat();
            String string = DDSImage.getCompressionFormatName(n2);
            printStream.println("Compression format: 0x" + Integer.toHexString(n2) + " (" + string + ")");
        }
        printStream.println("Width: " + this.header.width + " Height: " + this.header.height);
        printStream.println("header.pitchOrLinearSize: " + this.header.pitchOrLinearSize);
        printStream.println("header.pfRBitMask: 0x" + Integer.toHexString(this.header.pfRBitMask));
        printStream.println("header.pfGBitMask: 0x" + Integer.toHexString(this.header.pfGBitMask));
        printStream.println("header.pfBBitMask: 0x" + Integer.toHexString(this.header.pfBBitMask));
        printStream.println("SurfaceDesc flags:");
        n2 = 0;
        n2 |= this.printIfRecognized(printStream, this.header.flags, 1, "DDSD_CAPS");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 2, "DDSD_HEIGHT");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 4, "DDSD_WIDTH");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 8, "DDSD_PITCH");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 32, "DDSD_BACKBUFFERCOUNT");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 64, "DDSD_ZBUFFERBITDEPTH");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 128, "DDSD_ALPHABITDEPTH");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 2048, "DDSD_LPSURFACE");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 4096, "DDSD_PIXELFORMAT");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 131072, "DDSD_MIPMAPCOUNT");
        n2 |= this.printIfRecognized(printStream, this.header.flags, 524288, "DDSD_LINEARSIZE");
        if ((n2 |= this.printIfRecognized(printStream, this.header.flags, 0x800000, "DDSD_DEPTH")) == 0) {
            printStream.println("(none)");
        }
        printStream.println("Raw SurfaceDesc flags: 0x" + Integer.toHexString(this.header.flags));
        printStream.println("Pixel format flags:");
        n2 = 0;
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 1, "DDPF_ALPHAPIXELS");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 2, "DDPF_ALPHA");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 4, "DDPF_FOURCC");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 8, "DDPF_PALETTEINDEXED4");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 16, "DDPF_PALETTEINDEXEDTO8");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 32, "DDPF_PALETTEINDEXED8");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 64, "DDPF_RGB");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 128, "DDPF_COMPRESSED");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 256, "DDPF_RGBTOYUV");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 512, "DDPF_YUV");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 1024, "DDPF_ZBUFFER");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 2048, "DDPF_PALETTEINDEXED1");
        n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 4096, "DDPF_PALETTEINDEXED2");
        if ((n2 |= this.printIfRecognized(printStream, this.header.pfFlags, 8192, "DDPF_ZPIXELS")) == 0) {
            printStream.println("(none)");
        }
        printStream.println("Raw pixel format flags: 0x" + Integer.toHexString(this.header.pfFlags));
        printStream.println("Depth: " + this.getDepth());
        printStream.println("Number of mip maps: " + this.getNumMipMaps());
        int n3 = this.getPixelFormat();
        printStream.print("Pixel format: ");
        switch (n3) {
            case 20: {
                printStream.println("D3DFMT_R8G8B8");
                break;
            }
            case 21: {
                printStream.println("D3DFMT_A8R8G8B8");
                break;
            }
            case 22: {
                printStream.println("D3DFMT_X8R8G8B8");
                break;
            }
            case 827611204: {
                printStream.println("D3DFMT_DXT1");
                break;
            }
            case 844388420: {
                printStream.println("D3DFMT_DXT2");
                break;
            }
            case 861165636: {
                printStream.println("D3DFMT_DXT3");
                break;
            }
            case 877942852: {
                printStream.println("D3DFMT_DXT4");
                break;
            }
            case 894720068: {
                printStream.println("D3DFMT_DXT5");
                break;
            }
            case 0: {
                printStream.println("D3DFMT_UNKNOWN");
                break;
            }
            default: {
                printStream.println("(unknown pixel format " + n3 + ")");
            }
        }
    }

    private DDSImage() {
    }

    private void readFromFile(File file) throws IOException {
        this.fis = new FileInputStream(file);
        this.chan = this.fis.getChannel();
        MappedByteBuffer mappedByteBuffer = this.chan.map(FileChannel.MapMode.READ_ONLY, 0L, (int)file.length());
        this.readFromBuffer(mappedByteBuffer);
    }

    private void readFromBuffer(ByteBuffer byteBuffer) throws IOException {
        this.buf = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header = new Header();
        this.header.read(byteBuffer);
        this.fixupHeader();
    }

    private void initFromData(int n2, int n3, int n4, ByteBuffer[] byteBufferArray) throws IllegalArgumentException {
        int n5 = n3 * n4;
        int n6 = n3;
        boolean bl = false;
        switch (n2) {
            case 20: {
                n5 *= 3;
                n6 *= 3;
                break;
            }
            case 21: {
                n5 *= 4;
                n6 *= 4;
                break;
            }
            case 22: {
                n5 *= 4;
                n6 *= 4;
                break;
            }
            case 827611204: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: {
                n6 = n5 = DDSImage.computeCompressedBlockSize(n3, n4, 1, n2);
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("d3dFormat must be one of the known formats");
            }
        }
        int n7 = n5;
        int n8 = n3;
        int n9 = n4;
        int n10 = 0;
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            if (byteBufferArray[i2].remaining() != n7) {
                throw new IllegalArgumentException("Mipmap level " + i2 + " didn't match expected data size (expected " + n7 + ", got " + byteBufferArray[i2].remaining() + ")");
            }
            if (n8 > 1) {
                n8 /= 2;
            }
            if (n9 > 1) {
                n9 /= 2;
            }
            n7 = DDSImage.computeBlockSize(n8, n9, 1, n2);
            n10 += byteBufferArray[i2].remaining();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n10 += Header.writtenSize());
        byteBuffer.position(Header.writtenSize());
        for (int i3 = 0; i3 < byteBufferArray.length; ++i3) {
            byteBuffer.put(byteBufferArray[i3]);
        }
        this.buf = byteBuffer;
        this.header = new Header();
        this.header.size = Header.size();
        this.header.flags = 4103;
        if (byteBufferArray.length > 1) {
            this.header.flags |= 0x20000;
            this.header.mipMapCountOrAux = byteBufferArray.length;
        }
        this.header.width = n3;
        this.header.height = n4;
        if (bl) {
            this.header.flags |= 0x80000;
            this.header.pfFlags |= 4;
            this.header.pfFourCC = n2;
        } else {
            this.header.flags |= 8;
            this.header.pfFlags |= 0x40;
            switch (n2) {
                case 20: {
                    this.header.pfRGBBitCount = 24;
                    break;
                }
                case 21: {
                    this.header.pfRGBBitCount = 32;
                    this.header.pfFlags |= 1;
                    break;
                }
                case 22: {
                    this.header.pfRGBBitCount = 32;
                }
            }
            this.header.pfRBitMask = 0xFF0000;
            this.header.pfGBitMask = 65280;
            this.header.pfBBitMask = 255;
            if (n2 == 21) {
                this.header.pfABitMask = -16777216;
            }
        }
        this.header.pitchOrLinearSize = n6;
        this.header.pfSize = Header.pfSize();
    }

    private void fixupHeader() {
        if (this.isCompressed() && !this.isSurfaceDescFlagSet(524288)) {
            int n2 = this.header.backBufferCountOrDepth;
            if (n2 == 0) {
                n2 = 1;
            }
            this.header.pitchOrLinearSize = DDSImage.computeCompressedBlockSize(this.getWidth(), this.getHeight(), n2, this.getCompressionFormat());
            this.header.flags |= 0x80000;
        }
    }

    private static int computeCompressedBlockSize(int n2, int n3, int n4, int n5) {
        int n6 = (n2 + 3) / 4 * ((n3 + 3) / 4) * ((n4 + 3) / 4);
        switch (n5) {
            case 827611204: {
                n6 *= 8;
                break;
            }
            default: {
                n6 *= 16;
            }
        }
        return n6;
    }

    private static int computeBlockSize(int n2, int n3, int n4, int n5) {
        int n6;
        switch (n5) {
            case 20: {
                n6 = n2 * n3 * 3;
                break;
            }
            case 21: 
            case 22: {
                n6 = n2 * n3 * 4;
                break;
            }
            case 827611204: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: {
                n6 = DDSImage.computeCompressedBlockSize(n2, n3, 1, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException("d3dFormat must be one of the known formats");
            }
        }
        return n6;
    }

    private int mipMapWidth(int n2) {
        int n3 = this.getWidth();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 >>= 1;
        }
        return Math.max(n3, 1);
    }

    private int mipMapHeight(int n2) {
        int n3 = this.getHeight();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 >>= 1;
        }
        return Math.max(n3, 1);
    }

    private int mipMapSizeInBytes(int n2) {
        int n3 = this.mipMapWidth(n2);
        int n4 = this.mipMapHeight(n2);
        if (this.isCompressed()) {
            int n5 = this.getCompressionFormat() == 827611204 ? 8 : 16;
            return (n3 + 3) / 4 * ((n4 + 3) / 4) * n5;
        }
        return n3 * n4 * (this.getDepth() / 8);
    }

    private int sideSizeInBytes() {
        int n2 = this.getNumMipMaps();
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.mipMapSizeInBytes(i2);
        }
        return n3;
    }

    private int sideShiftInBytes(int n2) {
        int[] nArray = new int[]{1024, 2048, 4096, 8192, 16384, 32768};
        int n3 = 0;
        int n4 = this.sideSizeInBytes();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n5 = nArray[i2];
            if ((n5 & n2) != 0) {
                return n3;
            }
            n3 += n4;
        }
        throw new RuntimeException("Illegal side: " + n2);
    }

    private boolean printIfRecognized(PrintStream printStream, int n2, int n3, String string) {
        if ((n2 & n3) != 0) {
            printStream.println(string);
            return true;
        }
        return false;
    }

    static class Header {
        int size;
        int flags;
        int height;
        int width;
        int pitchOrLinearSize;
        int backBufferCountOrDepth;
        int mipMapCountOrAux;
        int alphaBitDepth;
        int reserved1;
        int surface;
        int colorSpaceLowValue;
        int colorSpaceHighValue;
        int destBltColorSpaceLowValue;
        int destBltColorSpaceHighValue;
        int srcOverlayColorSpaceLowValue;
        int srcOverlayColorSpaceHighValue;
        int srcBltColorSpaceLowValue;
        int srcBltColorSpaceHighValue;
        int pfSize;
        int pfFlags;
        int pfFourCC;
        int pfRGBBitCount;
        int pfRBitMask;
        int pfGBitMask;
        int pfBBitMask;
        int pfABitMask;
        int ddsCaps1;
        int ddsCaps2;
        int ddsCapsReserved1;
        int ddsCapsReserved2;
        int textureStage;

        Header() {
        }

        void read(ByteBuffer byteBuffer) throws IOException {
            int n2 = byteBuffer.getInt();
            if (n2 != 542327876) {
                throw new IOException("Incorrect magic number 0x" + Integer.toHexString(n2) + " (expected " + 542327876 + ")");
            }
            this.size = byteBuffer.getInt();
            this.flags = byteBuffer.getInt();
            this.height = byteBuffer.getInt();
            this.width = byteBuffer.getInt();
            this.pitchOrLinearSize = byteBuffer.getInt();
            this.backBufferCountOrDepth = byteBuffer.getInt();
            this.mipMapCountOrAux = byteBuffer.getInt();
            this.alphaBitDepth = byteBuffer.getInt();
            this.reserved1 = byteBuffer.getInt();
            this.surface = byteBuffer.getInt();
            this.colorSpaceLowValue = byteBuffer.getInt();
            this.colorSpaceHighValue = byteBuffer.getInt();
            this.destBltColorSpaceLowValue = byteBuffer.getInt();
            this.destBltColorSpaceHighValue = byteBuffer.getInt();
            this.srcOverlayColorSpaceLowValue = byteBuffer.getInt();
            this.srcOverlayColorSpaceHighValue = byteBuffer.getInt();
            this.srcBltColorSpaceLowValue = byteBuffer.getInt();
            this.srcBltColorSpaceHighValue = byteBuffer.getInt();
            this.pfSize = byteBuffer.getInt();
            this.pfFlags = byteBuffer.getInt();
            this.pfFourCC = byteBuffer.getInt();
            this.pfRGBBitCount = byteBuffer.getInt();
            this.pfRBitMask = byteBuffer.getInt();
            this.pfGBitMask = byteBuffer.getInt();
            this.pfBBitMask = byteBuffer.getInt();
            this.pfABitMask = byteBuffer.getInt();
            this.ddsCaps1 = byteBuffer.getInt();
            this.ddsCaps2 = byteBuffer.getInt();
            this.ddsCapsReserved1 = byteBuffer.getInt();
            this.ddsCapsReserved2 = byteBuffer.getInt();
            this.textureStage = byteBuffer.getInt();
        }

        void write(ByteBuffer byteBuffer) {
            byteBuffer.putInt(542327876);
            byteBuffer.putInt(this.size);
            byteBuffer.putInt(this.flags);
            byteBuffer.putInt(this.height);
            byteBuffer.putInt(this.width);
            byteBuffer.putInt(this.pitchOrLinearSize);
            byteBuffer.putInt(this.backBufferCountOrDepth);
            byteBuffer.putInt(this.mipMapCountOrAux);
            byteBuffer.putInt(this.alphaBitDepth);
            byteBuffer.putInt(this.reserved1);
            byteBuffer.putInt(this.surface);
            byteBuffer.putInt(this.colorSpaceLowValue);
            byteBuffer.putInt(this.colorSpaceHighValue);
            byteBuffer.putInt(this.destBltColorSpaceLowValue);
            byteBuffer.putInt(this.destBltColorSpaceHighValue);
            byteBuffer.putInt(this.srcOverlayColorSpaceLowValue);
            byteBuffer.putInt(this.srcOverlayColorSpaceHighValue);
            byteBuffer.putInt(this.srcBltColorSpaceLowValue);
            byteBuffer.putInt(this.srcBltColorSpaceHighValue);
            byteBuffer.putInt(this.pfSize);
            byteBuffer.putInt(this.pfFlags);
            byteBuffer.putInt(this.pfFourCC);
            byteBuffer.putInt(this.pfRGBBitCount);
            byteBuffer.putInt(this.pfRBitMask);
            byteBuffer.putInt(this.pfGBitMask);
            byteBuffer.putInt(this.pfBBitMask);
            byteBuffer.putInt(this.pfABitMask);
            byteBuffer.putInt(this.ddsCaps1);
            byteBuffer.putInt(this.ddsCaps2);
            byteBuffer.putInt(this.ddsCapsReserved1);
            byteBuffer.putInt(this.ddsCapsReserved2);
            byteBuffer.putInt(this.textureStage);
        }

        private static int size() {
            return 124;
        }

        private static int pfSize() {
            return 32;
        }

        private static int writtenSize() {
            return 128;
        }
    }

    public static class ImageInfo {
        private final ByteBuffer data;
        private final int width;
        private final int height;
        private final boolean isCompressed;
        private final int compressionFormat;

        public ImageInfo(ByteBuffer byteBuffer, int n2, int n3, boolean bl, int n4) {
            this.data = byteBuffer;
            this.width = n2;
            this.height = n3;
            this.isCompressed = bl;
            this.compressionFormat = n4;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public int getCompressionFormat() {
            if (!this.isCompressed()) {
                throw new RuntimeException("Should not call unless compressed");
            }
            return this.compressionFormat;
        }
    }
}

