/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicController;
import com.sun.media.CreateWorkThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.PlayThread;
import com.sun.media.SeekFailedEvent;
import com.sun.media.StatsThread;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.controls.SliderRegionControlAdapter;
import com.sun.media.ui.DefaultControlPanel;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DownloadProgressListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.ExtendedCachingControl;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;

public abstract class BasicPlayer
extends BasicController
implements Player,
ControllerListener,
DownloadProgressListener {
    public static String VERSION = JMFI18N.getResource("mediaplayer.version");
    protected DataSource source = null;
    protected Vector controllerList = new Vector();
    private Vector optionalControllerList = new Vector();
    private Vector removedControllerList = new Vector();
    private Vector currentControllerList = new Vector();
    private Vector potentialEventsList = null;
    private Vector receivedEventList = new Vector();
    private boolean receivedAllEvents = false;
    private Vector configureEventList = new Vector();
    private Vector realizeEventList = new Vector();
    private Vector prefetchEventList = new Vector();
    private Vector stopEventList = new Vector();
    private ControllerEvent CachingControlEvent = null;
    private Controller restartFrom = null;
    private Vector eomEventsReceivedFrom = new Vector();
    private Vector stopAtTimeReceivedFrom = new Vector();
    private PlayThread playThread = null;
    private StatsThread statsThread = null;
    private Time duration = Duration.DURATION_UNKNOWN;
    private Time startTime;
    private Time mediaTimeAtStart;
    private boolean aboutToRestart = false;
    private boolean closing = false;
    private boolean prefetchFailed = false;
    protected boolean framePositioning = true;
    protected Control[] controls = null;
    protected Component controlComp = null;
    public SliderRegionControl regionControl = null;
    protected CachingControl cachingControl = null;
    protected ExtendedCachingControl extendedCachingControl = null;
    protected BufferControl bufferControl = null;
    private Object startSync = new Object();
    private Object mediaTimeSync = new Object();
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    long lastTime = 0L;
    static final int LOCAL_STOP = 0;
    static final int STOP_BY_REQUEST = 1;
    static final int RESTARTING = 2;
    static /* synthetic */ Class class$com$sun$media$PlayThread;
    static /* synthetic */ Class class$com$sun$media$BasicPlayer;
    static /* synthetic */ Class class$com$sun$media$StatsThread;

    public BasicPlayer() {
        this.configureEventList.addElement("javax.media.ConfigureCompleteEvent");
        this.configureEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.realizeEventList.addElement("javax.media.RealizeCompleteEvent");
        this.realizeEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.prefetchEventList.addElement("javax.media.PrefetchCompleteEvent");
        this.prefetchEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.stopEventList.addElement("javax.media.StopEvent");
        this.stopEventList.addElement("javax.media.StopByRequestEvent");
        this.stopEventList.addElement("javax.media.StopAtTimeEvent");
        this.stopThreadEnabled = false;
    }

    public boolean isFramePositionable() {
        return this.framePositioning;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        this.source = source;
        try {
            this.cachingControl = (CachingControl)source.getControl("javax.media.CachingControl");
            if (this.cachingControl != null && this.cachingControl instanceof ExtendedCachingControl) {
                this.extendedCachingControl = (ExtendedCachingControl)this.cachingControl;
                if (this.extendedCachingControl != null) {
                    this.regionControl = new SliderRegionControlAdapter();
                    this.extendedCachingControl.addDownloadProgressListener(this, 100);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void downloadUpdate() {
        int maxValuePercent;
        if (this.extendedCachingControl == null) {
            return;
        }
        this.sendEvent(new CachingControlEvent(this, this.cachingControl, this.cachingControl.getContentProgress()));
        if (this.regionControl == null) {
            return;
        }
        long contentLength = this.cachingControl.getContentLength();
        if (contentLength == -1L || contentLength <= 0L) {
            maxValuePercent = 0;
        } else {
            long endOffset = this.extendedCachingControl.getEndOffset();
            maxValuePercent = (int)(100.0 * (double)endOffset / (double)contentLength);
            if (maxValuePercent < 0) {
                maxValuePercent = 0;
            } else if (maxValuePercent > 100) {
                maxValuePercent = 100;
            }
        }
        this.regionControl.setMinValue(0L);
        this.regionControl.setMaxValue(maxValuePercent);
    }

    public MediaLocator getMediaLocator() {
        if (this.source != null) {
            return this.source.getLocator();
        }
        return null;
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    protected DataSource getSource() {
        return this.source;
    }

    protected void doClose() {
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.closing = true;
            this.notifyAll();
        }
        if (this.getState() == 600) {
            this.stop(0);
        }
        if (this.controllerList != null) {
            while (!this.controllerList.isEmpty()) {
                Controller c2 = (Controller)this.controllerList.firstElement();
                c2.close();
                this.controllerList.removeElement(c2);
            }
        }
        if (this.controlComp != null) {
            ((DefaultControlPanel)this.controlComp).dispose();
        }
        this.controlComp = null;
        if (this.statsThread != null) {
            this.statsThread.kill();
        }
        this.sendEvent(new ControllerClosedEvent(this));
    }

    /*
     * Unable to fully structure code
     */
    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        block6: {
            oldTimeBase = this.getMasterTimeBase();
            if (tb == null) {
                tb = oldTimeBase;
            }
            c = null;
            if (this.controllerList != null) {
                try {
                    i = this.controllerList.size();
                    while (--i >= 0) {
                        c = (Controller)this.controllerList.elementAt(i);
                        c.setTimeBase(tb);
                    }
                    break block6;
                }
                catch (IncompatibleTimeBaseException e) {
                    i = this.controllerList.size();
                    ** while (--i >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    cx = (Controller)this.controllerList.elementAt(i);
                    if (cx == c) break;
                    cx.setTimeBase(oldTimeBase);
                    continue;
                }
lbl20:
                // 2 sources

                Log.dumpStack(e);
                throw e;
            }
        }
        super.setTimeBase(tb);
    }

    protected void setMediaLength(long t) {
        this.duration = new Time(t);
        super.setMediaLength(t);
    }

    public Time getDuration() {
        long t = this.getMediaNanoseconds();
        if (t > this.lastTime) {
            this.lastTime = t;
            this.updateDuration();
        }
        return this.duration;
    }

    protected synchronized void updateDuration() {
        Time oldDuration = this.duration;
        this.duration = Duration.DURATION_UNKNOWN;
        int i2 = 0;
        while (i2 < this.controllerList.size()) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            Time dur = c2.getDuration();
            if (dur.equals(Duration.DURATION_UNKNOWN)) {
                if (!(c2 instanceof BasicController)) {
                    this.duration = Duration.DURATION_UNKNOWN;
                    break;
                }
            } else {
                if (dur.equals(Duration.DURATION_UNBOUNDED)) {
                    this.duration = Duration.DURATION_UNBOUNDED;
                    break;
                }
                if (this.duration.equals(Duration.DURATION_UNKNOWN)) {
                    this.duration = dur;
                } else if (this.duration.getNanoseconds() < dur.getNanoseconds()) {
                    this.duration = dur;
                }
            }
            ++i2;
        }
        if (this.duration.getNanoseconds() != oldDuration.getNanoseconds()) {
            this.setMediaLength(this.duration.getNanoseconds());
            this.sendEvent(new DurationUpdateEvent(this, this.duration));
        }
    }

    public Time getStartLatency() {
        super.getStartLatency();
        long t = 0L;
        int i2 = 0;
        while (i2 < this.controllerList.size()) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            Time latency = c2.getStartLatency();
            if (latency != Controller.LATENCY_UNKNOWN && latency.getNanoseconds() > t) {
                t = latency.getNanoseconds();
            }
            ++i2;
        }
        if (t == 0L) {
            return Controller.LATENCY_UNKNOWN;
        }
        return new Time(t);
    }

    protected void stopAtTime() {
    }

    protected void controllerStopAtTime() {
        super.stopAtTime();
    }

    public void setStopTime(Time t) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getClock().getStopTime() == null || this.getClock().getStopTime().getNanoseconds() != t.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, t));
        }
        this.doSetStopTime(t);
    }

    private void doSetStopTime(Time t) {
        this.getClock().setStopTime(t);
        Vector list = this.controllerList;
        int i2 = list.size();
        while (--i2 >= 0) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            c2.setStopTime(t);
        }
    }

    protected void controllerSetStopTime(Time t) {
        super.setStopTime(t);
    }

    public final void setMediaTime(Time now) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(BasicController.MediaTimeError));
        }
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                return;
            }
            if (this.getState() == 600) {
                this.aboutToRestart = true;
                this.stop(2);
            }
            if (this.source instanceof Positionable) {
                now = ((Positionable)((Object)this.source)).setPosition(now, 2);
            }
            super.setMediaTime(now);
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                ((Controller)this.controllerList.elementAt(i2)).setMediaTime(now);
            }
            this.doSetMediaTime(now);
            if (this.aboutToRestart) {
                this.syncStart(this.getTimeBase().getTime());
                this.aboutToRestart = false;
            }
        }
    }

    public boolean isAboutToRestart() {
        return this.aboutToRestart;
    }

    protected void doSetMediaTime(Time now) {
    }

    public Component getVisualComponent() {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot get visual component on an unrealized player"));
        }
        return null;
    }

    public Component getControlPanelComponent() {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot get control panel component on an unrealized player"));
        }
        if (this.controlComp == null) {
            this.controlComp = new DefaultControlPanel(this);
        }
        return this.controlComp;
    }

    public GainControl getGainControl() {
        int state = this.getState();
        if (state >= 300) {
            return (GainControl)this.getControl("javax.media.GainControl");
        }
        this.throwError(new NotRealizedError("Cannot get gain control on an unrealized player"));
        return null;
    }

    public Control[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> cv = new Vector<Control>();
        if (this.cachingControl != null) {
            cv.addElement(this.cachingControl);
        }
        if (this.bufferControl != null) {
            cv.addElement(this.bufferControl);
        }
        int size = this.controllerList.size();
        int i2 = 0;
        while (i2 < size) {
            Controller ctrller = (Controller)this.controllerList.elementAt(i2);
            Control[] cs = ctrller.getControls();
            if (cs != null) {
                int j2 = 0;
                while (j2 < cs.length) {
                    cv.addElement(cs[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        size = cv.size();
        Control[] ctrls = new Control[size];
        i2 = 0;
        while (i2 < size) {
            ctrls[i2] = (Control)cv.elementAt(i2);
            ++i2;
        }
        if (this.getState() >= 300) {
            this.controls = ctrls;
        }
        return ctrls;
    }

    public final void controllerUpdate(ControllerEvent evt) {
        this.processEvent(evt);
    }

    public final Vector getControllerList() {
        return this.controllerList;
    }

    private Vector getPotentialEventsList() {
        return this.potentialEventsList;
    }

    private void resetReceivedEventList() {
        if (this.receivedEventList != null) {
            this.receivedEventList.removeAllElements();
        }
    }

    private Vector getReceivedEventsList() {
        return this.receivedEventList;
    }

    private void updateReceivedEventsList(ControllerEvent event2) {
        if (this.receivedEventList != null) {
            Controller source = event2.getSourceController();
            if (this.receivedEventList.contains(source)) {
                return;
            }
            this.receivedEventList.addElement(source);
        }
    }

    public final void start() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.restartFrom != null) {
                return;
            }
            if (this.getState() == 600) {
                this.sendEvent(new StartEvent(this, 600, 600, 600, this.mediaTimeAtStart, this.startTime));
                return;
            }
            if (this.playThread == null || !this.playThread.isAlive()) {
                this.setTargetState(600);
                if (jmfSecurity != null) {
                    String permission = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            permission = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            permission = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable e2) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        Constructor cons = CreateWorkThreadAction.cons;
                        this.playThread = (PlayThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$PlayThread == null ? (class$com$sun$media$PlayThread = BasicPlayer.class$("com.sun.media.PlayThread")) : class$com$sun$media$PlayThread, class$com$sun$media$BasicPlayer == null ? (class$com$sun$media$BasicPlayer = BasicPlayer.class$("com.sun.media.BasicPlayer")) : class$com$sun$media$BasicPlayer, this));
                        this.playThread.start();
                    }
                    catch (Exception exception) {}
                } else {
                    this.playThread = new PlayThread(this);
                    this.playThread.start();
                }
            }
        }
    }

    public final void syncStart(Time tbt) {
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                return;
            }
            int state = this.getState();
            if (state == 600) {
                this.throwError(new ClockStartedError("syncStart() cannot be used on an already started player"));
            }
            if (state != 500) {
                this.throwError(new NotPrefetchedError("Cannot start player before it has been prefetched"));
            }
            this.eomEventsReceivedFrom.removeAllElements();
            this.stopAtTimeReceivedFrom.removeAllElements();
            this.setTargetState(600);
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                if (this.getTargetState() != 600) continue;
                ((Controller)this.controllerList.elementAt(i2)).syncStart(tbt);
            }
            if (this.getTargetState() == 600) {
                this.startTime = tbt;
                this.mediaTimeAtStart = this.getMediaTime();
                super.syncStart(tbt);
            }
        }
    }

    protected void doStart() {
    }

    final synchronized void play() {
        if (this.getTargetState() != 600) {
            return;
        }
        this.prefetchFailed = false;
        int state = this.getState();
        if (state == 100 || state == 180 || state == 300) {
            this.prefetch();
        }
        while (!(this.closing || this.prefetchFailed || this.getState() != 140 && this.getState() != 200 && this.getState() != 300 && this.getState() != 400)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getState() != 600 && this.getTargetState() == 600 && this.getState() == 500) {
            this.syncStart(this.getTimeBase().getTime());
        }
    }

    protected void doStop() {
    }

    public final void stop() {
        this.stop(1);
    }

    private void stop(int stopType) {
        int state = this.getState();
        switch (state) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(state);
                break;
            }
            case 200: {
                this.setTargetState(300);
                break;
            }
            case 400: 
            case 600: {
                this.setTargetState(500);
            }
        }
        if (this.getState() != 600) {
            switch (stopType) {
                case 1: {
                    this.sendEvent(new StopByRequestEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
                case 2: {
                    this.sendEvent(new RestartingEvent(this, this.getState(), this.getState(), 600, this.getMediaTime()));
                    break;
                }
                default: {
                    this.sendEvent(new StopEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
            }
        } else if (this.getState() == 600) {
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.potentialEventsList = this.stopEventList;
                this.resetReceivedEventList();
                this.receivedAllEvents = false;
                this.currentControllerList.removeAllElements();
                int i2 = this.controllerList.size();
                while (--i2 >= 0) {
                    Controller c2 = (Controller)this.controllerList.elementAt(i2);
                    this.currentControllerList.addElement(c2);
                    c2.stop();
                }
                if (this.currentControllerList == null) {
                    return;
                }
                if (!this.currentControllerList.isEmpty()) {
                    try {
                        while (!this.closing && !this.receivedAllEvents) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    this.currentControllerList.removeAllElements();
                }
                super.stop();
                switch (stopType) {
                    case 1: {
                        this.sendEvent(new StopByRequestEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                        break;
                    }
                    case 2: {
                        this.sendEvent(new RestartingEvent(this, 600, this.getState(), 600, this.getMediaTime()));
                        break;
                    }
                    default: {
                        this.sendEvent(new StopEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                    }
                }
            }
        }
    }

    protected final void processEndOfMedia() {
        super.stop();
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected final void manageController(Controller controller) {
        this.manageController(controller, false);
    }

    protected final void manageController(Controller controller, boolean optional) {
        if (controller != null && !this.controllerList.contains(controller)) {
            this.controllerList.addElement(controller);
            if (optional) {
                this.optionalControllerList.addElement(controller);
            }
            controller.addControllerListener(this);
        }
        this.updateDuration();
    }

    public final void unmanageController(Controller controller) {
        if (controller != null && this.controllerList.contains(controller)) {
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
        }
    }

    public synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        int playerState = this.getState();
        if (playerState == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (playerState == 100 || playerState == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        if (newController == null || newController == this) {
            return;
        }
        int controllerState = newController.getState();
        if (controllerState == 100 || controllerState == 200) {
            this.throwError(new NotRealizedError("An Unrealized Controller cannot be added to a Player"));
        }
        if (this.controllerList.contains(newController)) {
            return;
        }
        if (playerState == 500 && (controllerState == 300 || controllerState == 400)) {
            this.deallocate();
        }
        this.manageController(newController);
        newController.setTimeBase(this.getTimeBase());
        newController.setMediaTime(this.getMediaTime());
        newController.setStopTime(this.getStopTime());
        if (newController.setRate(this.getRate()) != this.getRate()) {
            this.setRate(1.0f);
        }
    }

    public final synchronized void removeController(Controller oldController) {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot remove controller from a unrealized player"));
        }
        if (state == 600) {
            this.throwError(new ClockStartedError("Cannot remove controller from a started player"));
        }
        if (oldController == null) {
            return;
        }
        if (this.controllerList.contains(oldController)) {
            this.controllerList.removeElement(oldController);
            oldController.removeControllerListener(this);
            this.updateDuration();
            try {
                oldController.setTimeBase(null);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                // empty catch block
            }
        }
    }

    protected abstract boolean audioEnabled();

    protected abstract boolean videoEnabled();

    protected abstract TimeBase getMasterTimeBase();

    protected synchronized boolean doConfigure() {
        Controller c2;
        this.potentialEventsList = this.configureEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.getState() != 100 || !(c2 instanceof Processor) && !(c2 instanceof BasicController)) continue;
            this.currentControllerList.addElement(c2);
        }
        i2 = this.currentControllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.currentControllerList.elementAt(i2);
            if (c2 instanceof Processor) {
                ((Processor)c2).configure();
                continue;
            }
            if (!(c2 instanceof BasicController)) continue;
            ((BasicController)c2).configure();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            this.currentControllerList.removeAllElements();
        }
        i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (!(c2 instanceof Processor) && !(c2 instanceof BasicController) || c2.getState() >= 180) continue;
            Log.error("Error: Unable to configure " + c2);
            this.source.disconnect();
            return false;
        }
        return true;
    }

    protected void completeConfigure() {
        super.completeConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void doFailedConfigure() {
        super.doFailedConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    protected synchronized boolean doRealize() {
        Controller c2;
        this.potentialEventsList = this.realizeEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.getState() != 100 && c2.getState() != 180) continue;
            this.currentControllerList.addElement(c2);
        }
        i2 = this.currentControllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.currentControllerList.elementAt(i2);
            c2.realize();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            this.currentControllerList.removeAllElements();
        }
        i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.getState() >= 300) continue;
            Log.error("Error: Unable to realize " + c2);
            this.source.disconnect();
            return false;
        }
        this.updateDuration();
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception e3) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = CreateWorkThreadAction.cons;
                this.statsThread = (StatsThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$StatsThread == null ? (class$com$sun$media$StatsThread = BasicPlayer.class$("com.sun.media.StatsThread")) : class$com$sun$media$StatsThread, class$com$sun$media$BasicPlayer == null ? (class$com$sun$media$BasicPlayer = BasicPlayer.class$("com.sun.media.BasicPlayer")) : class$com$sun$media$BasicPlayer, this));
                this.statsThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.statsThread = new StatsThread(this);
            this.statsThread.start();
        }
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException e2) {
            Log.error(e2);
        }
        super.completeRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void doFailedRealize() {
        super.doFailedRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    protected void completePrefetch() {
        super.completePrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void doFailedPrefetch() {
        super.doFailedPrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected final void abortRealize() {
        if (this.controllerList != null) {
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                Controller c2 = (Controller)this.controllerList.elementAt(i2);
                c2.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected boolean doPrefetch() {
        Controller c2;
        this.potentialEventsList = this.prefetchEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        Vector list = this.controllerList;
        if (list == null) {
            return false;
        }
        int i2 = list.size();
        while (--i2 >= 0) {
            c2 = (Controller)list.elementAt(i2);
            if (c2.getState() != 300) continue;
            this.currentControllerList.addElement(c2);
            c2.prefetch();
        }
        if (!this.currentControllerList.isEmpty()) {
            c2 = this;
            synchronized (c2) {
                try {
                    while (!this.closing && !this.receivedAllEvents) {
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                this.currentControllerList.removeAllElements();
            }
        }
        i2 = list.size();
        while (--i2 >= 0) {
            c2 = (Controller)list.elementAt(i2);
            if (c2.getState() >= 500) continue;
            Log.error("Error: Unable to prefetch " + c2 + "\n");
            if (this.optionalControllerList.contains(c2)) {
                this.removedControllerList.addElement(c2);
                continue;
            }
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.prefetchFailed = true;
                this.notifyAll();
            }
            return false;
        }
        if (this.removedControllerList != null) {
            i2 = this.removedControllerList.size();
            while (--i2 >= 0) {
                Object o2 = this.removedControllerList.elementAt(i2);
                this.controllerList.removeElement(o2);
                ((BasicController)o2).close();
                if (this.deviceBusy((BasicController)o2)) continue;
                BasicPlayer basicPlayer = this;
                synchronized (basicPlayer) {
                    this.prefetchFailed = true;
                    this.notifyAll();
                }
                return false;
            }
            this.removedControllerList.removeAllElements();
        }
        return true;
    }

    protected final void abortPrefetch() {
        if (this.controllerList != null) {
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                Controller c2 = (Controller)this.controllerList.elementAt(i2);
                c2.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected boolean deviceBusy(BasicController mc) {
        return true;
    }

    protected void slaveToMasterTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.setTimeBase(tb);
    }

    private void notifyIfAllEventsArrived(Vector controllerList, Vector receivedEventList) {
        if (receivedEventList != null && receivedEventList.size() == this.currentControllerList.size()) {
            this.receivedAllEvents = true;
            this.resetReceivedEventList();
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.notifyAll();
            }
        }
    }

    protected void processEvent(ControllerEvent evt) {
        Controller c2;
        int ii;
        int i2;
        Controller source = evt.getSourceController();
        if (evt instanceof AudioDeviceUnavailableEvent) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            return;
        }
        if (evt instanceof ControllerClosedEvent && !this.closing && this.controllerList.contains(source) && !(evt instanceof ResourceUnavailableEvent)) {
            this.controllerList.removeElement(source);
            if (evt instanceof ControllerErrorEvent) {
                this.sendEvent(new ControllerErrorEvent(this, ((ControllerErrorEvent)evt).getMessage()));
            }
            this.close();
        }
        if (evt instanceof SizeChangeEvent && this.controllerList.contains(source)) {
            this.sendEvent(new SizeChangeEvent(this, ((SizeChangeEvent)evt).getWidth(), ((SizeChangeEvent)evt).getHeight(), ((SizeChangeEvent)evt).getScale()));
            return;
        }
        if (evt instanceof DurationUpdateEvent && this.controllerList.contains(source)) {
            this.updateDuration();
            return;
        }
        if (evt instanceof RestartingEvent && this.controllerList.contains(source)) {
            this.restartFrom = source;
            i2 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            ii = 0;
            while (ii < i2) {
                c2 = (Controller)this.controllerList.elementAt(ii);
                if (c2 != source) {
                    c2.stop();
                }
                ++ii;
            }
            super.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        }
        if (evt instanceof StartEvent && source == this.restartFrom) {
            this.restartFrom = null;
            this.start();
        }
        if (evt instanceof SeekFailedEvent && this.controllerList.contains(source)) {
            i2 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            ii = 0;
            while (ii < i2) {
                c2 = (Controller)this.controllerList.elementAt(ii);
                if (c2 != source) {
                    c2.stop();
                }
                ++ii;
            }
            this.sendEvent(new SeekFailedEvent(this, 600, 500, 500, this.getMediaTime()));
        }
        if (evt instanceof EndOfMediaEvent && this.controllerList.contains(source)) {
            if (this.eomEventsReceivedFrom.contains(source)) {
                return;
            }
            this.eomEventsReceivedFrom.addElement(source);
            if (this.eomEventsReceivedFrom.size() == this.controllerList.size()) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
            return;
        }
        if (evt instanceof StopAtTimeEvent && this.controllerList.contains(source) && this.getState() == 600) {
            Vector i3 = this.stopAtTimeReceivedFrom;
            synchronized (i3) {
                boolean allStopped;
                if (this.stopAtTimeReceivedFrom.contains(source)) {
                    return;
                }
                this.stopAtTimeReceivedFrom.addElement(source);
                boolean bl = allStopped = this.stopAtTimeReceivedFrom.size() == this.controllerList.size();
                if (!allStopped) {
                    allStopped = true;
                    int i4 = 0;
                    while (i4 < this.controllerList.size()) {
                        Controller c3 = (Controller)this.controllerList.elementAt(i4);
                        if (!this.stopAtTimeReceivedFrom.contains(c3) && !this.eomEventsReceivedFrom.contains(c3)) {
                            allStopped = false;
                            break;
                        }
                        ++i4;
                    }
                }
                if (allStopped) {
                    super.stop();
                    this.doSetStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                }
                return;
            }
        }
        if (evt instanceof CachingControlEvent && this.controllerList.contains(source)) {
            CachingControl mcc = ((CachingControlEvent)evt).getCachingControl();
            this.sendEvent(new CachingControlEvent(this, mcc, mcc.getContentProgress()));
            return;
        }
        Vector eventList = this.potentialEventsList;
        if (this.controllerList != null && this.controllerList.contains(source) && eventList != null && eventList.contains(evt.getClass().getName())) {
            this.updateReceivedEventsList(evt);
            this.notifyIfAllEventsArrived(this.controllerList, this.getReceivedEventsList());
        }
    }

    private boolean trySetRate(float rate) {
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.setRate(rate) == rate) continue;
            return false;
        }
        return true;
    }

    protected float doSetRate(float factor) {
        return factor;
    }

    public float setRate(float rate) {
        float rateSet;
        float oldRate;
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        if (this.source instanceof RateConfigureable) {
            rate = this.checkRateConfig((RateConfigureable)((Object)this.source), rate);
        }
        if ((oldRate = this.getRate()) == rate) {
            return rate;
        }
        if (this.getState() == 600) {
            this.aboutToRestart = true;
            this.stop(2);
        }
        if (!this.trySetRate(rate)) {
            if (!this.trySetRate(oldRate)) {
                this.trySetRate(1.0f);
                rateSet = 1.0f;
            } else {
                rateSet = oldRate;
            }
        } else {
            rateSet = rate;
        }
        super.setRate(rateSet);
        if (this.aboutToRestart) {
            this.syncStart(this.getTimeBase().getTime());
            this.aboutToRestart = false;
        }
        return rateSet;
    }

    float checkRateConfig(RateConfigureable rc, float rate) {
        RateConfiguration[] config = rc.getRateConfigurations();
        if (config == null) {
            return 1.0f;
        }
        float corrected = 1.0f;
        int i2 = 0;
        while (i2 < config.length) {
            RateRange rr = config[i2].getRate();
            if (rr != null && rr.inRange(rate)) {
                rr.setCurrentRate(rate);
                corrected = rate;
                RateConfiguration c2 = rc.setRateConfiguration(config[i2]);
                if (c2 == null || (rr = c2.getRate()) == null) break;
                corrected = rr.getCurrentRate();
                break;
            }
            ++i2;
        }
        return corrected;
    }

    public abstract void updateStats();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

