/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.DataSink;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.DataSource;

public abstract class BasicDataSink
implements DataSink {
    protected Vector listeners = new Vector(1);

    public void addDataSinkListener(DataSinkListener dsl) {
        if (dsl != null && !this.listeners.contains(dsl)) {
            this.listeners.addElement(dsl);
        }
    }

    public void removeDataSinkListener(DataSinkListener dsl) {
        if (dsl != null) {
            this.listeners.removeElement(dsl);
        }
    }

    protected void sendEvent(DataSinkEvent event2) {
        if (!this.listeners.isEmpty()) {
            Vector vector = this.listeners;
            synchronized (vector) {
                Enumeration list = this.listeners.elements();
                while (list.hasMoreElements()) {
                    DataSinkListener listener = (DataSinkListener)list.nextElement();
                    listener.dataSinkUpdate(event2);
                }
            }
        }
    }

    protected void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    protected final void sendEndofStreamEvent() {
        this.sendEvent(new EndOfStreamEvent(this));
    }

    protected final void sendDataSinkErrorEvent(String reason) {
        this.sendEvent(new DataSinkErrorEvent(this, reason));
    }

    public abstract String getContentType();

    public abstract void close();

    public abstract void open() throws IOException, SecurityException;

    public abstract void stop() throws IOException;

    public abstract void start() throws IOException;

    public abstract MediaLocator getOutputLocator();

    public abstract void setOutputLocator(MediaLocator var1);

    public abstract void setSource(DataSource var1) throws IOException, IncompatibleSourceException;

    public abstract Object getControl(String var1);

    public abstract Object[] getControls();
}

