/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.connection.Connection;
import com.willwinder.universalgcodesender.connection.ConnectionFactory;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.SerialCommunicatorListener;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.awt.EventQueue;
import java.util.ArrayList;

public abstract class AbstractCommunicator {
    public static String DEFAULT_TERMINATOR = "\r\n";
    protected Connection conn;
    ArrayList<SerialCommunicatorListener> commandSentListeners = new ArrayList();
    ArrayList<SerialCommunicatorListener> commandCompleteListeners = new ArrayList();
    ArrayList<SerialCommunicatorListener> commConsoleListeners = new ArrayList();
    ArrayList<SerialCommunicatorListener> commVerboseConsoleListeners = new ArrayList();
    ArrayList<SerialCommunicatorListener> commRawResponseListener = new ArrayList();
    protected static final int COMMAND_SENT = 1;
    protected static final int COMMAND_COMPLETE = 2;
    protected static final int RAW_RESPONSE = 3;
    protected static final int CONSOLE_MESSAGE = 4;
    protected static final int VERBOSE_CONSOLE_MESSAGE = 5;

    public abstract void setSingleStepMode(boolean var1);

    public abstract boolean getSingleStepMode();

    public abstract void queueStringForComm(String var1);

    public abstract void sendByteImmediately(byte var1) throws Exception;

    public abstract boolean areActiveCommands();

    public abstract void streamCommands();

    public abstract void pauseSend();

    public abstract void resumeSend();

    public abstract void cancelSend();

    public abstract void softReset();

    public abstract void responseMessage(String var1);

    protected boolean openCommPort(String name, int baud) throws Exception {
        this.conn = ConnectionFactory.getConnectionFor(name, baud);
        if (this.conn != null) {
            this.conn.setCommunicator(this);
        }
        if (this.conn == null) {
            throw new Exception(Localization.getString("communicator.exception.port") + ": " + name);
        }
        this.conn.openPort(name, baud);
        return true;
    }

    protected void closeCommPort() throws Exception {
        this.conn.closePort();
    }

    public abstract String getLineTerminator();

    void setListenAll(SerialCommunicatorListener scl) {
        this.addCommandSentListener(scl);
        this.addCommandCompleteListener(scl);
        this.addCommConsoleListener(scl);
        this.addCommVerboseConsoleListener(scl);
        this.addCommRawResponseListener(scl);
    }

    void addCommandSentListener(SerialCommunicatorListener scl) {
        this.commandSentListeners.add(scl);
    }

    void addCommandCompleteListener(SerialCommunicatorListener scl) {
        this.commandCompleteListeners.add(scl);
    }

    void addCommConsoleListener(SerialCommunicatorListener scl) {
        this.commConsoleListeners.add(scl);
    }

    void addCommVerboseConsoleListener(SerialCommunicatorListener scl) {
        this.commVerboseConsoleListeners.add(scl);
    }

    void addCommRawResponseListener(SerialCommunicatorListener scl) {
        this.commRawResponseListener.add(scl);
    }

    protected void sendMessageToConsoleListener(String msg) {
        this.sendMessageToConsoleListener(msg, false);
    }

    protected void sendMessageToConsoleListener(String msg, boolean verbose) {
        if (this.commConsoleListeners == null) {
            return;
        }
        int verbosity = !verbose ? 4 : 5;
        AbstractCommunicator.dispatchListenerEvents(verbosity, this.commConsoleListeners, msg);
    }

    protected static void dispatchListenerEvents(final int event2, final ArrayList<SerialCommunicatorListener> sclList, final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sclList != null) {
                    for (SerialCommunicatorListener s : sclList) {
                        AbstractCommunicator.sendEventToListener(event2, s, message, null);
                    }
                }
            }
        });
    }

    protected static void dispatchListenerEvents(final int event2, final ArrayList<SerialCommunicatorListener> sclList, final GcodeCommand command) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sclList != null) {
                    for (SerialCommunicatorListener s : sclList) {
                        AbstractCommunicator.sendEventToListener(event2, s, null, command);
                    }
                }
            }
        });
    }

    protected static void sendEventToListener(int event2, SerialCommunicatorListener scl, String string, GcodeCommand command) {
        switch (event2) {
            case 1: {
                scl.commandSent(string);
                break;
            }
            case 4: {
                scl.messageForConsole(string);
                break;
            }
            case 5: {
                scl.verboseMessageForConsole(string);
                break;
            }
            case 3: {
                scl.rawResponseListener(string);
            }
        }
    }
}

