/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.AbstractCommunicator;
import com.willwinder.universalgcodesender.GrblCommunicator;
import com.willwinder.universalgcodesender.IController;
import com.willwinder.universalgcodesender.gcode.GcodeCommandCreator;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.listeners.SerialCommunicatorListener;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.io.File;
import java.util.ArrayList;
import javax.vecmath.Point3d;

public abstract class AbstractController
implements SerialCommunicatorListener,
IController {
    protected AbstractCommunicator comm;
    protected GcodeCommandCreator commandCreator;
    private boolean statusUpdatesEnabled = true;
    private int statusUpdateRate = 200;
    private Boolean commOpen = false;
    private Boolean absoluteMode = true;
    private Boolean isStreaming = false;
    private Boolean paused = false;
    private long streamStart = 0L;
    private long streamStop = 0L;
    private File gcodeFile;
    private int numCommandsStreamed = 0;
    private int numCommandsSent = 0;
    private int numCommandsSkipped = 0;
    private int numCommandsCompleted = 0;
    private ArrayList<GcodeCommand> commands;
    private int outgoingQueueIdx;
    private int sentIdx;
    private int awaitingResponseIdx;
    private int completedCommandIdx;
    private int errorCount;
    private ArrayList<ControllerListener> listeners;

    protected abstract void closeCommBeforeEvent();

    protected abstract void closeCommAfterEvent();

    protected void openCommAfterEvent() throws Exception {
    }

    protected abstract void cancelSendBeforeEvent();

    protected abstract void cancelSendAfterEvent();

    protected abstract void pauseStreamingEvent() throws Exception;

    protected abstract void resumeStreamingEvent() throws Exception;

    protected abstract void isReadyToSendCommandsEvent() throws Exception;

    protected abstract void rawResponseHandler(String var1);

    @Override
    public void performHomingCycle() throws Exception {
        throw new Exception(Localization.getString("controller.exception.homing"));
    }

    @Override
    public void returnToHome() throws Exception {
        throw new Exception(Localization.getString("controller.exception.gohome"));
    }

    @Override
    public void resetCoordinatesToZero() throws Exception {
        throw new Exception(Localization.getString("controller.exception.reset"));
    }

    @Override
    public void resetCoordinateToZero(char coord) throws Exception {
        throw new Exception(Localization.getString("controller.exception.reset"));
    }

    @Override
    public void killAlarmLock() throws Exception {
        throw new Exception(Localization.getString("controller.exception.killalarm"));
    }

    @Override
    public void toggleCheckMode() throws Exception {
        throw new Exception(Localization.getString("controller.exception.checkmode"));
    }

    @Override
    public void viewParserState() throws Exception {
        throw new Exception(Localization.getString("controller.exception.parserstate"));
    }

    @Override
    public void issueSoftReset() throws Exception {
        this.flushSendQueues();
        this.softReset();
    }

    protected void softReset() throws Exception {
        throw new Exception(Localization.getString("controller.exception.softreset"));
    }

    protected abstract void statusUpdatesEnabledValueChanged(boolean var1);

    protected abstract void statusUpdatesRateValueChanged(int var1);

    @Override
    public GcodeCommandCreator getCommandCreator() {
        return this.commandCreator;
    }

    protected AbstractController(AbstractCommunicator comm) {
        this.comm = comm;
        this.comm.setListenAll(this);
        this.commands = new ArrayList();
        this.outgoingQueueIdx = 0;
        this.sentIdx = 0;
        this.awaitingResponseIdx = 0;
        this.completedCommandIdx = -1;
        this.listeners = new ArrayList();
    }

    @Deprecated
    public AbstractController() {
        this(new GrblCommunicator());
    }

    @Override
    public void setSingleStepMode(boolean enabled) {
        this.comm.setSingleStepMode(enabled);
    }

    @Override
    public boolean getSingleStepMode() {
        return this.comm.getSingleStepMode();
    }

    @Override
    public void setStatusUpdatesEnabled(boolean enabled) {
        if (this.statusUpdatesEnabled != enabled) {
            this.statusUpdatesEnabled = enabled;
            this.statusUpdatesEnabledValueChanged(enabled);
        }
    }

    @Override
    public boolean getStatusUpdatesEnabled() {
        return this.statusUpdatesEnabled;
    }

    @Override
    public void setStatusUpdateRate(int rate) {
        if (this.statusUpdateRate != rate) {
            this.statusUpdateRate = rate;
            this.statusUpdatesRateValueChanged(rate);
        }
    }

    @Override
    public int getStatusUpdateRate() {
        return this.statusUpdateRate;
    }

    @Override
    public Boolean openCommPort(String port, int portRate) throws Exception {
        if (this.commOpen.booleanValue()) {
            throw new Exception("Comm port is already open.");
        }
        this.commOpen = this.comm.openCommPort(port, portRate);
        if (this.commOpen.booleanValue()) {
            this.openCommAfterEvent();
            this.messageForConsole("**** Connected to " + port + " @ " + portRate + " baud ****\n");
        }
        return this.commOpen;
    }

    @Override
    public Boolean closeCommPort() throws Exception {
        if (!this.commOpen.booleanValue()) {
            return true;
        }
        this.closeCommBeforeEvent();
        this.messageForConsole("**** Connection closed ****\n");
        this.flushSendQueues();
        this.commandCreator.resetNum();
        this.comm.closeCommPort();
        this.commOpen = false;
        this.closeCommAfterEvent();
        return true;
    }

    @Override
    public Boolean isCommOpen() {
        return this.commOpen;
    }

    @Override
    public Boolean isStreamingFile() {
        return this.isStreaming;
    }

    @Override
    public long getSendDuration() {
        if (!this.isStreaming.booleanValue()) {
            return this.streamStop - this.streamStart;
        }
        if (this.streamStart == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.streamStart;
    }

    @Override
    public int rowsInQueue() {
        if (this.completedCommandIdx < 0) {
            return this.commands.size();
        }
        return this.commands.size() - this.completedCommandIdx;
    }

    @Override
    public int rowsInSend() {
        return this.numCommandsStreamed;
    }

    @Override
    public int rowsSent() {
        return this.numCommandsSent;
    }

    @Override
    public int rowsRemaining() {
        return this.numCommandsStreamed - this.numCommandsCompleted - this.numCommandsSkipped;
    }

    @Override
    public void sendCommandImmediately(String str) throws Exception {
        this.isReadyToSendCommandsEvent();
        if (!this.commOpen.booleanValue()) {
            throw new Exception("Cannot send command(s), comm port is not open.");
        }
        GcodeCommand command = this.commandCreator.createCommand(str);
        this.commands.add(this.outgoingQueueIdx, command);
        this.commandQueued(command);
        this.sendStringToComm(command.getCommandString());
    }

    private void prepCommandForCommAndSend(int idx) throws Exception {
        GcodeCommand command = this.commands.get(idx);
        if (this.outgoingQueueIdx == this.awaitingResponseIdx && command.hasComment()) {
            this.dispatchCommandCommment(command.getComment());
        }
        this.commandQueued(command);
        if (command.getCommandString().equals("")) {
            this.messageForConsole("Skipping command #" + command.getCommandNumber() + "\n");
            if (command.hasComment()) {
                command.setResponse("<comment skipped by application>");
            } else {
                command.setResponse("<skipped by application>");
            }
            command.setSkipped(true);
            this.commandComplete(command);
            this.dispatchCommandSent(command);
        } else {
            this.sendStringToComm(command.getCommandString());
        }
    }

    private void sendStringToComm(String command) {
        this.comm.queueStringForComm(command + "\n");
        ++this.numCommandsStreamed;
        this.comm.streamCommands();
    }

    @Override
    public Boolean isReadyToStreamFile() throws Exception {
        this.isReadyToSendCommandsEvent();
        if (!this.commOpen.booleanValue()) {
            throw new Exception("Cannot send command(s), comm port is not open.");
        }
        if (this.awaitingResponseIdx != this.outgoingQueueIdx) {
            throw new Exception("Cannot stream while there are active commands (controller).");
        }
        if (this.comm.areActiveCommands()) {
            throw new Exception("Cannot stream while there are active commands (communicator).");
        }
        return true;
    }

    @Override
    public void queueCommand(String str) throws Exception {
        GcodeCommand command = this.commandCreator.createCommand(str);
        this.commands.add(command);
    }

    @Override
    public void queueCommands(Iterable<String> commandStrings) throws Exception {
        for (String s : commandStrings) {
            this.queueCommand(s);
        }
    }

    @Override
    public void beginStreaming() throws Exception {
        this.isReadyToStreamFile();
        if (this.commands.size() <= this.outgoingQueueIdx) {
            throw new Exception("There are no commands queued for streaming.");
        }
        this.isStreaming = true;
        this.streamStop = 0L;
        this.streamStart = System.currentTimeMillis();
        this.numCommandsStreamed = 0;
        this.numCommandsSent = 0;
        this.numCommandsSkipped = 0;
        this.numCommandsCompleted = 0;
        try {
            while (this.outgoingQueueIdx < this.commands.size()) {
                this.prepCommandForCommAndSend(this.outgoingQueueIdx);
            }
            this.dispatchPostProcessData(this.numCommandsStreamed);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.isStreaming = false;
            this.streamStart = 0L;
            throw e2;
        }
    }

    @Override
    public void pauseStreaming() throws Exception {
        this.messageForConsole("\n**** Pausing file transfer. ****\n\n");
        this.pauseStreamingEvent();
        this.paused = true;
        this.comm.pauseSend();
    }

    @Override
    public void resumeStreaming() throws Exception {
        this.messageForConsole("\n**** Resuming file transfer. ****\n\n");
        this.resumeStreamingEvent();
        this.paused = false;
        this.comm.resumeSend();
    }

    @Override
    public void cancelSend() {
        this.messageForConsole("\n**** Canceling file transfer. ****\n\n");
        this.cancelSendBeforeEvent();
        this.flushQueuedCommands();
        this.comm.cancelSend();
        this.cancelSendAfterEvent();
    }

    private synchronized void flushQueuedCommands() {
        if (this.commands.size() > 0) {
            this.commands.subList(this.sentIdx, this.commands.size()).clear();
            this.outgoingQueueIdx = this.awaitingResponseIdx;
        }
    }

    private void flushSendQueues() {
        this.commands.clear();
        this.sentIdx = 0;
        this.outgoingQueueIdx = 0;
        this.awaitingResponseIdx = 0;
        this.completedCommandIdx = -1;
        this.errorCount = 0;
    }

    private void printStateOfQueues() {
        System.out.println("command queue size = " + this.commands.size());
        System.out.println("sentIdx = " + this.sentIdx);
        System.out.println("outgoingQueueIdx = " + this.outgoingQueueIdx);
        System.out.println("awaitingResponseIdx = " + this.awaitingResponseIdx);
        System.out.println("completedCommandIdx = " + this.completedCommandIdx);
        System.out.println("numErrors = " + this.errorCount);
        System.out.println("============");
    }

    private void commandQueued(GcodeCommand command) {
        ++this.outgoingQueueIdx;
        this.dispatchCommandQueued(command);
    }

    private void fileStreamComplete(String filename, boolean success) {
        this.messageForConsole("\n**** Finished sending file. ****\n\n");
        this.streamStop = System.currentTimeMillis();
        this.isStreaming = false;
        this.flushSendQueues();
        this.dispatchStreamComplete(filename, success);
    }

    @Override
    public void commandSent(String commandStr) {
        ++this.sentIdx;
        if (this.isStreamingFile().booleanValue()) {
            ++this.numCommandsSent;
        }
        GcodeCommand command = this.commands.get(this.awaitingResponseIdx++);
        while (command.isSkipped().booleanValue()) {
            command = this.commands.get(this.awaitingResponseIdx++);
            ++this.sentIdx;
        }
        if (!command.isSkipped().booleanValue()) {
            command.setSent(true);
        }
        if (!command.getCommandString().equals(commandStr)) {
            this.errorMessageForConsole("Command <" + command.getCommandString() + "> does not equal expected command <" + commandStr + ">");
        }
        this.dispatchCommandSent(command);
    }

    public void commandComplete(String response) throws UnexpectedCommand {
        if (this.commands.size() == this.completedCommandIdx + 1) {
            throw new UnexpectedCommand();
        }
        GcodeCommand command = this.commands.get(++this.completedCommandIdx);
        while (command.isSkipped().booleanValue() && this.completedCommandIdx < this.commands.size()) {
            command = this.commands.get(++this.completedCommandIdx);
        }
        command.setResponse(response);
        this.commandComplete(command);
    }

    private void commandComplete(GcodeCommand command) throws UnexpectedCommand {
        GcodeCommand c2 = command;
        if (!command.isSkipped().booleanValue()) {
            ++this.numCommandsCompleted;
            if (this.completedCommandIdx >= this.outgoingQueueIdx) {
                throw new UnexpectedCommand();
            }
            while (this.isStreamingFile().booleanValue() && this.completedCommandIdx + 1 < this.commands.size()) {
                GcodeCommand next = this.commands.get(this.completedCommandIdx + 1);
                if (next == null) continue;
                if (next.hasComment()) {
                    this.dispatchCommandCommment(next.getComment());
                }
                if (next.isSkipped().booleanValue()) {
                    ++this.completedCommandIdx;
                    continue;
                }
                break;
            }
        } else if (this.isStreamingFile().booleanValue()) {
            ++this.numCommandsSkipped;
        }
        this.dispatchCommandComplete(c2);
        if (this.isStreamingFile().booleanValue() && this.commands.size() <= this.outgoingQueueIdx && this.completedCommandIdx == this.commands.size() - 1) {
            String streamName = "queued commands";
            if (this.gcodeFile != null) {
                streamName = this.gcodeFile.getName();
            }
            boolean isSuccess = this.errorCount == 0;
            this.fileStreamComplete(streamName, isSuccess);
        }
    }

    @Override
    public void messageForConsole(String msg) {
        this.dispatchConsoleMessage(msg, Boolean.FALSE);
    }

    @Override
    public void verboseMessageForConsole(String msg) {
        this.dispatchConsoleMessage(msg, Boolean.TRUE);
    }

    @Override
    public void errorMessageForConsole(String msg) {
        this.dispatchConsoleMessage("[Error] " + msg, Boolean.TRUE);
    }

    @Override
    public void rawResponseListener(String response) {
        this.rawResponseHandler(response);
    }

    @Override
    public void addListener(ControllerListener cl) {
        this.listeners.add(cl);
    }

    protected void dispatchStatusString(String state, Point3d machine, Point3d work) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.statusStringListener(state, machine, work);
            }
        }
    }

    protected void dispatchConsoleMessage(String message, Boolean verbose) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.messageForConsole(message, verbose);
            }
        }
    }

    protected void dispatchStreamComplete(String filename, Boolean success) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.fileStreamComplete(filename, success);
            }
        }
    }

    protected void dispatchCommandQueued(GcodeCommand command) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.commandQueued(command);
            }
        }
    }

    protected void dispatchCommandSent(GcodeCommand command) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.commandSent(command);
            }
        }
    }

    protected void dispatchCommandComplete(GcodeCommand command) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.commandComplete(command);
            }
        }
    }

    protected void dispatchCommandCommment(String comment) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.commandComment(comment);
            }
        }
    }

    protected void dispatchPostProcessData(int numRows) {
        if (this.listeners != null) {
            for (ControllerListener c2 : this.listeners) {
                c2.postProcessData(numRows);
            }
        }
    }

    public class UnexpectedCommand
    extends Exception {
    }
}

