/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.AbstractCommunicator;
import com.willwinder.universalgcodesender.AbstractController;
import com.willwinder.universalgcodesender.GrblCommunicator;
import com.willwinder.universalgcodesender.GrblUtils;
import com.willwinder.universalgcodesender.gcode.GcodeCommandCreator;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.GrblSettingsListener;
import com.willwinder.universalgcodesender.model.Utils;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.vecmath.Point3d;

public class GrblController
extends AbstractController {
    private double grblVersion = 0.0;
    private String grblVersionLetter = null;
    private Boolean isReady = false;
    private GrblSettingsListener settings;
    private GrblUtils.Capabilities positionMode = null;
    private Boolean realTimeCapable = false;
    private String grblState;
    private Point3d machineLocation;
    private Point3d workLocation;
    private double maxZLocationMM;
    private Utils.Units units;
    private int outstandingPolls = 0;
    private Timer positionPollTimer = null;

    public GrblController(AbstractCommunicator comm) {
        super(comm);
        this.commandCreator = new GcodeCommandCreator();
        this.positionPollTimer = this.createPositionPollTimer();
        this.maxZLocationMM = -1.0;
        this.settings = new GrblSettingsListener(this);
    }

    public GrblController() {
        this(new GrblCommunicator());
    }

    @Override
    public long getJobLengthEstimate(Collection<String> jobLines) {
        return 0L;
    }

    @Override
    protected void rawResponseHandler(String response) {
        if (GcodeCommand.isOkErrorResponse(response).booleanValue()) {
            try {
                this.commandComplete(response);
            }
            catch (Exception e2) {
                this.errorMessageForConsole(Localization.getString("controller.error.response") + " <" + response + ">: " + e2.getMessage());
            }
            this.messageForConsole(response + "\n");
        } else if (GrblUtils.isGrblVersionString(response).booleanValue()) {
            this.messageForConsole(response + "\n");
            this.grblVersion = GrblUtils.getVersionDouble(response);
            this.grblVersionLetter = GrblUtils.getVersionLetter(response);
            this.isReady = true;
            this.realTimeCapable = GrblUtils.isRealTimeCapable(this.grblVersion);
            this.positionMode = GrblUtils.getGrblStatusCapabilities(this.grblVersion, this.grblVersionLetter);
            this.beginPollingPosition();
            Logger.getLogger(GrblController.class.getName()).log(Level.CONFIG, "{0} = {1}{2}", new Object[]{Localization.getString("controller.log.version"), this.grblVersion, this.grblVersionLetter});
            Logger.getLogger(GrblController.class.getName()).log(Level.CONFIG, "{0} = {1}", new Object[]{Localization.getString("controller.log.realtime"), this.realTimeCapable});
        } else if (GrblUtils.isGrblStatusString(response).booleanValue()) {
            this.outstandingPolls = 0;
            this.verboseMessageForConsole(response + "\n");
            this.handlePositionString(response);
        } else {
            this.messageForConsole(response + "\n");
        }
    }

    @Override
    protected void pauseStreamingEvent() throws Exception {
        if (this.realTimeCapable.booleanValue()) {
            this.comm.sendByteImmediately((byte)33);
        }
    }

    @Override
    protected void resumeStreamingEvent() throws Exception {
        if (this.realTimeCapable.booleanValue()) {
            this.comm.sendByteImmediately((byte)126);
        }
    }

    @Override
    protected void closeCommBeforeEvent() {
        this.stopPollingPosition();
    }

    @Override
    protected void closeCommAfterEvent() {
        this.grblVersion = 0.0;
        this.grblVersionLetter = null;
    }

    @Override
    protected void openCommAfterEvent() throws Exception {
        this.comm.sendByteImmediately((byte)24);
    }

    @Override
    protected void isReadyToSendCommandsEvent() throws Exception {
        if (!this.isReady.booleanValue()) {
            throw new Exception(Localization.getString("controller.exception.booting"));
        }
    }

    @Override
    protected void cancelSendBeforeEvent() {
        if (this.realTimeCapable.booleanValue()) {
            // empty if block
        }
    }

    @Override
    protected void cancelSendAfterEvent() {
    }

    @Override
    public void performHomingCycle() throws Exception {
        String command;
        if (this.isCommOpen().booleanValue() && !"".equals(command = GrblUtils.getHomingCommand(this.grblVersion, this.grblVersionLetter))) {
            this.sendCommandImmediately(command);
            return;
        }
        super.performHomingCycle();
    }

    @Override
    public void resetCoordinatesToZero() throws Exception {
        String command;
        if (this.isCommOpen().booleanValue() && !"".equals(command = GrblUtils.getResetCoordsToZeroCommand(this.grblVersion, this.grblVersionLetter))) {
            this.sendCommandImmediately(command);
            return;
        }
        super.resetCoordinatesToZero();
    }

    @Override
    public void resetCoordinateToZero(char coord) throws Exception {
        String command;
        if (this.isCommOpen().booleanValue() && !"".equals(command = GrblUtils.getResetCoordToZeroCommand(coord, this.grblVersion, this.grblVersionLetter))) {
            this.sendCommandImmediately(command);
            return;
        }
        super.resetCoordinatesToZero();
    }

    @Override
    public void returnToHome() throws Exception {
        if (this.isCommOpen().booleanValue()) {
            ArrayList<String> commands;
            double max = 0.0;
            if (this.maxZLocationMM != -1.0) {
                max = this.maxZLocationMM;
                if (this.units == Utils.Units.INCH) {
                    System.out.println("Converting max Z to INCH");
                    max = this.maxZLocationMM / 26.4;
                }
            }
            if (!(commands = GrblUtils.getReturnToHomeCommands(this.grblVersion, this.grblVersionLetter, max)).isEmpty()) {
                for (String command : commands) {
                    this.sendCommandImmediately(command);
                }
                return;
            }
        }
        super.returnToHome();
    }

    @Override
    public void killAlarmLock() throws Exception {
        String command;
        if (this.isCommOpen().booleanValue() && !"".equals(command = GrblUtils.getKillAlarmLockCommand(this.grblVersion, this.grblVersionLetter))) {
            this.sendCommandImmediately(command);
            return;
        }
        super.killAlarmLock();
    }

    @Override
    public void toggleCheckMode() throws Exception {
        String command;
        if (this.isCommOpen().booleanValue() && !"".equals(command = GrblUtils.getToggleCheckModeCommand(this.grblVersion, this.grblVersionLetter))) {
            this.sendCommandImmediately(command);
            return;
        }
        super.toggleCheckMode();
    }

    @Override
    public void viewParserState() throws Exception {
        String command;
        if (this.isCommOpen().booleanValue() && !"".equals(command = GrblUtils.getViewParserStateCommand(this.grblVersion, this.grblVersionLetter))) {
            this.sendCommandImmediately(command);
            return;
        }
        super.viewParserState();
    }

    @Override
    public void softReset() throws Exception {
        if (this.isCommOpen().booleanValue() && this.realTimeCapable.booleanValue()) {
            this.comm.sendByteImmediately((byte)24);
            this.comm.softReset();
        }
    }

    public String getGrblVersion() {
        if (this.isCommOpen().booleanValue()) {
            StringBuilder str = new StringBuilder();
            str.append("Grbl ");
            if (this.grblVersion > 0.0) {
                str.append(this.grblVersion);
            }
            if (this.grblVersionLetter != null) {
                str.append(this.grblVersionLetter);
            }
            if (this.grblVersion <= 0.0 && this.grblVersionLetter == null) {
                str.append("<").append(Localization.getString("unknown")).append(">");
            }
            return str.toString();
        }
        return "<" + Localization.getString("controller.log.notconnected") + ">";
    }

    private Timer createPositionPollTimer() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (GrblController.this.outstandingPolls == 0) {
                                GrblController.this.outstandingPolls++;
                                GrblController.this.comm.sendByteImmediately((byte)63);
                            } else {
                                GrblController.this.outstandingPolls++;
                                if (GrblController.this.outstandingPolls >= 20) {
                                    GrblController.this.outstandingPolls = 0;
                                }
                            }
                        }
                        catch (Exception ex) {
                            GrblController.this.messageForConsole(Localization.getString("controller.exception.sendingstatus") + ": " + ex.getMessage() + "\n");
                        }
                    }
                });
            }
        };
        return new Timer(this.getStatusUpdateRate(), actionListener);
    }

    private void beginPollingPosition() {
        if (this.positionMode != null && this.getStatusUpdatesEnabled() && !this.positionPollTimer.isRunning()) {
            this.outstandingPolls = 0;
            this.positionPollTimer.start();
        }
    }

    private void stopPollingPosition() {
        if (this.positionPollTimer.isRunning()) {
            this.positionPollTimer.stop();
        }
    }

    private void handlePositionString(String string) {
        if (this.positionMode != null) {
            this.grblState = GrblUtils.getStateFromStatusString(string, this.positionMode);
            this.machineLocation = GrblUtils.getMachinePositionFromStatusString(string, this.positionMode);
            this.workLocation = GrblUtils.getWorkPositionFromStatusString(string, this.positionMode);
            if (this.machineLocation != null) {
                Utils.Units u = GrblUtils.getUnitsFromStatusString(string, this.positionMode);
                double zLocationMM = this.machineLocation.z;
                if (u == Utils.Units.INCH) {
                    zLocationMM *= 26.4;
                }
                if (zLocationMM > this.maxZLocationMM) {
                    this.maxZLocationMM = zLocationMM;
                }
            }
            this.dispatchStatusString(this.grblState, this.machineLocation, this.workLocation);
        }
    }

    @Override
    protected void statusUpdatesEnabledValueChanged(boolean enabled) {
        if (enabled) {
            this.beginPollingPosition();
        } else {
            this.stopPollingPosition();
        }
    }

    @Override
    protected void statusUpdatesRateValueChanged(int rate) {
        this.stopPollingPosition();
        this.positionPollTimer = this.createPositionPollTimer();
        this.beginPollingPosition();
    }

    @Override
    public void currentUnits(Utils.Units units) {
        this.units = units;
    }
}

