/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.AbstractController;
import com.willwinder.universalgcodesender.GrblController;
import com.willwinder.universalgcodesender.Utils;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.ControlStateListener;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.model.BackendAPI;
import com.willwinder.universalgcodesender.model.ControlStateEvent;
import com.willwinder.universalgcodesender.model.GUIBackend;
import com.willwinder.universalgcodesender.model.Utils;
import com.willwinder.universalgcodesender.pendantui.PendantUI;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import com.willwinder.universalgcodesender.uielements.ConnectionSettingsDialog;
import com.willwinder.universalgcodesender.uielements.GcodeFileTypeFilter;
import com.willwinder.universalgcodesender.uielements.GcodeTable;
import com.willwinder.universalgcodesender.uielements.GcodeTableModel;
import com.willwinder.universalgcodesender.uielements.GrblFirmwareSettingsDialog;
import com.willwinder.universalgcodesender.uielements.StepSizeSpinnerModel;
import com.willwinder.universalgcodesender.utils.CommUtils;
import com.willwinder.universalgcodesender.utils.FirmwareUtils;
import com.willwinder.universalgcodesender.utils.Settings;
import com.willwinder.universalgcodesender.utils.SettingsFactory;
import com.willwinder.universalgcodesender.utils.Version;
import com.willwinder.universalgcodesender.visualizer.VisualizerWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultCaret;
import javax.vecmath.Point3d;
import org.jdesktop.layout.GroupLayout;

public class MainWindow
extends JFrame
implements KeyListener,
ControllerListener,
ControlStateListener {
    private static final Logger logger = Logger.getLogger(MainWindow.class.getName());
    private static final String VERSION = Version.getVersion() + " / " + Version.getTimestamp();
    static Boolean showNightlyWarning = false;
    private PendantUI pendantUI;
    public Settings settings;
    BackendAPI backend;
    private JFileChooser fileChooser;
    private int commandNum = -1;
    private List<String> manualCommandHistory;
    VisualizerWindow vw = null;
    private Timer timer;
    private JMenu PendantMenu;
    private JLabel activeStateLabel;
    private JLabel activeStateValueLabel;
    private JCheckBox arrowMovementEnabled;
    private JLabel baudLabel;
    private JComboBox baudrateSelectionComboBox;
    private JTabbedPane bottomTabbedPane;
    private JButton browseButton;
    private JButton cancelButton;
    private JComboBox commPortComboBox;
    private JLabel commandLabel;
    private GcodeTable commandTable;
    private JTextField commandTextField;
    private JPanel commandsPanel;
    private JPanel connectionPanel;
    private JTextArea consoleTextArea;
    private JTabbedPane controlContextTabbedPane;
    private JButton customGcodeButton1;
    private JButton customGcodeButton2;
    private JButton customGcodeButton3;
    private JButton customGcodeButton4;
    private JButton customGcodeButton5;
    private JTextField customGcodeText1;
    private JTextField customGcodeText2;
    private JTextField customGcodeText3;
    private JTextField customGcodeText4;
    private JTextField customGcodeText5;
    private JLabel durationLabel;
    private JLabel durationValueLabel;
    private JLabel fileLabel;
    private JPanel fileModePanel;
    private JPanel fileRunPanel;
    private JTextField fileTextField;
    private JComboBox firmwareComboBox;
    private JLabel firmwareLabel;
    private JMenu firmwareSettingsMenu;
    private JMenuItem grblConnectionSettingsMenuItem;
    private JMenuItem grblFirmwareSettingsMenuItem;
    private JButton helpButtonMachineControl;
    private JRadioButton inchRadioButton;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private ButtonGroup jogUnitsGroup;
    private JPanel keyboardMovementPanel;
    private JButton killAlarmLock;
    private JLabel latestCommentLabel;
    private JLabel latestCommentValueLabel;
    private ButtonGroup lineBreakGroup;
    private JPanel machineControlPanel;
    private JLabel machinePosition;
    private JLabel machinePositionXLabel;
    private JLabel machinePositionXValueLabel;
    private JLabel machinePositionYLabel;
    private JLabel machinePositionYValueLabel;
    private JLabel machinePositionZLabel;
    private JLabel machinePositionZValueLabel;
    private JLabel macroInstructions;
    private JPanel macroPanel;
    private JMenuBar mainMenuBar;
    private JRadioButton mmRadioButton;
    private JPanel movementButtonPanel;
    private JButton opencloseButton;
    private JButton pauseButton;
    private JButton performHomingCycleButton;
    private JLabel portLabel;
    private JButton refreshButton;
    private JLabel remainingRowsLabel;
    private JLabel remainingRowsValueLabel;
    private JLabel remainingTimeLabel;
    private JLabel remainingTimeValueLabel;
    private JButton requestStateInformation;
    private JButton resetCoordinatesButton;
    private JButton resetXButton;
    private JButton resetYButton;
    private JButton resetZButton;
    private JButton returnToZeroButton;
    private JLabel rowsLabel;
    private JLabel rowsValueLabel;
    private JButton saveButton;
    private JCheckBox scrollWindowCheckBox;
    private JButton sendButton;
    private JLabel sentRowsLabel;
    private JLabel sentRowsValueLabel;
    private JMenu settingsMenu;
    private JCheckBox showVerboseOutputCheckBox;
    private JButton softResetMachineControl;
    private JMenuItem startPendantServerButton;
    private JPanel statusPanel;
    private JLabel stepSizeLabel;
    private JSpinner stepSizeSpinner;
    private JMenuItem stopPendantServerButton;
    private JButton toggleCheckMode;
    private JButton visualizeButton;
    private JLabel workPositionLabel;
    private JLabel workPositionXLabel;
    private JLabel workPositionXValueLabel;
    private JLabel workPositionYLabel;
    private JLabel workPositionYValueLabel;
    private JLabel workPositionZLabel;
    private JLabel workPositionZValueLabel;
    private JButton xMinusButton;
    private JButton xPlusButton;
    private JButton yMinusButton;
    private JButton yPlusButton;
    private JButton zMinusButton;
    private JButton zPlusButton;

    public MainWindow(BackendAPI backend) {
        if (showNightlyWarning.booleanValue() && VERSION.contains("nightly")) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String message = "This version of Universal Gcode Sender is a nightly build.\nIt contains all of the latest features and improvements, \nbut may also have bugs that still need to be fixed.\n\nIf you encounter any problems, please report them on github.";
                    JOptionPane.showMessageDialog(new JFrame(), message, "", 1);
                }
            });
        }
        this.backend = backend;
        this.settings = SettingsFactory.loadSettings();
        this.initComponents();
        this.initProgram();
        backend.addControllerListener(this);
        backend.addControlStateListener(this);
        this.arrowMovementEnabled.setSelected(this.settings.isManualModeEnabled());
        this.stepSizeSpinner.setValue(this.settings.getManualModeStepSize());
        boolean unitsAreMM = this.settings.getDefaultUnits().equals("mm");
        this.mmRadioButton.setSelected(unitsAreMM);
        this.inchRadioButton.setSelected(!unitsAreMM);
        this.fileChooser = new JFileChooser(this.settings.getLastOpenedFilename());
        this.commPortComboBox.setSelectedItem(this.settings.getPort());
        this.baudrateSelectionComboBox.setSelectedItem(this.settings.getPortRate());
        this.scrollWindowCheckBox.setSelected(this.settings.isScrollWindowEnabled());
        this.checkScrollWindow();
        this.showVerboseOutputCheckBox.setSelected(this.settings.isVerboseOutputEnabled());
        this.firmwareComboBox.setSelectedItem(this.settings.getFirmwareVersion());
        this.customGcodeText1.setText(this.settings.getCustomGcode1());
        this.customGcodeText2.setText(this.settings.getCustomGcode2());
        this.customGcodeText3.setText(this.settings.getCustomGcode3());
        this.customGcodeText4.setText(this.settings.getCustomGcode4());
        this.customGcodeText5.setText(this.settings.getCustomGcode5());
        this.setSize(this.settings.getMainWindowSettings().width, this.settings.getMainWindowSettings().height);
        this.setLocation(this.settings.getMainWindowSettings().xLocation, this.settings.getMainWindowSettings().yLocation);
        this.initFileChooser();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (MainWindow.this.fileChooser.getSelectedFile() != null) {
                    MainWindow.this.settings.setLastOpenedFilename(MainWindow.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
                MainWindow.this.settings.setDefaultUnits(MainWindow.this.inchRadioButton.isSelected() ? "inch" : "mm");
                MainWindow.this.settings.setManualModeStepSize(MainWindow.this.getStepSize());
                MainWindow.this.settings.setManualModeEnabled(MainWindow.this.arrowMovementEnabled.isSelected());
                MainWindow.this.settings.setPort(MainWindow.this.commPortComboBox.getSelectedItem().toString());
                MainWindow.this.settings.setPortRate(MainWindow.this.baudrateSelectionComboBox.getSelectedItem().toString());
                MainWindow.this.settings.setScrollWindowEnabled(MainWindow.this.scrollWindowCheckBox.isSelected());
                MainWindow.this.settings.setVerboseOutputEnabled(MainWindow.this.showVerboseOutputCheckBox.isSelected());
                MainWindow.this.settings.setFirmwareVersion(MainWindow.this.firmwareComboBox.getSelectedItem().toString());
                MainWindow.this.settings.setCustomGcode1(MainWindow.this.customGcodeText1.getText());
                MainWindow.this.settings.setCustomGcode2(MainWindow.this.customGcodeText2.getText());
                MainWindow.this.settings.setCustomGcode3(MainWindow.this.customGcodeText3.getText());
                MainWindow.this.settings.setCustomGcode4(MainWindow.this.customGcodeText4.getText());
                MainWindow.this.settings.setCustomGcode5(MainWindow.this.customGcodeText5.getText());
                SettingsFactory.saveSettings(MainWindow.this.settings);
                if (MainWindow.this.pendantUI != null) {
                    MainWindow.this.pendantUI.stop();
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        GUIBackend backend = new GUIBackend();
        final MainWindow mw = new MainWindow(backend);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        mw.arrowMovementEnabled.setSelected(mw.settings.isManualModeEnabled());
        mw.stepSizeSpinner.setValue(mw.settings.getManualModeStepSize());
        boolean unitsAreMM = mw.settings.getDefaultUnits().equals("mm");
        mw.mmRadioButton.setSelected(unitsAreMM);
        mw.inchRadioButton.setSelected(!unitsAreMM);
        mw.fileChooser = new JFileChooser(mw.settings.getLastOpenedFilename());
        mw.commPortComboBox.setSelectedItem(mw.settings.getPort());
        mw.baudrateSelectionComboBox.setSelectedItem(mw.settings.getPortRate());
        mw.scrollWindowCheckBox.setSelected(mw.settings.isScrollWindowEnabled());
        mw.showVerboseOutputCheckBox.setSelected(mw.settings.isVerboseOutputEnabled());
        mw.firmwareComboBox.setSelectedItem(mw.settings.getFirmwareVersion());
        mw.customGcodeText1.setText(mw.settings.getCustomGcode1());
        mw.customGcodeText2.setText(mw.settings.getCustomGcode2());
        mw.customGcodeText3.setText(mw.settings.getCustomGcode3());
        mw.customGcodeText4.setText(mw.settings.getCustomGcode4());
        mw.customGcodeText5.setText(mw.settings.getCustomGcode5());
        mw.setSize(mw.settings.getMainWindowSettings().width, mw.settings.getMainWindowSettings().height);
        mw.setLocation(mw.settings.getMainWindowSettings().xLocation, mw.settings.getMainWindowSettings().yLocation);
        mw.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                mw.settings.getMainWindowSettings().height = ce.getComponent().getSize().height;
                mw.settings.getMainWindowSettings().width = ce.getComponent().getSize().width;
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
                mw.settings.getMainWindowSettings().xLocation = ce.getComponent().getLocation().x;
                mw.settings.getMainWindowSettings().yLocation = ce.getComponent().getLocation().y;
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                mw.setVisible(true);
            }
        });
        mw.initFileChooser();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (mw.fileChooser.getSelectedFile() != null) {
                    mw.settings.setLastOpenedFilename(mw.fileChooser.getSelectedFile().getAbsolutePath());
                }
                mw.settings.setDefaultUnits(mw.inchRadioButton.isSelected() ? "inch" : "mm");
                mw.settings.setManualModeStepSize(mw.getStepSize());
                mw.settings.setManualModeEnabled(mw.arrowMovementEnabled.isSelected());
                mw.settings.setPort(mw.commPortComboBox.getSelectedItem().toString());
                mw.settings.setPortRate(mw.baudrateSelectionComboBox.getSelectedItem().toString());
                mw.settings.setScrollWindowEnabled(mw.scrollWindowCheckBox.isSelected());
                mw.settings.setVerboseOutputEnabled(mw.showVerboseOutputCheckBox.isSelected());
                mw.settings.setFirmwareVersion(mw.firmwareComboBox.getSelectedItem().toString());
                SettingsFactory.saveSettings(mw.settings);
                if (mw.pendantUI != null) {
                    mw.pendantUI.stop();
                }
            }
        });
    }

    private void initComponents() {
        this.lineBreakGroup = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jogUnitsGroup = new ButtonGroup();
        this.scrollWindowCheckBox = new JCheckBox();
        this.bottomTabbedPane = new JTabbedPane();
        this.jScrollPane2 = new JScrollPane();
        this.consoleTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.commandTable = new GcodeTable();
        this.controlContextTabbedPane = new JTabbedPane();
        this.commandsPanel = new JPanel();
        this.commandLabel = new JLabel();
        this.commandTextField = new JTextField();
        this.fileModePanel = new JPanel();
        this.sendButton = new JButton();
        this.pauseButton = new JButton();
        this.cancelButton = new JButton();
        this.visualizeButton = new JButton();
        this.browseButton = new JButton();
        this.fileTextField = new JTextField();
        this.fileLabel = new JLabel();
        this.saveButton = new JButton();
        this.fileRunPanel = new JPanel();
        this.remainingTimeValueLabel = new JLabel();
        this.sentRowsValueLabel = new JLabel();
        this.remainingRowsLabel = new JLabel();
        this.rowsValueLabel = new JLabel();
        this.remainingTimeLabel = new JLabel();
        this.durationValueLabel = new JLabel();
        this.durationLabel = new JLabel();
        this.remainingRowsValueLabel = new JLabel();
        this.sentRowsLabel = new JLabel();
        this.rowsLabel = new JLabel();
        this.machineControlPanel = new JPanel();
        this.resetCoordinatesButton = new JButton();
        this.returnToZeroButton = new JButton();
        this.keyboardMovementPanel = new JPanel();
        this.stepSizeSpinner = new JSpinner();
        this.arrowMovementEnabled = new JCheckBox();
        this.movementButtonPanel = new JPanel();
        this.zMinusButton = new JButton();
        this.yMinusButton = new JButton();
        this.xPlusButton = new JButton();
        this.xMinusButton = new JButton();
        this.zPlusButton = new JButton();
        this.yPlusButton = new JButton();
        this.stepSizeLabel = new JLabel();
        this.inchRadioButton = new JRadioButton();
        this.mmRadioButton = new JRadioButton();
        this.performHomingCycleButton = new JButton();
        this.killAlarmLock = new JButton();
        this.toggleCheckMode = new JButton();
        this.helpButtonMachineControl = new JButton();
        this.softResetMachineControl = new JButton();
        this.requestStateInformation = new JButton();
        this.resetXButton = new JButton();
        this.resetYButton = new JButton();
        this.resetZButton = new JButton();
        this.macroPanel = new JPanel();
        this.customGcodeButton4 = new JButton();
        this.customGcodeButton3 = new JButton();
        this.customGcodeButton2 = new JButton();
        this.customGcodeButton1 = new JButton();
        this.customGcodeButton5 = new JButton();
        this.customGcodeText1 = new JTextField();
        this.customGcodeText2 = new JTextField();
        this.customGcodeText3 = new JTextField();
        this.customGcodeText4 = new JTextField();
        this.customGcodeText5 = new JTextField();
        this.macroInstructions = new JLabel();
        this.connectionPanel = new JPanel();
        this.commPortComboBox = new JComboBox();
        this.baudrateSelectionComboBox = new JComboBox();
        this.opencloseButton = new JButton();
        this.refreshButton = new JButton();
        this.baudLabel = new JLabel();
        this.portLabel = new JLabel();
        this.firmwareLabel = new JLabel();
        this.firmwareComboBox = new JComboBox();
        this.showVerboseOutputCheckBox = new JCheckBox();
        this.statusPanel = new JPanel();
        this.activeStateLabel = new JLabel();
        this.activeStateValueLabel = new JLabel();
        this.machinePosition = new JLabel();
        this.machinePositionXLabel = new JLabel();
        this.machinePositionYLabel = new JLabel();
        this.machinePositionZLabel = new JLabel();
        this.workPositionLabel = new JLabel();
        this.workPositionXLabel = new JLabel();
        this.workPositionYLabel = new JLabel();
        this.workPositionZLabel = new JLabel();
        this.machinePositionXValueLabel = new JLabel();
        this.machinePositionYValueLabel = new JLabel();
        this.machinePositionZValueLabel = new JLabel();
        this.workPositionXValueLabel = new JLabel();
        this.workPositionYValueLabel = new JLabel();
        this.workPositionZValueLabel = new JLabel();
        this.latestCommentValueLabel = new JLabel();
        this.latestCommentLabel = new JLabel();
        this.mainMenuBar = new JMenuBar();
        this.settingsMenu = new JMenu();
        this.grblConnectionSettingsMenuItem = new JMenuItem();
        this.firmwareSettingsMenu = new JMenu();
        this.grblFirmwareSettingsMenuItem = new JMenuItem();
        this.PendantMenu = new JMenu();
        this.startPendantServerButton = new JMenuItem();
        this.stopPendantServerButton = new JMenuItem();
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItem3.setText("jMenuItem3");
        this.jMenuItem4.setText("jMenuItem4");
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(640, 520));
        this.scrollWindowCheckBox.setSelected(true);
        this.scrollWindowCheckBox.setText("Scroll output window");
        this.scrollWindowCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.scrollWindowCheckBoxActionPerformed(evt);
            }
        });
        this.bottomTabbedPane.setBorder(BorderFactory.createTitledBorder(""));
        this.bottomTabbedPane.setMinimumSize(new Dimension(0, 0));
        this.bottomTabbedPane.setPreferredSize(new Dimension(468, 100));
        this.consoleTextArea.setColumns(20);
        this.consoleTextArea.setRows(5);
        this.consoleTextArea.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.consoleTextArea.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane2.setViewportView(this.consoleTextArea);
        this.bottomTabbedPane.addTab("Console", this.jScrollPane2);
        this.commandTable.setModel(new GcodeTableModel());
        this.commandTable.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.commandTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.commandTable);
        this.bottomTabbedPane.addTab("Command Table", this.jScrollPane1);
        this.controlContextTabbedPane.setBorder(BorderFactory.createTitledBorder(""));
        this.controlContextTabbedPane.setMinimumSize(new Dimension(395, 175));
        this.commandLabel.setText("Command");
        this.commandTextField.setEnabled(false);
        this.commandTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.commandTextFieldActionPerformed(evt);
            }
        });
        GroupLayout commandsPanelLayout = new GroupLayout(this.commandsPanel);
        this.commandsPanel.setLayout(commandsPanelLayout);
        commandsPanelLayout.setHorizontalGroup(commandsPanelLayout.createParallelGroup(1).add(commandsPanelLayout.createSequentialGroup().addContainerGap().add(commandsPanelLayout.createParallelGroup(1).add(this.commandTextField).add(commandsPanelLayout.createSequentialGroup().add(this.commandLabel).add(0, 595, Short.MAX_VALUE))).addContainerGap()));
        commandsPanelLayout.setVerticalGroup(commandsPanelLayout.createParallelGroup(1).add(commandsPanelLayout.createSequentialGroup().addContainerGap().add(this.commandLabel).addPreferredGap(0).add(this.commandTextField, -2, -1, -2).addContainerGap(143, Short.MAX_VALUE)));
        this.controlContextTabbedPane.addTab("Commands", this.commandsPanel);
        this.fileModePanel.setMinimumSize(new Dimension(389, 150));
        this.sendButton.setText("Send");
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.sendButtonActionPerformed(evt);
            }
        });
        this.pauseButton.setText("Pause");
        this.pauseButton.setEnabled(false);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.pauseButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.visualizeButton.setText("Visualize");
        this.visualizeButton.setEnabled(false);
        this.visualizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.visualizeButtonActionPerformed(evt);
            }
        });
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileTextField.setEnabled(false);
        this.fileLabel.setText("File");
        this.saveButton.setText("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.setMaximumSize(new Dimension(88, 29));
        this.saveButton.setMinimumSize(new Dimension(88, 29));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.saveButtonActionPerformed(evt);
            }
        });
        this.remainingTimeValueLabel.setText("--:--:--");
        this.sentRowsValueLabel.setText("0");
        this.remainingRowsLabel.setHorizontalAlignment(4);
        this.remainingRowsLabel.setText("Remaining Rows:");
        this.remainingRowsLabel.setCursor(new Cursor(0));
        this.remainingRowsLabel.setMaximumSize(null);
        this.remainingRowsLabel.setMinimumSize(new Dimension(106, 14));
        this.remainingRowsLabel.setPreferredSize(new Dimension(106, 14));
        this.rowsValueLabel.setText("0");
        this.remainingTimeLabel.setText("Estimated Time Remaining:");
        this.durationValueLabel.setText("00:00:00");
        this.durationLabel.setText("Duration:");
        this.remainingRowsValueLabel.setText("0");
        this.sentRowsLabel.setHorizontalAlignment(4);
        this.sentRowsLabel.setText("Sent Rows:");
        this.sentRowsLabel.setCursor(new Cursor(0));
        this.sentRowsLabel.setMaximumSize(null);
        this.sentRowsLabel.setMinimumSize(new Dimension(106, 14));
        this.sentRowsLabel.setPreferredSize(new Dimension(106, 14));
        this.rowsLabel.setHorizontalAlignment(4);
        this.rowsLabel.setText("Rows In File:");
        this.rowsLabel.setCursor(new Cursor(0));
        this.rowsLabel.setMinimumSize(new Dimension(106, 14));
        this.rowsLabel.setPreferredSize(new Dimension(106, 14));
        GroupLayout fileRunPanelLayout = new GroupLayout(this.fileRunPanel);
        this.fileRunPanel.setLayout(fileRunPanelLayout);
        fileRunPanelLayout.setHorizontalGroup(fileRunPanelLayout.createParallelGroup(1).add(fileRunPanelLayout.createSequentialGroup().addContainerGap().add(fileRunPanelLayout.createParallelGroup(1).add(2, this.remainingRowsLabel, -2, -1, -2).add(2, this.remainingTimeLabel).add(2, this.sentRowsLabel, -2, -1, -2).add(2, this.rowsLabel, -2, -1, -2).add(2, this.durationLabel)).addPreferredGap(0).add(fileRunPanelLayout.createParallelGroup(1, false).add(this.durationValueLabel, -1, -1, Short.MAX_VALUE).add(this.remainingRowsValueLabel, -1, -1, Short.MAX_VALUE).add(this.sentRowsValueLabel, -1, -1, Short.MAX_VALUE).add(this.remainingTimeValueLabel, -1, -1, Short.MAX_VALUE).add(this.rowsValueLabel, -2, 56, -2)).addContainerGap()));
        fileRunPanelLayout.setVerticalGroup(fileRunPanelLayout.createParallelGroup(1).add(fileRunPanelLayout.createSequentialGroup().addContainerGap().add(fileRunPanelLayout.createParallelGroup(2).add(fileRunPanelLayout.createSequentialGroup().add(this.rowsValueLabel, -2, 14, -2).addPreferredGap(0).add(this.sentRowsValueLabel, -2, 14, -2).addPreferredGap(0).add(this.remainingRowsValueLabel)).add(fileRunPanelLayout.createSequentialGroup().add(this.rowsLabel, -2, 14, -2).addPreferredGap(0).add(this.sentRowsLabel, -2, 14, -2).addPreferredGap(0).add(this.remainingRowsLabel, -2, -1, -2))).addPreferredGap(0).add(fileRunPanelLayout.createParallelGroup(3).add(this.remainingTimeLabel).add(this.remainingTimeValueLabel)).addPreferredGap(0).add(fileRunPanelLayout.createParallelGroup(3).add(this.durationValueLabel).add(this.durationLabel)).addContainerGap()));
        GroupLayout fileModePanelLayout = new GroupLayout(this.fileModePanel);
        this.fileModePanel.setLayout(fileModePanelLayout);
        fileModePanelLayout.setHorizontalGroup(fileModePanelLayout.createParallelGroup(1).add(fileModePanelLayout.createSequentialGroup().addContainerGap().add(this.fileTextField).addContainerGap()).add(2, fileModePanelLayout.createSequentialGroup().add(fileModePanelLayout.createParallelGroup(1).add(fileModePanelLayout.createSequentialGroup().add(2, 2, 2).add(this.sendButton, -2, 68, -2).addPreferredGap(0).add(this.pauseButton, -2, 95, -2).addPreferredGap(0).add(this.cancelButton).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.visualizeButton)).add(fileModePanelLayout.createSequentialGroup().add(fileModePanelLayout.createParallelGroup(1).add(fileModePanelLayout.createSequentialGroup().add(8, 8, 8).add(this.fileLabel)).add(fileModePanelLayout.createSequentialGroup().addContainerGap().add(this.fileRunPanel, -2, -1, -2))).add(0, 0, Short.MAX_VALUE))).addPreferredGap(0).add(fileModePanelLayout.createParallelGroup(1).add(fileModePanelLayout.createSequentialGroup().add(6, 6, 6).add(this.saveButton, -2, -1, -2)).add(this.browseButton)).add(8, 8, 8)));
        fileModePanelLayout.setVerticalGroup(fileModePanelLayout.createParallelGroup(1).add(fileModePanelLayout.createSequentialGroup().add(this.fileLabel).addPreferredGap(0).add(this.fileTextField, -1, -1, -2).addPreferredGap(0).add(fileModePanelLayout.createParallelGroup(1).add(2, this.browseButton).add(fileModePanelLayout.createParallelGroup(3).add(this.sendButton).add(this.pauseButton).add(this.cancelButton).add(this.visualizeButton))).addPreferredGap(0).add(fileModePanelLayout.createParallelGroup(1).add(fileModePanelLayout.createSequentialGroup().add(this.saveButton, -2, -1, -2).add(0, 99, Short.MAX_VALUE)).add(this.fileRunPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.controlContextTabbedPane.addTab("File Mode", this.fileModePanel);
        this.resetCoordinatesButton.setText("Reset Zero");
        this.resetCoordinatesButton.setEnabled(false);
        this.resetCoordinatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.resetCoordinatesButtonActionPerformed(evt);
            }
        });
        this.returnToZeroButton.setText("Return to Zero");
        this.returnToZeroButton.setEnabled(false);
        this.returnToZeroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.returnToZeroButtonActionPerformed(evt);
            }
        });
        this.stepSizeSpinner.setModel(new StepSizeSpinnerModel((Number)1.0, (Comparable)Double.valueOf(0.0), null, (Number)1.0));
        this.stepSizeSpinner.setEnabled(false);
        this.stepSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainWindow.this.stepSizeSpinnerStateChanged(evt);
            }
        });
        this.arrowMovementEnabled.setText("Enable Keyboard Movement");
        this.arrowMovementEnabled.setEnabled(false);
        this.zMinusButton.setText("Z-");
        this.zMinusButton.setEnabled(false);
        this.zMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.zMinusButtonActionPerformed(evt);
            }
        });
        this.yMinusButton.setText("Y-");
        this.yMinusButton.setEnabled(false);
        this.yMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.yMinusButtonActionPerformed(evt);
            }
        });
        this.xPlusButton.setText("X+");
        this.xPlusButton.setEnabled(false);
        this.xPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.xPlusButtonActionPerformed(evt);
            }
        });
        this.xMinusButton.setText("X-");
        this.xMinusButton.setEnabled(false);
        this.xMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.xMinusButtonActionPerformed(evt);
            }
        });
        this.zPlusButton.setText("Z+");
        this.zPlusButton.setEnabled(false);
        this.zPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.zPlusButtonActionPerformed(evt);
            }
        });
        this.yPlusButton.setText("Y+");
        this.yPlusButton.setEnabled(false);
        this.yPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.yPlusButtonActionPerformed(evt);
            }
        });
        GroupLayout movementButtonPanelLayout = new GroupLayout(this.movementButtonPanel);
        this.movementButtonPanel.setLayout(movementButtonPanelLayout);
        movementButtonPanelLayout.setHorizontalGroup(movementButtonPanelLayout.createParallelGroup(1).add(movementButtonPanelLayout.createSequentialGroup().add(this.xMinusButton, -2, 50, -2).addPreferredGap(0).add(movementButtonPanelLayout.createParallelGroup(2).add(this.yPlusButton, -2, 50, -2).add(this.yMinusButton, -2, 50, -2)).addPreferredGap(0).add(this.xPlusButton, -1, 50, -2).addPreferredGap(1).add(movementButtonPanelLayout.createParallelGroup(1).add(2, this.zMinusButton, -2, 50, -2).add(2, this.zPlusButton, -2, 50, -2))));
        movementButtonPanelLayout.setVerticalGroup(movementButtonPanelLayout.createParallelGroup(1).add(movementButtonPanelLayout.createParallelGroup(4).add(this.xMinusButton, -2, 45, -2).add(this.xPlusButton, -2, 45, -2).add(movementButtonPanelLayout.createSequentialGroup().add(this.yPlusButton, -2, 45, -2).addPreferredGap(0).add(this.yMinusButton, -2, 45, -2)).add(movementButtonPanelLayout.createSequentialGroup().add(this.zPlusButton, -2, 46, -2).addPreferredGap(0).add(this.zMinusButton, -2, 45, -2))));
        this.stepSizeLabel.setText("Step size:");
        this.stepSizeLabel.setEnabled(false);
        this.jogUnitsGroup.add(this.inchRadioButton);
        this.inchRadioButton.setText("inch");
        this.inchRadioButton.setEnabled(false);
        this.inchRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.inchRadioButtonActionPerformed(evt);
            }
        });
        this.jogUnitsGroup.add(this.mmRadioButton);
        this.mmRadioButton.setText("millimeters");
        this.mmRadioButton.setEnabled(false);
        this.mmRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mmRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout keyboardMovementPanelLayout = new GroupLayout(this.keyboardMovementPanel);
        this.keyboardMovementPanel.setLayout(keyboardMovementPanelLayout);
        keyboardMovementPanelLayout.setHorizontalGroup(keyboardMovementPanelLayout.createParallelGroup(1).add(this.arrowMovementEnabled).add(this.movementButtonPanel, -2, -1, -2).add(keyboardMovementPanelLayout.createSequentialGroup().addContainerGap().add(keyboardMovementPanelLayout.createParallelGroup(1).add(keyboardMovementPanelLayout.createSequentialGroup().add(keyboardMovementPanelLayout.createParallelGroup(1).add(this.inchRadioButton).add(this.stepSizeLabel)).addPreferredGap(0).add(this.stepSizeSpinner, -2, 70, -2)).add(this.mmRadioButton))));
        keyboardMovementPanelLayout.setVerticalGroup(keyboardMovementPanelLayout.createParallelGroup(1).add(keyboardMovementPanelLayout.createSequentialGroup().add(this.arrowMovementEnabled).addPreferredGap(0).add(keyboardMovementPanelLayout.createParallelGroup(3).add(this.stepSizeLabel).add(this.stepSizeSpinner, -2, -1, -2)).addPreferredGap(0).add(this.inchRadioButton).addPreferredGap(1).add(this.mmRadioButton).addPreferredGap(0).add(this.movementButtonPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        keyboardMovementPanelLayout.linkSize(new Component[]{this.stepSizeLabel, this.stepSizeSpinner}, 2);
        this.performHomingCycleButton.setText("$H");
        this.performHomingCycleButton.setEnabled(false);
        this.performHomingCycleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.performHomingCycleButtonActionPerformed(evt);
            }
        });
        this.killAlarmLock.setText("$X");
        this.killAlarmLock.setEnabled(false);
        this.killAlarmLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.killAlarmLockActionPerformed(evt);
            }
        });
        this.toggleCheckMode.setText("$C");
        this.toggleCheckMode.setEnabled(false);
        this.toggleCheckMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.toggleCheckModeActionPerformed(evt);
            }
        });
        this.helpButtonMachineControl.setText("Help");
        this.helpButtonMachineControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.helpButtonMachineControlActionPerformed(evt);
            }
        });
        this.softResetMachineControl.setText("Soft Reset");
        this.softResetMachineControl.setEnabled(false);
        this.softResetMachineControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.softResetMachineControlActionPerformed(evt);
            }
        });
        this.requestStateInformation.setText("$G");
        this.requestStateInformation.setEnabled(false);
        this.requestStateInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.requestStateInformationActionPerformed(evt);
            }
        });
        this.resetXButton.setText("Reset X Axis");
        this.resetXButton.setEnabled(false);
        this.resetXButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.resetXCoordinateButtonActionPerformed(evt);
            }
        });
        this.resetYButton.setText("Reset Y Axis");
        this.resetYButton.setEnabled(false);
        this.resetYButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.resetYCoordinateButtonActionPerformed(evt);
            }
        });
        this.resetZButton.setText("Reset Z Axis");
        this.resetZButton.setEnabled(false);
        this.resetZButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.resetZCoordinateButtonActionPerformed(evt);
            }
        });
        GroupLayout machineControlPanelLayout = new GroupLayout(this.machineControlPanel);
        this.machineControlPanel.setLayout(machineControlPanelLayout);
        machineControlPanelLayout.setHorizontalGroup(machineControlPanelLayout.createParallelGroup(1).add(2, machineControlPanelLayout.createSequentialGroup().addContainerGap().add(machineControlPanelLayout.createParallelGroup(1).add(machineControlPanelLayout.createSequentialGroup().add(this.softResetMachineControl, -2, 159, -2).addPreferredGap(0).add(this.resetZButton)).add(machineControlPanelLayout.createParallelGroup(2, false).add(1, machineControlPanelLayout.createSequentialGroup().add(this.requestStateInformation, -2, 49, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.helpButtonMachineControl)).add(1, machineControlPanelLayout.createSequentialGroup().add(this.performHomingCycleButton, -2, 49, -2).addPreferredGap(0).add(this.killAlarmLock, -2, 49, -2).addPreferredGap(0).add(this.toggleCheckMode, -2, 49, -2))).add(machineControlPanelLayout.createSequentialGroup().add(this.resetCoordinatesButton, -2, 159, -2).addPreferredGap(0).add(this.resetXButton)).add(machineControlPanelLayout.createSequentialGroup().add(this.returnToZeroButton, -2, 159, -2).addPreferredGap(0).add(this.resetYButton))).addPreferredGap(1, 162, Short.MAX_VALUE).add(this.keyboardMovementPanel, -2, -1, -2).addContainerGap()));
        machineControlPanelLayout.setVerticalGroup(machineControlPanelLayout.createParallelGroup(1).add(machineControlPanelLayout.createSequentialGroup().addContainerGap().add(this.keyboardMovementPanel, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add(machineControlPanelLayout.createSequentialGroup().add(machineControlPanelLayout.createParallelGroup(3).add(this.resetCoordinatesButton).add(this.resetXButton)).addPreferredGap(0).add(machineControlPanelLayout.createParallelGroup(3).add(this.returnToZeroButton).add(this.resetYButton)).addPreferredGap(0).add(machineControlPanelLayout.createParallelGroup(3).add(this.softResetMachineControl).add(this.resetZButton)).addPreferredGap(0).add(machineControlPanelLayout.createParallelGroup(3).add(this.performHomingCycleButton).add(this.killAlarmLock).add(this.toggleCheckMode)).addPreferredGap(0).add(machineControlPanelLayout.createParallelGroup(3).add(this.requestStateInformation).add(this.helpButtonMachineControl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.controlContextTabbedPane.addTab("Machine Control", this.machineControlPanel);
        this.customGcodeButton4.setText("C4");
        this.customGcodeButton4.setEnabled(false);
        this.customGcodeButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeButton4ActionPerformed(evt);
            }
        });
        this.customGcodeButton3.setText("C3");
        this.customGcodeButton3.setEnabled(false);
        this.customGcodeButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeButton3ActionPerformed(evt);
            }
        });
        this.customGcodeButton2.setText("C2");
        this.customGcodeButton2.setEnabled(false);
        this.customGcodeButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeButton2ActionPerformed(evt);
            }
        });
        this.customGcodeButton1.setText("C1");
        this.customGcodeButton1.setEnabled(false);
        this.customGcodeButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeButton1ActionPerformed(evt);
            }
        });
        this.customGcodeButton5.setText("C5");
        this.customGcodeButton5.setEnabled(false);
        this.customGcodeButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeButton5ActionPerformed(evt);
            }
        });
        this.customGcodeText1.setText("G91 X0 Y0");
        this.customGcodeText1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeText1ActionPerformed(evt);
            }
        });
        this.customGcodeText2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeText2ActionPerformed(evt);
            }
        });
        this.customGcodeText3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeText3ActionPerformed(evt);
            }
        });
        this.customGcodeText4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeText4ActionPerformed(evt);
            }
        });
        this.customGcodeText5.setToolTipText("");
        this.customGcodeText5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.customGcodeText5ActionPerformed(evt);
            }
        });
        this.macroInstructions.setText("asgasg");
        GroupLayout macroPanelLayout = new GroupLayout(this.macroPanel);
        this.macroPanel.setLayout(macroPanelLayout);
        macroPanelLayout.setHorizontalGroup(macroPanelLayout.createParallelGroup(1).add(macroPanelLayout.createSequentialGroup().addContainerGap().add(macroPanelLayout.createParallelGroup(1).add(macroPanelLayout.createSequentialGroup().add(this.customGcodeButton1, -2, 49, -2).addPreferredGap(0).add(this.customGcodeText1)).add(macroPanelLayout.createSequentialGroup().add(this.customGcodeButton2, -2, 49, -2).addPreferredGap(0).add(this.customGcodeText2)).add(macroPanelLayout.createSequentialGroup().add(this.customGcodeButton4, -2, 49, -2).addPreferredGap(0).add(this.customGcodeText4)).add(macroPanelLayout.createSequentialGroup().add(this.customGcodeButton3, -2, 49, -2).addPreferredGap(0).add(this.customGcodeText3)).add(macroPanelLayout.createSequentialGroup().add(this.customGcodeButton5, -2, 49, -2).addPreferredGap(0).add(this.customGcodeText5)).add(macroPanelLayout.createSequentialGroup().add(this.macroInstructions).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        macroPanelLayout.setVerticalGroup(macroPanelLayout.createParallelGroup(1).add(macroPanelLayout.createSequentialGroup().add(8, 8, 8).add(this.macroInstructions).addPreferredGap(0).add(macroPanelLayout.createParallelGroup(3).add(this.customGcodeButton1).add(this.customGcodeText1, -2, -1, -2)).addPreferredGap(0).add(macroPanelLayout.createParallelGroup(3).add(this.customGcodeButton2).add(this.customGcodeText2, -2, -1, -2)).addPreferredGap(0).add(macroPanelLayout.createParallelGroup(3).add(this.customGcodeButton3).add(this.customGcodeText3, -2, -1, -2)).addPreferredGap(0).add(macroPanelLayout.createParallelGroup(3).add(this.customGcodeButton4).add(this.customGcodeText4, -2, -1, -2)).addPreferredGap(0).add(macroPanelLayout.createParallelGroup(3).add(this.customGcodeButton5).add(this.customGcodeText5, -2, -1, -2)).addContainerGap(76, Short.MAX_VALUE)));
        this.controlContextTabbedPane.addTab("Macros", this.macroPanel);
        this.connectionPanel.setBorder(BorderFactory.createTitledBorder("Connection"));
        this.connectionPanel.setMaximumSize(new Dimension(247, 100));
        this.connectionPanel.setMinimumSize(new Dimension(247, 100));
        this.connectionPanel.setName("Connection");
        this.connectionPanel.setPreferredSize(new Dimension(247, 100));
        this.commPortComboBox.setEditable(true);
        this.baudrateSelectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"2400", "4800", "9600", "19200", "38400", "57600", "115200"}));
        this.baudrateSelectionComboBox.setSelectedIndex(2);
        this.baudrateSelectionComboBox.setToolTipText("Select baudrate to use for the serial port.");
        this.baudrateSelectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.baudrateSelectionComboBoxActionPerformed(evt);
            }
        });
        this.opencloseButton.setText("Open");
        this.opencloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.opencloseButtonActionPerformed(evt);
            }
        });
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/refresh.gif")));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.refreshButtonActionPerformed(evt);
            }
        });
        this.baudLabel.setText("Baud:");
        this.portLabel.setText("Port:");
        this.firmwareLabel.setText("Firmware:");
        this.firmwareComboBox.setEditable(true);
        GroupLayout connectionPanelLayout = new GroupLayout(this.connectionPanel);
        this.connectionPanel.setLayout(connectionPanelLayout);
        connectionPanelLayout.setHorizontalGroup(connectionPanelLayout.createParallelGroup(1).add(connectionPanelLayout.createSequentialGroup().addContainerGap().add(connectionPanelLayout.createParallelGroup(1, false).add(2, connectionPanelLayout.createParallelGroup(1).add(connectionPanelLayout.createSequentialGroup().add(this.portLabel).addPreferredGap(0).add(this.commPortComboBox, -2, 183, -2)).add(connectionPanelLayout.createSequentialGroup().add(this.baudLabel).addPreferredGap(0).add(this.baudrateSelectionComboBox, -2, -1, -2).addPreferredGap(0).add(this.refreshButton, -2, 25, -2).addPreferredGap(0).add(this.opencloseButton))).add(connectionPanelLayout.createSequentialGroup().add(this.firmwareLabel).addPreferredGap(0).add(this.firmwareComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        connectionPanelLayout.setVerticalGroup(connectionPanelLayout.createParallelGroup(1).add(connectionPanelLayout.createSequentialGroup().add(connectionPanelLayout.createParallelGroup(3).add(this.commPortComboBox, -2, -1, -2).add(this.portLabel)).addPreferredGap(0).add(connectionPanelLayout.createParallelGroup(1).add(connectionPanelLayout.createParallelGroup(3).add(this.baudLabel).add(this.baudrateSelectionComboBox, -2, -1, -2)).add(this.refreshButton, -2, 24, -2).add(this.opencloseButton)).addPreferredGap(0).add(connectionPanelLayout.createParallelGroup(3).add(this.firmwareLabel).add(this.firmwareComboBox, -2, -1, -2)).addContainerGap(25, Short.MAX_VALUE)));
        this.showVerboseOutputCheckBox.setText("Show verbose output");
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Machine status"));
        this.statusPanel.setMinimumSize(new Dimension(247, 160));
        this.statusPanel.setPreferredSize(new Dimension(247, 160));
        this.activeStateLabel.setText("Active State:");
        this.activeStateLabel.setOpaque(true);
        this.activeStateValueLabel.setText(" ");
        this.activeStateValueLabel.setOpaque(true);
        this.machinePosition.setText("Machine Position:");
        this.machinePositionXLabel.setText("X:");
        this.machinePositionYLabel.setText("Y:");
        this.machinePositionZLabel.setText("Z:");
        this.workPositionLabel.setText("Work Position:");
        this.workPositionXLabel.setText("X:");
        this.workPositionYLabel.setText("Y:");
        this.workPositionZLabel.setText("Z:");
        this.machinePositionXValueLabel.setText("0");
        this.machinePositionYValueLabel.setText("0");
        this.machinePositionZValueLabel.setText("0");
        this.workPositionXValueLabel.setText("0");
        this.workPositionYValueLabel.setText("0");
        this.workPositionZValueLabel.setText("0");
        this.latestCommentValueLabel.setText(" ");
        this.latestCommentLabel.setText("Latest Comment:");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().addContainerGap().add(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(this.latestCommentLabel).addPreferredGap(0).add(this.latestCommentValueLabel, -1, -1, Short.MAX_VALUE)).add(statusPanelLayout.createSequentialGroup().add(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(this.activeStateLabel).addPreferredGap(0).add(this.activeStateValueLabel, -2, 120, -2)).add(statusPanelLayout.createSequentialGroup().add(statusPanelLayout.createParallelGroup(1).add(this.workPositionLabel).add(statusPanelLayout.createSequentialGroup().add(17, 17, 17).add(statusPanelLayout.createParallelGroup(1, false).add(statusPanelLayout.createSequentialGroup().add(this.workPositionZLabel).addPreferredGap(0).add(this.workPositionZValueLabel, -1, -1, Short.MAX_VALUE)).add(statusPanelLayout.createSequentialGroup().add(this.workPositionYLabel).addPreferredGap(0).add(this.workPositionYValueLabel, -1, -1, Short.MAX_VALUE)).add(statusPanelLayout.createSequentialGroup().add(this.workPositionXLabel).addPreferredGap(0).add(this.workPositionXValueLabel, -2, 65, -2))))).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(1).add(this.machinePosition).add(statusPanelLayout.createSequentialGroup().add(17, 17, 17).add(statusPanelLayout.createParallelGroup(1, false).add(statusPanelLayout.createSequentialGroup().add(this.machinePositionZLabel).addPreferredGap(0).add(this.machinePositionZValueLabel, -1, -1, Short.MAX_VALUE)).add(statusPanelLayout.createSequentialGroup().add(this.machinePositionYLabel).addPreferredGap(0).add(this.machinePositionYValueLabel, -1, -1, Short.MAX_VALUE)).add(statusPanelLayout.createSequentialGroup().add(this.machinePositionXLabel).addPreferredGap(0).add(this.machinePositionXValueLabel, -2, 65, -2))))))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(statusPanelLayout.createParallelGroup(3).add(this.activeStateLabel).add(this.activeStateValueLabel)).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.latestCommentLabel).add(this.latestCommentValueLabel)).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(2).add(statusPanelLayout.createSequentialGroup().add(this.workPositionLabel).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.workPositionXLabel).add(this.workPositionXValueLabel)).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.workPositionYLabel).add(this.workPositionYValueLabel)).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.workPositionZLabel).add(this.workPositionZValueLabel))).add(statusPanelLayout.createSequentialGroup().add(this.machinePosition).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.machinePositionXLabel).add(this.machinePositionXValueLabel)).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.machinePositionYLabel).add(this.machinePositionYValueLabel)).addPreferredGap(0).add(statusPanelLayout.createParallelGroup(3).add(this.machinePositionZLabel).add(this.machinePositionZValueLabel)))).addContainerGap(6, Short.MAX_VALUE)));
        this.settingsMenu.setText("Settings");
        this.grblConnectionSettingsMenuItem.setText("Sender Settings");
        this.grblConnectionSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.grblConnectionSettingsMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.grblConnectionSettingsMenuItem);
        this.firmwareSettingsMenu.setText("Firmware Settings");
        this.grblFirmwareSettingsMenuItem.setText("GRBL");
        this.grblFirmwareSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.grblFirmwareSettingsMenuItemActionPerformed(evt);
            }
        });
        this.firmwareSettingsMenu.add(this.grblFirmwareSettingsMenuItem);
        this.settingsMenu.add(this.firmwareSettingsMenu);
        this.mainMenuBar.add(this.settingsMenu);
        this.PendantMenu.setText("Pendant");
        this.startPendantServerButton.setText("Start...");
        this.startPendantServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.startPendantServerButtonActionPerformed(evt);
            }
        });
        this.PendantMenu.add(this.startPendantServerButton);
        this.stopPendantServerButton.setText("Stop...");
        this.stopPendantServerButton.setEnabled(false);
        this.stopPendantServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.stopPendantServerButtonActionPerformed(evt);
            }
        });
        this.PendantMenu.add(this.stopPendantServerButton);
        this.mainMenuBar.add(this.PendantMenu);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1, false).add(this.connectionPanel, -1, -1, Short.MAX_VALUE).add(this.statusPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.scrollWindowCheckBox).addPreferredGap(0).add(this.showVerboseOutputCheckBox).addContainerGap()).add(this.controlContextTabbedPane, -1, -1, Short.MAX_VALUE))).add(this.bottomTabbedPane, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.connectionPanel, -2, 144, -2).addPreferredGap(0).add(this.statusPanel, -2, -1, -2)).add(layout.createSequentialGroup().add(this.controlContextTabbedPane, -2, 283, -2).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.scrollWindowCheckBox).add(this.showVerboseOutputCheckBox)))).addPreferredGap(0).add(this.bottomTabbedPane, -1, 305, Short.MAX_VALUE)));
        this.pack();
    }

    private void scrollWindowCheckBoxActionPerformed(ActionEvent evt) {
        this.checkScrollWindow();
    }

    private void commandTextFieldActionPerformed(ActionEvent evt) {
        final String str = this.commandTextField.getText().replaceAll("(\\r\\n|\\n\\r|\\r|\\n)", "");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow.this.backend.sendGcodeCommand(str);
                }
                catch (Exception ex) {
                    MainWindow.displayErrorDialog(ex.getMessage());
                }
            }
        });
        this.commandTextField.setText("");
        this.manualCommandHistory.add(str);
        this.commandNum = -1;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        boolean pressed = false;
        if (ke.getKeyCode() == 38) {
            pressed = true;
            if (this.commandNum == 0 || this.manualCommandHistory.isEmpty()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.commandNum = this.commandNum == -1 ? this.manualCommandHistory.size() - 1 : --this.commandNum;
            }
        } else if (ke.getKeyCode() == 40) {
            pressed = true;
            if (this.commandNum == -1 || this.commandNum == this.manualCommandHistory.size() - 1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            ++this.commandNum;
        }
        if (pressed && this.commandNum != -1) {
            String text = this.manualCommandHistory.get(this.commandNum);
            this.commandTextField.setText(text);
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    private void opencloseButtonActionPerformed(ActionEvent evt) {
        if (this.opencloseButton.getText().equalsIgnoreCase(Localization.getString("open"))) {
            this.clearTable();
            this.sentRowsValueLabel.setText("0");
            String firmware = this.firmwareComboBox.getSelectedItem().toString();
            String port = this.commPortComboBox.getSelectedItem().toString();
            int baudRate = Integer.parseInt(this.baudrateSelectionComboBox.getSelectedItem().toString());
            try {
                this.backend.connect(firmware, port, baudRate);
                if (this.backend.getFile() != null && this.vw != null) {
                    this.vw.setGcodeFile(this.backend.getFile().getAbsolutePath());
                }
                this.commandTextField.grabFocus();
            }
            catch (Exception e2) {
                MainWindow.displayErrorDialog(e2.getMessage());
            }
        } else {
            try {
                this.backend.disconnect();
            }
            catch (Exception e3) {
                MainWindow.displayErrorDialog(e3.getMessage());
            }
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.loadPortSelector();
    }

    private void baudrateSelectionComboBoxActionPerformed(ActionEvent evt) {
    }

    private void increaseStepActionPerformed(ActionEvent evt) {
        double stepSize = this.getStepSize();
        stepSize = stepSize >= 1.0 ? (stepSize += 1.0) : (stepSize >= 0.1 ? (stepSize += 0.1) : (stepSize >= 0.01 ? (stepSize += 0.01) : 0.01));
        this.setStepSize(stepSize);
    }

    private void decreaseStepActionPerformed(ActionEvent evt) {
        double stepSize = this.getStepSize();
        if (stepSize > 1.0) {
            stepSize -= 1.0;
        } else if (stepSize > 0.1) {
            stepSize -= 0.1;
        } else if (stepSize > 0.01) {
            stepSize -= 0.01;
        }
        this.setStepSize(stepSize);
    }

    private void divideStepActionPerformed(ActionEvent evt) {
        double stepSize = this.getStepSize();
        if (stepSize > 100.0) {
            stepSize = 100.0;
        } else if (stepSize <= 100.0 && stepSize > 10.0) {
            stepSize = 10.0;
        } else if (stepSize <= 10.0 && stepSize > 1.0) {
            stepSize = 1.0;
        } else if (stepSize <= 1.0 && stepSize > 0.1) {
            stepSize = 0.1;
        } else if (stepSize <= 0.1) {
            stepSize = 0.01;
        }
        this.setStepSize(stepSize);
    }

    private void multiplyStepActionPerformed(ActionEvent evt) {
        double stepSize = this.getStepSize();
        if (stepSize < 0.01) {
            stepSize = 0.01;
        } else if (stepSize >= 0.01 && stepSize < 0.1) {
            stepSize = 0.1;
        } else if (stepSize >= 0.1 && stepSize < 1.0) {
            stepSize = 1.0;
        } else if (stepSize >= 1.0 && stepSize < 10.0) {
            stepSize = 10.0;
        } else if (stepSize >= 10.0) {
            stepSize = 100.0;
        }
        this.setStepSize(stepSize);
    }

    private void grblConnectionSettingsMenuItemActionPerformed(ActionEvent evt) {
        ConnectionSettingsDialog gcsd = new ConnectionSettingsDialog((Frame)this, true);
        gcsd.setSpeedOverrideEnabled(this.settings.isOverrideSpeedSelected());
        gcsd.setSpeedOverridePercent((int)this.settings.getOverrideSpeedValue());
        gcsd.setMaxCommandLength(this.settings.getMaxCommandLength());
        gcsd.setTruncateDecimalLength(this.settings.getTruncateDecimalLength());
        gcsd.setSingleStepModeEnabled(this.settings.isSingleStepMode());
        gcsd.setRemoveAllWhitespace(this.settings.isRemoveAllWhitespace());
        gcsd.setStatusUpdatesEnabled(this.settings.isStatusUpdatesEnabled());
        gcsd.setStatusUpdatesRate(this.settings.getStatusUpdateRate());
        gcsd.setStateColorDisplayEnabled(this.settings.isDisplayStateColor());
        gcsd.setConvertArcsToLines(this.settings.isConvertArcsToLines());
        gcsd.setSmallArcThreshold(this.settings.getSmallArcThreshold());
        gcsd.setSmallArcSegmentLengthSpinner(this.settings.getSmallArcSegmentLength());
        gcsd.setselectedLanguage(this.settings.getLanguage());
        gcsd.setVisible(true);
        if (gcsd.saveChanges()) {
            this.settings.setOverrideSpeedSelected(gcsd.getSpeedOverrideEnabled());
            this.settings.setOverrideSpeedValue(gcsd.getSpeedOverridePercent());
            this.settings.setMaxCommandLength(gcsd.getMaxCommandLength());
            this.settings.setTruncateDecimalLength(gcsd.getTruncateDecimalLength());
            this.settings.setSingleStepMode(gcsd.getSingleStepModeEnabled());
            this.settings.setRemoveAllWhitespace(gcsd.getRemoveAllWhitespace());
            this.settings.setStatusUpdatesEnabled(gcsd.getStatusUpdatesEnabled());
            this.settings.setStatusUpdateRate(gcsd.getStatusUpdatesRate());
            this.settings.setDisplayStateColor(gcsd.getDisplayStateColor());
            this.settings.setConvertArcsToLines(gcsd.getConvertArcsToLines());
            this.settings.setSmallArcThreshold(gcsd.getSmallArcThreshold());
            this.settings.setSmallArcSegmentLength(gcsd.getSmallArcSegmentLength());
            this.settings.setLanguage(gcsd.getLanguage());
            try {
                this.backend.applySettings(this.settings);
            }
            catch (Exception e2) {
                MainWindow.displayErrorDialog(e2.getMessage());
            }
            if (this.vw != null) {
                this.vw.setMinArcLength(gcsd.getSmallArcThreshold());
                this.vw.setArcLength(gcsd.getSmallArcSegmentLength());
            }
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.fileTextField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
                File gcodeFile = this.fileChooser.getSelectedFile();
                this.backend.setFile(gcodeFile);
                if (this.vw != null) {
                    this.vw.setGcodeFile(gcodeFile.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                MainWindow.displayErrorDialog(ex.getMessage());
            }
        }
    }

    private void visualizeButtonActionPerformed(ActionEvent evt) {
        if (this.vw == null) {
            this.vw = new VisualizerWindow(this.settings.getVisualizerWindowSettings());
            final MainWindow mw = this;
            this.vw.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    mw.settings.getVisualizerWindowSettings().height = ce.getComponent().getSize().height;
                    mw.settings.getVisualizerWindowSettings().width = ce.getComponent().getSize().width;
                }

                @Override
                public void componentMoved(ComponentEvent ce) {
                    mw.settings.getVisualizerWindowSettings().xLocation = ce.getComponent().getLocation().x;
                    mw.settings.getVisualizerWindowSettings().yLocation = ce.getComponent().getLocation().y;
                }

                @Override
                public void componentShown(ComponentEvent ce) {
                }

                @Override
                public void componentHidden(ComponentEvent ce) {
                }
            });
            this.vw.setMinArcLength(this.settings.getSmallArcThreshold());
            this.vw.setArcLength(this.settings.getSmallArcSegmentLength());
            if (this.fileTextField.getText().length() > 1) {
                this.vw.setGcodeFile(this.fileTextField.getText());
            }
            this.backend.addControllerListener(this.vw);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.vw.setVisible(true);
            }
        });
    }

    public void cancelButtonActionPerformed() {
        try {
            this.backend.cancel();
        }
        catch (Exception e2) {
            MainWindow.displayErrorDialog(e2.getMessage());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelButtonActionPerformed();
    }

    public void pauseButtonActionPerformed() {
        try {
            this.backend.pauseResume();
        }
        catch (Exception e2) {
            MainWindow.displayErrorDialog(e2.getMessage());
        }
    }

    private void pauseButtonActionPerformed(ActionEvent evt) {
        this.pauseButtonActionPerformed();
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.durationValueLabel.setText(Utils.formattedMillis(MainWindow.this.backend.getSendDuration()));
                        MainWindow.this.remainingTimeValueLabel.setText(Utils.formattedMillis(MainWindow.this.backend.getSendRemainingDuration()));
                        MainWindow.this.sentRowsValueLabel.setText("" + MainWindow.this.backend.getNumSentRows());
                        MainWindow.this.remainingRowsValueLabel.setText("" + MainWindow.this.backend.getNumRemainingRows());
                        if (MainWindow.this.backend.isSending() && MainWindow.this.vw != null) {
                            MainWindow.this.vw.setCompletedCommandNumber((int)MainWindow.this.backend.getNumSentRows());
                        }
                    }
                });
            }
        };
        this.resetTimerLabels();
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(1000, actionListener);
        try {
            this.backend.send();
            this.resetSentRowLabels(this.backend.getNumRows());
            this.timer.start();
        }
        catch (Exception e2) {
            this.timer.stop();
            logger.log(Level.INFO, "Exception in sendButtonActionPerformed.", e2);
            MainWindow.displayErrorDialog(e2.getMessage());
        }
    }

    private void grblFirmwareSettingsMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (!this.backend.isConnected()) {
                MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.noFirmware"));
            } else if (this.backend.getController() instanceof GrblController) {
                GrblFirmwareSettingsDialog gfsd = new GrblFirmwareSettingsDialog((Frame)this, true, this.backend);
                gfsd.setVisible(true);
            } else {
                MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.notGrbl"));
            }
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                File newFile = this.fileChooser.getSelectedFile();
                AbstractController control = FirmwareUtils.getControllerFor("GRBL");
                this.backend.applySettingsToController(this.settings, control);
                this.backend.preprocessAndExportToFile(newFile);
            }
            catch (FileNotFoundException ex) {
                MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.openingFile") + ": " + ex.getMessage());
            }
            catch (IOException e2) {
                MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.processingFile") + ": " + e2.getMessage());
            }
            catch (Exception e3) {
                logger.log(Level.INFO, "Exception in saveButtonActionPerformed.", e3);
                MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.duringSave") + ": " + e3.getMessage());
            }
        }
    }

    private void startPendantServerButtonActionPerformed(ActionEvent evt) {
        this.pendantUI = new PendantUI(this.backend);
        this.pendantUI.start();
        this.startPendantServerButton.setEnabled(false);
        this.stopPendantServerButton.setEnabled(true);
        this.backend.addControllerListener(this.pendantUI);
    }

    private void stopPendantServerButtonActionPerformed(ActionEvent evt) {
        this.pendantUI.stop();
        this.startPendantServerButton.setEnabled(true);
        this.stopPendantServerButton.setEnabled(false);
    }

    private void customGcodeText1ActionPerformed(ActionEvent evt) {
        this.settings.setCustomGcode1(this.customGcodeText1.getText());
    }

    private void customGcodeButton5ActionPerformed(ActionEvent evt) {
        this.executeCustomGcode(this.customGcodeText5.getText());
    }

    private void customGcodeButton1ActionPerformed(ActionEvent evt) {
        this.executeCustomGcode(this.customGcodeText1.getText());
    }

    private void customGcodeButton2ActionPerformed(ActionEvent evt) {
        this.executeCustomGcode(this.customGcodeText2.getText());
    }

    private void customGcodeButton3ActionPerformed(ActionEvent evt) {
        this.executeCustomGcode(this.customGcodeText3.getText());
    }

    private void customGcodeButton4ActionPerformed(ActionEvent evt) {
        this.executeCustomGcode(this.customGcodeText4.getText());
    }

    private void resetZCoordinateButtonActionPerformed(ActionEvent evt) {
        try {
            this.backend.resetCoordinateToZero('Z');
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void resetYCoordinateButtonActionPerformed(ActionEvent evt) {
        try {
            this.backend.resetCoordinateToZero('Y');
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void resetXCoordinateButtonActionPerformed(ActionEvent evt) {
        try {
            this.backend.resetCoordinateToZero('X');
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void requestStateInformationActionPerformed(ActionEvent evt) {
        try {
            this.backend.requestParserState();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void softResetMachineControlActionPerformed(ActionEvent evt) {
        try {
            this.backend.issueSoftReset();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void helpButtonMachineControlActionPerformed(ActionEvent evt) {
        StringBuilder message = new StringBuilder().append(Localization.getString("mainWindow.resetZero")).append("\n").append(Localization.getString("mainWindow.returnToZero")).append("\n").append(Localization.getString("mainWindow.softReset")).append("\n").append(Localization.getString("mainWindow.homing")).append("\n").append(Localization.getString("mainWindow.alarmLock")).append("\n").append(Localization.getString("mainWindow.checkMode")).append("\n").append(Localization.getString("mainWindow.getState")).append("\n").append(Localization.getString("mainWindow.helpKeyboard")).append("\n").append(Localization.getString("mainWindow.helpKeyX")).append("\n").append(Localization.getString("mainWindow.helpKeyY")).append("\n").append(Localization.getString("mainWindow.helpKeyZ")).append("\n").append(Localization.getString("mainWindow.helpKeyPlusMinus")).append("\n").append(Localization.getString("mainWindow.helpKeyDivMul")).append("\n").append(Localization.getString("mainWindow.helpKeyZero")).append("\n");
        JOptionPane.showMessageDialog(new JFrame(), message, Localization.getString("mainWindow.helpDialog"), 1);
    }

    private void toggleCheckModeActionPerformed(ActionEvent evt) {
        try {
            this.backend.toggleCheckMode();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void killAlarmLockActionPerformed(ActionEvent evt) {
        try {
            this.backend.killAlarmLock();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void performHomingCycleButtonActionPerformed(ActionEvent evt) {
        try {
            this.backend.performHomingCycle();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private Utils.Units getSelectedUnits() {
        if (this.inchRadioButton.isSelected()) {
            return Utils.Units.INCH;
        }
        if (this.mmRadioButton.isSelected()) {
            return Utils.Units.MM;
        }
        return Utils.Units.UNKNOWN;
    }

    private void adjustManualLocation(int x, int y, int z) {
        try {
            this.backend.adjustManualLocation(x, y, z, this.getStepSize(), this.getSelectedUnits());
        }
        catch (Exception e2) {
            MainWindow.displayErrorDialog(e2.getMessage());
        }
    }

    private void yPlusButtonActionPerformed(ActionEvent evt) {
        this.adjustManualLocation(0, 1, 0);
    }

    private void zPlusButtonActionPerformed(ActionEvent evt) {
        this.adjustManualLocation(0, 0, 1);
    }

    private void xMinusButtonActionPerformed(ActionEvent evt) {
        this.adjustManualLocation(-1, 0, 0);
    }

    private void xPlusButtonActionPerformed(ActionEvent evt) {
        this.adjustManualLocation(1, 0, 0);
    }

    private void yMinusButtonActionPerformed(ActionEvent evt) {
        this.adjustManualLocation(0, -1, 0);
    }

    private void zMinusButtonActionPerformed(ActionEvent evt) {
        this.adjustManualLocation(0, 0, -1);
    }

    private void stepSizeSpinnerStateChanged(ChangeEvent evt) {
    }

    private void returnToZeroButtonActionPerformed(ActionEvent evt) {
        try {
            this.backend.returnToZero();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void resetCoordinatesButtonActionPerformed(ActionEvent evt) {
        try {
            this.backend.resetCoordinatesToZero();
        }
        catch (Exception ex) {
            MainWindow.displayErrorDialog(ex.getMessage());
        }
    }

    private void customGcodeText2ActionPerformed(ActionEvent evt) {
        this.settings.setCustomGcode2(this.customGcodeText2.getText());
    }

    private void customGcodeText3ActionPerformed(ActionEvent evt) {
        this.settings.setCustomGcode3(this.customGcodeText3.getText());
    }

    private void customGcodeText4ActionPerformed(ActionEvent evt) {
        this.settings.setCustomGcode4(this.customGcodeText4.getText());
    }

    private void customGcodeText5ActionPerformed(ActionEvent evt) {
        this.settings.setCustomGcode5(this.customGcodeText5.getText());
    }

    private void inchRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void mmRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void executeCustomGcode(String str) {
        str = str.replaceAll("(\\r\\n|\\n\\r|\\r|\\n)", "");
        final String[] parts = str.split(";");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String cmd : parts) {
                        MainWindow.this.backend.sendGcodeCommand(cmd);
                    }
                }
                catch (Exception ex) {
                    MainWindow.displayErrorDialog(ex.getMessage());
                }
            }
        });
        for (String cmd : parts) {
            this.manualCommandHistory.add(cmd);
            this.commandNum = -1;
        }
    }

    private void initFileChooser() {
        this.fileChooser = GcodeFileTypeFilter.getGcodeFileChooser(this.settings.getLastOpenedFilename());
    }

    private void initProgram() {
        Localization.initialize(this.settings.getLanguage());
        try {
            this.backend.applySettings(this.settings);
        }
        catch (Exception e2) {
            MainWindow.displayErrorDialog(e2.getMessage());
        }
        this.setLocalLabels();
        this.loadPortSelector();
        this.checkScrollWindow();
        this.loadFirmwareSelector();
        this.setTitle(Localization.getString("title") + " (" + Localization.getString("version") + " " + VERSION + ")");
        this.manualCommandHistory = new ArrayList<String>();
        this.commandTextField.addKeyListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e2) {
                if (MainWindow.this.arrowMovementEnabled.isSelected() && e2.getID() == 401 && MainWindow.this.xPlusButton.isEnabled()) {
                    switch (e2.getKeyCode()) {
                        case 39: 
                        case 102: 
                        case 227: {
                            MainWindow.this.xPlusButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 37: 
                        case 100: 
                        case 226: {
                            MainWindow.this.xMinusButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 38: 
                        case 104: 
                        case 224: {
                            MainWindow.this.yPlusButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 40: 
                        case 98: 
                        case 225: {
                            MainWindow.this.yMinusButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 33: 
                        case 105: {
                            MainWindow.this.zPlusButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 34: 
                        case 99: {
                            MainWindow.this.zMinusButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 107: {
                            MainWindow.this.increaseStepActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 109: {
                            MainWindow.this.decreaseStepActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 111: {
                            MainWindow.this.divideStepActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 106: {
                            MainWindow.this.multiplyStepActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                        case 96: 
                        case 155: {
                            MainWindow.this.resetCoordinatesButtonActionPerformed(null);
                            e2.consume();
                            return true;
                        }
                    }
                }
                return false;
            }
        });
    }

    private double getStepSize() {
        BigDecimal bd = new BigDecimal(this.stepSizeSpinner.getValue().toString()).setScale(3, RoundingMode.HALF_EVEN);
        return bd.doubleValue();
    }

    private void setStepSize(double val) {
        BigDecimal bd = new BigDecimal(val).setScale(3, RoundingMode.HALF_EVEN);
        val = bd.doubleValue();
        this.stepSizeSpinner.setValue(val);
    }

    private void setStatusColorForState(String state) {
        if (this.settings.isDisplayStateColor()) {
            Color color = null;
            color = state.equals(Localization.getString("mainWindow.status.alarm")) ? Color.RED : (state.equals(Localization.getString("mainWindow.status.hold")) ? Color.YELLOW : (state.equals(Localization.getString("mainWindow.status.queue")) ? Color.YELLOW : (state.equals(Localization.getString("mainWindow.status.run")) ? Color.GREEN : Color.WHITE)));
            this.activeStateLabel.setBackground(color);
            this.activeStateValueLabel.setBackground(color);
        } else {
            this.activeStateLabel.setBackground(null);
            this.activeStateValueLabel.setBackground(null);
        }
    }

    private void updateControls() {
        boolean hasFile;
        this.cancelButton.setEnabled(this.backend.canCancel());
        this.pauseButton.setEnabled(this.backend.canPause() || this.backend.isPaused());
        this.pauseButton.setText(this.backend.getPauseResumeText());
        this.sendButton.setEnabled(this.backend.canSend());
        boolean bl = hasFile = this.backend.getFile() != null;
        if (hasFile) {
            this.saveButton.setEnabled(true);
            this.visualizeButton.setEnabled(true);
            this.fileTextField.setEnabled(false);
        }
        switch (this.backend.getControlState()) {
            case COMM_DISCONNECTED: {
                this.updateConnectionControlsStateOpen(false);
                this.updateManualControls(false);
                this.updateWorkflowControls(false);
                this.updateCustomGcodeControls(false);
                this.setStatusColorForState("");
                break;
            }
            case COMM_IDLE: {
                this.updateConnectionControlsStateOpen(true);
                this.updateManualControls(true);
                this.updateWorkflowControls(true);
                this.updateCustomGcodeControls(true);
                break;
            }
            case COMM_SENDING: {
                this.updateWorkflowControls(false);
                this.updateCustomGcodeControls(false);
                this.updateManualControls(false);
                break;
            }
            case COMM_SENDING_PAUSED: {
                break;
            }
        }
    }

    private void updateConnectionControlsStateOpen(boolean isOpen) {
        this.commPortComboBox.setEnabled(!isOpen);
        this.baudrateSelectionComboBox.setEnabled(!isOpen);
        this.refreshButton.setEnabled(!isOpen);
        this.commandTextField.setEnabled(isOpen);
        if (isOpen) {
            this.opencloseButton.setText(Localization.getString("close"));
        } else {
            this.opencloseButton.setText(Localization.getString("open"));
        }
    }

    private void updateManualControls(boolean enabled) {
        this.arrowMovementEnabled.setEnabled(enabled);
        this.xMinusButton.setEnabled(enabled);
        this.xPlusButton.setEnabled(enabled);
        this.yMinusButton.setEnabled(enabled);
        this.yPlusButton.setEnabled(enabled);
        this.zMinusButton.setEnabled(enabled);
        this.zPlusButton.setEnabled(enabled);
        this.stepSizeLabel.setEnabled(enabled);
        this.stepSizeSpinner.setEnabled(enabled);
        this.inchRadioButton.setEnabled(enabled);
        this.mmRadioButton.setEnabled(enabled);
    }

    private void updateWorkflowControls(boolean enabled) {
        this.resetCoordinatesButton.setEnabled(enabled);
        this.resetXButton.setEnabled(enabled);
        this.resetYButton.setEnabled(enabled);
        this.resetZButton.setEnabled(enabled);
        this.returnToZeroButton.setEnabled(enabled);
        this.performHomingCycleButton.setEnabled(enabled);
        this.softResetMachineControl.setEnabled(enabled);
        this.killAlarmLock.setEnabled(enabled);
        this.toggleCheckMode.setEnabled(enabled);
        this.requestStateInformation.setEnabled(enabled);
    }

    private void updateCustomGcodeControls(boolean enabled) {
        this.customGcodeButton1.setEnabled(enabled);
        this.customGcodeButton2.setEnabled(enabled);
        this.customGcodeButton3.setEnabled(enabled);
        this.customGcodeButton4.setEnabled(enabled);
        this.customGcodeButton5.setEnabled(enabled);
        this.customGcodeText1.setEnabled(enabled);
        this.customGcodeText2.setEnabled(enabled);
        this.customGcodeText3.setEnabled(enabled);
        this.customGcodeText4.setEnabled(enabled);
        this.customGcodeText5.setEnabled(enabled);
    }

    private void resetTimerLabels() {
        this.durationValueLabel.setText("00:00:00");
        if (this.backend.getSendDuration() < 0L) {
            this.remainingTimeValueLabel.setText("estimating...");
        } else if (this.backend.getSendDuration() == 0L) {
            this.remainingTimeValueLabel.setText("--:--:--");
        } else {
            this.remainingTimeValueLabel.setText(Utils.formattedMillis(this.backend.getSendDuration()));
        }
    }

    private void resetSentRowLabels(long numRows) {
        String totalRows = String.valueOf(numRows);
        this.resetTimerLabels();
        this.sentRowsValueLabel.setText("0");
        this.remainingRowsValueLabel.setText(totalRows);
        this.rowsValueLabel.setText(totalRows);
    }

    private void setLocalLabels() {
        this.arrowMovementEnabled.setText(Localization.getString("mainWindow.swing.arrowMovementEnabled"));
        this.baudLabel.setText(Localization.getString("mainWindow.swing.baudLabel"));
        this.browseButton.setText(Localization.getString("mainWindow.swing.browseButton"));
        this.cancelButton.setText(Localization.getString("mainWindow.swing.cancelButton"));
        this.commandLabel.setText(Localization.getString("mainWindow.swing.commandLabel"));
        this.connectionPanel.setBorder(BorderFactory.createTitledBorder(Localization.getString("mainWindow.swing.connectionPanel")));
        this.controlContextTabbedPane.setTitleAt(0, Localization.getString("mainWindow.swing.controlContextTabbedPane.commands"));
        this.controlContextTabbedPane.setTitleAt(1, Localization.getString("mainWindow.swing.controlContextTabbedPane.fileMode"));
        this.controlContextTabbedPane.setTitleAt(2, Localization.getString("mainWindow.swing.controlContextTabbedPane.machineControl"));
        this.controlContextTabbedPane.setTitleAt(3, Localization.getString("mainWindow.swing.controlContextTabbedPane.macros"));
        this.durationLabel.setText(Localization.getString("mainWindow.swing.durationLabel"));
        this.fileLabel.setText(Localization.getString("mainWindow.swing.fileLabel"));
        this.firmwareLabel.setText(Localization.getString("mainWindow.swing.firmwareLabel"));
        this.firmwareSettingsMenu.setText(Localization.getString("mainWindow.swing.firmwareSettingsMenu"));
        this.grblConnectionSettingsMenuItem.setText(Localization.getString("mainWindow.swing.grblConnectionSettingsMenuItem"));
        this.grblFirmwareSettingsMenuItem.setText(Localization.getString("mainWindow.swing.grblFirmwareSettingsMenuItem"));
        this.helpButtonMachineControl.setText(Localization.getString("help"));
        this.settingsMenu.setText(Localization.getString("mainWindow.swing.settingsMenu"));
        this.statusPanel.setBorder(BorderFactory.createTitledBorder(Localization.getString("mainWindow.swing.statusPanel")));
        this.bottomTabbedPane.setTitleAt(0, Localization.getString("mainWindow.swing.bottomTabbedPane.console"));
        this.bottomTabbedPane.setTitleAt(1, Localization.getString("mainWindow.swing.bottomTabbedPane.table"));
        this.latestCommentLabel.setText(Localization.getString("mainWindow.swing.latestCommentLabel"));
        this.machinePosition.setText(Localization.getString("mainWindow.swing.machinePosition"));
        this.opencloseButton.setText(Localization.getString("mainWindow.swing.opencloseButton"));
        this.pauseButton.setText(Localization.getString("mainWindow.swing.pauseButton"));
        this.portLabel.setText(Localization.getString("mainWindow.swing.portLabel"));
        this.remainingRowsLabel.setText(Localization.getString("mainWindow.swing.remainingRowsLabel"));
        this.remainingTimeLabel.setText(Localization.getString("mainWindow.swing.remainingTimeLabel"));
        this.resetCoordinatesButton.setText(Localization.getString("mainWindow.swing.resetCoordinatesButton"));
        this.returnToZeroButton.setText(Localization.getString("mainWindow.swing.returnToZeroButton"));
        this.rowsLabel.setText(Localization.getString("mainWindow.swing.rowsLabel"));
        this.saveButton.setText(Localization.getString("save"));
        this.scrollWindowCheckBox.setText(Localization.getString("mainWindow.swing.scrollWindowCheckBox"));
        this.sendButton.setText(Localization.getString("mainWindow.swing.sendButton"));
        this.sentRowsLabel.setText(Localization.getString("mainWindow.swing.sentRowsLabel"));
        this.showVerboseOutputCheckBox.setText(Localization.getString("mainWindow.swing.showVerboseOutputCheckBox"));
        this.softResetMachineControl.setText(Localization.getString("mainWindow.swing.softResetMachineControl"));
        this.stepSizeLabel.setText(Localization.getString("mainWindow.swing.stepSizeLabel"));
        this.visualizeButton.setText(Localization.getString("mainWindow.swing.visualizeButton"));
        this.workPositionLabel.setText(Localization.getString("mainWindow.swing.workPositionLabel"));
        this.macroInstructions.setText(Localization.getString("mainWindow.swing.macroInstructions"));
        this.inchRadioButton.setText(Localization.getString("mainWindow.swing.inchRadioButton"));
        this.mmRadioButton.setText(Localization.getString("mainWindow.swing.mmRadioButton"));
    }

    private void loadPortSelector() {
        this.commPortComboBox.removeAllItems();
        String[] portList = CommUtils.getSerialPortList();
        if (portList.length < 1) {
            MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.noSerialPort"));
        } else {
            for (String port : portList) {
                this.commPortComboBox.addItem(port);
            }
            this.commPortComboBox.setSelectedIndex(0);
        }
    }

    private void loadFirmwareSelector() {
        this.firmwareComboBox.removeAllItems();
        ArrayList<String> firmwareList = FirmwareUtils.getFirmwareList();
        if (firmwareList.size() < 1) {
            MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.noFirmware"));
        } else {
            Iterator iter = firmwareList.iterator();
            while (iter.hasNext()) {
                this.firmwareComboBox.addItem(iter.next());
            }
        }
    }

    private void checkScrollWindow() {
        DefaultCaret caret = (DefaultCaret)this.consoleTextArea.getCaret();
        if (this.scrollWindowCheckBox.isSelected()) {
            caret.setUpdatePolicy(2);
            this.consoleTextArea.setCaretPosition(this.consoleTextArea.getDocument().getLength());
        } else {
            caret.setUpdatePolicy(1);
        }
        this.commandTable.setAutoWindowScroll(this.scrollWindowCheckBox.isSelected());
    }

    private String getNewline() {
        return "\r\n";
    }

    void clearTable() {
        this.commandTable.clear();
    }

    private static void displayErrorDialog(final String errorMessage) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(new JFrame(), errorMessage, Localization.getString("error"), 0);
            }
        });
    }

    @Override
    public void fileStreamComplete(String filename, boolean success) {
        this.timer.stop();
        this.remainingTimeValueLabel.setText(Utils.formattedMillis(0L));
        this.remainingRowsValueLabel.setText("" + this.backend.getNumRemainingRows());
        final String durationLabelCopy = this.durationValueLabel.getText();
        if (success) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(new JFrame(), Localization.getString("mainWindow.ui.jobComplete") + " " + durationLabelCopy, Localization.getString("success"), 1);
                }
            });
        } else {
            MainWindow.displayErrorDialog(Localization.getString("mainWindow.error.jobComplete"));
        }
    }

    @Override
    public void commandQueued(GcodeCommand command) {
        this.commandTable.addRow(command);
    }

    @Override
    public void commandSent(final GcodeCommand command) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.commandTable.updateRow(command);
            }
        });
    }

    @Override
    public void commandComment(String comment) {
        this.latestCommentValueLabel.setText(comment);
    }

    @Override
    public void commandComplete(final GcodeCommand command) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.commandTable.updateRow(command);
            }
        });
    }

    @Override
    public void messageForConsole(final String msg, final Boolean verbose) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!verbose.booleanValue() || MainWindow.this.showVerboseOutputCheckBox.isSelected()) {
                    String verboseS = "[" + Localization.getString("verbose") + "]";
                    MainWindow.this.consoleTextArea.append((verbose != false ? verboseS : "") + msg);
                    if (MainWindow.this.consoleTextArea.isVisible() && MainWindow.this.scrollWindowCheckBox.isSelected()) {
                        MainWindow.this.consoleTextArea.setCaretPosition(MainWindow.this.consoleTextArea.getDocument().getLength());
                    }
                }
            }
        });
    }

    @Override
    public void statusStringListener(String state, Point3d machineCoord, Point3d workCoord) {
        this.activeStateValueLabel.setText(state);
        this.setStatusColorForState(state);
        if (machineCoord != null) {
            this.machinePositionXValueLabel.setText(Utils.formatter.format(machineCoord.x) + "");
            this.machinePositionYValueLabel.setText(Utils.formatter.format(machineCoord.y) + "");
            this.machinePositionZValueLabel.setText(Utils.formatter.format(machineCoord.z) + "");
        }
        if (workCoord != null) {
            this.workPositionXValueLabel.setText(Utils.formatter.format(workCoord.x) + "");
            this.workPositionYValueLabel.setText(Utils.formatter.format(workCoord.y) + "");
            this.workPositionZValueLabel.setText(Utils.formatter.format(workCoord.z) + "");
        }
    }

    @Override
    public void postProcessData(int numRows) {
    }

    @Override
    public void ControlStateEvent(ControlStateEvent evt) {
        switch (evt.getEventType()) {
            case STATE_CHANGED: 
            case FILE_CHANGED: {
                this.updateControls();
            }
        }
    }
}

