/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.willwinder.universalgcodesender.AbstractController;
import com.willwinder.universalgcodesender.TinyGCommunicator;
import com.willwinder.universalgcodesender.gcode.TinyGGcodeCommandCreator;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.model.Utils;
import com.willwinder.universalgcodesender.types.TinyGGcodeCommand;
import java.io.IOException;
import java.util.Collection;
import javax.vecmath.Point3d;

public class TinyGController
extends AbstractController {
    boolean isReady = false;
    Utils.Units units;
    String state = "";
    Point3d machineLocation = new Point3d();
    Point3d workLocation = new Point3d();

    protected TinyGController(TinyGCommunicator comm) {
        super(comm);
        this.commandCreator = new TinyGGcodeCommandCreator();
    }

    public TinyGController() {
        this(new TinyGCommunicator());
    }

    @Override
    public long getJobLengthEstimate(Collection<String> jobLines) {
        return 0L;
    }

    @Override
    protected void closeCommBeforeEvent() {
    }

    @Override
    protected void closeCommAfterEvent() {
    }

    @Override
    protected void openCommAfterEvent() throws Exception {
        byte b2 = 24;
        this.comm.sendByteImmediately(b2);
    }

    @Override
    protected void cancelSendBeforeEvent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void cancelSendAfterEvent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void pauseStreamingEvent() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void resumeStreamingEvent() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void rawResponseHandler(String response) {
        JsonObject jo;
        try {
            jo = TinyGUtils.jsonToObject(response);
        }
        catch (Exception e2) {
            return;
        }
        if (TinyGUtils.isRestartingResponse(jo)) {
            this.messageForConsole("[restarting] " + response + "\n");
            this.isReady = false;
        } else if (TinyGUtils.isReadyResponse(jo)) {
            this.messageForConsole("[ready] " + response + "\n");
            this.isReady = true;
        } else if (TinyGUtils.isStatusResponse(jo)) {
            TinyGUtils.StatusResult result = TinyGUtils.updateStatus(jo);
            this.state = result.state;
            this.machineLocation.set(result.machine);
            this.workLocation.set(result.work);
            this.dispatchStatusString(this.state, this.machineLocation, this.workLocation);
        } else if (TinyGGcodeCommand.isOkErrorResponse(response).booleanValue()) {
            try {
                this.commandComplete(response);
            }
            catch (Exception e3) {
                this.errorMessageForConsole(Localization.getString("controller.error.response") + " <" + response + ">: " + e3.getMessage());
            }
            this.messageForConsole(response + "\n");
        } else {
            this.messageForConsole("[unhandled message] " + response + "\n");
        }
    }

    @Override
    public void performHomingCycle() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void resetCoordinatesToZero() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void returnToHome() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void killAlarmLock() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void toggleCheckMode() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void viewParserState() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void softReset() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void isReadyToSendCommandsEvent() throws Exception {
    }

    @Override
    protected void statusUpdatesEnabledValueChanged(boolean enabled) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void statusUpdatesRateValueChanged(int rate) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void currentUnits(Utils.Units units) {
        this.units = units;
    }

    static class TinyGUtils {
        static JsonParser parser = new JsonParser();

        TinyGUtils() {
        }

        private static JsonObject jsonToObject(String response) {
            return parser.parse(response).getAsJsonObject();
        }

        private static boolean isTinyGVersion(JsonObject response) {
            JsonObject jo;
            return response.has("r") && (jo = response.getAsJsonObject("r")).has("fv");
        }

        private static String getVersion(JsonObject response) {
            JsonObject jo;
            if (response.has("r") && (jo = response.getAsJsonObject("r")).has("fv")) {
                return jo.get("fv").getAsString();
            }
            return "";
        }

        private static boolean isRestartingResponse(JsonObject response) {
            JsonObject jo;
            if (response.has("r") && (jo = response.getAsJsonObject("r")).has("msg")) {
                String msg = jo.get("msg").getAsString();
                return msg.equals("Loading configs from EEPROM");
            }
            return false;
        }

        private static boolean isReadyResponse(JsonObject response) {
            JsonObject jo;
            if (response.has("r") && (jo = response.getAsJsonObject("r")).has("msg")) {
                String msg = jo.get("msg").getAsString();
                return msg.equals("SYSTEM READY");
            }
            return false;
        }

        private static boolean isStatusResponse(JsonObject response) {
            return response.has("sr");
        }

        private static StatusResult updateStatus(JsonObject response) {
            StatusResult result = new StatusResult();
            if (response.has("sr")) {
                JsonObject jo = response.getAsJsonObject("sr");
                if (jo.has("posx")) {
                    result.machine.x = jo.get("posx").getAsDouble();
                }
                if (jo.has("posy")) {
                    result.machine.y = jo.get("posy").getAsDouble();
                }
                if (jo.has("posz")) {
                    result.machine.z = jo.get("posz").getAsDouble();
                }
                if (jo.has("stat")) {
                    result.state = TinyGUtils.getStateAsString(jo.get("stat").getAsInt());
                }
                result.work.set(result.machine);
            }
            return result;
        }

        private static String getStateAsString(int state) {
            switch (state) {
                case 0: {
                    return "initializing";
                }
                case 1: {
                    return "ready";
                }
                case 2: {
                    return "shutdown";
                }
                case 3: {
                    return "stop";
                }
                case 4: {
                    return "end";
                }
                case 5: {
                    return "run";
                }
                case 6: {
                    return "hold";
                }
                case 9: {
                    return "homing";
                }
            }
            return "unknown(" + state + ")";
        }

        private static class StatusResult {
            Point3d machine = new Point3d();
            Point3d work = new Point3d();
            String state;

            private StatusResult() {
            }
        }
    }
}

