/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.gcode;

import com.willwinder.universalgcodesender.i18n.Localization;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;

public class GcodePreprocessorUtils {
    public static final String EMPTY = "";
    private static Pattern COMMENT_PAREN = Pattern.compile("\\([^\\(]*\\)");
    private static Pattern COMMENT_SEMICOLON = Pattern.compile(";.*");
    private static Pattern COMMENTPARSE = Pattern.compile("(?<=\\()[^\\(\\)]*|(?<=\\;).*|%");
    private static Pattern WHITESPACE = Pattern.compile("\\s");
    private static Pattern M30 = Pattern.compile("[Mm]30");
    private static Pattern gPattern = Pattern.compile("[Gg]0*(\\d+)");
    private static int decimalLength = -1;
    private static Pattern decimalPattern;
    private static DecimalFormat decimalFormatter;
    private static Pattern mPattern;

    public static String overrideSpeed(String command, double speed) {
        String returnString = command;
        Pattern pattern = Pattern.compile("F([0-9.]+)", 2);
        Matcher matcher = pattern.matcher(command);
        if (matcher.find()) {
            Double originalFeedRate = Double.parseDouble(matcher.group(1));
            Double newFeedRate = originalFeedRate * speed / 100.0;
            returnString = matcher.replaceAll("F" + newFeedRate.toString());
        }
        return returnString;
    }

    public static String removeComment(String command) {
        String newCommand = command;
        newCommand = COMMENT_PAREN.matcher(command).replaceAll(EMPTY);
        if ((newCommand = COMMENT_SEMICOLON.matcher(newCommand).replaceAll(EMPTY)).endsWith("%")) {
            newCommand = newCommand.substring(0, newCommand.length() - 1);
        }
        return newCommand.trim();
    }

    public static String parseComment(String command) {
        String comment = EMPTY;
        Matcher matcher = COMMENTPARSE.matcher(command);
        if (matcher.find()) {
            comment = matcher.group(0);
        }
        return comment;
    }

    public static String truncateDecimals(int length, String command) {
        if (length != decimalLength) {
            GcodePreprocessorUtils.updateDecimalFormatter(length);
        }
        Matcher matcher = decimalPattern.matcher(command);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            Double d2 = Double.parseDouble(matcher.group());
            matcher.appendReplacement(sb, decimalFormatter.format(d2));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static void updateDecimalFormatter(int length) {
        int i2;
        StringBuilder df = new StringBuilder();
        df.append("#");
        if (length != 0) {
            df.append(".");
        }
        for (i2 = 0; i2 < length; ++i2) {
            df.append('#');
        }
        decimalFormatter = new DecimalFormat(df.toString(), Localization.dfs);
        df = new StringBuilder();
        df.append("\\d+\\.\\d");
        for (i2 = 0; i2 < length; ++i2) {
            df.append("\\d");
        }
        df.append('+');
        decimalPattern = Pattern.compile(df.toString());
        decimalLength = length;
    }

    public static String removeAllWhitespace(String command) {
        return WHITESPACE.matcher(command).replaceAll(EMPTY);
    }

    public static String removeM30(String command) {
        return M30.matcher(command).replaceAll(EMPTY);
    }

    public static List<String> parseCodes(List<String> args, char code) {
        ArrayList<String> l2 = new ArrayList<String>();
        char address = Character.toUpperCase(code);
        for (String s : args) {
            if (s.length() <= 0 || Character.toUpperCase(s.charAt(0)) != address) continue;
            l2.add(s.substring(1));
        }
        return l2;
    }

    public static List<Integer> parseGCodes(String command) {
        Matcher matcher = gPattern.matcher(command);
        ArrayList<Integer> codes = new ArrayList<Integer>();
        while (matcher.find()) {
            codes.add(Integer.parseInt(matcher.group(1)));
        }
        return codes;
    }

    public static List<Integer> parseMCodes(String command) {
        Matcher matcher = gPattern.matcher(command);
        ArrayList<Integer> codes = new ArrayList<Integer>();
        while (matcher.find()) {
            codes.add(Integer.parseInt(matcher.group(1)));
        }
        return codes;
    }

    public static Point3d updatePointWithCommand(String command, Point3d initial, boolean absoluteMode) {
        List<String> l2 = GcodePreprocessorUtils.splitCommand(command);
        return GcodePreprocessorUtils.updatePointWithCommand(l2, initial, absoluteMode);
    }

    public static Point3d updatePointWithCommand(List<String> commandArgs, Point3d initial, boolean absoluteMode) {
        double x = GcodePreprocessorUtils.parseCoord(commandArgs, 'X');
        double y = GcodePreprocessorUtils.parseCoord(commandArgs, 'Y');
        double z = GcodePreprocessorUtils.parseCoord(commandArgs, 'Z');
        return GcodePreprocessorUtils.updatePointWithCommand(initial, x, y, z, absoluteMode);
    }

    public static Point3d updatePointWithCommand(Point3d initial, double x, double y, double z, boolean absoluteMode) {
        Point3d newPoint = new Point3d(initial.x, initial.y, initial.z);
        if (absoluteMode) {
            if (!Double.isNaN(x)) {
                newPoint.x = x;
            }
            if (!Double.isNaN(y)) {
                newPoint.y = y;
            }
            if (!Double.isNaN(z)) {
                newPoint.z = z;
            }
        } else {
            if (!Double.isNaN(x)) {
                newPoint.x += x;
            }
            if (!Double.isNaN(y)) {
                newPoint.y += y;
            }
            if (!Double.isNaN(z)) {
                newPoint.z += z;
            }
        }
        return newPoint;
    }

    public static Point3d updateCenterWithCommand(List<String> commandArgs, Point3d initial, Point3d nextPoint, boolean absoluteIJKMode, boolean clockwise) {
        double i2 = GcodePreprocessorUtils.parseCoord(commandArgs, 'I');
        double j2 = GcodePreprocessorUtils.parseCoord(commandArgs, 'J');
        double k2 = GcodePreprocessorUtils.parseCoord(commandArgs, 'K');
        double radius = GcodePreprocessorUtils.parseCoord(commandArgs, 'R');
        if (Double.isNaN(i2) && Double.isNaN(j2) && Double.isNaN(k2)) {
            return GcodePreprocessorUtils.convertRToCenter(initial, nextPoint, radius, absoluteIJKMode, clockwise);
        }
        return GcodePreprocessorUtils.updatePointWithCommand(initial, i2, j2, k2, absoluteIJKMode);
    }

    public static String generateG1FromPoints(Point3d start, Point3d end, boolean absoluteMode, DecimalFormat formatter) {
        DecimalFormat df = formatter;
        if (df == null) {
            df = new DecimalFormat("#.####");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("G1");
        if (absoluteMode) {
            if (!Double.isNaN(end.x)) {
                sb.append("X");
                sb.append(df.format(end.x));
            }
            if (!Double.isNaN(end.y)) {
                sb.append("Y");
                sb.append(df.format(end.y));
            }
            if (!Double.isNaN(end.z)) {
                sb.append("Z");
                sb.append(df.format(end.z));
            }
        } else {
            if (!Double.isNaN(end.x)) {
                sb.append("X");
                sb.append(df.format(end.x - start.x));
            }
            if (!Double.isNaN(end.y)) {
                sb.append("Y");
                sb.append(df.format(end.y - start.x));
            }
            if (!Double.isNaN(end.z)) {
                sb.append("Z");
                sb.append(df.format(end.z - start.x));
            }
        }
        return sb.toString();
    }

    public static List<String> splitCommand(String command) {
        ArrayList<String> l2 = new ArrayList<String>();
        boolean readNumeric = false;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < command.length(); ++i2) {
            char c2 = command.charAt(i2);
            if (readNumeric && !Character.isDigit(c2) && c2 != '.') {
                readNumeric = false;
                l2.add(sb.toString());
                sb = new StringBuilder();
                if (!Character.isLetter(c2)) continue;
                sb.append(c2);
                continue;
            }
            if (Character.isDigit(c2) || c2 == '.' || c2 == '-') {
                sb.append(c2);
                readNumeric = true;
                continue;
            }
            if (!Character.isLetter(c2)) continue;
            sb.append(c2);
        }
        if (sb.length() > 0) {
            l2.add(sb.toString());
        }
        return l2;
    }

    public static double parseCoord(List<String> argList, char c2) {
        char address = Character.toUpperCase(c2);
        for (String t : argList) {
            if (t.length() <= 0 || Character.toUpperCase(t.charAt(0)) != address) continue;
            return Double.parseDouble(t.substring(1));
        }
        return Double.NaN;
    }

    public static List<String> convertArcsToLines(Point3d start, Point3d end) {
        ArrayList<String> l2 = new ArrayList<String>();
        return l2;
    }

    public static Point3d convertRToCenter(Point3d start, Point3d end, double radius, boolean absoluteIJK, boolean clockwise) {
        double R = radius;
        Point3d center = new Point3d();
        double x = end.x - start.x;
        double y = end.y - start.y;
        double h_x2_div_d = 4.0 * R * R - x * x - y * y;
        if (h_x2_div_d < 0.0) {
            System.out.println("Error computing arc radius.");
        }
        h_x2_div_d = -Math.sqrt(h_x2_div_d) / Math.hypot(x, y);
        if (!clockwise) {
            h_x2_div_d = -h_x2_div_d;
        }
        if (R < 0.0) {
            h_x2_div_d = -h_x2_div_d;
            radius = -radius;
        }
        double offsetX = 0.5 * (x - y * h_x2_div_d);
        double offsetY = 0.5 * (y + x * h_x2_div_d);
        if (!absoluteIJK) {
            center.x = start.x + offsetX;
            center.y = start.y + offsetY;
        } else {
            center.x = offsetX;
            center.y = offsetY;
        }
        return center;
    }

    public static double getAngle(Point3d start, Point3d end) {
        double deltaX = end.x - start.x;
        double deltaY = end.y - start.y;
        double angle = 0.0;
        if (deltaX != 0.0) {
            if (deltaX > 0.0 && deltaY >= 0.0) {
                angle = Math.atan(deltaY / deltaX);
            } else if (deltaX < 0.0 && deltaY >= 0.0) {
                angle = Math.PI - Math.abs(Math.atan(deltaY / deltaX));
            } else if (deltaX < 0.0 && deltaY < 0.0) {
                angle = Math.PI + Math.abs(Math.atan(deltaY / deltaX));
            } else if (deltaX > 0.0 && deltaY < 0.0) {
                angle = Math.PI * 2 - Math.abs(Math.atan(deltaY / deltaX));
            }
        } else {
            angle = deltaY > 0.0 ? 1.5707963267948966 : 4.71238898038469;
        }
        return angle;
    }

    public static double calculateSweep(double startAngle, double endAngle, boolean isCw) {
        double sweep;
        if (startAngle == endAngle) {
            sweep = Math.PI * 2;
        } else {
            if (endAngle == 0.0) {
                endAngle = Math.PI * 2;
            }
            sweep = !isCw && endAngle < startAngle ? Math.PI * 2 - startAngle + endAngle : (isCw && endAngle > startAngle ? Math.PI * 2 - endAngle + startAngle : Math.abs(endAngle - startAngle));
        }
        return sweep;
    }

    public static List<Point3d> generatePointsAlongArcBDring(Point3d start, Point3d end, Point3d center, boolean clockwise, double R, double minArcLength, double arcSegmentLength) {
        double radius = R;
        if (radius == 0.0) {
            radius = Math.sqrt(Math.pow(start.x - center.x, 2.0) + Math.pow(end.y - center.y, 2.0));
        }
        double startAngle = GcodePreprocessorUtils.getAngle(center, start);
        double endAngle = GcodePreprocessorUtils.getAngle(center, end);
        double sweep = GcodePreprocessorUtils.calculateSweep(startAngle, endAngle, clockwise);
        double arcLength = sweep * radius;
        if (minArcLength > 0.0 && arcLength < minArcLength) {
            return null;
        }
        int numPoints = 20;
        if (arcSegmentLength <= 0.0 && minArcLength > 0.0) {
            arcSegmentLength = sweep * radius / minArcLength;
        }
        if (arcSegmentLength > 0.0) {
            numPoints = (int)Math.ceil(arcLength / arcSegmentLength);
        }
        return GcodePreprocessorUtils.generatePointsAlongArcBDring(start, end, center, clockwise, radius, startAngle, sweep, numPoints);
    }

    public static List<Point3d> generatePointsAlongArcBDring(Point3d p1, Point3d p2, Point3d center, boolean isCw, double radius, double startAngle, double sweep, int numPoints) {
        Point3d lineStart = new Point3d(p1.x, p1.y, p1.z);
        ArrayList<Point3d> segments = new ArrayList<Point3d>();
        if (radius == 0.0) {
            radius = Math.sqrt(Math.pow(p1.x - center.x, 2.0) + Math.pow(p1.y - center.y, 2.0));
        }
        double zIncrement = (p2.z - p1.z) / (double)numPoints;
        for (int i2 = 0; i2 < numPoints; ++i2) {
            double angle = isCw ? startAngle - (double)i2 * sweep / (double)numPoints : startAngle + (double)i2 * sweep / (double)numPoints;
            if (angle >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            lineStart.x = Math.cos(angle) * radius + center.x;
            lineStart.y = Math.sin(angle) * radius + center.y;
            lineStart.z += zIncrement;
            segments.add(new Point3d(lineStart));
        }
        segments.add(new Point3d(p2));
        return segments;
    }

    static {
        mPattern = Pattern.compile("[Mm]0*(\\d+)");
    }
}

