/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.listeners;

import com.willwinder.universalgcodesender.AbstractController;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;

public class GrblSettingsListener
implements ControllerListener {
    public boolean inParsingMode = false;
    private boolean firstSettingReceived = false;
    public boolean sending = false;
    private Object refreshLock = new Object();
    public final List<String> settings = new ArrayList<String>();
    private AbstractController controller;

    public GrblSettingsListener(AbstractController controller) {
        this.controller = controller;
        this.controller.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSettings() {
        if (this.settings.size() == 0) {
            Object object = this.refreshLock;
            synchronized (object) {
                if (this.settings.size() == 0) {
                    this.refreshSettings();
                }
            }
        }
        return this.settings;
    }

    public void refreshSettings() {
        try {
            boolean ready;
            this.sending = true;
            do {
                try {
                    this.controller.isReadyToStreamFile();
                    ready = true;
                }
                catch (Exception e2) {
                    ready = false;
                }
            } while (!ready);
            this.controller.sendCommandImmediately("$$");
            while (this.sending) {
                Thread.sleep(10L);
            }
            while (this.inParsingMode) {
                Thread.sleep(1L);
            }
        }
        catch (Exception e3) {
            return;
        }
    }

    @Override
    public void fileStreamComplete(String filename, boolean success) {
    }

    @Override
    public void commandQueued(GcodeCommand command) {
    }

    @Override
    public void commandSent(GcodeCommand command) {
        if (command.getCommandString().startsWith("$$")) {
            this.inParsingMode = true;
            this.firstSettingReceived = false;
            if (this.sending) {
                this.sending = false;
            }
            this.settings.clear();
        }
    }

    @Override
    public void commandComplete(GcodeCommand command) {
    }

    @Override
    public void commandComment(String comment) {
    }

    @Override
    public void messageForConsole(String msg, Boolean verbose) {
        if (verbose.booleanValue()) {
            return;
        }
        if (this.inParsingMode) {
            if (this.firstSettingReceived && msg.startsWith("ok")) {
                this.inParsingMode = false;
            } else if (msg.startsWith("$")) {
                this.firstSettingReceived = true;
                this.settings.add(msg);
            }
        }
    }

    @Override
    public void statusStringListener(String state, Point3d machineCoord, Point3d workCoord) {
    }

    @Override
    public void postProcessData(int numRows) {
    }
}

