/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.types;

import javax.vecmath.Point3d;

public final class PointSegment {
    private int toolhead = 0;
    private double speed;
    private Point3d point;
    private boolean isMetric = true;
    private boolean isZMovement = false;
    private boolean isArc = false;
    private boolean isFastTraverse = false;
    private int lineNumber = -1;
    private ArcProperties arcProperties = null;

    public PointSegment() {
    }

    public PointSegment(PointSegment ps) {
        this(ps.point(), ps.getLineNumber());
        this.setToolHead(ps.toolhead);
        this.setSpeed(ps.speed);
        this.setIsMetric(ps.isMetric);
        this.setIsZMovement(ps.isZMovement);
        this.setIsFastTraverse(ps.isFastTraverse);
        if (ps.isArc) {
            this.setArcCenter(ps.center());
            this.setRadius(ps.getRadius());
            this.setIsClockwise(ps.isClockwise());
        }
    }

    public PointSegment(Point3d b2, int num) {
        this();
        this.point = new Point3d(b2);
        this.lineNumber = num;
    }

    public PointSegment(Point3d point, int num, Point3d center, double radius, boolean clockwise) {
        this(point, num);
        this.isArc = true;
        this.arcProperties = new ArcProperties();
        this.arcProperties.center = new Point3d(center);
        this.arcProperties.radius = radius;
        this.arcProperties.isClockwise = clockwise;
    }

    public void setPoint(Point3d point) {
        this.point = new Point3d(point);
    }

    public Point3d point() {
        return this.point;
    }

    public double[] points() {
        double[] points = new double[]{this.point.x, this.point.y, this.point.z};
        return points;
    }

    public void setToolHead(int head) {
        this.toolhead = head;
    }

    public int getToolhead() {
        return this.toolhead;
    }

    public void setLineNumber(int num) {
        this.lineNumber = num;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setSpeed(double s) {
        this.speed = s;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setIsZMovement(boolean isZ) {
        this.isZMovement = isZ;
    }

    public boolean isZMovement() {
        return this.isZMovement;
    }

    public void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public void setIsArc(boolean isA) {
        this.isArc = isA;
    }

    public boolean isArc() {
        return this.isArc;
    }

    public void setIsFastTraverse(boolean isF) {
        this.isFastTraverse = isF;
    }

    public boolean isFastTraverse() {
        return this.isFastTraverse;
    }

    public void setArcCenter(Point3d center) {
        if (this.arcProperties == null) {
            this.arcProperties = new ArcProperties();
        }
        this.arcProperties.center = new Point3d(center);
        this.setIsArc(true);
    }

    public double[] centerPoints() {
        if (this.arcProperties != null && this.arcProperties.center != null) {
            double[] points = new double[]{this.arcProperties.center.x, this.arcProperties.center.y, this.arcProperties.center.z};
            return points;
        }
        return null;
    }

    public Point3d center() {
        if (this.arcProperties != null && this.arcProperties.center != null) {
            return this.arcProperties.center;
        }
        return null;
    }

    public void setIsClockwise(boolean clockwise) {
        if (this.arcProperties == null) {
            this.arcProperties = new ArcProperties();
        }
        this.arcProperties.isClockwise = clockwise;
    }

    public boolean isClockwise() {
        if (this.arcProperties != null && this.arcProperties.center != null) {
            return this.arcProperties.isClockwise;
        }
        return false;
    }

    public void setRadius(double rad) {
        if (this.arcProperties == null) {
            this.arcProperties = new ArcProperties();
        }
        this.arcProperties.radius = rad;
    }

    public double getRadius() {
        if (this.arcProperties != null && this.arcProperties.center != null) {
            return this.arcProperties.radius;
        }
        return 0.0;
    }

    public void convertToMetric() {
        if (this.isMetric) {
            return;
        }
        this.isMetric = true;
        this.point.scale(25.4);
        if (this.isArc && this.arcProperties != null) {
            this.arcProperties.center.scale(25.4);
            this.arcProperties.radius *= 25.4;
        }
    }

    private class ArcProperties {
        public boolean isClockwise;
        public double radius = 0.0;
        public Point3d center = null;

        private ArcProperties() {
        }
    }
}

