/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.ui.TabControl;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import jmapps.ui.ImageArea;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.ProgressDialog;
import jmapps.ui.ProgressThread;
import jmapps.ui.TrackPanelAudio;
import jmapps.ui.TrackPanelVideo;
import jmapps.util.JMAppsCfg;

public class SaveAsDialog
extends JMDialog
implements ControllerListener,
DataSinkListener,
ItemListener {
    private JMAppsCfg cfgJMApps;
    private String inputURL;
    private DataSource dataSource = null;
    private Processor processor = null;
    private DataSink dataSink = null;
    private TrackControl[] arrTrackControls;
    private int nAudioTrackCount = 0;
    private int nVideoTrackCount = 0;
    private String strContentType = null;
    private String strContentTypeExt = null;
    private boolean boolSaving = false;
    private ProgressDialog dlgProgress = null;
    private ProgressThread threadProgress = null;
    private Format captureFormat = null;
    private TabControl tabControl;
    private Hashtable hashtablePanelsAudio = new Hashtable();
    private Hashtable hashtablePanelsVideo = new Hashtable();
    private Button buttonSave;
    private Button buttonCancel;
    private Choice comboContentType;
    private Image imageAudioEn = null;
    private Image imageAudioDis = null;
    private Image imageVideoEn = null;
    private Image imageVideoDis = null;
    private String strFailMessage = null;
    private ContentDescriptor[] supportedCDs;
    private static final String STR_MSVIDEO = JMFI18N.getResource("jmstudio.saveas.type.msvideo");
    private static final String STR_QUICKTIME = JMFI18N.getResource("jmstudio.saveas.type.quicktime");
    private static final String STR_AIFF = JMFI18N.getResource("jmstudio.saveas.type.aiff");
    private static final String STR_GSM = JMFI18N.getResource("jmstudio.saveas.type.gsm");
    private static final String STR_WAVE = JMFI18N.getResource("jmstudio.saveas.type.wave");
    private static final String STR_BASIC_AUDIO = JMFI18N.getResource("jmstudio.saveas.type.basicaudio");
    private static final String STR_MPEG_AUDIO = JMFI18N.getResource("jmstudio.saveas.type.mpegaudio");
    Object stateLock = new Object();
    boolean stateFailed = false;

    public SaveAsDialog(Frame frame, String inputURL, Format format, JMAppsCfg cfgJMApps) {
        super(frame, JMFI18N.getResource("jmstudio.saveas.title"), false);
        this.cfgJMApps = cfgJMApps;
        this.inputURL = inputURL;
        this.captureFormat = format;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public SaveAsDialog(Frame frame, DataSource dataSource, JMAppsCfg cfgJMApps) {
        super(frame, JMFI18N.getResource("jmstudio.saveas.title"), false);
        this.cfgJMApps = cfgJMApps;
        this.dataSource = dataSource;
        this.inputURL = "Capture";
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.imageAudioEn = ImageArea.loadImage("audio.gif", this, true);
        this.imageAudioDis = ImageArea.loadImage("audio-disabled.gif", this, true);
        this.imageVideoEn = ImageArea.loadImage("video.gif", this, true);
        this.imageVideoDis = ImageArea.loadImage("video-disabled.gif", this, true);
        this.frameOwner.setCursor(new Cursor(3));
        if (this.dataSource == null) {
            try {
                FormatControl[] fcs;
                MediaLocator mediaSource = new MediaLocator(this.inputURL);
                this.dataSource = Manager.createDataSource(mediaSource);
                if (this.captureFormat != null && this.dataSource instanceof CaptureDevice && (fcs = ((CaptureDevice)((Object)this.dataSource)).getFormatControls()) != null && fcs.length > 0) {
                    fcs[0].setFormat(this.captureFormat);
                }
            }
            catch (Exception exception) {
                MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.datasource.createfor") + " '" + this.inputURL + "'.", exception);
                this.frameOwner.setCursor(Cursor.getDefaultCursor());
                throw exception;
            }
        }
        this.strContentType = this.dataSource.getContentType();
        try {
            this.processor = Manager.createProcessor(this.dataSource);
        }
        catch (NoPlayerException exception) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.create"), exception);
            this.frameOwner.setCursor(Cursor.getDefaultCursor());
            throw exception;
        }
        this.processor.addControllerListener(this);
        boolean boolResult = this.waitForState(this.processor, 180);
        if (!boolResult) {
            this.frameOwner.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.supportedCDs = this.processor.getSupportedContentDescriptors();
        this.arrTrackControls = this.processor.getTrackControls();
        int i2 = 0;
        while (i2 < this.arrTrackControls.length) {
            Format format = this.arrTrackControls[i2].getFormat();
            if (format instanceof VideoFormat) {
                ++this.nVideoTrackCount;
            }
            if (format instanceof AudioFormat) {
                ++this.nAudioTrackCount;
            }
            ++i2;
        }
        this.setLayout(new BorderLayout());
        JMPanel panelBorder = new JMPanel(new BorderLayout(6, 6));
        panelBorder.setEmptyBorder(6, 6, 6, 6);
        panelBorder.setBackground(Color.lightGray);
        this.add((Component)panelBorder, "Center");
        Panel panel = this.createPanelGeneral();
        panelBorder.add((Component)panel, "North");
        panel = this.createPanelProperties();
        panelBorder.add((Component)panel, "Center");
        panel = new JMPanel(new FlowLayout(1));
        panelBorder.add((Component)panel, "South");
        JMPanel panelButtons = this.createButtonPanel(new String[]{JMDialog.ACTION_SAVE, JMDialog.ACTION_CANCEL});
        panel.add(panelButtons);
        this.changeContentType();
        this.pack();
        Dimension dim = this.getSize();
        dim.width += 64;
        ((Component)this).setSize(dim);
        this.addWindowListener(this);
        this.setResizable(false);
        this.setVisible(true);
        this.frameOwner.setCursor(Cursor.getDefaultCursor());
    }

    private Panel createPanelProperties() throws Exception {
        String strAudio = JMFI18N.getResource("jmstudio.saveas.audio");
        String strVideo = JMFI18N.getResource("jmstudio.saveas.video");
        this.tabControl = new TabControl(0);
        int nIndexAudio = 0;
        int nIndexVideo = 0;
        int nCount = this.arrTrackControls.length;
        int i2 = 0;
        while (i2 < nCount) {
            JMAppsCfg.TrackData dataTrack;
            String strTitle;
            Format format = this.arrTrackControls[i2].getFormat();
            if (format instanceof AudioFormat) {
                strTitle = this.nAudioTrackCount < 2 ? new String(strAudio) : new String(strAudio + " " + ++nIndexAudio);
                TrackPanelAudio panelAudio = new TrackPanelAudio(this.arrTrackControls[i2], this);
                this.tabControl.addPage(panelAudio, strTitle, this.imageAudioEn);
                this.hashtablePanelsAudio.put(strTitle, panelAudio);
                if (this.cfgJMApps != null && (dataTrack = this.cfgJMApps.getLastSaveFileTrackData(strTitle)) != null) {
                    panelAudio.setDefaults(dataTrack.boolEnable, dataTrack.format);
                }
            } else if (format instanceof VideoFormat) {
                strTitle = this.nVideoTrackCount < 2 ? new String(strVideo) : new String(strVideo + " " + ++nIndexVideo);
                TrackPanelVideo panelVideo = new TrackPanelVideo(this.arrTrackControls[i2], this);
                this.tabControl.addPage(panelVideo, strTitle, this.imageVideoEn);
                this.hashtablePanelsVideo.put(strTitle, panelVideo);
                if (this.cfgJMApps != null && (dataTrack = this.cfgJMApps.getLastSaveFileTrackData(strTitle)) != null) {
                    panelVideo.setDefaults(dataTrack.boolEnable, dataTrack.format);
                }
            }
            ++i2;
        }
        return this.tabControl;
    }

    private Panel createPanelGeneral() throws Exception {
        String strValue;
        Panel panelGeneral = new Panel(new GridLayout(0, 1, 4, 4));
        Panel panelFormat = new Panel(new BorderLayout());
        panelGeneral.add(panelFormat);
        Label label = new Label(JMFI18N.getResource("jmstudio.saveas.format"));
        panelFormat.add((Component)label, "West");
        this.comboContentType = new Choice();
        this.comboContentType.addItemListener(this);
        int i2 = 0;
        while (i2 < this.supportedCDs.length) {
            if (this.supportedCDs[i2] instanceof FileTypeDescriptor) {
                String ct = this.supportedCDs[i2].getContentType();
                strValue = this.transCDToDesc(ct);
                if (!(this.nAudioTrackCount < 1 && (strValue.equals(STR_AIFF) || strValue.equals(STR_GSM) || strValue.equals(STR_WAVE) || strValue.equals(STR_BASIC_AUDIO) || strValue.equals(STR_MPEG_AUDIO)))) {
                    this.comboContentType.addItem(strValue);
                }
            }
            ++i2;
        }
        strValue = null;
        if (this.cfgJMApps != null) {
            strValue = this.cfgJMApps.getLastSaveFileContentType();
        }
        if (strValue == null) {
            strValue = this.transCDToDesc(ContentDescriptor.mimeTypeToPackageName(this.strContentType));
        }
        this.comboContentType.select(strValue);
        panelFormat.add((Component)this.comboContentType, "Center");
        return panelGeneral;
    }

    private String transCDToDesc(String strContentType) {
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("video.x_msvideo"))) {
            return STR_MSVIDEO;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("video.quicktime"))) {
            return STR_QUICKTIME;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_aiff"))) {
            return STR_AIFF;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_gsm"))) {
            return STR_GSM;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_wav"))) {
            return STR_WAVE;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.basic"))) {
            return STR_BASIC_AUDIO;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.mpeg"))) {
            return STR_MPEG_AUDIO;
        }
        return strContentType;
    }

    private void doSave() {
        String strFileContentType = null;
        String strDirName = null;
        String strFileName = null;
        Component monitor = null;
        FileDialog dlgFile = new FileDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveas.filedialog"), 1);
        int i2 = this.inputURL.indexOf(58);
        strFileName = i2 > 2 ? this.inputURL.substring(i2 + 1) : new String(this.inputURL);
        if (strFileName.indexOf(47) == 0 && strFileName.indexOf(58) == 2) {
            strFileName = strFileName.substring(1);
        }
        if ((i2 = strFileName.lastIndexOf(46)) >= 0 && this.strContentTypeExt != null) {
            strFileName = strFileName.substring(0, i2 + 1) + this.strContentTypeExt;
        } else if (i2 < 0 && this.strContentTypeExt != null) {
            strFileName = "Unknown." + this.strContentTypeExt;
        }
        strDirName = this.cfgJMApps.getLastSaveFileDir();
        i2 = Math.max(strFileName.lastIndexOf(47), strFileName.lastIndexOf(92));
        if (i2 > -1) {
            if (strDirName == null) {
                strDirName = strFileName.substring(0, i2);
            }
            strFileName = strFileName.substring(i2 + 1);
        }
        if (strDirName != null) {
            dlgFile.setDirectory(strDirName);
        }
        dlgFile.setFile(strFileName);
        ((Component)dlgFile).setVisible(true);
        strFileName = dlgFile.getFile();
        if (strFileName == null || strFileName.length() == 0) {
            return;
        }
        strDirName = dlgFile.getDirectory();
        if (strDirName != null) {
            strFileName = strDirName.trim() + strFileName.trim();
            this.cfgJMApps.setLastSaveFileDir(strDirName);
        } else {
            strFileName = strFileName.trim();
        }
        if (this.cfgJMApps != null) {
            String strValue = this.comboContentType.getSelectedItem();
            this.cfgJMApps.setLastSaveFileContentType(strValue);
        }
        this.setCursor(new Cursor(3));
        try {
            TrackControl trackControl;
            JMAppsCfg.TrackData dataTrack;
            String strPanel;
            this.processor.setContentDescriptor(new FileTypeDescriptor(this.strContentType));
            Enumeration enumKeys = this.hashtablePanelsVideo.keys();
            while (enumKeys.hasMoreElements()) {
                strPanel = (String)enumKeys.nextElement();
                TrackPanelVideo panelVideo = (TrackPanelVideo)this.hashtablePanelsVideo.get(strPanel);
                panelVideo.updateTrack();
                if (this.cfgJMApps == null) continue;
                dataTrack = this.cfgJMApps.createTrackDataObject();
                trackControl = panelVideo.getTrackControl();
                dataTrack.boolEnable = trackControl.isEnabled();
                dataTrack.format = trackControl.getFormat();
                this.cfgJMApps.setLastSaveFileTrackData(dataTrack, strPanel);
            }
            enumKeys = this.hashtablePanelsAudio.keys();
            while (enumKeys.hasMoreElements()) {
                strPanel = (String)enumKeys.nextElement();
                TrackPanelAudio panelAudio = (TrackPanelAudio)this.hashtablePanelsAudio.get(strPanel);
                panelAudio.updateTrack();
                if (this.cfgJMApps == null) continue;
                dataTrack = this.cfgJMApps.createTrackDataObject();
                trackControl = panelAudio.getTrackControl();
                dataTrack.boolEnable = trackControl.isEnabled();
                dataTrack.format = trackControl.getFormat();
                this.cfgJMApps.setLastSaveFileTrackData(dataTrack, strPanel);
            }
            boolean boolResult = this.waitForState(this.processor, 300);
            if (!boolResult) {
                this.setCursor(Cursor.getDefaultCursor());
                this.processor.close();
                this.dispose();
                return;
            }
            strFileContentType = "file:";
            DataSource dataSource = this.processor.getDataOutput();
            int sepIndex = strFileName.lastIndexOf(File.separatorChar);
            String fileNameOnly = sepIndex >= 0 ? strFileName.substring(sepIndex + 1, strFileName.length()) : strFileName;
            if (fileNameOnly.indexOf(".") == -1) {
                strFileName = strFileName + "." + this.strContentTypeExt;
            }
            MediaLocator mediaDest = new MediaLocator(strFileContentType + strFileName);
            this.dataSink = Manager.createDataSink(dataSource, mediaDest);
            this.boolSaving = true;
            MonitorControl monitorControl = (MonitorControl)this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                monitor = monitorControl.getControlComponent();
            }
            Time duration = this.processor.getDuration();
            int nMediaDuration = (int)duration.getSeconds();
            this.dataSink.addDataSinkListener(this);
            try {
                this.dataSink.open();
            }
            catch (Exception e2) {
                this.processor.close();
                throw e2;
            }
            this.dataSink.start();
            this.processor.start();
            this.dlgProgress = nMediaDuration > 0 && duration != Duration.DURATION_UNBOUNDED && duration != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), 0, nMediaDuration, (ActionListener)this) : new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), JMFI18N.getResource("jmstudio.saveprogress.label"), monitor, (ActionListener)this);
            this.dlgProgress.setVisible(true);
            this.threadProgress = new ProgressThread(this.processor, this.dlgProgress);
            this.threadProgress.start();
        }
        catch (Exception exception) {
            this.boolSaving = false;
            MessageDialog.createErrorDialogModeless(this.frameOwner, null, exception);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    public void actionPerformed(ActionEvent event2) {
        Object objectSource2;
        String strCmd = event2.getActionCommand();
        if (strCmd.equals(JMDialog.ACTION_CANCEL)) {
            this.stopSaving();
            this.dispose();
        } else if (strCmd.equals(JMDialog.ACTION_SAVE)) {
            this.doSave();
        } else if ((strCmd.equals(ProgressDialog.ACTION_ABORT) || strCmd.equals(ProgressDialog.ACTION_STOP)) && this.boolSaving) {
            this.stopSaving();
        } else if (strCmd.equals(ProgressDialog.ACTION_PAUSE) && this.boolSaving) {
            this.processor.stop();
            this.dlgProgress.setPauseButtonText(ProgressDialog.ACTION_RESUME);
            this.threadProgress.pauseThread();
        } else if (strCmd.equals(ProgressDialog.ACTION_RESUME) && this.boolSaving) {
            this.processor.start();
            this.dlgProgress.setPauseButtonText(ProgressDialog.ACTION_PAUSE);
            this.threadProgress.resumeThread();
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            Object objectSource2 = event2.getSource();
            if (objectSource2 instanceof TrackPanelAudio) {
                this.tabControl.setPageImage((Panel)objectSource2, this.imageAudioEn);
            }
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_DISABLED")) {
            Object objectSource2 = event2.getSource();
            if (objectSource2 instanceof TrackPanelAudio) {
                this.tabControl.setPageImage((Panel)objectSource2, this.imageAudioDis);
            }
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_ENABLED")) {
            Object objectSource2 = event2.getSource();
            if (objectSource2 instanceof TrackPanelVideo) {
                this.tabControl.setPageImage((Panel)objectSource2, this.imageVideoEn);
            }
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_DISABLED") && (objectSource2 = event2.getSource()) instanceof TrackPanelVideo) {
            this.tabControl.setPageImage((Panel)objectSource2, this.imageVideoDis);
        }
    }

    public void itemStateChanged(ItemEvent event2) {
        Object objectSource = event2.getSource();
        if (objectSource == this.comboContentType) {
            this.changeContentType();
        }
    }

    public void windowClosing(WindowEvent event2) {
        this.stopSaving();
        this.dispose();
    }

    public void controllerUpdate(ControllerEvent event2) {
        if (event2 instanceof ControllerErrorEvent) {
            this.strFailMessage = ((ControllerErrorEvent)event2).getMessage();
            if (this.boolSaving) {
                this.stopSaving();
                MessageDialog.createErrorDialogModeless(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.savefile") + "\n" + JMFI18N.getResource("jmstudio.error.controller") + "\n" + this.strFailMessage);
            } else {
                MessageDialog.createErrorDialogModeless(this.frameOwner, JMFI18N.getResource("jmstudio.error.controller") + "\n" + this.strFailMessage);
            }
        } else if (event2 instanceof EndOfMediaEvent && this.boolSaving) {
            this.stopSaving();
        }
    }

    public void dataSinkUpdate(DataSinkEvent event2) {
        if (event2 instanceof EndOfStreamEvent) {
            this.closeDataSink();
        } else if (event2 instanceof DataSinkErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialogModeless(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.writefile"));
        }
    }

    private void closeDataSink() {
        SaveAsDialog saveAsDialog = this;
        synchronized (saveAsDialog) {
            if (this.dataSink != null) {
                this.dataSink.close();
            }
            this.dataSink = null;
        }
    }

    private void stopSaving() {
        this.boolSaving = false;
        if (this.threadProgress != null) {
            this.threadProgress.terminateNormaly();
            this.threadProgress = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.processor.close();
        }
        if (this.dlgProgress != null) {
            this.dlgProgress.dispose();
            this.dlgProgress = null;
        }
    }

    private synchronized boolean waitForState(Processor p, int state) {
        p.addControllerListener(new StateListener());
        this.stateFailed = false;
        if (state == 180) {
            p.configure();
        } else if (state == 300) {
            p.realize();
        }
        while (p.getState() < state && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException ie) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return !this.stateFailed;
    }

    private void changeContentType() {
        String strValue = this.comboContentType.getSelectedItem();
        if (strValue.equals(STR_MSVIDEO)) {
            this.strContentType = "video.x_msvideo";
            this.strContentTypeExt = "avi";
        } else if (strValue.equals(STR_QUICKTIME)) {
            this.strContentType = "video.quicktime";
            this.strContentTypeExt = "mov";
        } else if (strValue.equals(STR_AIFF)) {
            this.strContentType = "audio.x_aiff";
            this.strContentTypeExt = "aif";
        } else if (strValue.equals(STR_GSM)) {
            this.strContentType = "audio.x_gsm";
            this.strContentTypeExt = "gsm";
        } else if (strValue.equals(STR_WAVE)) {
            this.strContentType = "audio.x_wav";
            this.strContentTypeExt = "wav";
        } else if (strValue.equals(STR_BASIC_AUDIO)) {
            this.strContentType = "audio.basic";
            this.strContentTypeExt = "au";
        } else if (strValue.equals(STR_MPEG_AUDIO)) {
            this.strContentType = "audio.mpeg";
            this.strContentTypeExt = "mp3";
        } else {
            this.strContentType = strValue;
            this.strContentTypeExt = "movie";
        }
        if (this.processor.setContentDescriptor(new FileTypeDescriptor(this.strContentType)) == null) {
            System.err.println("Error setting content descriptor on processor");
        }
        Enumeration enumPanels = this.hashtablePanelsVideo.elements();
        while (enumPanels.hasMoreElements()) {
            TrackPanelVideo panelVideo = (TrackPanelVideo)enumPanels.nextElement();
            panelVideo.setContentType(this.strContentType);
        }
        enumPanels = this.hashtablePanelsAudio.elements();
        while (enumPanels.hasMoreElements()) {
            TrackPanelAudio panelAudio = (TrackPanelAudio)enumPanels.nextElement();
            panelAudio.setContentType(this.strContentType);
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                SaveAsDialog.this.stateFailed = true;
            }
            if (ce instanceof ControllerEvent) {
                Object object = SaveAsDialog.this.stateLock;
                synchronized (object) {
                    SaveAsDialog.this.stateLock.notifyAll();
                }
            }
        }
    }
}

