/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import jmapps.registry.VectorEditor;
import jmapps.registry.VectorPanel;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.PopupWait;

public class CDMPanel
extends JMPanel
implements VectorEditor,
ActionListener {
    Panel panelLeft;
    Button buttonDetect;
    VectorPanel panelDevices = null;
    Vector deviceVector;
    Vector deviceArray;
    Vector devices;
    TextArea textArea;
    int type;

    public CDMPanel() {
        this.setLayout(new GridLayout(1, 2, 6, 6));
        this.panelLeft = new Panel(new BorderLayout(6, 6));
        this.add(this.panelLeft);
        Panel panel = new Panel(new FlowLayout(0));
        this.panelLeft.add((Component)panel, "South");
        this.buttonDetect = new Button(JMFI18N.getResource("jmfregistry.capture.detect"));
        this.buttonDetect.addActionListener(this);
        panel.add(this.buttonDetect);
        this.createPanelDevices();
        panel = new Panel(new BorderLayout());
        this.add(panel);
        Label label = new Label(JMFI18N.getResource("jmfregistry.capture.details.label"));
        panel.add((Component)label, "North");
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        panel.add((Component)this.textArea, "Center");
    }

    public Vector stringArrayToVector(String[] array) {
        Vector<String> v = new Vector<String>();
        if (array != null) {
            int i2 = 0;
            while (i2 < array.length) {
                v.addElement(array[i2]);
                ++i2;
            }
        }
        return v;
    }

    public String[] vectorToStringArray(Vector v) {
        String[] sa = new String[v.size()];
        Enumeration e2 = v.elements();
        int i2 = 0;
        while (e2.hasMoreElements()) {
            sa[i2++] = (String)e2.nextElement();
        }
        return sa;
    }

    public Vector getList(int code) {
        this.devices = CaptureDeviceManager.getDeviceList(null);
        this.devices = (Vector)this.devices.clone();
        this.deviceVector = new Vector(10);
        Enumeration enumeration = this.devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
            this.deviceVector.addElement(cdi.getName());
        }
        return this.deviceVector;
    }

    public void setList(int code, Vector v) {
        this.deviceVector = v;
    }

    public void commit(int code) {
        int i2 = 0;
        while (i2 < this.devices.size()) {
            CaptureDeviceManager.removeDevice((CaptureDeviceInfo)this.devices.elementAt(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.deviceVector.size()) {
            String name = (String)this.deviceVector.elementAt(i2);
            int j2 = 0;
            while (j2 < this.devices.size()) {
                if (((CaptureDeviceInfo)this.devices.elementAt(j2)).getName().equals(name)) {
                    CaptureDeviceManager.addDevice((CaptureDeviceInfo)this.devices.elementAt(j2));
                    break;
                }
                ++j2;
            }
            ++i2;
        }
        try {
            CaptureDeviceManager.commit();
        }
        catch (IOException ioe) {
            System.err.println("CaptureDeviceManager.commit() - " + ioe);
        }
    }

    public boolean addToList(int code, String value) {
        try {
            CaptureDeviceInfo cdi;
            String className = value;
            Class<?> pic = Class.forName(className);
            Object instance = pic.newInstance();
            if (instance instanceof CaptureDeviceInfo && ((cdi = (CaptureDeviceInfo)instance).getName() != null || cdi.getLocator() != null) && CaptureDeviceManager.addDevice(cdi)) {
                return true;
            }
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        catch (Error er) {
            System.err.println(er);
        }
        return false;
    }

    public void selectedIndex(int code, int index) {
        String text = "";
        String name = null;
        CaptureDeviceInfo cdi = null;
        if (index >= 0) {
            name = (String)this.deviceVector.elementAt(index);
        }
        if (name != null) {
            cdi = CaptureDeviceManager.getDevice(name);
        }
        if (cdi != null) {
            text = text + JMFI18N.getResource("jmfregistry.details.name") + " = " + cdi.getName() + "\n\n";
            text = text + JMFI18N.getResource("jmfregistry.details.locator") + " = " + cdi.getLocator() + "\n\n";
            text = text + JMFI18N.getResource("jmfregistry.details.outformats") + "---->\n\n" + this.printFormats(cdi.getFormats()) + "\n\n";
        }
        this.textArea.setText(text);
    }

    public void actionPerformed(ActionEvent event2) {
        String strAction = event2.getActionCommand();
        if (strAction.equals(this.buttonDetect.getActionCommand())) {
            this.detectDevices();
        }
    }

    private String printFormats(Object fa) {
        if (!(fa instanceof Format[])) {
            return "null";
        }
        Format[] formats = (Format[])fa;
        String text = "";
        int i2 = 0;
        while (i2 < formats.length) {
            text = text + i2 + ". " + formats[i2].getClass().getName() + "\n  " + formats[i2] + "\n";
            ++i2;
        }
        return text;
    }

    private void createPanelDevices() {
        if (this.panelDevices != null) {
            this.panelLeft.remove(this.panelDevices);
        }
        this.panelDevices = new VectorPanel(JMFI18N.getResource("jmfregistry.capture.vector.label"), this, 0);
        this.panelLeft.add((Component)this.panelDevices, "Center");
        this.panelLeft.validate();
    }

    private void detectDevices() {
        Class<?> directAudio = null;
        Class<?> autoAudio = null;
        Class<?> autoVideo = null;
        Class<?> autoVideoPlus = null;
        try {
            directAudio = Class.forName("DirectSoundAuto");
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            autoAudio = Class.forName("JavaSoundAuto");
        }
        catch (Exception e3) {
            // empty catch block
        }
        try {
            autoVideo = Class.forName("VFWAuto");
        }
        catch (Exception e4) {
            // empty catch block
        }
        if (autoVideo == null) {
            try {
                autoVideo = Class.forName("SunVideoAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
            try {
                autoVideoPlus = Class.forName("SunVideoPlusAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        if (autoVideo == null) {
            try {
                autoVideo = Class.forName("V4LAuto");
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
        if (directAudio == null && autoAudio == null && autoVideo == null && autoVideoPlus == null) {
            return;
        }
        PopupWait popupWait = new PopupWait(this.getFrame(), JMFI18N.getResource("jmstudio.mssg.capturequery") + "\n" + JMFI18N.getResource("jmfregistry.appname") + " " + JMFI18N.getResource("jmstudio.mssg.lookingcapture"));
        popupWait.setVisible(true);
        try {
            Object instanceAudio;
            if (directAudio != null) {
                instanceAudio = directAudio.newInstance();
            }
            if (autoAudio != null) {
                instanceAudio = autoAudio.newInstance();
            }
            if (autoVideo != null) {
                Object instanceVideo = autoVideo.newInstance();
            }
            if (autoVideoPlus != null) {
                Object instanceVideoPlus = autoVideoPlus.newInstance();
            }
        }
        catch (ThreadDeath td) {
            popupWait.dispose();
            throw td;
        }
        catch (Throwable t) {
            MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmstudio.error.capturequery"));
        }
        popupWait.dispose();
        this.createPanelDevices();
    }
}

