/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.MimeManager;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class MimePanel
extends JMPanel
implements ActionListener,
ItemListener,
TextListener {
    private Hashtable htMimeTypes;
    private Button buttonRestore;
    private Button buttonCommit;
    private Button buttonAdd;
    private Button buttonRemove;
    private List listBoxMimeType;
    private TextField textMimeType;
    private List listBoxMimeExt;
    private TextField textMimeExt;

    public MimePanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = this.createPanelButtons();
        this.add((Component)panel, "East");
        Panel panelData = new Panel(new GridLayout(1, 0, 12, 12));
        this.add((Component)panelData, "Center");
        panel = this.createPanelMimeTypes();
        panelData.add(panel);
        panel = this.createPanelMimeExt();
        panelData.add(panel);
        this.restore();
        this.updateButtons();
    }

    private Panel createPanelButtons() {
        Panel panelButtons = new Panel(new FlowLayout(0));
        Panel panel = new Panel(new GridLayout(0, 1, 12, 12));
        panelButtons.add(panel);
        this.buttonAdd = new Button(JMFI18N.getResource("jmfregistry.vector.add"));
        this.buttonAdd.addActionListener(this);
        panel.add(this.buttonAdd);
        this.buttonRemove = new Button(JMFI18N.getResource("jmfregistry.vector.remove"));
        this.buttonRemove.addActionListener(this);
        panel.add(this.buttonRemove);
        this.buttonRestore = new Button(JMFI18N.getResource("jmfregistry.vector.restore"));
        this.buttonRestore.addActionListener(this);
        this.buttonCommit = new Button(JMFI18N.getResource("jmfregistry.vector.commit"));
        this.buttonCommit.addActionListener(this);
        panel.add(this.buttonCommit);
        return panelButtons;
    }

    private Panel createPanelMimeTypes() {
        Panel panel = new Panel(new BorderLayout(6, 6));
        Panel panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "North");
        Label label = new Label(JMFI18N.getResource("jmfregistry.mime.type.label"));
        panelTemp.add((Component)label, "North");
        this.textMimeType = new TextField();
        this.textMimeType.addTextListener(this);
        panelTemp.add((Component)this.textMimeType, "Center");
        this.listBoxMimeType = new List();
        this.listBoxMimeType.addItemListener(this);
        panel.add((Component)this.listBoxMimeType, "Center");
        return panel;
    }

    private Panel createPanelMimeExt() {
        Panel panel = new Panel(new BorderLayout(6, 6));
        Panel panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "North");
        Label label = new Label(JMFI18N.getResource("jmfregistry.mime.ext.label"));
        panelTemp.add((Component)label, "North");
        this.textMimeExt = new TextField();
        this.textMimeExt.addTextListener(this);
        panelTemp.add((Component)this.textMimeExt, "Center");
        this.listBoxMimeExt = new List();
        this.listBoxMimeExt.addItemListener(this);
        panel.add((Component)this.listBoxMimeExt, "Center");
        return panel;
    }

    public void actionPerformed(ActionEvent event2) {
        Object objSource = event2.getSource();
        String strCmd = event2.getActionCommand();
        if (strCmd.equals(this.buttonRestore.getActionCommand())) {
            this.restore();
        }
        if (strCmd.equals(this.buttonCommit.getActionCommand())) {
            MimeManager.commit();
        } else if (objSource == this.buttonAdd) {
            this.addExt();
        } else if (objSource == this.buttonRemove) {
            this.removeExt();
        }
        this.updateButtons();
    }

    public void itemStateChanged(ItemEvent event2) {
        Object objSource = event2.getSource();
        if (objSource == this.listBoxMimeType) {
            String strValue = this.listBoxMimeType.getSelectedItem();
            this.textMimeType.setText(strValue);
            this.fillExtList();
        } else if (objSource == this.listBoxMimeExt) {
            String strValue = this.listBoxMimeExt.getSelectedItem();
            this.textMimeExt.setText(strValue);
        }
        this.updateButtons();
    }

    public void textValueChanged(TextEvent event2) {
        this.updateButtons();
    }

    private void restore() {
        Hashtable htMimeExt = MimeManager.getMimeTable();
        this.htMimeTypes = new Hashtable();
        Enumeration enumKeys = htMimeExt.keys();
        while (enumKeys.hasMoreElements()) {
            Vector vectorExt;
            Object objExt = enumKeys.nextElement();
            Object objType = htMimeExt.get(objExt);
            String strExt = objExt.toString();
            String strType = objType.toString();
            if (this.htMimeTypes.containsKey(strType)) {
                vectorExt = (Vector)this.htMimeTypes.get(strType);
            } else {
                vectorExt = new Vector();
                this.htMimeTypes.put(strType, vectorExt);
            }
            if (vectorExt.contains(strExt)) continue;
            vectorExt.addElement(strExt);
        }
        this.fillTypeList();
    }

    private void fillTypeList() {
        this.listBoxMimeType.removeAll();
        Enumeration enumKeys = this.htMimeTypes.keys();
        while (enumKeys.hasMoreElements()) {
            Object objType = enumKeys.nextElement();
            this.listBoxMimeType.add(objType.toString());
        }
    }

    private void fillExtList() {
        this.listBoxMimeExt.removeAll();
        String strType = this.listBoxMimeType.getSelectedItem();
        if (strType == null) {
            return;
        }
        Vector vectorExt = (Vector)this.htMimeTypes.get(strType);
        int nCount = vectorExt.size();
        int i2 = 0;
        while (i2 < nCount) {
            Object objExt = vectorExt.elementAt(i2);
            this.listBoxMimeExt.add(objExt.toString());
            ++i2;
        }
    }

    private void addType() {
        String strType = this.textMimeType.getText().trim();
        if (strType.length() < 1) {
            return;
        }
        if (!this.htMimeTypes.containsKey(strType)) {
            Vector vectorExt = new Vector();
            this.htMimeTypes.put(strType, vectorExt);
            this.listBoxMimeType.add(strType);
        }
        this.selectItem(this.listBoxMimeType, strType);
        this.fillExtList();
    }

    private void removeType() {
        boolean boolResult = true;
        String strType = this.textMimeType.getText().trim();
        if (strType.length() < 1) {
            return;
        }
        Vector vectorExt = (Vector)this.htMimeTypes.get(strType);
        int nCount = vectorExt.size();
        int i2 = nCount - 1;
        while (i2 >= 0) {
            String strExt = (String)vectorExt.elementAt(i2);
            boolResult = MimeManager.removeMimeType(strExt);
            if (boolResult) {
                vectorExt.removeElement(strExt);
                this.listBoxMimeExt.remove(strExt);
            }
            --i2;
        }
        nCount = vectorExt.size();
        if (nCount > 0) {
            this.listBoxMimeExt.select(0);
            MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.removeitem"));
        } else {
            this.htMimeTypes.remove(strType);
            i2 = this.getItemIndex(this.listBoxMimeType, strType);
            this.listBoxMimeType.remove(strType);
        }
    }

    private void addExt() {
        boolean boolResult = true;
        String strExt = this.textMimeExt.getText().trim();
        if (strExt.length() < 1) {
            return;
        }
        String strType = this.textMimeType.getText().trim();
        if (strType.length() < 1) {
            return;
        }
        if (!this.htMimeTypes.containsKey(strType)) {
            this.addType();
        }
        if (!this.htMimeTypes.containsKey(strType)) {
            return;
        }
        Vector vectorExt = (Vector)this.htMimeTypes.get(strType);
        if (!vectorExt.contains(strExt)) {
            boolResult = MimeManager.addMimeType(strExt, strType);
            if (boolResult) {
                vectorExt.addElement(strExt);
                this.listBoxMimeExt.add(strExt);
            } else {
                MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.additem"));
            }
        }
        if (boolResult) {
            this.selectItem(this.listBoxMimeExt, strExt);
        }
    }

    private void removeExt() {
        boolean boolResult = true;
        String strExt = this.textMimeExt.getText().trim();
        if (strExt.length() < 1) {
            return;
        }
        String strType = this.textMimeType.getText().trim();
        if (strType.length() < 1) {
            return;
        }
        if (!this.htMimeTypes.containsKey(strType)) {
            return;
        }
        Vector vectorExt = (Vector)this.htMimeTypes.get(strType);
        if (!vectorExt.contains(strExt)) {
            return;
        }
        boolResult = MimeManager.removeMimeType(strExt);
        if (boolResult) {
            vectorExt.removeElement(strExt);
            int i2 = this.getItemIndex(this.listBoxMimeExt, strExt);
            this.listBoxMimeExt.remove(strExt);
            if (vectorExt.isEmpty()) {
                this.removeType();
            }
        } else {
            MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.removeitem"));
        }
    }

    private void selectItem(List listBox, String strItemSel) {
        int i2 = this.getItemIndex(listBox, strItemSel);
        if (i2 >= 0) {
            listBox.select(i2);
        }
    }

    private int getItemIndex(List listBox, String strItemSel) {
        int nCount = listBox.getItemCount();
        int i2 = 0;
        while (i2 < nCount) {
            String strItem = listBox.getItem(i2);
            if (strItem.equals(strItemSel)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private void updateButtons() {
        boolean boolRemoveEnable;
        boolean boolAddEnable;
        String strExt = this.textMimeExt.getText().trim();
        String strType = this.textMimeType.getText().trim();
        if (strExt.length() > 1 && strType.length() > 1) {
            boolAddEnable = true;
            boolRemoveEnable = true;
        } else {
            boolAddEnable = false;
            boolRemoveEnable = false;
        }
        if (this.htMimeTypes.containsKey(strType)) {
            Vector vectorExt = (Vector)this.htMimeTypes.get(strType);
            if (vectorExt.contains(strExt)) {
                boolAddEnable = false;
            } else {
                boolRemoveEnable = false;
            }
        } else {
            boolRemoveEnable = false;
        }
        this.buttonAdd.setEnabled(boolAddEnable);
        this.buttonRemove.setEnabled(boolRemoveEnable);
    }
}

