/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.ui.TabControl;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;

public class TransmissionStatsDialog
extends JMDialog {
    private Vector vectorMngrSessions;
    private Vector vectorStreamLabels;
    private UpdateThread threadUpdate = null;
    private Label[] fieldTotalRtpPacketsSent;
    private Label[] fieldTotalBytesSent;
    private Label[] fieldRtcpPacketsSent;
    private Label[] fieldLocalCollisions;
    private Label[] fieldRemoteCollisions;
    private Label[] fieldFailedTransmissions;
    private static final String LABEL_TOTAL_RTP_PACKETS_SENT = JMFI18N.getResource("jmstudio.transmitstats.totalrtppacketssent");
    private static final String LABEL_TOTAL_BYTES_SENT = JMFI18N.getResource("jmstudio.transmitstats.totalbytessent");
    private static final String LABEL_RTCP_PACKETS_SENT = JMFI18N.getResource("jmstudio.transmitstats.rtcppacketssent");
    private static final String LABEL_LOCAL_COLLISIONS = JMFI18N.getResource("jmstudio.transmitstats.localcollisions");
    private static final String LABEL_REMOTE_COLLISIONS = JMFI18N.getResource("jmstudio.transmitstats.remotecollisions");
    private static final String LABEL_FAILED_TRANSMISSIONS = JMFI18N.getResource("jmstudio.transmitstats.failedtransmissions");

    public TransmissionStatsDialog(Frame frame, Vector vectorMngrSessions, Vector vectorStreamLabels) {
        super(frame, JMFI18N.getResource("jmstudio.transmitstats.title"), false);
        this.vectorStreamLabels = vectorStreamLabels;
        this.vectorMngrSessions = vectorMngrSessions;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void init() throws Exception {
        JMPanel panel;
        this.setLayout(new BorderLayout(6, 6));
        JMPanel panelContent = new JMPanel(new BorderLayout(6, 6));
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        TabControl tabControl = new TabControl(0);
        panelContent.add((Component)tabControl, "Center");
        int nCount = Math.min(this.vectorMngrSessions.size(), this.vectorStreamLabels.size());
        this.fieldTotalRtpPacketsSent = new Label[nCount];
        this.fieldTotalBytesSent = new Label[nCount];
        this.fieldRtcpPacketsSent = new Label[nCount];
        this.fieldLocalCollisions = new Label[nCount];
        this.fieldRemoteCollisions = new Label[nCount];
        this.fieldFailedTransmissions = new Label[nCount];
        int i2 = 0;
        while (i2 < nCount) {
            panel = this.createStreamPanel(i2);
            tabControl.addPage(panel, this.vectorStreamLabels.elementAt(i2).toString());
            ++i2;
        }
        panel = new JMPanel(new BorderLayout(6, 6));
        panelContent.add((Component)panel, "South");
        JMPanel panelButtons = this.createButtonPanel(new String[]{JMDialog.ACTION_CLOSE});
        panel.add((Component)panelButtons, "East");
        this.pack();
        this.setResizable(false);
        this.updateFields();
    }

    public void addNotify() {
        super.addNotify();
        if (this.threadUpdate == null) {
            this.threadUpdate = new UpdateThread();
        }
        this.threadUpdate.start();
    }

    public void removeNotify() {
        if (this.threadUpdate != null) {
            this.threadUpdate.terminate();
            this.threadUpdate = null;
        }
        super.removeNotify();
    }

    private JMPanel createStreamPanel(int nIndex) {
        JMPanel panelStream = new JMPanel(new BorderLayout(6, 6));
        JMPanel panel = new JMPanel(new BorderLayout(6, 6));
        panelStream.add((Component)panel, "North");
        JMPanel panelLabels = new JMPanel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panelLabels, "West");
        JMPanel panelData = new JMPanel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panelData, "Center");
        Label label = new Label(LABEL_TOTAL_RTP_PACKETS_SENT);
        panelLabels.add(label);
        this.fieldTotalRtpPacketsSent[nIndex] = new Label("000000000000");
        panelData.add(this.fieldTotalRtpPacketsSent[nIndex]);
        label = new Label(LABEL_TOTAL_BYTES_SENT);
        panelLabels.add(label);
        this.fieldTotalBytesSent[nIndex] = new Label();
        panelData.add(this.fieldTotalBytesSent[nIndex]);
        label = new Label(LABEL_RTCP_PACKETS_SENT);
        panelLabels.add(label);
        this.fieldRtcpPacketsSent[nIndex] = new Label();
        panelData.add(this.fieldRtcpPacketsSent[nIndex]);
        label = new Label(LABEL_LOCAL_COLLISIONS);
        panelLabels.add(label);
        this.fieldLocalCollisions[nIndex] = new Label();
        panelData.add(this.fieldLocalCollisions[nIndex]);
        label = new Label(LABEL_REMOTE_COLLISIONS);
        panelLabels.add(label);
        this.fieldRemoteCollisions[nIndex] = new Label();
        panelData.add(this.fieldRemoteCollisions[nIndex]);
        label = new Label(LABEL_FAILED_TRANSMISSIONS);
        panelLabels.add(label);
        this.fieldFailedTransmissions[nIndex] = new Label();
        panelData.add(this.fieldFailedTransmissions[nIndex]);
        return panelStream;
    }

    public void actionPerformed(ActionEvent event2) {
        String strAction = event2.getActionCommand();
        if (strAction.equals(JMDialog.ACTION_CLOSE)) {
            this.setAction(JMDialog.ACTION_CLOSE);
            this.setVisible(false);
        }
    }

    public void windowClosing(WindowEvent event2) {
        this.setAction(JMDialog.ACTION_CLOSE);
        this.setVisible(false);
    }

    private void updateFields() {
        int nCount = Math.min(this.vectorMngrSessions.size(), this.vectorStreamLabels.size());
        int i2 = 0;
        while (i2 < nCount) {
            Object objMngr = this.vectorMngrSessions.elementAt(i2);
            if (objMngr instanceof SessionManager) {
                SessionManager mngrSession = (SessionManager)objMngr;
                GlobalTransmissionStats stats = mngrSession.getGlobalTransmissionStats();
                this.fieldTotalRtpPacketsSent[i2].setText("" + stats.getRTPSent());
                this.fieldTotalBytesSent[i2].setText("" + stats.getBytesSent());
                this.fieldRtcpPacketsSent[i2].setText("" + stats.getRTCPSent());
                this.fieldLocalCollisions[i2].setText("" + stats.getLocalColls());
                this.fieldRemoteCollisions[i2].setText("" + stats.getRemoteColls());
                this.fieldFailedTransmissions[i2].setText("" + stats.getTransmitFailed());
            }
            ++i2;
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean boolTerminate = false;

        public void terminate() {
            this.boolTerminate = true;
        }

        public void run() {
            while (!this.boolTerminate) {
                try {
                    Thread.sleep(1000L);
                    TransmissionStatsDialog.this.updateFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

