/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import jmapps.ui.ImageArea;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.TextView;

public class MessageDialog
extends JMDialog {
    public static String titleDefault = "Message";
    protected String strMessage;
    protected Image image = null;
    private Button buttonOK;
    private Button buttonCancel;
    private boolean needCancel;
    private boolean YesNoDiag = false;
    private TextView fieldMessage;

    public MessageDialog(Frame frame, String strTitle, String strMessage, Image image, boolean boolModal, boolean needCancel) {
        this(frame, strTitle, strMessage, image, boolModal, needCancel, false);
    }

    public MessageDialog(Frame frame, String strTitle, String strMessage, Image image, boolean boolModal, boolean needCancel, boolean YesNoDiag) {
        super(frame, strTitle, boolModal);
        this.strMessage = strMessage;
        this.image = image;
        this.needCancel = needCancel;
        this.YesNoDiag = YesNoDiag;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public MessageDialog(Frame frame, String strTitle, String strMessage, Image image, boolean boolModal) {
        this(frame, strTitle, strMessage, image, boolModal, false);
    }

    public static String createErrorDialog(Frame frame, String strTitle, String strMessage) {
        boolean boolCenter = false;
        if (frame == null) {
            frame = new Frame();
            boolCenter = true;
        }
        Image image = ImageArea.loadImage("iconError.gif");
        MessageDialog dlg = new MessageDialog(frame, strTitle + " " + JMFI18N.getResource("jmstudio.messagedlg.error"), strMessage, image, true);
        if (boolCenter) {
            dlg.setLocationCenter();
        }
        dlg.show();
        String strAction = dlg.getAction();
        return strAction;
    }

    public static String createYesNoDialog(Frame frame, String strTitle, String strMessage) {
        boolean boolCenter = false;
        if (frame == null) {
            frame = new Frame();
            boolCenter = true;
        }
        Image image = ImageArea.loadImage("iconQuery.gif");
        MessageDialog dlg = new MessageDialog(frame, strTitle, strMessage, image, true, false, true);
        if (boolCenter) {
            dlg.setLocationCenter();
        }
        dlg.show();
        String strAction = dlg.getAction();
        return strAction;
    }

    public static String createErrorDialog(Frame frame, String strMessage) {
        String strAction = MessageDialog.createErrorDialog(frame, titleDefault, strMessage);
        return strAction;
    }

    public static String createErrorDialog(Frame frame, Exception exception) {
        String strAction = MessageDialog.createErrorDialog(frame, null, exception);
        return strAction;
    }

    public static String createErrorDialog(Frame frame, String strText, Exception exception) {
        String strMessage = exception.getMessage();
        if (strMessage == null || strMessage.trim().length() < 1) {
            strMessage = exception.getClass().getName();
        }
        strMessage = JMFI18N.getResource("jmstudio.messagedlg.exception") + ". " + "\n" + strMessage;
        if (strText != null) {
            strMessage = strText + "\n" + strMessage;
        }
        String strAction = MessageDialog.createErrorDialog(frame, strMessage);
        return strAction;
    }

    public static String createInfoDialog(Frame frame, String strMessage) {
        String strAction = MessageDialog.createInfoDialog(frame, titleDefault, strMessage);
        return strAction;
    }

    public static String createInfoDialog(Frame frame, String strTitle, String strMessage) {
        boolean boolCenter = false;
        if (frame == null) {
            frame = new Frame();
            boolCenter = true;
        }
        Image image = ImageArea.loadImage("iconInfo.gif");
        MessageDialog dlg = new MessageDialog(frame, strTitle, strMessage, image, true);
        if (boolCenter) {
            dlg.setLocationCenter();
        }
        dlg.show();
        String strAction = dlg.getAction();
        return strAction;
    }

    public static String createWarningDialog(Frame frame, String strMessage) {
        boolean boolCenter = false;
        if (frame == null) {
            frame = new Frame();
            boolCenter = true;
        }
        Image image = ImageArea.loadImage("iconWarning.gif");
        MessageDialog dlg = new MessageDialog(frame, titleDefault + " " + JMFI18N.getResource("jmstudio.messagedlg.warning"), strMessage, image, true);
        if (boolCenter) {
            dlg.setLocationCenter();
        }
        dlg.show();
        String strAction = dlg.getAction();
        return strAction;
    }

    public static String createOKCancelDialog(Frame frame, String strMessage) {
        boolean boolCenter = false;
        if (frame == null) {
            frame = new Frame();
            boolCenter = true;
        }
        Image image = ImageArea.loadImage("iconQuery.gif");
        MessageDialog dlg = new MessageDialog(frame, titleDefault + " " + JMFI18N.getResource("jmstudio.messagedlg.query"), strMessage, image, true, true);
        if (boolCenter) {
            dlg.setLocationCenter();
        }
        dlg.show();
        String strAction = dlg.getAction();
        return strAction;
    }

    public static void createErrorDialogModeless(Frame frame, String strMessage) {
        boolean boolCenter = false;
        if (frame == null) {
            frame = new Frame();
            boolCenter = true;
        }
        Image image = ImageArea.loadImage("iconError.gif");
        MessageDialog dlg = new MessageDialog(frame, titleDefault + " " + JMFI18N.getResource("jmstudio.messagedlg.error"), strMessage, image, false);
        if (boolCenter) {
            dlg.setLocationCenter();
        }
        dlg.show();
    }

    public static void createErrorDialogModeless(Frame frame, String strText, Exception exception) {
        String strMessage = exception.getMessage();
        if (strMessage == null || strMessage.trim().length() < 1) {
            strMessage = exception.getClass().getName();
        }
        strMessage = JMFI18N.getResource("jmstudio.messagedlg.exception") + ". " + "\n" + strMessage;
        if (strText != null) {
            strMessage = strText + "\n" + strMessage;
        }
        MessageDialog.createErrorDialogModeless(frame, strMessage);
    }

    public TextView getTextView() {
        return this.fieldMessage;
    }

    protected void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        JMPanel panel = new JMPanel(new BorderLayout(6, 6));
        panel.setEmptyBorder(12, 6, 12, 6);
        this.add((Component)panel, "Center");
        if (this.strMessage != null) {
            this.fieldMessage = new TextView(this.strMessage);
            panel.add((Component)this.fieldMessage, "Center");
            this.fieldMessage.setPreferredWidth(360);
        }
        JMPanel panelImage = new JMPanel(new FlowLayout(1));
        panel.add((Component)panelImage, "West");
        if (this.image != null) {
            MediaTracker trackerMedia = new MediaTracker(this);
            trackerMedia.addImage(this.image, 1001);
            try {
                trackerMedia.waitForID(1001);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImageArea fieldImage = new ImageArea(this.image);
            panelImage.add(fieldImage);
        }
        panel = new JMPanel(new FlowLayout(1));
        this.add((Component)panel, "South");
        JMPanel panelButtons = this.YesNoDiag ? this.createButtonPanel(new String[]{JMDialog.ACTION_YES, JMDialog.ACTION_NO}) : (this.needCancel ? this.createButtonPanel(new String[]{JMDialog.ACTION_OK, JMDialog.ACTION_CANCEL}) : this.createButtonPanel(new String[]{JMDialog.ACTION_OK}));
        panel.add(panelButtons);
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent event2) {
        String strAction = event2.getActionCommand();
        if (strAction.equals(JMDialog.ACTION_OK)) {
            this.setAction(strAction);
            this.dispose();
        } else if (strAction.equals(JMDialog.ACTION_CANCEL)) {
            this.setAction(strAction);
            this.dispose();
        } else if (strAction.equals(JMDialog.ACTION_YES)) {
            this.setAction(strAction);
            this.dispose();
        } else if (strAction.equals(JMDialog.ACTION_NO)) {
            this.setAction(strAction);
            this.dispose();
        }
    }
}

