/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.SecurityUtil;

abstract class DynamicLinkerImpl
implements DynamicLinker {
    private final Object secSync = new Object();
    private boolean allLinkPermissionGranted = false;
    private static final LongObjectHashMap libHandle2Name = new LongObjectHashMap(16);

    DynamicLinkerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            this.allLinkPermissionGranted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            this.allLinkPermissionGranted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLinkPermission(String string) throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                SecurityUtil.checkLinkPermission(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLinkPermission(long l2) throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                LibRef libRef = this.getLibRef(l2);
                if (null == libRef) {
                    throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l2) + " unknown.");
                }
                SecurityUtil.checkLinkPermission(libRef.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                SecurityUtil.checkAllLinkPermission();
            }
        }
    }

    @Override
    public final long openLibraryGlobal(String string, boolean bl) throws SecurityException {
        this.checkLinkPermission(string);
        long l2 = this.openLibraryGlobalImpl(string);
        if (0L != l2) {
            LibRef libRef = this.incrLibRefCount(l2, string);
            if (DEBUG || bl) {
                System.err.println("DynamicLinkerImpl.openLibraryGlobal \"" + string + "\": 0x" + Long.toHexString(l2) + " -> " + libRef + ")");
            }
        } else if (DEBUG || bl) {
            System.err.println("DynamicLinkerImpl.openLibraryGlobal \"" + string + "\" failed, error: " + this.getLastError());
        }
        return l2;
    }

    protected abstract long openLibraryGlobalImpl(String var1) throws SecurityException;

    @Override
    public final long openLibraryLocal(String string, boolean bl) throws SecurityException {
        this.checkLinkPermission(string);
        long l2 = this.openLibraryLocalImpl(string);
        if (0L != l2) {
            LibRef libRef = this.incrLibRefCount(l2, string);
            if (DEBUG || bl) {
                System.err.println("DynamicLinkerImpl.openLibraryLocal \"" + string + "\": 0x" + Long.toHexString(l2) + " -> " + libRef + ")");
            }
        } else if (DEBUG || bl) {
            System.err.println("DynamicLinkerImpl.openLibraryLocal \"" + string + "\" failed, error: " + this.getLastError());
        }
        return l2;
    }

    protected abstract long openLibraryLocalImpl(String var1) throws SecurityException;

    @Override
    public final long lookupSymbolGlobal(String string) throws SecurityException {
        this.checkAllLinkPermission();
        long l2 = this.lookupSymbolGlobalImpl(string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbolGlobal(" + string + ") -> 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    protected abstract long lookupSymbolGlobalImpl(String var1) throws SecurityException;

    @Override
    public final long lookupSymbol(long l2, String string) throws SecurityException, IllegalArgumentException {
        this.checkLinkPermission(l2);
        long l3 = this.lookupSymbolLocalImpl(l2, string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbol(0x" + Long.toHexString(l2) + ", " + string + ") -> 0x" + Long.toHexString(l3));
        }
        return l3;
    }

    protected abstract long lookupSymbolLocalImpl(long var1, String var3) throws SecurityException;

    @Override
    public final void closeLibrary(long l2, boolean bl) throws SecurityException, IllegalArgumentException {
        LibRef libRef = this.decrLibRefCount(l2);
        if (null == libRef) {
            throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l2) + " unknown.");
        }
        this.checkLinkPermission(libRef.getName());
        if (DEBUG || bl) {
            System.err.println("DynamicLinkerImpl.closeLibrary(0x" + Long.toHexString(l2) + " -> " + libRef + ")");
        }
        this.closeLibraryImpl(l2);
    }

    protected abstract void closeLibraryImpl(long var1) throws SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef getLibRef(long l2) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            return (LibRef)libHandle2Name.get(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef incrLibRefCount(long l2, String string) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            LibRef libRef = this.getLibRef(l2);
            if (null == libRef) {
                libRef = new LibRef(string);
                libHandle2Name.put(l2, libRef);
            } else {
                libRef.incrRefCount();
            }
            if (DEBUG) {
                System.err.println("DynamicLinkerImpl.incrLibRefCount 0x" + Long.toHexString(l2) + " -> " + libRef + ", libs loaded " + libHandle2Name.size());
            }
            return libRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef decrLibRefCount(long l2) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            LibRef libRef = this.getLibRef(l2);
            if (null != libRef && 0 == libRef.decrRefCount()) {
                libHandle2Name.remove(l2);
            }
            if (DEBUG) {
                System.err.println("DynamicLinkerImpl.decrLibRefCount 0x" + Long.toHexString(l2) + " -> " + libRef + ", libs loaded " + libHandle2Name.size());
            }
            return libRef;
        }
    }

    static final class LibRef {
        private final String name;
        private int refCount;

        LibRef(String string) {
            this.name = string;
            this.refCount = 1;
        }

        final int incrRefCount() {
            return ++this.refCount;
        }

        final int decrRefCount() {
            return --this.refCount;
        }

        final int getRefCount() {
            return this.refCount;
        }

        final String getName() {
            return this.name;
        }

        public final String toString() {
            return "LibRef[" + this.name + ", refCount " + this.refCount + "]";
        }
    }
}

