/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;

public class Ehdr_p1 {
    StructAccessor accessor;
    private static final int mdIdx = 0;
    private final MachineDataInfo md;
    private static final int[] Ehdr_p1_size = new int[]{24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] e_ident_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] e_ident_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] e_type_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] e_machine_offset = new int[]{18, 18, 18, 18, 18, 18, 18, 18};
    private static final int[] e_version_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 20};

    public static int size() {
        return Ehdr_p1_size[0];
    }

    public static Ehdr_p1 create() {
        return Ehdr_p1.create(Buffers.newDirectByteBuffer(Ehdr_p1.size()));
    }

    public static Ehdr_p1 create(ByteBuffer byteBuffer) {
        return new Ehdr_p1(byteBuffer);
    }

    Ehdr_p1(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[0].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public static final int getE_identArrayLength() {
        return 16;
    }

    public Ehdr_p1 setE_ident(int n2, byte[] byArray) {
        if (n2 + byArray.length > 16) {
            throw new IndexOutOfBoundsException("offset " + n2 + " + val.length " + byArray.length + " > array-length " + 16);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (16 > e_ident_size[0]) {
            throw new IndexOutOfBoundsException("bTotal 16 > size " + e_ident_size[0] + ", elemSize " + 1 + " * " + 16);
        }
        int n3 = e_ident_offset[0];
        int n4 = n3 + 16;
        if (n4 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n4 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n3 + ", elemSize " + 1 + " * " + 16);
        }
        this.accessor.setBytesAt(n3 += 1 * n2, byArray);
        return this;
    }

    public ByteBuffer getE_ident() {
        return this.accessor.slice(e_ident_offset[0], 16);
    }

    public byte[] getE_ident(int n2, byte[] byArray) {
        if (n2 + byArray.length > 16) {
            throw new IndexOutOfBoundsException("offset " + n2 + " + result.length " + byArray.length + " > array-length " + 16);
        }
        return this.accessor.getBytesAt(e_ident_offset[0] + 1 * n2, byArray);
    }

    public Ehdr_p1 setE_type(short s) {
        this.accessor.setShortAt(e_type_offset[0], s);
        return this;
    }

    public short getE_type() {
        return this.accessor.getShortAt(e_type_offset[0]);
    }

    public Ehdr_p1 setE_machine(short s) {
        this.accessor.setShortAt(e_machine_offset[0], s);
        return this;
    }

    public short getE_machine() {
        return this.accessor.getShortAt(e_machine_offset[0]);
    }

    public Ehdr_p1 setE_version(int n2) {
        this.accessor.setIntAt(e_version_offset[0], n2);
        return this;
    }

    public int getE_version() {
        return this.accessor.getIntAt(e_version_offset[0]);
    }
}

