/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.Lock;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LockDebugUtil {
    private static final ThreadLocal<ArrayList<Throwable>> tlsLockedStacks;
    private static final List<Throwable> dummy;

    public static List<Throwable> getRecursiveLockTrace() {
        if (Lock.DEBUG) {
            ArrayList<Throwable> arrayList = tlsLockedStacks.get();
            if (null == arrayList) {
                arrayList = new ArrayList();
                tlsLockedStacks.set(arrayList);
            }
            return arrayList;
        }
        return dummy;
    }

    public static void dumpRecursiveLockTrace(PrintStream printStream) {
        List<Throwable> list;
        if (Lock.DEBUG && null != (list = LockDebugUtil.getRecursiveLockTrace()) && list.size() > 0) {
            int n2 = 0;
            printStream.println("TLSLockedStacks: locks " + list.size());
            Iterator<Throwable> iterator = list.iterator();
            while (iterator.hasNext()) {
                printStream.print(n2 + ": ");
                iterator.next().printStackTrace(printStream);
                ++n2;
            }
        }
    }

    static {
        if (Lock.DEBUG) {
            tlsLockedStacks = new ThreadLocal();
            dummy = null;
        } else {
            tlsLockedStacks = null;
            dummy = new ArrayList<Throwable>(0);
        }
    }
}

