/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import jogamp.common.util.locks.LockDebugUtil;

public class RecursiveLockImpl01CompleteFair
implements RecursiveLock {
    private final Sync sync = new Sync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable getLockedStack() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.lockedStack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getOwner() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOwner(Thread thread) {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner() == thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            return null != this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLockedByOtherThread() {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = this.sync.getOwner();
            return null != thread && Thread.currentThread() != thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHoldCount() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.holdCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validateLocked() throws RuntimeException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (Thread.currentThread() != this.sync.getOwner()) {
                if (null == this.sync.getOwner()) {
                    throw new RuntimeException(this.threadName(Thread.currentThread()) + ": Not locked: " + this.toString());
                }
                if (null != this.sync.lockedStack) {
                    this.sync.lockedStack.printStackTrace();
                }
                throw new RuntimeException(Thread.currentThread() + ": Not owner: " + this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void lock() {
        Sync sync = this.sync;
        synchronized (sync) {
            try {
                if (!this.tryLock(TIMEOUT)) {
                    if (null != this.sync.lockedStack) {
                        this.sync.lockedStack.printStackTrace();
                    }
                    throw new RuntimeException("Waited " + TIMEOUT + "ms for: " + this.toString() + " - " + this.threadName(Thread.currentThread()));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryLock(long l2) throws InterruptedException {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = Thread.currentThread();
            if (TRACE_LOCK) {
                System.err.println("+++ LOCK 0 " + this.toString() + ", cur " + this.threadName(thread));
            }
            if (this.sync.getOwner() == thread) {
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK XR " + this.toString() + ", cur " + this.threadName(thread));
                }
                return true;
            }
            if (this.sync.getOwner() != null || 0L < l2 && 0 < this.sync.queue.size()) {
                if (0L >= l2) {
                    if (TRACE_LOCK) {
                        System.err.println("+++ LOCK XY " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l2 + " ms");
                    }
                    return false;
                }
                WaitingThread waitingThread = new WaitingThread(thread);
                this.sync.queue.add(0, waitingThread);
                do {
                    long l3 = System.currentTimeMillis();
                    try {
                        this.sync.wait(l2);
                        l2 -= System.currentTimeMillis() - l3;
                    }
                    catch (InterruptedException interruptedException) {
                        if (!waitingThread.signaledByUnlock) {
                            this.sync.queue.remove(waitingThread);
                            throw interruptedException;
                        }
                        if (thread == this.sync.getOwner()) continue;
                        l2 -= System.currentTimeMillis() - l3;
                        if (TRACE_LOCK) {
                            System.err.println("+++ LOCK 1 " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l2 + " ms, signaled: " + waitingThread.signaledByUnlock);
                        }
                        if (0L >= l2) continue;
                        waitingThread.signaledByUnlock = false;
                        this.sync.queue.add(this.sync.queue.size(), waitingThread);
                    }
                } while (thread != this.sync.getOwner() && 0L < l2);
                if (0L >= l2 && thread != this.sync.getOwner()) {
                    if (!waitingThread.signaledByUnlock) {
                        this.sync.queue.remove(waitingThread);
                    }
                    if (TRACE_LOCK) {
                        System.err.println("+++ LOCK XX " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l2 + " ms");
                    }
                    return false;
                }
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK X1 " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l2 + " ms");
                }
            } else {
                ++this.sync.holdCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK X0 " + this.toString() + ", cur " + this.threadName(thread));
                }
            }
            this.sync.setOwner(thread);
            if (DEBUG) {
                this.sync.setLockedStack(new Throwable("Previously locked by " + this.toString()));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock() {
        Sync sync = this.sync;
        synchronized (sync) {
            this.unlock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock(Runnable runnable) {
        Sync sync = this.sync;
        synchronized (sync) {
            this.validateLocked();
            Thread thread = Thread.currentThread();
            --this.sync.holdCount;
            if (this.sync.holdCount > 0) {
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK XR " + this.toString() + ", cur " + this.threadName(thread));
                }
                return;
            }
            if (DEBUG) {
                this.sync.setLockedStack(null);
            }
            if (null != runnable) {
                runnable.run();
            }
            if (this.sync.queue.size() > 0) {
                WaitingThread waitingThread = this.sync.queue.remove(this.sync.queue.size() - 1);
                this.sync.setOwner(waitingThread.thread);
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK X1 " + this.toString() + ", cur " + this.threadName(thread) + ", signal: " + this.threadName(waitingThread.thread));
                }
                waitingThread.signaledByUnlock = true;
                waitingThread.thread.interrupt();
            } else {
                this.sync.setOwner(null);
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK X0 " + this.toString() + ", cur " + this.threadName(thread) + ", signal any");
                }
                this.sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getQueueLength() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.queue.size();
        }
    }

    public String toString() {
        return this.syncName() + "[count " + this.sync.holdCount + ", qsz " + this.sync.queue.size() + ", owner " + this.threadName(this.sync.getOwner()) + "]";
    }

    private final String syncName() {
        return "<" + Integer.toHexString(this.hashCode()) + ", " + Integer.toHexString(this.sync.hashCode()) + ">";
    }

    private final String threadName(Thread thread) {
        return null != thread ? "<" + thread.getName() + ">" : "<NULL>";
    }

    private static class Sync
    extends AbstractOwnableSynchronizer {
        private int holdCount = 0;
        final ArrayList<WaitingThread> queue = new ArrayList();
        private Throwable lockedStack = null;

        private Sync() {
        }

        private final Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        private final void setOwner(Thread thread) {
            this.setExclusiveOwnerThread(thread);
        }

        private final void setLockedStack(Throwable throwable) {
            List<Throwable> list = LockDebugUtil.getRecursiveLockTrace();
            if (throwable == null) {
                list.remove(this.lockedStack);
            } else {
                list.add(throwable);
            }
            this.lockedStack = throwable;
        }
    }

    private static class WaitingThread {
        final Thread thread;
        boolean signaledByUnlock;

        WaitingThread(Thread thread) {
            this.thread = thread;
            this.signaledByUnlock = false;
        }
    }
}

