/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.geom.Vertex;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.opengl.Debug;

public class TypecastRenderer {
    private static final boolean DEBUG = Debug.debug("graph.font.Renderer");

    private static void addShapeMoveTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point) {
        if (DEBUG) {
            System.err.println("Shape.MoveTo: " + point);
        }
        outlineShape.closeLastOutline(false);
        outlineShape.addEmptyOutline();
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
    }

    private static void addShapeLineTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point) {
        if (DEBUG) {
            System.err.println("Shape.LineTo: " + point);
        }
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
    }

    private static void addShapeQuadTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point, Point point2) {
        if (DEBUG) {
            System.err.println("Shape.QuadTo: " + point + ", " + point2);
        }
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
        outlineShape.addVertex(0, factory.create(point2.x, (float)point2.y, 0.0f, point2.onCurve));
    }

    private static void addShapeQuadTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point, float f2, float f3, boolean bl) {
        if (DEBUG) {
            System.err.println("Shape.QuadTo: " + point + ", p2 " + f2 + ", " + f3 + ", onCurve " + bl);
        }
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
        outlineShape.addVertex(0, factory.create(f2, f3, 0.0f, bl));
    }

    public static OutlineShape buildShape(char c2, OTGlyph oTGlyph, Vertex.Factory<? extends Vertex> factory) {
        if (oTGlyph == null) {
            return null;
        }
        OutlineShape outlineShape = new OutlineShape(factory);
        TypecastRenderer.buildShapeImpl(outlineShape, c2, oTGlyph, factory);
        outlineShape.setIsQuadraticNurbs();
        return outlineShape;
    }

    private static void buildShapeImpl(OutlineShape outlineShape, char c2, OTGlyph oTGlyph, Vertex.Factory<? extends Vertex> factory) {
        int n2 = 0;
        int n3 = 0;
        int n4 = oTGlyph.getPointCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            ++n3;
            if (!oTGlyph.getPoint((int)i2).endOfContour) continue;
            int n5 = 0;
            while (n5 < n3 - 1) {
                Point point;
                Point point2 = oTGlyph.getPoint(n2 + n5 % n3);
                Point point3 = oTGlyph.getPoint(n2 + (n5 + 1) % n3);
                Point point4 = oTGlyph.getPoint(n2 + (n5 + 2) % n3);
                Point point5 = point = n5 + 3 < n3 ? oTGlyph.getPoint(n2 + n5 + 3) : null;
                if (DEBUG) {
                    System.err.println("GlyphShape<" + c2 + ">: offset " + n5 + " of " + n3 + "/" + n4 + " points");
                    int n6 = n5 == 0 ? n2 + n3 - 1 : n2 + (n5 - 1) % n3;
                    Point point6 = oTGlyph.getPoint(n6);
                    int n7 = n2 + n5 % n3;
                    int n8 = n2 + (n5 + 1) % n3;
                    int n9 = n2 + (n5 + 2) % n3;
                    int n10 = n2 + (n5 + 3) % n3;
                    System.err.println("\t pM[" + n6 + "] " + point6);
                    System.err.println("\t p0[" + n7 + "] " + point2);
                    System.err.println("\t p1[" + n8 + "] " + point3);
                    System.err.println("\t p2[" + n9 + "] " + point4);
                    System.err.println("\t p3[" + n10 + "] " + point);
                }
                if (n5 == 0) {
                    TypecastRenderer.addShapeMoveTo(outlineShape, factory, point2);
                }
                if (point2.endOfContour) {
                    if (DEBUG) {
                        System.err.println("B0 .. end-of-contour **** EOC");
                    }
                    outlineShape.closeLastOutline(false);
                    break;
                }
                if (point2.onCurve) {
                    if (point3.onCurve) {
                        if (DEBUG) {
                            System.err.println("B1 .. line-to p0-p1");
                        }
                        TypecastRenderer.addShapeLineTo(outlineShape, factory, point3);
                        ++n5;
                        continue;
                    }
                    if (point4.onCurve) {
                        if (DEBUG) {
                            System.err.println("B2 .. quad-to p0-p1-p2");
                        }
                        TypecastRenderer.addShapeQuadTo(outlineShape, factory, point3, point4);
                        n5 += 2;
                        continue;
                    }
                    if (null != point && point.onCurve) {
                        if (DEBUG) {
                            System.err.println("B3 .. 2-quad p0-p1-p1_2, p1_2-p2-p3 **** 2QUAD");
                        }
                        TypecastRenderer.addShapeQuadTo(outlineShape, factory, point3, TypecastRenderer.midValue(point3.x, point4.x), TypecastRenderer.midValue(point3.y, point4.y), true);
                        TypecastRenderer.addShapeQuadTo(outlineShape, factory, point4, point);
                        n5 += 3;
                        continue;
                    }
                    if (DEBUG) {
                        System.err.println("B4 .. quad-to p0-p1-p2h **** MID");
                    }
                    TypecastRenderer.addShapeQuadTo(outlineShape, factory, point3, TypecastRenderer.midValue(point3.x, point4.x), TypecastRenderer.midValue(point3.y, point4.y), true);
                    n5 += 2;
                    continue;
                }
                if (!point3.onCurve) {
                    if (DEBUG) {
                        System.err.println("B5 .. quad-to pMh-p0-p1h ***** MID");
                    }
                    TypecastRenderer.addShapeQuadTo(outlineShape, factory, point2, TypecastRenderer.midValue(point2.x, point3.x), TypecastRenderer.midValue(point2.y, point3.y), true);
                    ++n5;
                    continue;
                }
                if (DEBUG) {
                    System.err.println("B6 .. quad-to pMh-p0-p1");
                }
                TypecastRenderer.addShapeQuadTo(outlineShape, factory, point2, point3);
                ++n5;
            }
            outlineShape.closeLastOutline(false);
            n2 = i2 + 1;
            n3 = 0;
        }
    }

    private static float midValue(float f2, float f3) {
        return f2 + (f3 - f2) / 2.0f;
    }
}

