/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;
import jogamp.graph.font.typecast.ot.table.HdmxTable;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.HmtxTable;
import jogamp.graph.font.typecast.ot.table.LocaTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.NameTable;
import jogamp.graph.font.typecast.ot.table.Os2Table;
import jogamp.graph.font.typecast.ot.table.PostTable;
import jogamp.graph.font.typecast.ot.table.Table;
import jogamp.graph.font.typecast.ot.table.TableDirectory;
import jogamp.graph.font.typecast.ot.table.TableFactory;
import jogamp.graph.font.typecast.ot.table.VheaTable;

public class OTFont {
    private final OTFontCollection _fc;
    private TableDirectory _tableDirectory = null;
    private Table[] _tables;
    private Os2Table _os2;
    private CmapTable _cmap;
    private GlyfTable _glyf;
    private HeadTable _head;
    private HheaTable _hhea;
    private HdmxTable _hdmx;
    private HmtxTable _hmtx;
    private LocaTable _loca;
    private MaxpTable _maxp;
    private NameTable _name;
    private PostTable _post;
    private VheaTable _vhea;

    public OTFont(OTFontCollection oTFontCollection) {
        this._fc = oTFontCollection;
    }

    public StringBuilder getName(int n2, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        return this._name.getRecordsRecordString(stringBuilder, n2);
    }

    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        if (null != this._name) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            for (int i2 = 0; i2 < this._name.getNumberOfNameRecords(); ++i2) {
                this._name.getRecord(i2).getRecordString(stringBuilder).append(string);
            }
        }
        return stringBuilder;
    }

    public Table getTable(int n2) {
        for (int i2 = 0; i2 < this._tables.length; ++i2) {
            if (this._tables[i2] == null || this._tables[i2].getType() != n2) continue;
            return this._tables[i2];
        }
        return null;
    }

    public Os2Table getOS2Table() {
        return this._os2;
    }

    public CmapTable getCmapTable() {
        return this._cmap;
    }

    public HeadTable getHeadTable() {
        return this._head;
    }

    public HheaTable getHheaTable() {
        return this._hhea;
    }

    public HdmxTable getHdmxTable() {
        return this._hdmx;
    }

    public HmtxTable getHmtxTable() {
        return this._hmtx;
    }

    public LocaTable getLocaTable() {
        return this._loca;
    }

    public MaxpTable getMaxpTable() {
        return this._maxp;
    }

    public NameTable getNameTable() {
        return this._name;
    }

    public PostTable getPostTable() {
        return this._post;
    }

    public VheaTable getVheaTable() {
        return this._vhea;
    }

    public int getAscent() {
        return this._hhea.getAscender();
    }

    public int getDescent() {
        return this._hhea.getDescender();
    }

    public int getNumGlyphs() {
        return this._maxp.getNumGlyphs();
    }

    public OTGlyph getGlyph(int n2) {
        GlyfDescript glyfDescript = this._glyf.getDescription(n2);
        return null != glyfDescript ? new OTGlyph(glyfDescript, this._hmtx.getLeftSideBearing(n2), this._hmtx.getAdvanceWidth(n2)) : null;
    }

    public TableDirectory getTableDirectory() {
        return this._tableDirectory;
    }

    private Table readTable(DataInputStream dataInputStream, int n2, int n3) throws IOException {
        dataInputStream.reset();
        DirectoryEntry directoryEntry = this._tableDirectory.getEntryByTag(n3);
        if (directoryEntry == null) {
            return null;
        }
        dataInputStream.skip(n2 + directoryEntry.getOffset());
        return TableFactory.create(this._fc, this, directoryEntry, dataInputStream);
    }

    protected void read(DataInputStream dataInputStream, int n2, int n3) throws IOException {
        dataInputStream.reset();
        dataInputStream.skip(n2);
        this._tableDirectory = new TableDirectory(dataInputStream);
        this._tables = new Table[this._tableDirectory.getNumTables()];
        this._head = (HeadTable)this.readTable(dataInputStream, n3, 1751474532);
        this._hhea = (HheaTable)this.readTable(dataInputStream, n3, 1751672161);
        this._maxp = (MaxpTable)this.readTable(dataInputStream, n3, 1835104368);
        this._loca = (LocaTable)this.readTable(dataInputStream, n3, 1819239265);
        this._vhea = (VheaTable)this.readTable(dataInputStream, n3, 1986553185);
        int n4 = 0;
        this._tables[n4++] = this._head;
        this._tables[n4++] = this._hhea;
        this._tables[n4++] = this._maxp;
        if (this._loca != null) {
            this._tables[n4++] = this._loca;
        }
        if (this._vhea != null) {
            this._tables[n4++] = this._vhea;
        }
        for (int i2 = 0; i2 < this._tableDirectory.getNumTables(); ++i2) {
            DirectoryEntry directoryEntry = this._tableDirectory.getEntry(i2);
            if (directoryEntry.getTag() == 1751474532 || directoryEntry.getTag() == 1751672161 || directoryEntry.getTag() == 1835104368 || directoryEntry.getTag() == 1819239265 || directoryEntry.getTag() == 1986553185) continue;
            dataInputStream.reset();
            dataInputStream.skip(n3 + directoryEntry.getOffset());
            this._tables[n4] = TableFactory.create(this._fc, this, directoryEntry, dataInputStream);
            ++n4;
        }
        this._cmap = (CmapTable)this.getTable(1668112752);
        this._hdmx = (HdmxTable)this.getTable(1751412088);
        this._hmtx = (HmtxTable)this.getTable(1752003704);
        this._name = (NameTable)this.getTable(1851878757);
        this._os2 = (Os2Table)this.getTable(1330851634);
        this._post = (PostTable)this.getTable(1886352244);
        this._glyf = (GlyfTable)this.getTable(1735162214);
    }

    public String toString() {
        if (this._tableDirectory != null) {
            return this._tableDirectory.toString();
        }
        return "Empty font";
    }
}

