/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jogamp.graph.font.typecast.ot.OTFont;
import jogamp.graph.font.typecast.ot.mac.ResourceHeader;
import jogamp.graph.font.typecast.ot.mac.ResourceMap;
import jogamp.graph.font.typecast.ot.mac.ResourceReference;
import jogamp.graph.font.typecast.ot.mac.ResourceType;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.TTCHeader;
import jogamp.graph.font.typecast.ot.table.Table;

public class OTFontCollection {
    private String _pathName;
    private String _fileName;
    private TTCHeader _ttcHeader;
    private OTFont[] _fonts;
    private final ArrayList<Table> _tables = new ArrayList();
    private boolean _resourceFork = false;

    protected OTFontCollection() {
    }

    public static OTFontCollection create(File file) throws IOException {
        OTFontCollection oTFontCollection = new OTFontCollection();
        oTFontCollection.read(file);
        return oTFontCollection;
    }

    public static OTFontCollection create(InputStream inputStream, int n2) throws IOException {
        OTFontCollection oTFontCollection = new OTFontCollection();
        oTFontCollection.read(inputStream, n2);
        return oTFontCollection;
    }

    public String getPathName() {
        return this._pathName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public OTFont getFont(int n2) {
        return this._fonts[n2];
    }

    public int getFontCount() {
        return this._fonts.length;
    }

    public TTCHeader getTtcHeader() {
        return this._ttcHeader;
    }

    public Table getTable(DirectoryEntry directoryEntry) {
        for (int i2 = 0; i2 < this._tables.size(); ++i2) {
            Table table = this._tables.get(i2);
            if (table.getDirectoryEntry().getTag() != directoryEntry.getTag() || table.getDirectoryEntry().getOffset() != directoryEntry.getOffset()) continue;
            return table;
        }
        return null;
    }

    public void addTable(Table table) {
        this._tables.add(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(File file) throws IOException {
        this._pathName = file.getPath();
        this._fileName = file.getName();
        if (!file.exists()) {
            throw new IOException("File <" + file.getName() + "> doesn't exist.");
        }
        if (file.length() == 0L) {
            if (!(file = new File(file, "..namedfork/rsrc")).exists()) {
                throw new IOException();
            }
            this._resourceFork = true;
        }
        int n2 = (int)file.length();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), n2);
        try {
            this.readImpl(bufferedInputStream, n2);
        }
        finally {
            bufferedInputStream.close();
        }
    }

    protected void read(InputStream inputStream, int n2) throws IOException {
        this._pathName = "";
        this._fileName = "";
        InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, n2);
        this.readImpl(inputStream2, n2);
    }

    private void readImpl(InputStream inputStream, int n2) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("stream of type " + inputStream.getClass().getName() + " doesn't support mark");
        }
        inputStream.mark(n2);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (this._resourceFork || this._pathName.endsWith(".dfont")) {
            ResourceHeader resourceHeader = new ResourceHeader(dataInputStream);
            dataInputStream.reset();
            dataInputStream.skip(resourceHeader.getMapOffset());
            ResourceMap resourceMap = new ResourceMap(dataInputStream);
            ResourceType resourceType = resourceMap.getResourceType("sfnt");
            this._fonts = new OTFont[resourceType.getCount()];
            for (int i2 = 0; i2 < resourceType.getCount(); ++i2) {
                ResourceReference resourceReference = resourceType.getReference(i2);
                this._fonts[i2] = new OTFont(this);
                int n3 = resourceHeader.getDataOffset() + resourceReference.getDataOffset() + 4;
                this._fonts[i2].read(dataInputStream, n3, n3);
            }
        } else if (TTCHeader.isTTC(dataInputStream)) {
            dataInputStream.reset();
            this._ttcHeader = new TTCHeader(dataInputStream);
            this._fonts = new OTFont[this._ttcHeader.getDirectoryCount()];
            for (int i3 = 0; i3 < this._ttcHeader.getDirectoryCount(); ++i3) {
                this._fonts[i3] = new OTFont(this);
                this._fonts[i3].read(dataInputStream, this._ttcHeader.getTableDirectory(i3), 0);
            }
        } else {
            this._fonts = new OTFont[1];
            this._fonts[0] = new OTFont(this);
            this._fonts[0].read(dataInputStream, 0, 0);
        }
    }
}

